/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Types {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$wsdl$fromJava$Types == null ? (class$org$apache$axis$wsdl$fromJava$Types = Types.class$("org.apache.axis.wsdl.fromJava.Types")) : class$org$apache$axis$wsdl$fromJava$Types).getName());
    Definition def;
    Namespaces namespaces = null;
    TypeMapping tm;
    TypeMapping defaultTM;
    String targetNamespace;
    Element wsdlTypesElem = null;
    HashMap schemaTypes = null;
    HashMap schemaElementNames = null;
    HashMap schemaUniqueElementNames = null;
    List stopClasses = null;
    List beanCompatErrs = new ArrayList();
    Document docHolder;
    static /* synthetic */ Class class$org$apache$axis$wsdl$fromJava$Types;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$org$apache$axis$encoding$SimpleType;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public Types(Definition def, TypeMapping tm, TypeMapping defaultTM, Namespaces namespaces, String targetNamespace, List stopClasses) {
        this.def = def;
        this.createDocumentFragment();
        this.tm = tm;
        this.defaultTM = defaultTM;
        this.namespaces = namespaces;
        this.targetNamespace = targetNamespace;
        this.stopClasses = stopClasses;
        this.schemaElementNames = new HashMap();
        this.schemaUniqueElementNames = new HashMap();
        this.schemaTypes = new HashMap();
    }

    public QName writePartType(Class type, QName qname) throws Exception {
        if (type.getName().equals("void")) {
            return null;
        }
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = Types.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(type)) {
            type = JavaUtils.getHolderValueType(type);
        }
        if (this.isSimpleType(type)) {
            String elementType;
            Element element;
            QName typeQName = this.getTypeQName(type);
            if (qname != null && (element = this.createElementDecl(qname, elementType = this.writeType(type), false)) != null) {
                this.writeSchemaElement(qname, element);
            }
            return typeQName;
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        return this.writeTypeAsElement(type, qname);
    }

    private QName writeTypeAsElement(Class type, QName qName) throws Exception {
        String elementType;
        QName typeQName = this.writeTypeNamespace(type);
        if (qName == null) {
            qName = typeQName;
        }
        if ((elementType = this.writeType(type)) != null) {
            Element element = this.createElementDecl(qName, elementType, this.isNullable(type));
            if (element != null) {
                this.writeSchemaElement(typeQName, element);
            }
            return qName;
        }
        return null;
    }

    private QName writeTypeNamespace(Class type) {
        QName qName = this.getTypeQName(type);
        String pref = this.def.getPrefix(qName.getNamespaceURI());
        if (pref == null) {
            this.def.addNamespace(this.namespaces.getCreatePrefix(qName.getNamespaceURI()), qName.getNamespaceURI());
        }
        return qName;
    }

    private QName getTypeQName(Class javaType) {
        QName qName = null;
        QName dQName = null;
        if (this.defaultTM != null) {
            dQName = this.defaultTM.getTypeQName(javaType);
        }
        if (this.tm != null) {
            qName = this.tm.getTypeQName(javaType);
        }
        if (qName == null) {
            qName = dQName;
        } else if (qName != null && qName != dQName && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            qName = dQName;
        }
        if (javaType.isArray() && qName != null && Constants.equals(Constants.SOAP_ARRAY, qName)) {
            Class<?> componentType = javaType.getComponentType();
            QName cqName = this.getTypeQName(componentType);
            if (this.targetNamespace.equals(cqName.getNamespaceURI())) {
                qName = new QName(this.targetNamespace, "ArrayOf" + cqName.getLocalPart());
            } else {
                String pre = this.namespaces.getCreatePrefix(cqName.getNamespaceURI());
                qName = new QName(this.targetNamespace, "ArrayOf_" + pre + "_" + cqName.getLocalPart());
            }
            return qName;
        }
        if (qName == null) {
            String pkg = Types.getPackageNameFromFullName(javaType.getName());
            String lcl = Types.getLocalNameFromFullName(javaType.getName());
            String ns = this.namespaces.getCreate(pkg);
            this.namespaces.getCreatePrefix(ns);
            String localPart = lcl.replace('$', '_');
            qName = new QName(ns, localPart);
        }
        return qName;
    }

    public static String getPackageNameFromFullName(String full) {
        if (full.lastIndexOf(46) < 0) {
            return "";
        }
        return full.substring(0, full.lastIndexOf(46));
    }

    public static String getLocalNameFromFullName(String full) {
        if (full.lastIndexOf(46) < 0) {
            return full;
        }
        return full.substring(full.lastIndexOf(46) + 1);
    }

    public void writeSchemaElement(QName qName, Element element) {
        if (this.wsdlTypesElem == null) {
            try {
                this.writeWsdlTypesElement();
            }
            catch (Exception e) {
                log.error((Object)e);
                return;
            }
        }
        Node schemaElem = null;
        NodeList nl = this.wsdlTypesElem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            NamedNodeMap attrs = nl.item(i).getAttributes();
            int n = 0;
            while (n < attrs.getLength()) {
                Attr a = (Attr)attrs.item(n);
                if (a.getName().equals("targetNamespace") && a.getValue().equals(qName.getNamespaceURI())) {
                    schemaElem = (Element)nl.item(i);
                }
                ++n;
            }
            ++i;
        }
        if (schemaElem == null) {
            schemaElem = this.docHolder.createElement("schema");
            this.wsdlTypesElem.appendChild(schemaElem);
            schemaElem.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            schemaElem.setAttribute("targetNamespace", qName.getNamespaceURI());
            Element importElem = this.docHolder.createElement("import");
            schemaElem.appendChild(importElem);
            importElem.setAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
        }
        schemaElem.appendChild(element);
    }

    private void writeWsdlTypesElement() throws Exception {
        if (this.wsdlTypesElem == null) {
            this.wsdlTypesElem = this.docHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "types");
            this.wsdlTypesElem.setPrefix("wsdl");
        }
    }

    public String writeType(Class type) throws Exception {
        if (this.isSimpleType(type)) {
            QName qName = this.getTypeQName(type);
            if (Constants.isSchemaXSD(qName.getNamespaceURI())) {
                return "xsd:" + qName.getLocalPart();
            }
            return "soapenc:" + qName.getLocalPart();
        }
        Serializer ser = null;
        SerializerFactory factory = null;
        factory = this.tm != null ? (SerializerFactory)this.tm.getSerializer(type) : (SerializerFactory)this.defaultTM.getSerializer(type);
        if (factory == null) {
            if (this.isBeanCompatible(type, true)) {
                factory = new BeanSerializerFactory(type, this.getTypeQName(type));
            } else {
                return "xsd:" + Constants.XSD_ANYTYPE.getLocalPart();
            }
        }
        if (factory != null) {
            ser = (Serializer)factory.getSerializerAs("Axis SAX Mechanism");
        }
        if (ser == null) {
            throw new AxisFault(JavaUtils.getMessage("NoSerializer00", type.getName()));
        }
        QName qName = this.writeTypeNamespace(type);
        String componentTypeName = null;
        Class<?> componentType = null;
        if (type.isArray()) {
            String dimString = "[]";
            componentType = type.getComponentType();
            if (componentType.isArray()) {
                while (componentType.isArray()) {
                    dimString = dimString + "[]";
                    componentType = componentType.getComponentType();
                }
            }
            componentTypeName = this.writeType(componentType) + dimString;
        }
        String soapTypeName = qName.getLocalPart();
        String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
        String prefixedName = prefix + ":" + soapTypeName;
        if (!this.addToTypesList(qName, soapTypeName)) {
            return prefixedName;
        }
        if (type.isArray()) {
            Element complexType = this.docHolder.createElement("complexType");
            this.writeSchemaElement(qName, complexType);
            complexType.setAttribute("name", soapTypeName);
            Element complexContent = this.docHolder.createElement("complexContent");
            complexType.appendChild(complexContent);
            Element restriction = this.docHolder.createElement("restriction");
            complexContent.appendChild(restriction);
            restriction.setAttribute("base", "soapenc:Array");
            Element attribute = this.docHolder.createElement("attribute");
            restriction.appendChild(attribute);
            attribute.setAttribute("ref", "soapenc:arrayType");
            attribute.setAttribute("wsdl:arrayType", componentTypeName);
        } else if (Types.isEnumClass(type)) {
            this.writeEnumType(qName, type);
        } else {
            ser.writeSchema(this);
        }
        return prefixedName;
    }

    public static boolean isEnumClass(Class cls) {
        try {
            Method m = cls.getMethod("getValue", null);
            Method m2 = cls.getMethod("toString", null);
            if (m != null && m2 != null) {
                Method m3 = cls.getDeclaredMethod("fromString", class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String);
                Method m4 = cls.getDeclaredMethod("fromValue", m.getReturnType());
                if (m3 != null && Modifier.isStatic(m3.getModifiers()) && Modifier.isPublic(m3.getModifiers()) && m4 != null && Modifier.isStatic(m4.getModifiers()) && Modifier.isPublic(m4.getModifiers())) {
                    try {
                        return cls.getMethod("setValue", m.getReturnType()) == null;
                    }
                    catch (NoSuchMethodException e) {
                        return true;
                    }
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void writeEnumType(QName qName, Class cls) throws Exception {
        if (!Types.isEnumClass(cls)) {
            return;
        }
        Method m = cls.getMethod("getValue", null);
        Class<?> base = m.getReturnType();
        Element simpleType = this.docHolder.createElement("simpleType");
        this.writeSchemaElement(qName, simpleType);
        simpleType.setAttribute("name", qName.getLocalPart());
        Element restriction = this.docHolder.createElement("restriction");
        simpleType.appendChild(restriction);
        String baseType = this.writeType(base);
        restriction.setAttribute("base", baseType);
        Field[] fields = cls.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int mod = field.getModifiers();
            if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && field.getType() == base) {
                Element enumeration = this.docHolder.createElement("enumeration");
                enumeration.setAttribute("value", field.get(null).toString());
                restriction.appendChild(enumeration);
            }
            ++i;
        }
    }

    private Element createElementDecl(QName qName, String elementType, boolean nullable) {
        if (!this.addToElementsList(qName)) {
            return null;
        }
        Element element = this.docHolder.createElement("element");
        element.setAttribute("name", qName.getLocalPart());
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public Element createElement(String elementName, String elementType, boolean nullable, boolean omittable, Document docHolder) {
        Element element = docHolder.createElement("element");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        if (omittable) {
            element.setAttribute("minOccurs", "0");
            element.setAttribute("maxOccurs", "1");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public Element createAttributeElement(String elementName, String elementType, boolean nullable, Document docHolder) {
        Element element = docHolder.createElement("attribute");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public boolean isSimpleSchemaType(Class type) {
        return type == (class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String) || type == Boolean.TYPE || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = Types.class$("java.math.BigInteger")) : class$java$math$BigInteger) || type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Types.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || type == (class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = Types.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName) || type == (class$java$util$Calendar == null ? (class$java$util$Calendar = Types.class$("java.util.Calendar")) : class$java$util$Calendar) || type == (array$B == null ? (array$B = Types.class$("[B")) : array$B);
    }

    boolean isSimpleSoapEncodingType(Class type) {
        return type == (class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String) || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Types.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Types.class$("java.lang.Byte")) : class$java$lang$Byte) || type == (class$java$lang$Double == null ? (class$java$lang$Double = Types.class$("java.lang.Double")) : class$java$lang$Double) || type == (class$java$lang$Float == null ? (class$java$lang$Float = Types.class$("java.lang.Float")) : class$java$lang$Float) || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Types.class$("java.lang.Integer")) : class$java$lang$Integer) || type == (class$java$lang$Long == null ? (class$java$lang$Long = Types.class$("java.lang.Long")) : class$java$lang$Long) || type == (class$java$lang$Short == null ? (class$java$lang$Short = Types.class$("java.lang.Short")) : class$java$lang$Short) || type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Types.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || type == (array$B == null ? (array$B = Types.class$("[B")) : array$B);
    }

    boolean isSimpleType(Class type) {
        return this.isSimpleSchemaType(type) || this.isSimpleSoapEncodingType(type);
    }

    public boolean isAcceptableAsAttribute(Class type) {
        return this.isSimpleType(type) || Types.isEnumClass(type) || this.implementsSimpleType(type);
    }

    boolean implementsSimpleType(Class type) {
        Class<?>[] impls = type.getInterfaces();
        int i = 0;
        while (i < impls.length) {
            if (impls[i] == (class$org$apache$axis$encoding$SimpleType == null ? Types.class$("org.apache.axis.encoding.SimpleType") : class$org$apache$axis$encoding$SimpleType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean addToTypesList(QName qName, String typeName) {
        boolean added = false;
        ArrayList<String> types = (ArrayList<String>)this.schemaTypes.get(qName.getNamespaceURI());
        if (types == null) {
            types = new ArrayList<String>();
            types.add(typeName);
            this.schemaTypes.put(qName.getNamespaceURI(), types);
            added = true;
        } else if (!types.contains(typeName)) {
            types.add(typeName);
            added = true;
        }
        if (added) {
            String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
            return !prefix.equals("soapenv") && !prefix.equals("soapenc") && !prefix.equals("xsd") && !prefix.equals("wsdl") && !prefix.equals("wsdlsoap");
        }
        return false;
    }

    private boolean addToElementsList(QName qName) {
        if (qName == null) {
            return false;
        }
        boolean added = false;
        ArrayList<String> elements = (ArrayList<String>)this.schemaElementNames.get(qName.getNamespaceURI());
        if (elements == null) {
            elements = new ArrayList<String>();
            elements.add(qName.getLocalPart());
            this.schemaElementNames.put(qName.getNamespaceURI(), elements);
            added = true;
        } else if (!elements.contains(qName.getLocalPart())) {
            elements.add(qName.getLocalPart());
            added = true;
        }
        return added;
    }

    public boolean isNullable(Class type) {
        return !type.isPrimitive() && (!type.isArray() || type.getComponentType() != Byte.TYPE);
    }

    private void createDocumentFragment() {
        this.docHolder = XMLUtils.newDocument();
    }

    public void insertTypesFragment(Document doc) {
        if (this.wsdlTypesElem != null) {
            Node node = doc.importNode(this.wsdlTypesElem, true);
            doc.getDocumentElement().insertBefore(node, doc.getDocumentElement().getFirstChild());
        }
    }

    public List getStopClasses() {
        return this.stopClasses;
    }

    public Element createElement(String elementName) {
        return this.docHolder.createElement(elementName);
    }

    protected boolean isBeanCompatible(Class javaType, boolean issueErrors) {
        Class superClass;
        if (javaType.isArray() || javaType.isPrimitive()) {
            if (issueErrors && !this.beanCompatErrs.contains(javaType)) {
                log.error((Object)JavaUtils.getMessage("beanCompatType00", javaType.getName()));
                this.beanCompatErrs.add(javaType);
            }
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            if (issueErrors && !this.beanCompatErrs.contains(javaType)) {
                log.error((Object)JavaUtils.getMessage("beanCompatPkg00", javaType.getName()));
                this.beanCompatErrs.add(javaType);
            }
            return false;
        }
        if (JavaUtils.isEnumClass(javaType)) {
            return true;
        }
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = Types.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(javaType)) {
            try {
                javaType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (issueErrors && !this.beanCompatErrs.contains(javaType)) {
                    log.error((Object)JavaUtils.getMessage("beanCompatConstructor00", javaType.getName()));
                    this.beanCompatErrs.add(javaType);
                }
                return false;
            }
        }
        if (!((superClass = javaType.getSuperclass()) == null || superClass == (class$java$lang$Object == null ? (class$java$lang$Object = Types.class$("java.lang.Object")) : class$java$lang$Object) || superClass == (class$java$lang$Exception == null ? (class$java$lang$Exception = Types.class$("java.lang.Exception")) : class$java$lang$Exception) || superClass == (class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = Types.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault) || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
            return this.isBeanCompatible(superClass, issueErrors);
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

