/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtils {
    private static String[] schemaTypes = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};

    public static Vector getContainedElementDeclarations(Node node, SymbolTable symbolTable) {
        Type simpleType;
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            QName extensionKind;
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Node extension = null;
            int j = 0;
            while (j < children.getLength() && complexContent == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                    if (complexContentKind.getLocalPart().equals("complexContent")) {
                        complexContent = children.item(j);
                    } else if (complexContentKind.getLocalPart().equals("simpleContent")) {
                        simpleContent = children.item(j);
                    }
                }
                ++j;
            }
            if (complexContent != null) {
                children = complexContent.getChildNodes();
                int j2 = 0;
                while (j2 < children.getLength() && extension == null) {
                    extensionKind = Utils.getNodeQName(children.item(j2));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j2);
                    }
                    ++j2;
                }
            }
            if (simpleContent != null) {
                children = simpleContent.getChildNodes();
                int j3 = 0;
                while (j3 < children.getLength() && extension == null) {
                    extensionKind = Utils.getNodeQName(children.item(j3));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        QName extendsType = Utils.getNodeTypeRefQName(children.item(j3), "base");
                        Vector<ElementDecl> v = new Vector<ElementDecl>();
                        ElementDecl elem = new ElementDecl();
                        elem.setType(symbolTable.getTypeEntry(extendsType, false));
                        elem.setName(new QName("", "value"));
                        v.add(elem);
                        return v;
                    }
                    ++j3;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            Vector v = new Vector();
            int j4 = 0;
            while (j4 < children.getLength()) {
                QName subNodeKind = Utils.getNodeQName(children.item(j4));
                if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) {
                    if (subNodeKind.getLocalPart().equals("sequence")) {
                        v.addAll(SchemaUtils.processSequenceNode(children.item(j4), symbolTable));
                    } else if (subNodeKind.getLocalPart().equals("all")) {
                        v.addAll(SchemaUtils.processAllNode(children.item(j4), symbolTable));
                    } else if (subNodeKind.getLocalPart().equals("choice")) {
                        v.addAll(SchemaUtils.processChoiceNode(children.item(j4), symbolTable));
                    } else if (subNodeKind.getLocalPart().equals("group")) {
                        v.addAll(SchemaUtils.processGroupNode(children.item(j4), symbolTable));
                    }
                }
                ++j4;
            }
            return v;
        }
        QName simpleQName = SchemaUtils.getSimpleTypeBase(node, symbolTable);
        if (simpleQName != null && (simpleType = symbolTable.getType(simpleQName)) != null) {
            Vector<ElementDecl> v = new Vector<ElementDecl>();
            ElementDecl elem = new ElementDecl();
            elem.setType(simpleType);
            elem.setName(new QName("", "value"));
            v.add(elem);
            return v;
        }
        return null;
    }

    private static Vector processChoiceNode(Node choiceNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = choiceNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) {
                ElementDecl elem;
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("group")) {
                    v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("element") && (elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable)) != null) {
                    v.add(elem);
                }
            }
            ++j;
        }
        return v;
    }

    private static Vector processSequenceNode(Node sequenceNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = sequenceNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) {
                ElementDecl elem;
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("group")) {
                    v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("any")) {
                    Type type = symbolTable.getType(Constants.XSD_ANY);
                    ElementDecl elem2 = new ElementDecl(type, new QName("", "any"));
                    elem2.setAnyElement(true);
                    v.add(elem2);
                } else if (subNodeKind.getLocalPart().equals("element") && (elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable)) != null) {
                    v.add(elem);
                }
            }
            ++j;
        }
        return v;
    }

    private static Vector processGroupNode(Node groupNode, SymbolTable symbolTable) {
        Vector v = new Vector();
        NodeList children = groupNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) {
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("all")) {
                    v.addAll(SchemaUtils.processAllNode(children.item(j), symbolTable));
                }
            }
            ++j;
        }
        return v;
    }

    private static Vector processAllNode(Node allNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = allNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            ElementDecl elem;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI()) && subNodeKind.getLocalPart().equals("element") && (elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable)) != null) {
                v.add(elem);
            }
            ++j;
        }
        return v;
    }

    private static ElementDecl processChildElementNode(Node elementNode, SymbolTable symbolTable) {
        TypeEntry type;
        QName nodeName = Utils.getNodeNameQName(elementNode);
        BooleanHolder forElement = new BooleanHolder();
        QName nodeType = Utils.getNodeTypeRefQName(elementNode, forElement);
        if (!forElement.value) {
            String def;
            String form = Utils.getAttribute(elementNode, "form");
            if (form != null && form.equals("unqualified")) {
                nodeName = new QName("", nodeName.getLocalPart());
            } else if (form == null && ((def = Utils.getScopedAttribute(elementNode, "elementFormDefault")) == null || def.equals("unqualified"))) {
                nodeName = new QName("", nodeName.getLocalPart());
            }
        } else {
            nodeName = nodeType;
        }
        if (nodeType == null) {
            nodeType = SchemaUtils.getElementAnonQName(elementNode);
            forElement.value = false;
        }
        if ((type = symbolTable.getTypeEntry(nodeType, forElement.value)) != null) {
            ElementDecl elem = new ElementDecl(type, nodeName);
            String minOccurs = Utils.getAttribute(elementNode, "minOccurs");
            if (minOccurs != null && minOccurs.equals("0")) {
                elem.setMinOccursIs0(true);
            }
            return elem;
        }
        return null;
    }

    public static QName getElementAnonQName(Node node) {
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            NodeList children = node.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind != null && (kind.getLocalPart().equals("complexType") || kind.getLocalPart().equals("simpleType")) && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    return Utils.getNodeNameQName(children.item(j));
                }
                ++j;
            }
        }
        return null;
    }

    public static QName getAttributeAnonQName(Node node) {
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("attribute") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            NodeList children = node.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind != null && (kind.getLocalPart().equals("complexType") || kind.getLocalPart().equals("simpleType")) && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    return Utils.getNodeNameQName(children.item(j));
                }
                ++j;
            }
        }
        return null;
    }

    public static boolean isSimpleTypeOrSimpleContent(Node node) {
        NodeList children;
        if (node == null) {
            return false;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind != null && kind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                if (kind != null && kind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    return true;
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            return true;
        }
        if (nodeKind != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            int j = 0;
            while (j < children.getLength() && complexContent == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                    if (complexContentKind.getLocalPart().equals("complexContent")) {
                        complexContent = children.item(j);
                    } else if (complexContentKind.getLocalPart().equals("simpleContent")) {
                        simpleContent = children.item(j);
                    }
                }
                ++j;
            }
            if (complexContent != null) {
                return false;
            }
            if (simpleContent != null) {
                return true;
            }
        }
        return false;
    }

    public static TypeEntry getComplexElementExtensionBase(Node node, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            int j = 0;
            while (j < children.getLength() && content == null) {
                QName contentKind = Utils.getNodeQName(children.item(j));
                if (contentKind != null && contentKind.getLocalPart().equals("complexContent") && Constants.isSchemaXSD(contentKind.getNamespaceURI())) {
                    content = children.item(j);
                }
                if (contentKind != null && contentKind.getLocalPart().equals("simpleContent") && Constants.isSchemaXSD(contentKind.getNamespaceURI())) {
                    content = children.item(j);
                }
                ++j;
            }
            if (content != null) {
                children = content.getChildNodes();
                int j2 = 0;
                while (j2 < children.getLength() && extension == null) {
                    QName extensionKind = Utils.getNodeQName(children.item(j2));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j2);
                    }
                    ++j2;
                }
            }
            if (extension == null) {
                return null;
            }
            QName extendsType = Utils.getNodeTypeRefQName(extension, "base");
            if (extendsType == null) {
                return null;
            }
            return symbolTable.getType(extendsType);
        }
        return null;
    }

    public static QName getSimpleTypeBase(Node node, SymbolTable symbolTable) {
        int j;
        NodeList children;
        QName baseQName = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            j = 0;
            while (j < children.getLength() && simpleNode == null) {
                QName simpleKind = Utils.getNodeQName(children.item(j));
                if (simpleKind != null && simpleKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(simpleKind.getNamespaceURI())) {
                    node = simpleNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node restrictionNode = null;
            j = 0;
            while (j < children.getLength() && restrictionNode == null) {
                QName restrictionKind = Utils.getNodeQName(children.item(j));
                if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                    restrictionNode = children.item(j);
                }
                ++j;
            }
            if (restrictionNode != null) {
                baseQName = Utils.getNodeTypeRefQName(restrictionNode, "base");
            }
            if (baseQName != null && restrictionNode != null) {
                NodeList enums = restrictionNode.getChildNodes();
                int i = 0;
                while (i < enums.getLength()) {
                    QName enumKind = Utils.getNodeQName(enums.item(i));
                    if (enumKind != null && enumKind.getLocalPart().equals("enumeration") && Constants.isSchemaXSD(enumKind.getNamespaceURI())) {
                        return null;
                    }
                    ++i;
                }
            }
        }
        return baseQName;
    }

    public static Node getRestrictionOrExtensionNode(Node node) {
        int j;
        NodeList children;
        Node re = null;
        if (node == null) {
            return re;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node node2 = null;
            j = 0;
            while (j < children.getLength() && node2 == null) {
                QName kind2 = Utils.getNodeQName(children.item(j));
                if (kind2 != null && (kind2.getLocalPart().equals("simpleType") || kind2.getLocalPart().equals("complexType") || kind2.getLocalPart().equals("simpleContent")) && Constants.isSchemaXSD(kind2.getNamespaceURI())) {
                    node = node2 = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && (nodeKind.getLocalPart().equals("simpleType") || nodeKind.getLocalPart().equals("complexType")) && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContent = null;
            if (nodeKind.getLocalPart().equals("complexType")) {
                j = 0;
                while (j < children.getLength() && complexContent == null) {
                    QName complexContentKind = Utils.getNodeQName(children.item(j));
                    if (complexContentKind != null && (complexContentKind.getLocalPart().equals("complexContent") || complexContentKind.getLocalPart().equals("simpleContent")) && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                        complexContent = children.item(j);
                    }
                    ++j;
                }
                node = complexContent;
            }
            if (node != null) {
                children = node.getChildNodes();
                j = 0;
                while (j < children.getLength() && re == null) {
                    QName reKind = Utils.getNodeQName(children.item(j));
                    if (reKind != null && (reKind.getLocalPart().equals("extension") || reKind.getLocalPart().equals("restriction")) && Constants.isSchemaXSD(reKind.getNamespaceURI())) {
                        re = children.item(j);
                    }
                    ++j;
                }
            }
        }
        return re;
    }

    public static QName getArrayElementQName(Node node, IntHolder dims) {
        dims.value = 1;
        QName qName = SchemaUtils.getCollectionElementQName(node);
        if (qName == null) {
            qName = SchemaUtils.getArrayElementQName_JAXRPC(node, dims);
        }
        return qName;
    }

    private static QName getCollectionElementQName(Node node) {
        QName fullTypeQName;
        QName justTypeQName;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) && (justTypeQName = Utils.getNodeTypeRefQName(node, "type")) != null && justTypeQName != (fullTypeQName = Utils.getNodeTypeRefQName(node, new BooleanHolder()))) {
            return justTypeQName;
        }
        return null;
    }

    private static QName getArrayElementQName_JAXRPC(Node node, IntHolder dims) {
        int j;
        NodeList children;
        dims.value = 0;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContentNode = null;
            j = 0;
            while (j < children.getLength() && complexContentNode == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && (complexContentKind.getLocalPart().equals("complexContent") || complexContentKind.getLocalPart().equals("simpleContent")) && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                    complexContentNode = children.item(j);
                }
                ++j;
            }
            Node restrictionNode = null;
            if (complexContentNode != null) {
                children = complexContentNode.getChildNodes();
                int j2 = 0;
                while (j2 < children.getLength() && restrictionNode == null) {
                    QName restrictionKind = Utils.getNodeQName(children.item(j2));
                    if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                        restrictionNode = children.item(j2);
                    }
                    ++j2;
                }
            }
            QName baseType = null;
            if (!(restrictionNode == null || (baseType = Utils.getNodeTypeRefQName(restrictionNode, "base")) != null && baseType.getLocalPart().equals("Array") && Constants.isSOAP_ENC(baseType.getNamespaceURI()))) {
                baseType = null;
            }
            Node groupNode = null;
            Node attributeNode = null;
            if (baseType != null) {
                children = restrictionNode.getChildNodes();
                int j3 = 0;
                while (j3 < children.getLength() && groupNode == null && attributeNode == null) {
                    QName refQName;
                    QName kind = Utils.getNodeQName(children.item(j3));
                    if (kind != null && (kind.getLocalPart().equals("sequence") || kind.getLocalPart().equals("all")) && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                        groupNode = children.item(j3);
                    }
                    if (kind != null && kind.getLocalPart().equals("attribute") && Constants.isSchemaXSD(kind.getNamespaceURI()) && (refQName = Utils.getNodeTypeRefQName(children.item(j3), "ref")) != null && refQName.getLocalPart().equals("arrayType") && Constants.isSOAP_ENC(refQName.getNamespaceURI())) {
                        attributeNode = children.item(j3);
                    }
                    ++j3;
                }
            }
            if (attributeNode != null) {
                int i;
                String wsdlArrayTypeValue = null;
                Vector attrs = Utils.getAttributesWithLocalName(attributeNode, "arrayType");
                int i2 = 0;
                while (i2 < attrs.size() && wsdlArrayTypeValue == null) {
                    Node attrNode = (Node)attrs.elementAt(i2);
                    String attrName = attrNode.getNodeName();
                    QName attrQName = Utils.getQNameFromPrefixedName(attributeNode, attrName);
                    if (Constants.isWSDL(attrQName.getNamespaceURI())) {
                        wsdlArrayTypeValue = attrNode.getNodeValue();
                    }
                    ++i2;
                }
                if (wsdlArrayTypeValue != null && (i = wsdlArrayTypeValue.indexOf(91)) > 0) {
                    String prefixedName = wsdlArrayTypeValue.substring(0, i);
                    String mangledString = wsdlArrayTypeValue.replace(',', '[');
                    dims.value = 0;
                    int index = mangledString.indexOf(91);
                    while (index > 0) {
                        ++dims.value;
                        index = mangledString.indexOf(91, index + 1);
                    }
                    return Utils.getQNameFromPrefixedName(restrictionNode, prefixedName);
                }
            } else if (groupNode != null) {
                String maxOccursValue;
                NodeList elements = groupNode.getChildNodes();
                Node elementNode = null;
                int i = 0;
                while (i < elements.getLength() && elementNode == null) {
                    QName elementKind = Utils.getNodeQName(elements.item(i));
                    if (elementKind != null && elementKind.getLocalPart().equals("element") && Constants.isSchemaXSD(elementKind.getNamespaceURI())) {
                        elementNode = elements.item(i);
                    }
                    ++i;
                }
                if (elementNode != null && (maxOccursValue = Utils.getAttribute(elementNode, "maxOccurs")) != null && maxOccursValue.equalsIgnoreCase("unbounded")) {
                    dims.value = 1;
                    return Utils.getNodeTypeRefQName(elementNode, "type");
                }
            }
        }
        return null;
    }

    public static Vector getContainedAttributeTypes(Node node, SymbolTable symbolTable) {
        NodeList children;
        Vector<Object> v = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            int j = 0;
            while (j < children.getLength() && content == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && Constants.isSchemaXSD(complexContentKind.getNamespaceURI()) && (complexContentKind.getLocalPart().equals("complexContent") || complexContentKind.getLocalPart().equals("simpleContent"))) {
                    content = children.item(j);
                }
                ++j;
            }
            if (content != null) {
                children = content.getChildNodes();
                int j2 = 0;
                while (j2 < children.getLength()) {
                    QName extensionKind = Utils.getNodeQName(children.item(j2));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j2);
                        break;
                    }
                    ++j2;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                nodeKind = Utils.getNodeQName(child);
                if (nodeKind != null && nodeKind.getLocalPart().equals("attribute")) {
                    TypeEntry type;
                    if (v == null) {
                        v = new Vector<Object>();
                    }
                    QName attributeName = Utils.getNodeNameQName(child);
                    BooleanHolder forElement = new BooleanHolder();
                    QName attributeType = Utils.getNodeTypeRefQName(child, forElement);
                    if (!forElement.value) {
                        String def;
                        String form = Utils.getAttribute(child, "form");
                        if (form != null && form.equals("unqualified")) {
                            attributeName = new QName("", attributeName.getLocalPart());
                        } else if (form == null && ((def = Utils.getScopedAttribute(child, "attributeFormDefault")) == null || def.equals("unqualified"))) {
                            attributeName = new QName("", attributeName.getLocalPart());
                        }
                    } else {
                        attributeName = attributeType;
                    }
                    if (attributeType == null) {
                        attributeType = SchemaUtils.getAttributeAnonQName(child);
                        forElement.value = false;
                    }
                    if ((type = symbolTable.getTypeEntry(attributeType, forElement.value)) != null && attributeName != null) {
                        v.add(type);
                        v.add(attributeName);
                    }
                }
                ++i;
            }
        }
        return v;
    }

    public static boolean isSimpleSchemaType(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < schemaTypes.length) {
            if (schemaTypes[i].equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSimpleSchemaType(QName qname) {
        if (qname == null || !Constants.isSchemaXSD(qname.getNamespaceURI())) {
            return false;
        }
        return SchemaUtils.isSimpleSchemaType(qname.getLocalPart());
    }
}

