/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Undefined;
import org.apache.axis.wsdl.symbolTable.UndefinedElement;
import org.apache.axis.wsdl.symbolTable.UndefinedType;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SymbolTable {
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private Vector types = new Vector();
    private boolean verbose;
    private boolean debug = false;
    private BaseTypeMapping btm = null;
    private boolean nowrap;
    private boolean wrapped = false;
    public static final String ANON_TOKEN = ">";
    private Definition def = null;
    private Document doc = null;
    private String wsdlURI = null;
    private HashSet importedFiles = new HashSet();
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$MessageEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$PortTypeEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$BindingEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$ServiceEntry;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$UndefinedType;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$UndefinedElement;

    public SymbolTable(BaseTypeMapping btm, boolean addImports, boolean verbose, boolean debug, boolean nowrap) {
        this.btm = btm;
        this.addImports = addImports;
        this.verbose = verbose;
        this.debug = debug;
        this.nowrap = nowrap;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qname) {
        return (Vector)this.symbolTable.get(qname);
    }

    public SymTabEntry get(QName qname, Class cls) {
        Vector v = (Vector)this.symbolTable.get(qname);
        if (v == null) {
            return null;
        }
        int i = 0;
        while (i < v.size()) {
            SymTabEntry entry = (SymTabEntry)v.elementAt(i);
            if (cls.isInstance(entry)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public TypeEntry getTypeEntry(QName qname, boolean wantElementType) {
        if (wantElementType) {
            return this.getElement(qname);
        }
        return this.getType(qname);
    }

    public Type getType(QName qname) {
        int i = 0;
        while (i < this.types.size()) {
            TypeEntry type = (TypeEntry)this.types.get(i);
            if (type.getQName().equals(qname) && type instanceof Type) {
                return (Type)type;
            }
            ++i;
        }
        return null;
    }

    public Element getElement(QName qname) {
        int i = 0;
        while (i < this.types.size()) {
            TypeEntry type = (TypeEntry)this.types.get(i);
            if (type.getQName().equals(qname) && type instanceof Element) {
                return (Element)type;
            }
            ++i;
        }
        return null;
    }

    public MessageEntry getMessageEntry(QName qname) {
        return (MessageEntry)this.get(qname, class$org$apache$axis$wsdl$symbolTable$MessageEntry == null ? (class$org$apache$axis$wsdl$symbolTable$MessageEntry = SymbolTable.class$("org.apache.axis.wsdl.symbolTable.MessageEntry")) : class$org$apache$axis$wsdl$symbolTable$MessageEntry);
    }

    public PortTypeEntry getPortTypeEntry(QName qname) {
        return (PortTypeEntry)this.get(qname, class$org$apache$axis$wsdl$symbolTable$PortTypeEntry == null ? (class$org$apache$axis$wsdl$symbolTable$PortTypeEntry = SymbolTable.class$("org.apache.axis.wsdl.symbolTable.PortTypeEntry")) : class$org$apache$axis$wsdl$symbolTable$PortTypeEntry);
    }

    public BindingEntry getBindingEntry(QName qname) {
        return (BindingEntry)this.get(qname, class$org$apache$axis$wsdl$symbolTable$BindingEntry == null ? (class$org$apache$axis$wsdl$symbolTable$BindingEntry = SymbolTable.class$("org.apache.axis.wsdl.symbolTable.BindingEntry")) : class$org$apache$axis$wsdl$symbolTable$BindingEntry);
    }

    public ServiceEntry getServiceEntry(QName qname) {
        return (ServiceEntry)this.get(qname, class$org$apache$axis$wsdl$symbolTable$ServiceEntry == null ? (class$org$apache$axis$wsdl$symbolTable$ServiceEntry = SymbolTable.class$("org.apache.axis.wsdl.symbolTable.ServiceEntry")) : class$org$apache$axis$wsdl$symbolTable$ServiceEntry);
    }

    public Vector getTypes() {
        return this.types;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public String getWSDLURI() {
        return this.wsdlURI;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public void dump(PrintStream out) {
        out.println();
        out.println(JavaUtils.getMessage("symbolTable00"));
        out.println("-----------------------");
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                out.println(v.elementAt(i).getClass().getName());
                out.println(v.elementAt(i));
                ++i;
            }
        }
        out.println("-----------------------");
    }

    public void populate(String uri) throws IOException, WSDLException {
        this.populate(uri, null, null);
    }

    public void populate(String uri, String username, String password) throws IOException, WSDLException {
        Document doc;
        if (this.verbose) {
            System.out.println(JavaUtils.getMessage("parsing00", uri));
        }
        if ((doc = XMLUtils.newDocument(uri, username, password)) == null) {
            throw new IOException(JavaUtils.getMessage("cantGetDoc00", uri));
        }
        this.wsdlURI = uri;
        this.populate(uri, doc);
    }

    public void populate(String context, Document doc) throws IOException, WSDLException {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", this.verbose);
        this.def = reader.readWSDL(context, doc);
        this.doc = doc;
        this.add(context, this.def, doc);
    }

    private void add(String context, Definition def, Document doc) throws IOException {
        URL contextURL = context == null ? null : SymbolTable.getURL(null, context);
        this.populate(contextURL, def, doc, null);
        this.checkForUndefined();
        this.populateParameters();
        this.setReferences(def, doc);
    }

    private void checkForUndefined(Definition def, String filename) throws IOException {
        if (def != null) {
            Iterator ib = def.getBindings().values().iterator();
            while (ib.hasNext()) {
                Binding binding = (Binding)ib.next();
                if (!binding.isUndefined()) continue;
                if (filename == null) {
                    throw new IOException(JavaUtils.getMessage("emitFailtUndefinedBinding01", binding.getQName().getLocalPart()));
                }
                throw new IOException(JavaUtils.getMessage("emitFailtUndefinedBinding02", binding.getQName().getLocalPart(), filename));
            }
            Iterator ip = def.getPortTypes().values().iterator();
            while (ip.hasNext()) {
                PortType portType = (PortType)ip.next();
                if (!portType.isUndefined()) continue;
                if (filename == null) {
                    throw new IOException(JavaUtils.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
                }
                throw new IOException(JavaUtils.getMessage("emitFailtUndefinedPort02", portType.getQName().getLocalPart(), filename));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.get(i);
                if (entry instanceof UndefinedType && SchemaUtils.isSimpleSchemaType(entry.getQName())) {
                    throw new IOException(JavaUtils.getMessage("unsupportedSchemaType00", entry.getQName().getLocalPart()));
                }
                if (entry instanceof Undefined) {
                    throw new IOException(JavaUtils.getMessage("undefined00", entry.getQName().toString()));
                }
                ++i;
            }
        }
    }

    private void populate(URL context, Definition def, Document doc, String filename) throws IOException {
        if (doc != null) {
            this.populateTypes(doc);
            if (this.addImports) {
                this.lookForImports(context, doc);
            }
        }
        if (def != null) {
            this.checkForUndefined(def, filename);
            if (this.addImports) {
                Map imports = def.getImports();
                Object[] importKeys = imports.keySet().toArray();
                int i = 0;
                while (i < importKeys.length) {
                    Vector v = (Vector)imports.get(importKeys[i]);
                    int j = 0;
                    while (j < v.size()) {
                        Import imp = (Import)v.get(j);
                        if (!this.importedFiles.contains(imp.getLocationURI())) {
                            this.importedFiles.add(imp.getLocationURI());
                            URL url = SymbolTable.getURL(context, imp.getLocationURI());
                            this.populate(url, imp.getDefinition(), XMLUtils.newDocument(url.toString()), url.toString());
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.populateMessages(def);
            this.populatePortTypes(def);
            this.populateBindings(def);
            this.populateServices(def);
        }
    }

    private static URL getURL(URL contextURL, String spec) throws IOException {
        String path = spec.replace('\\', '/');
        URL url = null;
        try {
            url = new URL(contextURL, path);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = SymbolTable.getFileURL(contextURL, path);
            }
        }
        catch (MalformedURLException me) {
            url = SymbolTable.getFileURL(contextURL, path);
        }
        return url;
    }

    private static URL getFileURL(URL contextURL, String path) throws IOException {
        String contextFileName;
        String parentName;
        if (contextURL != null && (parentName = new File(contextFileName = contextURL.getFile()).getParent()) != null) {
            return new URL("file", "", parentName + "/" + path);
        }
        return new URL("file", "", path);
    }

    private void lookForImports(URL context, Node node) throws IOException {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            block6: {
                Node child;
                block5: {
                    child = children.item(i);
                    if (!"import".equals(child.getLocalName())) break block5;
                    NamedNodeMap attributes = child.getAttributes();
                    Node namespace = attributes.getNamedItem("namespace");
                    if (namespace != null && Constants.isSOAP_ENC(namespace.getNodeValue())) break block6;
                    Node importFile = attributes.getNamedItem("schemaLocation");
                    if (importFile != null) {
                        String filename = SymbolTable.getURL(context, importFile.getNodeValue()).toString();
                        this.populate(context, null, XMLUtils.newDocument(filename), filename);
                    }
                }
                this.lookForImports(context, child);
            }
            ++i;
        }
    }

    private void populateTypes(Document doc) throws IOException {
        this.addTypes(doc, -1);
    }

    private void addTypes(Node node, int level) throws IOException {
        if (node == null) {
            return;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null) {
            Node re;
            String localPart = nodeKind.getLocalPart();
            boolean isXSD = Constants.isSchemaXSD(nodeKind.getNamespaceURI());
            if (isXSD && localPart.equals("complexType") || localPart.equals("simpleType")) {
                re = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (re != null && Utils.getAttribute(re, "base") != null) {
                    this.createTypeFromRef(re);
                }
                this.createTypeFromDef(node, false, false);
            } else if (isXSD && localPart.equals("element")) {
                if (Utils.getNodeTypeRefQName(node, "type") != null || Utils.getNodeTypeRefQName(node, "ref") != null) {
                    this.createTypeFromRef(node);
                }
                if ((re = SchemaUtils.getRestrictionOrExtensionNode(node)) != null && Utils.getAttribute(re, "base") != null) {
                    this.createTypeFromRef(re);
                }
                this.createTypeFromDef(node, true, level > 0);
            } else if (isXSD && localPart.equals("attribute")) {
                QName refQName;
                if (Utils.getNodeTypeRefQName(node, "type") != null) {
                    this.createTypeFromRef(node);
                }
                if ((refQName = Utils.getNodeTypeRefQName(node, "type")) != null) {
                    TypeEntry refType = this.getTypeEntry(refQName, false);
                    if (refType != null && refType instanceof Undefined) {
                        refType.setSimpleType(true);
                    } else if (refType == null || !(refType instanceof BaseType) && !refType.isSimpleType()) {
                        throw new IOException(JavaUtils.getMessage("AttrNotSimpleType01", refQName.toString()));
                    }
                }
            } else if (isXSD && localPart.equals("any")) {
                QName anyQName = Constants.XSD_ANY;
                if (this.getType(anyQName) == null) {
                    this.symbolTablePut(new BaseType(anyQName));
                }
            } else if (localPart.equals("part") && Constants.isWSDL(nodeKind.getNamespaceURI())) {
                this.createTypeFromRef(node);
            }
        }
        if (level == -1) {
            if (nodeKind != null && nodeKind.getLocalPart().equals("schema")) {
                level = 0;
            }
        } else {
            ++level;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.addTypes(children.item(i), level);
            ++i;
        }
    }

    private void createTypeFromDef(Node node, boolean isElement, boolean belowSchemaLevel) throws IOException {
        QName qName = Utils.getNodeNameQName(node);
        if (qName != null) {
            if (!isElement && this.btm.getBaseName(qName) != null) {
                return;
            }
            BooleanHolder forElement = new BooleanHolder();
            QName refQName = Utils.getNodeTypeRefQName(node, forElement);
            if (refQName != null) {
                TypeEntry refType = this.getTypeEntry(refQName, forElement.value);
                if (!belowSchemaLevel) {
                    this.symbolTablePut(new DefinedElement(qName, refType, node, ""));
                }
            } else {
                IntHolder numDims = new IntHolder();
                numDims.value = 0;
                QName arrayEQName = SchemaUtils.getArrayElementQName(node, numDims);
                if (arrayEQName != null) {
                    refQName = arrayEQName;
                    TypeEntry refType = this.getTypeEntry(refQName, false);
                    if (refType == null) {
                        String baseName = this.btm.getBaseName(refQName);
                        refType = baseName != null ? new BaseType(refQName) : new UndefinedType(refQName);
                        this.symbolTablePut(refType);
                    }
                    String dims = "";
                    while (numDims.value > 0) {
                        dims = dims + "[]";
                        --numDims.value;
                    }
                    TypeEntry defType = null;
                    if (isElement) {
                        if (!belowSchemaLevel) {
                            defType = new DefinedElement(qName, refType, node, dims);
                        }
                    } else {
                        defType = new DefinedType(qName, refType, node, dims);
                    }
                    if (defType != null) {
                        this.symbolTablePut(defType);
                    }
                } else {
                    String baseName = this.btm.getBaseName(qName);
                    if (baseName != null) {
                        this.symbolTablePut(new BaseType(qName));
                    } else {
                        TypeEntry te = null;
                        if (!isElement) {
                            Node parent;
                            QName parentQName;
                            Element parentType;
                            te = new DefinedType(qName, node);
                            if (qName.getLocalPart().indexOf(ANON_TOKEN) >= 0 && (parentType = this.getElement(parentQName = Utils.getNodeNameQName(parent = node.getParentNode()))) != null) {
                                parentType.setRefType(te);
                            }
                        } else if (!belowSchemaLevel) {
                            te = new DefinedElement(qName, node);
                        }
                        if (te != null) {
                            if (SchemaUtils.isSimpleTypeOrSimpleContent(node)) {
                                te.setSimpleType(true);
                            }
                            this.symbolTablePut(te);
                        }
                    }
                }
            }
        }
    }

    private void createTypeFromRef(Node node) throws IOException {
        TypeEntry type;
        BooleanHolder forElement = new BooleanHolder();
        QName qName = Utils.getNodeTypeRefQName(node, forElement);
        if (qName != null && (type = this.getTypeEntry(qName, forElement.value)) == null) {
            if (qName.getLocalPart().indexOf("[") > 0) {
                QName typeAttr = Utils.getNodeTypeRefQName(node, "type");
                TypeEntry collEl = this.getTypeEntry(typeAttr, false);
                if (collEl == null) {
                    String baseName = this.btm.getBaseName(typeAttr);
                    collEl = baseName != null ? new BaseType(typeAttr) : new UndefinedType(typeAttr);
                    this.symbolTablePut(collEl);
                }
                this.symbolTablePut(new CollectionType(qName, collEl, node, "[]"));
            } else {
                String baseName = this.btm.getBaseName(qName);
                if (baseName != null) {
                    this.symbolTablePut(new BaseType(qName));
                } else if (!forElement.value) {
                    this.symbolTablePut(new UndefinedType(qName));
                } else {
                    this.symbolTablePut(new UndefinedElement(qName));
                }
            }
        }
    }

    private void populateMessages(Definition def) throws IOException {
        Iterator i = def.getMessages().values().iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            MessageEntry mEntry = new MessageEntry(message);
            this.symbolTablePut(mEntry);
        }
    }

    private void populatePortTypes(Definition def) throws IOException {
        Iterator i = def.getPortTypes().values().iterator();
        while (i.hasNext()) {
            PortType portType = (PortType)i.next();
            if (portType.isUndefined()) continue;
            PortTypeEntry ptEntry = new PortTypeEntry(portType);
            this.symbolTablePut(ptEntry);
        }
    }

    private void populateParameters() throws IOException {
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                if (v.get(i) instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)v.get(i);
                    Binding binding = bEntry.getBinding();
                    PortType portType = binding.getPortType();
                    HashMap<Operation, Parameters> parameters = new HashMap<Operation, Parameters>();
                    Iterator operations = portType.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        String namespace = portType.getQName().getNamespaceURI();
                        Parameters parms = this.getOperationParameters(operation, namespace, bEntry);
                        parameters.put(operation, parms);
                    }
                    bEntry.setParameters(parameters);
                }
                ++i;
            }
        }
    }

    public Parameters getOperationParameters(Operation operation, String namespace, BindingEntry bindingEntry) throws IOException {
        int i;
        Output output;
        Input input;
        Input input2;
        Parameters parameters = new Parameters();
        Vector inputs = new Vector();
        Vector outputs = new Vector();
        List parameterOrder = operation.getParameterOrdering();
        if (parameterOrder != null && parameterOrder.isEmpty()) {
            parameterOrder = null;
        }
        if (parameterOrder != null && (input2 = operation.getInput()) != null) {
            Message inputMsg = input2.getMessage();
            Map allInputs = inputMsg.getParts();
            List orderedInputs = inputMsg.getOrderedParts(parameterOrder);
            if (allInputs.size() != orderedInputs.size()) {
                throw new IOException(JavaUtils.getMessage("emitFail00", operation.getName()));
            }
        }
        boolean literalInput = false;
        boolean literalOutput = false;
        String bindingName = "unknown";
        if (bindingEntry != null) {
            literalInput = bindingEntry.getInputBodyType(operation) == 1;
            literalOutput = bindingEntry.getOutputBodyType(operation) == 1;
            bindingName = bindingEntry.getBinding().getQName().toString();
        }
        if ((input = operation.getInput()) != null) {
            this.getParametersFromParts(inputs, input.getMessage().getOrderedParts(null), literalInput, operation.getName(), bindingName);
        }
        if ((output = operation.getOutput()) != null) {
            this.getParametersFromParts(outputs, output.getMessage().getOrderedParts(null), literalOutput, operation.getName(), bindingName);
        }
        if (parameterOrder != null) {
            i = 0;
            while (i < parameterOrder.size()) {
                String name = (String)parameterOrder.get(i);
                int index = this.getPartIndex(name, inputs);
                int outdex = this.getPartIndex(name, outputs);
                if (index >= 0) {
                    this.addInishParm(inputs, outputs, index, outdex, parameters, true);
                } else if (outdex >= 0) {
                    this.addOutParm(outputs, outdex, parameters, true);
                } else {
                    System.err.println(JavaUtils.getMessage("noPart00", name));
                }
                ++i;
            }
        }
        i = 0;
        while (i < inputs.size()) {
            Parameter p = (Parameter)inputs.get(i);
            int outdex = this.getPartIndex(p.getName(), outputs);
            this.addInishParm(inputs, outputs, i, outdex, parameters, false);
            ++i;
        }
        if (outputs.size() == 1) {
            Parameter returnParam = (Parameter)outputs.get(0);
            parameters.returnType = returnParam.getType();
            parameters.returnName = parameters.returnType instanceof DefinedElement ? ((DefinedElement)parameters.returnType).getQName() : returnParam.getQName();
            ++parameters.outputs;
        } else {
            int i2 = 0;
            while (i2 < outputs.size()) {
                this.addOutParm(outputs, i2, parameters, false);
                ++i2;
            }
        }
        parameters.faults = operation.getFaults();
        return parameters;
    }

    private int getPartIndex(String name, Vector v) {
        int i = 0;
        while (i < v.size()) {
            if (name.equals(((Parameter)v.get(i)).getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addInishParm(Vector inputs, Vector outputs, int index, int outdex, Parameters parameters, boolean trimInput) {
        Parameter p = (Parameter)inputs.get(index);
        if (p.getType() instanceof DefinedElement) {
            DefinedElement de = (DefinedElement)p.getType();
            p.setQName(de.getQName());
        }
        if (trimInput) {
            inputs.remove(index);
        }
        if (outdex >= 0) {
            Parameter outParam = (Parameter)outputs.get(outdex);
            if (p.getType().equals(outParam.getType())) {
                outputs.remove(outdex);
                p.setMode((byte)3);
                ++parameters.inouts;
            } else {
                ++parameters.inputs;
            }
        } else {
            ++parameters.inputs;
        }
        parameters.list.add(p);
    }

    private void addOutParm(Vector outputs, int outdex, Parameters parameters, boolean trim) {
        Parameter p = (Parameter)outputs.get(outdex);
        if (p.getType() instanceof DefinedElement) {
            DefinedElement de = (DefinedElement)p.getType();
            p.setQName(de.getQName());
        }
        if (trim) {
            outputs.remove(outdex);
        }
        p.setMode((byte)2);
        ++parameters.outputs;
        parameters.list.add(p);
    }

    public void getParametersFromParts(Vector v, Collection parts, boolean literal, String opName, String bindingName) throws IOException {
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Vector vTypes;
            Parameter param = new Parameter();
            Part part = (Part)i.next();
            QName elementName = part.getElementName();
            QName typeName = part.getTypeName();
            String partName = part.getName();
            if (!this.nowrap && literal && !i.hasNext() && elementName != null && elementName.getLocalPart().equals(opName)) {
                this.wrapped = true;
            }
            if (!literal || !this.wrapped) {
                param.setName(partName);
                if (typeName != null) {
                    param.setType(this.getType(typeName));
                } else if (elementName != null) {
                    param.setType(this.getElement(elementName));
                } else {
                    throw new IOException(JavaUtils.getMessage("noTypeOrElement00", new String[]{partName, opName}));
                }
                v.add(param);
                continue;
            }
            Node node = null;
            if (typeName != null) {
                throw new IOException(JavaUtils.getMessage("literalTypePart00", new String[]{partName, opName, bindingName}));
            }
            if (elementName == null) {
                throw new IOException(JavaUtils.getMessage("noElemOrType", partName, opName));
            }
            node = this.getTypeEntry(elementName, true).getNode();
            QName type = Utils.getNodeTypeRefQName(node, "type");
            if (type != null) {
                node = this.getTypeEntry(type, false).getNode();
            }
            if (node == null) {
                throw new IOException(JavaUtils.getMessage("badTypeNode", new String[]{partName, opName, elementName.toString()}));
            }
            Vector vAttrs = SchemaUtils.getContainedAttributeTypes(node, this);
            if (vAttrs != null) {
                this.wrapped = false;
            }
            if ((vTypes = SchemaUtils.getContainedElementDeclarations(node, this)) != null && this.wrapped) {
                int j = 0;
                while (j < vTypes.size()) {
                    ElementDecl elem = (ElementDecl)vTypes.elementAt(j);
                    Parameter p = new Parameter();
                    p.setQName(elem.getName());
                    p.setType(elem.getType());
                    v.add(p);
                    ++j;
                }
                continue;
            }
            Parameter p = new Parameter();
            p.setName(partName);
            if (typeName != null) {
                p.setType(this.getType(typeName));
            } else if (elementName != null) {
                p.setType(this.getElement(elementName));
            }
            v.add(p);
        }
    }

    private void populateBindings(Definition def) throws IOException {
        Iterator i = def.getBindings().values().iterator();
        while (i.hasNext()) {
            int bindingStyle = 1;
            int bindingType = 3;
            Binding binding = (Binding)i.next();
            Iterator extensibilityElementsIterator = binding.getExtensibilityElements().iterator();
            while (extensibilityElementsIterator.hasNext()) {
                Object obj = extensibilityElementsIterator.next();
                if (obj instanceof SOAPBinding) {
                    bindingType = 0;
                    SOAPBinding sb = (SOAPBinding)obj;
                    String style = sb.getStyle();
                    if (!"rpc".equalsIgnoreCase(style)) continue;
                    bindingStyle = 0;
                    continue;
                }
                if (!(obj instanceof HTTPBinding)) continue;
                HTTPBinding hb = (HTTPBinding)obj;
                bindingType = hb.getVerb().equalsIgnoreCase("post") ? 2 : 1;
            }
            boolean hasLiteral = false;
            HashMap<Operation, BindingEntry.OperationAttr> attributes = new HashMap<Operation, BindingEntry.OperationAttr>();
            List bindList = binding.getBindingOperations();
            Iterator opIterator = bindList.iterator();
            while (opIterator.hasNext()) {
                String use;
                Object obj;
                int inputBodyType = 0;
                int outputBodyType = 0;
                BindingOperation bindOp = (BindingOperation)opIterator.next();
                if (bindOp.getBindingInput() != null && bindOp.getBindingInput().getExtensibilityElements() != null) {
                    Iterator inIter = bindOp.getBindingInput().getExtensibilityElements().iterator();
                    while (inIter.hasNext()) {
                        obj = inIter.next();
                        if (!(obj instanceof SOAPBody)) continue;
                        use = ((SOAPBody)obj).getUse();
                        if (use == null) {
                            throw new IOException(JavaUtils.getMessage("noUse", bindOp.getName()));
                        }
                        if (!use.equalsIgnoreCase("literal")) break;
                        inputBodyType = 1;
                        break;
                    }
                }
                if (bindOp.getBindingOutput() != null && bindOp.getBindingOutput().getExtensibilityElements() != null) {
                    Iterator outIter = bindOp.getBindingOutput().getExtensibilityElements().iterator();
                    while (outIter.hasNext()) {
                        obj = outIter.next();
                        if (!(obj instanceof SOAPBody)) continue;
                        use = ((SOAPBody)obj).getUse();
                        if (use == null) {
                            throw new IOException(JavaUtils.getMessage("noUse", bindOp.getName()));
                        }
                        if (!use.equalsIgnoreCase("literal")) break;
                        outputBodyType = 1;
                        break;
                    }
                }
                HashMap<String, Integer> faultMap = new HashMap<String, Integer>();
                Iterator faultMapIter = bindOp.getBindingFaults().values().iterator();
                while (faultMapIter.hasNext()) {
                    BindingFault bFault = (BindingFault)faultMapIter.next();
                    String faultName = bFault.getName();
                    int faultBodyType = 0;
                    Iterator faultIter = bFault.getExtensibilityElements().iterator();
                    while (faultIter.hasNext()) {
                        Object obj2 = faultIter.next();
                        if (!(obj2 instanceof SOAPBody)) continue;
                        String use2 = ((SOAPBody)obj2).getUse();
                        if (use2 == null) {
                            throw new IOException(JavaUtils.getMessage("noUse", bindOp.getName()));
                        }
                        if (!use2.equalsIgnoreCase("literal")) break;
                        faultBodyType = 1;
                        break;
                    }
                    faultMap.put(faultName, new Integer(faultBodyType));
                }
                attributes.put(bindOp.getOperation(), new BindingEntry.OperationAttr(inputBodyType, outputBodyType, faultMap));
                if (inputBodyType != 1 && outputBodyType != 1) continue;
                hasLiteral = true;
            }
            BindingEntry bEntry = new BindingEntry(binding, bindingType, bindingStyle, hasLiteral, attributes);
            this.symbolTablePut(bEntry);
        }
    }

    private void populateServices(Definition def) throws IOException {
        Iterator i = def.getServices().values().iterator();
        while (i.hasNext()) {
            Service service = (Service)i.next();
            if (service.getQName() == null || service.getQName().getLocalPart() == null || service.getQName().getLocalPart().equals("")) {
                throw new IOException(JavaUtils.getMessage("BadServiceName00"));
            }
            ServiceEntry sEntry = new ServiceEntry(service);
            this.symbolTablePut(sEntry);
        }
    }

    private void setReferences(Definition def, Document doc) {
        Map stuff = def.getServices();
        if (stuff.isEmpty()) {
            stuff = def.getBindings();
            if (stuff.isEmpty()) {
                stuff = def.getPortTypes();
                if (stuff.isEmpty()) {
                    stuff = def.getMessages();
                    if (stuff.isEmpty()) {
                        int i = 0;
                        while (i < this.types.size()) {
                            TypeEntry type = (TypeEntry)this.types.get(i);
                            this.setTypeReferences(type, doc, false);
                            ++i;
                        }
                    } else {
                        Iterator i = stuff.values().iterator();
                        while (i.hasNext()) {
                            Message message = (Message)i.next();
                            MessageEntry mEntry = this.getMessageEntry(message.getQName());
                            this.setMessageReferences(mEntry, def, doc, false);
                        }
                    }
                } else {
                    Iterator i = stuff.values().iterator();
                    while (i.hasNext()) {
                        PortType portType = (PortType)i.next();
                        PortTypeEntry ptEntry = this.getPortTypeEntry(portType.getQName());
                        this.setPortTypeReferences(ptEntry, null, def, doc);
                    }
                }
            } else {
                Iterator i = stuff.values().iterator();
                while (i.hasNext()) {
                    Binding binding = (Binding)i.next();
                    BindingEntry bEntry = this.getBindingEntry(binding.getQName());
                    this.setBindingReferences(bEntry, def, doc);
                }
            }
        } else {
            Iterator i = stuff.values().iterator();
            while (i.hasNext()) {
                Service service = (Service)i.next();
                ServiceEntry sEntry = this.getServiceEntry(service.getQName());
                this.setServiceReferences(sEntry, def, doc);
            }
        }
    }

    private void setTypeReferences(TypeEntry entry, Document doc, boolean literal) {
        if (entry.isReferenced() && !literal || entry.isOnlyLiteralReferenced() && literal) {
            return;
        }
        if (this.wrapped) {
            if (!entry.isReferenced() && literal) {
                entry.setOnlyLiteralReference(true);
            } else if (entry.isOnlyLiteralReferenced() && !literal) {
                entry.setOnlyLiteralReference(false);
            }
        }
        Node node = entry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == doc) {
            entry.setIsReferenced(true);
            if (entry instanceof DefinedElement) {
                Type anonType;
                QName anonQName;
                TypeEntry referent;
                BooleanHolder forElement = new BooleanHolder();
                QName referentName = Utils.getNodeTypeRefQName(node, forElement);
                if (referentName != null && (referent = this.getTypeEntry(referentName, forElement.value)) != null) {
                    this.setTypeReferences(referent, doc, literal);
                }
                if ((anonQName = SchemaUtils.getElementAnonQName(entry.getNode())) != null && (anonType = this.getType(anonQName)) != null) {
                    this.setTypeReferences(anonType, doc, literal);
                    return;
                }
            }
        }
        HashSet nestedTypes = Utils.getNestedTypes(entry, this, true);
        Iterator it = nestedTypes.iterator();
        while (it.hasNext()) {
            TypeEntry nestedType = (TypeEntry)it.next();
            if (nestedType.isReferenced()) continue;
            this.setTypeReferences(nestedType, doc, false);
        }
    }

    private void setMessageReferences(MessageEntry entry, Definition def, Document doc, boolean literal) {
        Message message = entry.getMessage();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map messages = def.getMessages();
            if (messages.containsValue(message)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator parts = message.getParts().values().iterator();
        while (parts.hasNext()) {
            Part part = (Part)parts.next();
            TypeEntry type = this.getType(part.getTypeName());
            if (type != null) {
                this.setTypeReferences(type, doc, literal);
            }
            if ((type = this.getElement(part.getElementName())) == null) continue;
            this.setTypeReferences(type, doc, literal);
            TypeEntry refType = type.getRefType();
            if (refType == null) continue;
            this.setTypeReferences(refType, doc, literal);
        }
    }

    private void setPortTypeReferences(PortTypeEntry entry, BindingEntry bEntry, Definition def, Document doc) {
        PortType portType = entry.getPortType();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map portTypes = def.getPortTypes();
            if (portTypes.containsValue(portType)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator operations = portType.getOperations().iterator();
        while (operations.hasNext()) {
            MessageEntry mEntry;
            Message message;
            Operation operation = (Operation)operations.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean literalInput = false;
            boolean literalOutput = false;
            if (bEntry != null) {
                literalInput = bEntry.getInputBodyType(operation) == 1;
                boolean bl = literalOutput = bEntry.getOutputBodyType(operation) == 1;
            }
            if (input != null && (message = input.getMessage()) != null && (mEntry = this.getMessageEntry(message.getQName())) != null) {
                this.setMessageReferences(mEntry, def, doc, literalInput);
            }
            if (output != null && (message = output.getMessage()) != null && (mEntry = this.getMessageEntry(message.getQName())) != null) {
                this.setMessageReferences(mEntry, def, doc, literalOutput);
            }
            Iterator faults = operation.getFaults().values().iterator();
            while (faults.hasNext()) {
                MessageEntry mEntry2;
                Message message2 = ((Fault)faults.next()).getMessage();
                if (message2 == null || (mEntry2 = this.getMessageEntry(message2.getQName())) == null) continue;
                this.setMessageReferences(mEntry2, def, doc, false);
            }
        }
    }

    private void setBindingReferences(BindingEntry entry, Definition def, Document doc) {
        if (entry.getBindingType() == 0) {
            Binding binding = entry.getBinding();
            if (this.addImports) {
                entry.setIsReferenced(true);
            } else {
                Map bindings = def.getBindings();
                if (bindings.containsValue(binding)) {
                    entry.setIsReferenced(true);
                }
            }
            PortType portType = binding.getPortType();
            PortTypeEntry ptEntry = this.getPortTypeEntry(portType.getQName());
            if (ptEntry != null) {
                this.setPortTypeReferences(ptEntry, entry, def, doc);
            }
        }
    }

    private void setServiceReferences(ServiceEntry entry, Definition def, Document doc) {
        Service service = entry.getService();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map services = def.getServices();
            if (services.containsValue(service)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator ports = service.getPorts().values().iterator();
        while (ports.hasNext()) {
            Port port = (Port)ports.next();
            Binding binding = port.getBinding();
            BindingEntry bEntry = this.getBindingEntry(binding.getQName());
            if (bEntry == null) continue;
            this.setBindingReferences(bEntry, def, doc);
        }
    }

    private void symbolTablePut(SymTabEntry entry) throws IOException {
        QName name = entry.getQName();
        if (this.get(name, entry.getClass()) == null) {
            if (entry instanceof Type && this.get(name, class$org$apache$axis$wsdl$symbolTable$UndefinedType == null ? (class$org$apache$axis$wsdl$symbolTable$UndefinedType = SymbolTable.class$("org.apache.axis.wsdl.symbolTable.UndefinedType")) : class$org$apache$axis$wsdl$symbolTable$UndefinedType) != null) {
                if (((TypeEntry)this.get(name, class$org$apache$axis$wsdl$symbolTable$UndefinedType == null ? (class$org$apache$axis$wsdl$symbolTable$UndefinedType = SymbolTable.class$("org.apache.axis.wsdl.symbolTable.UndefinedType")) : class$org$apache$axis$wsdl$symbolTable$UndefinedType)).isSimpleType() && !((TypeEntry)entry).isSimpleType()) {
                    throw new IOException(JavaUtils.getMessage("AttrNotSimpleType01", name.toString()));
                }
                Vector v = (Vector)this.symbolTable.get(name);
                int i = 0;
                while (i < v.size()) {
                    Object oldEntry = v.elementAt(i);
                    if (oldEntry instanceof UndefinedType) {
                        v.setElementAt(entry, i);
                        int j = 0;
                        while (j < this.types.size()) {
                            if (this.types.elementAt(j) == oldEntry) {
                                this.types.setElementAt(entry, j);
                            }
                            ++j;
                        }
                        ((UndefinedType)oldEntry).update((Type)entry);
                    }
                    ++i;
                }
            } else if (entry instanceof Element && this.get(name, class$org$apache$axis$wsdl$symbolTable$UndefinedElement == null ? (class$org$apache$axis$wsdl$symbolTable$UndefinedElement = SymbolTable.class$("org.apache.axis.wsdl.symbolTable.UndefinedElement")) : class$org$apache$axis$wsdl$symbolTable$UndefinedElement) != null) {
                Vector v = (Vector)this.symbolTable.get(name);
                int i = 0;
                while (i < v.size()) {
                    Object oldEntry = v.elementAt(i);
                    if (oldEntry instanceof UndefinedElement) {
                        v.setElementAt(entry, i);
                        int j = 0;
                        while (j < this.types.size()) {
                            if (this.types.elementAt(j) == oldEntry) {
                                this.types.setElementAt(entry, j);
                            }
                            ++j;
                        }
                        ((Undefined)oldEntry).update((Element)entry);
                    }
                    ++i;
                }
            } else {
                Vector<SymTabEntry> v = (Vector<SymTabEntry>)this.symbolTable.get(name);
                if (v == null) {
                    v = new Vector<SymTabEntry>();
                    this.symbolTable.put(name, v);
                }
                v.add(entry);
                if (entry instanceof TypeEntry) {
                    this.types.add(entry);
                }
            }
        } else {
            throw new IOException(JavaUtils.getMessage("alreadyExists00", "" + name));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

