/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaBeanHelperWriter
extends JavaClassWriter {
    protected TypeEntry type;
    protected Vector elements;
    protected Vector attributes;
    protected TypeEntry extendType;
    protected PrintWriter wrapperPW = null;
    protected Vector elementMetaData = null;

    protected JavaBeanHelperWriter(Emitter emitter, TypeEntry type, Vector elements, TypeEntry extendType, Vector attributes) {
        super(emitter, type.getName() + "_Helper", "helper");
        this.type = type;
        this.elements = elements;
        this.attributes = attributes;
        this.extendType = extendType;
    }

    protected void setPrintWriter(PrintWriter pw) {
        this.wrapperPW = pw;
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        return this.wrapperPW == null ? super.getPrintWriter(filename) : this.wrapperPW;
    }

    protected void registerFile(String file) {
        if (this.wrapperPW == null) {
            super.registerFile(file);
        }
    }

    protected String verboseMessage(String file) {
        if (this.wrapperPW == null) {
            return super.verboseMessage(file);
        }
        return null;
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileHeader(pw);
        }
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeMetaData(pw);
        this.writeSerializer(pw);
        this.writeDeserializer(pw);
    }

    protected void writeFileFooter(PrintWriter pw) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileFooter(pw);
        }
    }

    protected void closePrintWriter(PrintWriter pw) {
        if (this.wrapperPW == null) {
            pw.close();
        }
    }

    protected void writeMetaData(PrintWriter pw) throws IOException {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.size()) {
                ElementDecl elem = (ElementDecl)this.elements.get(i);
                String elemName = elem.getName().getLocalPart();
                String javaName = Utils.xmlNameToJava(elemName);
                if (this.elementMetaData == null) {
                    this.elementMetaData = new Vector();
                }
                this.elementMetaData.add(elem);
                ++i;
            }
        }
        if (this.attributes != null || this.elementMetaData != null) {
            String fieldName;
            boolean wroteFieldType = false;
            pw.println("    // " + JavaUtils.getMessage("typeMeta"));
            pw.println("    private static org.apache.axis.description.TypeDesc typeDesc =");
            pw.println("        new org.apache.axis.description.TypeDesc(" + Utils.getJavaLocalName(this.type.getName()) + ".class);");
            pw.println();
            pw.println("    static {");
            if (this.attributes != null) {
                int i = 0;
                while (i < this.attributes.size()) {
                    QName attrName = (QName)this.attributes.get(i + 1);
                    String attrLocalName = attrName.getLocalPart();
                    fieldName = Utils.xmlNameToJava(attrLocalName);
                    pw.print("        ");
                    if (!wroteFieldType) {
                        pw.print("org.apache.axis.description.FieldDesc ");
                        wroteFieldType = true;
                    }
                    pw.println("field = new org.apache.axis.description.AttributeDesc();");
                    pw.println("        field.setFieldName(\"" + fieldName + "\");");
                    pw.print("        field.setXmlName(");
                    pw.print("new javax.xml.namespace.QName(\"");
                    pw.print(attrName.getNamespaceURI() + "\", \"");
                    pw.println(attrName.getLocalPart() + "\"));");
                    pw.println("        typeDesc.addFieldDesc(field);");
                    i += 2;
                }
            }
            if (this.elementMetaData != null) {
                int i = 0;
                while (i < this.elementMetaData.size()) {
                    ElementDecl elem = (ElementDecl)this.elementMetaData.elementAt(i);
                    String elemLocalName = elem.getName().getLocalPart();
                    fieldName = Utils.xmlNameToJava(elemLocalName);
                    QName xmlName = elem.getName();
                    pw.print("        ");
                    if (!wroteFieldType) {
                        pw.print("org.apache.axis.description.FieldDesc ");
                        wroteFieldType = true;
                    }
                    pw.println("field = new org.apache.axis.description.ElementDesc();");
                    pw.println("        field.setFieldName(\"" + fieldName + "\");");
                    pw.print("        field.setXmlName(new javax.xml.namespace.QName(\"");
                    pw.println(xmlName.getNamespaceURI() + "\", \"" + xmlName.getLocalPart() + "\"));");
                    if (elem.getMinOccursIs0()) {
                        pw.println("        field.setMinOccursIs0(true);");
                    }
                    pw.println("        typeDesc.addFieldDesc(field);");
                    ++i;
                }
            }
            pw.println("    };");
            pw.println();
            pw.println("    /**");
            pw.println("     * " + JavaUtils.getMessage("returnTypeMeta"));
            pw.println("     */");
            pw.println("    public static org.apache.axis.description.TypeDesc getTypeDesc() {");
            pw.println("        return typeDesc;");
            pw.println("    }");
            pw.println();
        }
    }

    protected void writeSerializer(PrintWriter pw) throws IOException {
        String typeDesc = null;
        if (this.attributes != null || this.elementMetaData != null) {
            typeDesc = "typeDesc";
        }
        String ser = " org.apache.axis.encoding.ser.BeanSerializer";
        if (this.type.isSimpleType()) {
            ser = " org.apache.axis.encoding.ser.SimpleSerializer";
        }
        pw.println("    /**");
        pw.println("     * Get Custom Serializer");
        pw.println("     */");
        pw.println("    public static org.apache.axis.encoding.Serializer getSerializer(");
        pw.println("           String mechType, ");
        pw.println("           Class _javaType,  ");
        pw.println("           javax.xml.namespace.QName _xmlType) {");
        pw.println("        return ");
        pw.println("          new " + ser + "(");
        pw.println("            _javaType, _xmlType, " + typeDesc + ");");
        pw.println("    }");
        pw.println();
    }

    protected void writeDeserializer(PrintWriter pw) throws IOException {
        String typeDesc = null;
        if (this.attributes != null || this.elementMetaData != null) {
            typeDesc = "typeDesc";
        }
        String dser = " org.apache.axis.encoding.ser.BeanDeserializer";
        if (this.type.isSimpleType()) {
            dser = " org.apache.axis.encoding.ser.SimpleDeserializer";
        }
        pw.println("    /**");
        pw.println("     * Get Custom Deserializer");
        pw.println("     */");
        pw.println("    public static org.apache.axis.encoding.Deserializer getDeserializer(");
        pw.println("           String mechType, ");
        pw.println("           Class _javaType,  ");
        pw.println("           javax.xml.namespace.QName _xmlType) {");
        pw.println("        return ");
        pw.println("          new " + dser + "(");
        pw.println("            _javaType, _xmlType, " + typeDesc + ");");
        pw.println("    }");
        pw.println();
    }
}

