/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaFaultWriter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaDefinitionWriter
implements Generator {
    protected Emitter emitter;
    protected Definition definition;
    protected SymbolTable symbolTable;
    private HashSet importedFiles = new HashSet();

    public JavaDefinitionWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        this.writeFaults();
    }

    private void writeFaults() throws IOException {
        HashMap faults = new HashMap();
        this.collectFaults(this.definition, faults);
        Iterator fi = faults.entrySet().iterator();
        while (fi.hasNext()) {
            Boolean complexTypeFault;
            Map.Entry entry = fi.next();
            Fault fault = (Fault)entry.getKey();
            MessageEntry me = this.symbolTable.getMessageEntry(fault.getMessage().getQName());
            boolean emitSimpleFault = true;
            if (me != null && (complexTypeFault = (Boolean)me.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT)) != null && complexTypeFault.booleanValue()) {
                emitSimpleFault = false;
            }
            if (!emitSimpleFault) continue;
            QName faultQName = (QName)entry.getValue();
            new JavaFaultWriter(this.emitter, faultQName, fault, this.symbolTable).generate();
        }
    }

    private void collectFaults(Definition def, Map faults) throws IOException {
        Vector<String> faultList = new Vector<String>();
        Map imports = def.getImports();
        Object[] importValues = imports.values().toArray();
        int i = 0;
        while (i < importValues.length) {
            Vector v = (Vector)importValues[i];
            int j = 0;
            while (j < v.size()) {
                Import imp = (Import)v.get(j);
                if (!this.importedFiles.contains(imp.getLocationURI())) {
                    this.importedFiles.add(imp.getLocationURI());
                    Definition importDef = imp.getDefinition();
                    if (importDef != null) {
                        this.collectFaults(importDef, faults);
                    }
                }
                ++j;
            }
            ++i;
        }
        Map portTypes = def.getPortTypes();
        Iterator pti = portTypes.values().iterator();
        while (pti.hasNext()) {
            PortType portType = (PortType)pti.next();
            if (!this.symbolTable.getPortTypeEntry(portType.getQName()).isReferenced()) continue;
            List operations = portType.getOperations();
            int i2 = 0;
            while (i2 < operations.size()) {
                Operation operation = (Operation)operations.get(i2);
                Map opFaults = operation.getFaults();
                Iterator fi = opFaults.values().iterator();
                while (fi.hasNext()) {
                    Fault f = (Fault)fi.next();
                    String name = Utils.getFullExceptionName(f, this.emitter);
                    if (faultList.contains(name)) continue;
                    faultList.add(name);
                    faults.put(f, f.getMessage().getQName());
                }
                ++i2;
            }
        }
    }
}

