/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;

public class JavaEnumTypeWriter
extends JavaClassWriter {
    private TypeEntry type;
    private Vector elements;

    protected JavaEnumTypeWriter(Emitter emitter, TypeEntry type, Vector elements) {
        super(emitter, type.getName(), "enumType");
        this.type = type;
        this.elements = elements;
    }

    protected String getImplementsText() {
        return "implements java.io.Serializable ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        String javaName = this.getClassName();
        String baseType = ((TypeEntry)this.elements.get(0)).getName();
        String baseClass = "Object";
        if (baseType.indexOf("String") >= 0) {
            baseClass = "String";
        } else if (baseType.equals("java.math.BigDecimal")) {
            baseClass = "java.math.BigDecimal";
        } else if (baseType.equals("java.math.BigInteger")) {
            baseClass = "java.math.BigInteger";
        } else if (baseType.indexOf("int") == 0) {
            baseClass = "Integer";
        } else if (baseType.indexOf("char") == 0) {
            baseClass = "Character";
        } else if (baseType.indexOf("short") == 0) {
            baseClass = "Short";
        } else if (baseType.indexOf("long") == 0) {
            baseClass = "Long";
        } else if (baseType.indexOf("double") == 0) {
            baseClass = "Double";
        } else if (baseType.indexOf("float") == 0) {
            baseClass = "Float";
        } else if (baseType.indexOf("byte") == 0) {
            baseClass = "Byte";
        }
        Vector<String> values = new Vector<String>();
        int i = 1;
        while (i < this.elements.size()) {
            String value = (String)this.elements.get(i);
            if (baseClass.equals("String")) {
                value = "\"" + value + "\"";
            }
            if (baseClass.equals("java.math.BigDecimal") || baseClass.equals("java.math.BigInteger")) {
                value = "new " + baseClass + "(\"" + value + "\")";
            } else if (baseClass.equals("Character")) {
                value = "'" + value + "'";
            } else if (baseClass.equals("Float")) {
                if (!value.endsWith("F") && !value.endsWith("f")) {
                    value = value + "F";
                }
            } else if (baseClass.equals("Long") && !value.endsWith("L") && !value.endsWith("l")) {
                value = value + "L";
            }
            values.add(value);
            ++i;
        }
        Vector ids = JavaEnumTypeWriter.getEnumValueIds(this.elements);
        pw.println("    private " + baseType + " _value_;");
        pw.println("    private static java.util.HashMap _table_ = new java.util.HashMap();");
        pw.println("");
        pw.println("    // " + JavaUtils.getMessage("ctor00"));
        pw.println("    protected " + javaName + "(" + baseType + " value) {");
        pw.println("        _value_ = value;");
        if (baseClass.equals("String") || baseClass.equals("java.math.BigDecimal") || baseClass.equals("java.math.BigInteger")) {
            pw.println("        _table_.put(_value_,this);");
        } else {
            pw.println("        _table_.put(new " + baseClass + "(_value_),this);");
        }
        pw.println("    };");
        pw.println("");
        int i2 = 0;
        while (i2 < ids.size()) {
            pw.println("    public static final " + baseType + " _" + ids.get(i2) + " = " + values.get(i2) + ";");
            ++i2;
        }
        int i3 = 0;
        while (i3 < ids.size()) {
            pw.println("    public static final " + javaName + " " + ids.get(i3) + " = new " + javaName + "(_" + ids.get(i3) + ");");
            ++i3;
        }
        pw.println("    public " + baseType + " getValue() { return _value_;}");
        pw.println("    public static " + javaName + " fromValue(" + baseType + " value)");
        pw.println("          throws java.lang.IllegalStateException {");
        pw.println("        " + javaName + " enum = (" + javaName + ")");
        if (baseClass.equals("String") || baseClass.equals("java.math.BigDecimal") || baseClass.equals("java.math.BigInteger")) {
            pw.println("            _table_.get(value);");
        } else {
            pw.println("            _table_.get(new " + baseClass + "(value));");
        }
        pw.println("        if (enum==null) throw new java.lang.IllegalStateException();");
        pw.println("        return enum;");
        pw.println("    }");
        pw.println("    public static " + javaName + " fromString(String value)");
        pw.println("          throws java.lang.IllegalStateException {");
        if (baseClass.equals("String")) {
            pw.println("        return fromValue(value);");
        } else if (baseClass.equals("java.math.BigDecimal") || baseClass.equals("java.math.BigInteger")) {
            pw.println("        return fromValue(new " + baseClass + "(value));");
        } else if (baseClass.equals("Character")) {
            pw.println("        if (value != null && value.length() == 1);");
            pw.println("            return fromValue(value.charAt(0));");
            pw.println("        throw new java.lang.IllegalStateException();");
        } else if (baseClass.equals("Integer")) {
            pw.println("        try {");
            pw.println("            return fromValue(Integer.parseInt(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalStateException();");
            pw.println("        }");
        } else {
            pw.println("        try {");
            pw.println("            return fromValue(" + baseClass + ".parse" + baseClass + "(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalStateException();");
            pw.println("        }");
        }
        pw.println("    }");
        pw.println("    public boolean equals(Object obj) {return (obj == this);}");
        pw.println("    public int hashCode() { return toString().hashCode();}");
        if (baseClass.equals("String")) {
            pw.println("    public String toString() { return _value_;}");
        } else if (baseClass.equals("java.math.BigDecimal") || baseClass.equals("java.math.BigInteger")) {
            pw.println("    public String toString() { return _value_.toString();}");
        } else {
            pw.println("    public String toString() { return String.valueOf(_value_);}");
        }
    }

    public static Vector getEnumValueIds(Vector bv) {
        boolean validJava = true;
        int i = 1;
        while (i < bv.size() && validJava) {
            String value = (String)bv.get(i);
            if (!JavaUtils.isJavaId(value)) {
                validJava = false;
            }
            ++i;
        }
        Vector<String> ids = new Vector<String>();
        int i2 = 1;
        while (i2 < bv.size()) {
            if (!validJava) {
                ids.add("value" + i2);
            } else {
                ids.add((String)bv.get(i2));
            }
            ++i2;
        }
        return ids;
    }
}

