/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaFaultWriter
extends JavaClassWriter {
    private Fault fault;
    private SymbolTable symbolTable;

    protected JavaFaultWriter(Emitter emitter, QName qname, Fault fault, SymbolTable symbolTable) {
        super(emitter, Utils.getFullExceptionName(fault, emitter), "fault");
        this.fault = fault;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends org.apache.axis.AxisFault ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Vector params = new Vector();
        this.symbolTable.getParametersFromParts(params, this.fault.getMessage().getOrderedParts(null), false, this.fault.getName(), "unknown");
        int i = 0;
        while (i < params.size()) {
            Parameter param = (Parameter)params.get(i);
            String type = param.getType().getName();
            String variable = param.getName();
            pw.println("    public " + type + " " + variable + ";");
            pw.println("    public " + type + " get" + Utils.capitalizeFirstChar(variable) + "() {");
            pw.println("        return this." + variable + ";");
            pw.println("    }");
            ++i;
        }
        pw.println();
        pw.println("    public " + this.className + "() {");
        pw.println("    }");
        pw.println();
        if (params.size() > 0) {
            String variable;
            pw.print("      public " + this.className + "(");
            int i2 = 0;
            while (i2 < params.size()) {
                if (i2 != 0) {
                    pw.print(", ");
                }
                Parameter param = (Parameter)params.get(i2);
                String type = param.getType().getName();
                variable = param.getName();
                pw.print(type + " " + variable);
                ++i2;
            }
            pw.println(") {");
            int i3 = 0;
            while (i3 < params.size()) {
                Parameter param = (Parameter)params.get(i3);
                variable = param.getName();
                pw.println("        this." + variable + " = " + variable + ";");
                ++i3;
            }
            pw.println("    }");
        }
    }
}

