/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaImplWriter
extends JavaClassWriter {
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry.getName() + "Impl", "templateImpl");
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bEntry;
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        List operations = this.binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(parameters.signature);
                pw.println();
            } else {
                this.writeOperation(pw, parameters);
            }
            ++i;
        }
    }

    protected String getImplementsText() {
        String portTypeName = (String)this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
        String implementsText = "implements " + portTypeName;
        return implementsText;
    }

    protected void writeOperation(PrintWriter pw, Parameters parms) throws IOException {
        pw.println(parms.signature + " {");
        Iterator iparam = ((AbstractList)parms.list).iterator();
        while (iparam.hasNext()) {
            Parameter param = (Parameter)iparam.next();
            String paramType = param.getType().getName();
            if (param.getMode() != 2) continue;
            pw.print("        " + Utils.xmlNameToJava(param.getName()) + ".value = ");
            if (Utils.isPrimitiveType(param.getType())) {
                if ("boolean".equals(paramType)) {
                    pw.print("false");
                } else if ("byte".equals(paramType)) {
                    pw.print("(byte)-3");
                } else if ("short".equals(paramType)) {
                    pw.print("(short)-3");
                } else {
                    pw.print("-3");
                }
            } else if (paramType.equals("java.lang.Boolean")) {
                pw.print("new java.lang.Boolean(false)");
            } else if (paramType.equals("java.lang.Byte")) {
                pw.print("new java.lang.Byte((byte)-3)");
            } else if (paramType.equals("java.lang.Double")) {
                pw.print("new java.lang.Double(-3)");
            } else if (paramType.equals("java.lang.Float")) {
                pw.print("new java.lang.Float(-3)");
            } else if (paramType.equals("java.lang.Integer")) {
                pw.print("new java.lang.Integer(-3)");
            } else if (paramType.equals("java.lang.Long")) {
                pw.print("new java.lang.Long(-3)");
            } else if (paramType.equals("java.lang.Short")) {
                pw.print("new java.lang.Short((short)-3)");
            } else if (paramType.equals("java.math.BigDecimal")) {
                pw.print("new java.math.BigDecimal(-3)");
            } else if (paramType.equals("java.math.BigInteger")) {
                pw.print("new java.math.BigInteger(\"-3\")");
            } else if (paramType.equals("java.lang.Object")) {
                pw.print("new java.lang.String()");
            } else if (paramType.equals("byte[]")) {
                pw.print("new byte[0]");
            } else if (paramType.equals("java.lang.Byte[]")) {
                pw.print("new java.lang.Byte[0]");
            } else if (paramType.equals("java.util.Calendar")) {
                pw.print("java.util.Calendar.getInstance()");
            } else if (paramType.equals("javax.xml.namespace.QName")) {
                pw.print("new javax.xml.namespace.QName(\"\", \"\")");
            } else if (paramType.endsWith("[]")) {
                pw.print("new " + JavaUtils.replace(paramType, "[]", "[0]"));
            } else {
                Vector v = Utils.getEnumerationBaseAndValues(param.getType().getNode(), this.symbolTable);
                if (v != null) {
                    String enumeration = (String)JavaEnumTypeWriter.getEnumValueIds(v).get(0);
                    pw.print(paramType + "." + enumeration);
                } else {
                    pw.print("new " + paramType + "()");
                }
            }
            pw.println(";");
        }
        if (parms.returnType != null) {
            pw.print("        return ");
            if (Utils.isPrimitiveType(parms.returnType)) {
                String returnType = parms.returnType.getName();
                if ("boolean".equals(returnType)) {
                    pw.println("false;");
                } else if ("byte".equals(returnType)) {
                    pw.println("(byte)-3;");
                } else if ("short".equals(returnType)) {
                    pw.println("(short)-3;");
                } else {
                    pw.println("-3;");
                }
            } else {
                pw.println("null;");
            }
        }
        pw.println("    }");
        pw.println();
    }
}

