/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.WSDLUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaServiceImplWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "Locator", "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends org.apache.axis.client.Service ";
    }

    protected String getImplementsText() {
        return "implements " + this.sEntry.getName() + ' ';
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(pw, service.getDocumentationElement());
        Vector<String> getPortIfaces = new Vector<String>();
        Vector<String> getPortStubClasses = new Vector<String>();
        Vector<String> getPortPortNames = new Vector<String>();
        boolean printGetPortNotice = false;
        Map portMap = service.getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = Utils.xmlNameToJavaClass(p.getName());
            String stubClass = bEntry.getName() + "Stub";
            String bindingType = (String)bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
            if (getPortIfaces.contains(bindingType)) {
                printGetPortNotice = true;
            } else {
                getPortIfaces.add(bindingType);
                getPortStubClasses.add(stubClass);
                getPortPortNames.add(portName);
            }
            String address = WSDLUtils.getAddressFromPort(p);
            if (address == null) {
                throw new IOException(JavaUtils.getMessage("emitFail02", portName, this.className));
            }
            try {
                new URL(address);
            }
            catch (MalformedURLException e) {
                throw new IOException(JavaUtils.getMessage("emitFail03", new String[]{portName, this.className, address}));
            }
            pw.println();
            pw.println("    // " + JavaUtils.getMessage("getProxy00", portName));
            this.writeComment(pw, p.getDocumentationElement());
            pw.println("    private final java.lang.String " + portName + "_address = \"" + address + "\";");
            pw.println("");
            pw.println("    public String get" + portName + "Address() {");
            pw.println("        return " + portName + "_address;");
            pw.println("    }");
            pw.println("");
            pw.println("    public " + bindingType + " get" + portName + "() throws javax.xml.rpc.ServiceException {");
            pw.println("       java.net.URL endpoint;");
            pw.println("        try {");
            pw.println("            endpoint = new java.net.URL(" + portName + "_address);");
            pw.println("        }");
            pw.println("        catch (java.net.MalformedURLException e) {");
            pw.println("            return null; // " + JavaUtils.getMessage("unlikely00"));
            pw.println("        }");
            pw.println("        return get" + portName + "(endpoint);");
            pw.println("    }");
            pw.println();
            pw.println("    public " + bindingType + " get" + portName + "(java.net.URL portAddress) throws javax.xml.rpc.ServiceException {");
            pw.println("        try {");
            pw.println("            return new " + stubClass + "(portAddress, this);");
            pw.println("        }");
            pw.println("        catch (org.apache.axis.AxisFault e) {");
            pw.println("            return null; // ???");
            pw.println("        }");
            pw.println("    }");
        }
        pw.println();
        pw.println("    /**");
        pw.println("     * " + JavaUtils.getMessage("getPortDoc00"));
        pw.println("     * " + JavaUtils.getMessage("getPortDoc01"));
        pw.println("     * " + JavaUtils.getMessage("getPortDoc02"));
        if (printGetPortNotice) {
            pw.println("     * " + JavaUtils.getMessage("getPortDoc03"));
            pw.println("     * " + JavaUtils.getMessage("getPortDoc04"));
        }
        pw.println("     */");
        pw.println("    public java.rmi.Remote getPort(Class serviceEndpointInterface) throws javax.xml.rpc.ServiceException {");
        if (getPortIfaces.size() == 0) {
            pw.println("        throw new javax.xml.rpc.ServiceException(\"" + JavaUtils.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        } else {
            pw.println("        try {");
            int i = 0;
            while (i < getPortIfaces.size()) {
                String iface = (String)getPortIfaces.get(i);
                String stubClass = (String)getPortStubClasses.get(i);
                String portName = (String)getPortPortNames.get(i);
                pw.println("            if (" + iface + ".class.isAssignableFrom(serviceEndpointInterface)) {");
                pw.println("                return new " + stubClass + "(new java.net.URL(" + portName + "_address), this);");
                pw.println("            }");
                ++i;
            }
            pw.println("        }");
            pw.println("        catch (Throwable t) {");
            pw.println("            throw new javax.xml.rpc.ServiceException(t);");
            pw.println("        }");
            pw.println("        throw new javax.xml.rpc.ServiceException(\"" + JavaUtils.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        }
        pw.println("    }");
        pw.println();
    }
}

