/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaSkelWriter
extends JavaClassWriter {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;

    protected JavaSkelWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry.getName() + "Skeleton", "skeleton");
        this.bEntry = bEntry;
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME) + ", org.apache.axis.wsdl.Skeleton ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        String portTypeName = (String)this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
        String implType = portTypeName + " impl";
        boolean isRPC = true;
        if (this.bEntry.getBindingStyle() == 1) {
            isRPC = false;
        }
        pw.println("    private " + implType + ";");
        pw.println("    private static java.util.Map _myOperations = new java.util.Hashtable();");
        pw.println("    private static java.util.Collection _myOperationsList = new java.util.ArrayList();");
        pw.println();
        pw.println("    /**");
        pw.println("    * Returns List of OperationDesc objects with this name");
        pw.println("    */");
        pw.println("    public static java.util.List getOperationDescByName(String methodName) {");
        pw.println("        return (java.util.List)_myOperations.get(methodName);");
        pw.println("    }");
        pw.println();
        pw.println("    /**");
        pw.println("    * Returns Collection of OperationDescs");
        pw.println("    */");
        pw.println("    public static java.util.Collection getOperationDescs() {");
        pw.println("        return _myOperationsList;");
        pw.println("    }");
        pw.println();
        pw.println("    static {");
        pw.println("        org.apache.axis.description.OperationDesc _oper;");
        pw.println("        org.apache.axis.description.ParameterDesc [] _params;");
        List operations = this.binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            if (parameters != null) {
                String opName = operation.getOperation().getName();
                String javaOpName = Utils.xmlNameToJava(opName);
                pw.println("        _params = new org.apache.axis.description.ParameterDesc [] {");
                int j = 0;
                while (j < parameters.list.size()) {
                    String modeStr;
                    Parameter p = (Parameter)parameters.list.get(j);
                    switch (p.getMode()) {
                        case 1: {
                            modeStr = "org.apache.axis.description.ParameterDesc.IN";
                            break;
                        }
                        case 2: {
                            modeStr = "org.apache.axis.description.ParameterDesc.OUT";
                            break;
                        }
                        case 3: {
                            modeStr = "org.apache.axis.description.ParameterDesc.INOUT";
                            break;
                        }
                        default: {
                            throw new IOException(JavaUtils.getMessage("badParmMode00", new Byte(p.getMode()).toString()));
                        }
                    }
                    TypeEntry paramType = p.getType();
                    if (paramType instanceof Element && paramType.getRefType() != null) {
                        paramType = paramType.getRefType();
                    }
                    pw.println("            new org.apache.axis.description.ParameterDesc(" + Utils.getNewQName(p.getQName()) + ", " + modeStr + "," + Utils.getNewQName(paramType.getQName()) + "," + p.getType().getName() + ".class" + "),");
                    ++j;
                }
                pw.println("        };");
                String returnStr = parameters.returnType != null ? Utils.getNewQName(parameters.returnName) : "null";
                pw.println("        _oper = new org.apache.axis.description.OperationDesc(\"" + javaOpName + "\", _params, " + returnStr + ");");
                QName elementQName = Utils.getOperationQName(operation);
                if (elementQName != null) {
                    pw.println("        _oper.setElementQName(" + Utils.getNewQName(elementQName) + ");");
                }
                List elems = operation.getExtensibilityElements();
                Iterator it = elems.iterator();
                boolean found = false;
                while (!found && it.hasNext()) {
                    SOAPOperation soapOp;
                    String action;
                    ExtensibilityElement elem = (ExtensibilityElement)it.next();
                    if (!(elem instanceof SOAPOperation) || (action = (soapOp = (SOAPOperation)elem).getSoapActionURI()) == null) continue;
                    pw.println("        _oper.setSoapAction(\"" + action + "\");");
                    found = true;
                }
                pw.println("        _myOperationsList.add(_oper);");
                pw.println("        if (_myOperations.get(\"" + javaOpName + "\")==null) {");
                pw.println("            _myOperations.put(\"" + javaOpName + "\", new java.util.ArrayList());");
                pw.println("        }");
                pw.println("        ((java.util.List)_myOperations.get(\"" + javaOpName + "\")).add(_oper);");
            }
            ++i;
        }
        pw.println("    }");
        pw.println();
        pw.println("    public " + this.className + "() {");
        pw.println("        this.impl = new " + this.bEntry.getName() + "Impl();");
        pw.println("    }");
        pw.println();
        pw.println("    public " + this.className + "(" + implType + ") {");
        pw.println("        this.impl = impl;");
        pw.println("    }");
        int i2 = 0;
        while (i2 < operations.size()) {
            Operation ptOperation;
            OperationType type;
            BindingOperation operation = (BindingOperation)operations.get(i2);
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            String soapAction = "";
            Iterator operationExtensibilityIterator = operation.getExtensibilityElements().iterator();
            while (operationExtensibilityIterator.hasNext()) {
                Object obj = operationExtensibilityIterator.next();
                if (!(obj instanceof SOAPOperation)) continue;
                soapAction = ((SOAPOperation)obj).getSoapActionURI();
                break;
            }
            String namespace = "";
            Iterator bindingMsgIterator = null;
            BindingInput input = operation.getBindingInput();
            if (input != null) {
                bindingMsgIterator = input.getExtensibilityElements().iterator();
            } else {
                BindingOutput output = operation.getBindingOutput();
                if (output != null) {
                    bindingMsgIterator = output.getExtensibilityElements().iterator();
                }
            }
            if (bindingMsgIterator != null) {
                while (bindingMsgIterator.hasNext()) {
                    Object obj = bindingMsgIterator.next();
                    if (!(obj instanceof SOAPBody)) continue;
                    namespace = ((SOAPBody)obj).getNamespaceURI();
                    if (namespace == null) {
                        namespace = this.symbolTable.getDefinition().getTargetNamespace();
                    }
                    if (namespace != null) break;
                    namespace = "";
                    break;
                }
            }
            if ((type = (ptOperation = operation.getOperation()).getStyle()) == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(parameters.signature);
                pw.println();
            } else {
                this.writeOperation(pw, operation, parameters, soapAction, namespace, isRPC);
            }
            ++i2;
        }
    }

    private void writeOperation(PrintWriter pw, BindingOperation operation, Parameters parms, String soapAction, String namespace, boolean isRPC) throws IOException {
        this.writeComment(pw, operation.getDocumentationElement());
        pw.println(parms.signature);
        pw.println("    {");
        if (parms.returnType == null) {
            pw.print("        ");
        } else {
            pw.print("        " + parms.returnType.getName() + " ret = ");
        }
        String call = "impl." + Utils.xmlNameToJava(operation.getName()) + "(";
        boolean needComma = false;
        int i = 0;
        while (i < parms.list.size()) {
            if (needComma) {
                call = call + ", ";
            } else {
                needComma = true;
            }
            Parameter p = (Parameter)parms.list.get(i);
            call = call + Utils.xmlNameToJava(p.getName());
            ++i;
        }
        call = call + ")";
        pw.println(call + ";");
        if (parms.returnType != null) {
            pw.println("        return ret;");
        }
        pw.println("    }");
        pw.println();
    }
}

