/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaStubWriter
extends JavaClassWriter {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    private boolean firstSer = true;

    protected JavaStubWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry.getName() + "Stub", "stub");
        this.bEntry = bEntry;
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends org.apache.axis.client.Stub ";
    }

    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        HashSet types;
        PortType portType = this.binding.getPortType();
        String portTypeName = (String)this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
        boolean isRPC = true;
        if (this.bEntry.getBindingStyle() == 1) {
            isRPC = false;
        }
        if ((types = this.getTypesInPortType(portType)).size() > 0) {
            pw.println("    private java.util.Vector cachedSerClasses = new java.util.Vector();");
            pw.println("    private java.util.Vector cachedSerQNames = new java.util.Vector();");
            pw.println("    private java.util.Vector cachedSerFactories = new java.util.Vector();");
            pw.println("    private java.util.Vector cachedDeserFactories = new java.util.Vector();");
        }
        pw.println();
        pw.println("    public " + this.className + "() throws org.apache.axis.AxisFault {");
        pw.println("         this(null);");
        pw.println("    }");
        pw.println();
        pw.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        pw.println("         this(service);");
        pw.println("         super.cachedEndpoint = endpointURL;");
        pw.println("    }");
        pw.println();
        pw.println("    public " + this.className + "(javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        pw.println("        try {");
        pw.println("            if (service == null) {");
        pw.println("                super.service = new org.apache.axis.client.Service();");
        pw.println("            } else {");
        pw.println("                super.service = service;");
        pw.println("            }");
        Iterator it = types.iterator();
        while (it.hasNext()) {
            this.writeSerializationInit(pw, (TypeEntry)it.next());
        }
        pw.println("        }");
        pw.println("        catch(java.lang.Exception t) {");
        pw.println("            throw org.apache.axis.AxisFault.makeFault(t);");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    private org.apache.axis.client.Call createCall() throws java.rmi.RemoteException {");
        pw.println("        try {");
        pw.println("            org.apache.axis.client.Call call =");
        pw.println("                    (org.apache.axis.client.Call) super.service.createCall();");
        pw.println("            if (super.maintainSessionSet) {");
        pw.println("                call.setMaintainSession(super.maintainSession);");
        pw.println("            }");
        pw.println("            if (super.cachedUsername != null) {");
        pw.println("                call.setUsername(super.cachedUsername);");
        pw.println("            }");
        pw.println("            if (super.cachedPassword != null) {");
        pw.println("                call.setPassword(super.cachedPassword);");
        pw.println("            }");
        pw.println("            if (super.cachedEndpoint != null) {");
        pw.println("                call.setTargetEndpointAddress(super.cachedEndpoint);");
        pw.println("            }");
        pw.println("            if (super.cachedTimeout != null) {");
        pw.println("                call.setTimeout(super.cachedTimeout);");
        pw.println("            }");
        pw.println("            java.util.Enumeration keys = super.cachedProperties.keys();");
        pw.println("            while (keys.hasMoreElements()) {");
        pw.println("                String key = (String) keys.nextElement();");
        pw.println("                if(call.isPropertySupported(key))");
        pw.println("                    call.setProperty(key, super.cachedProperties.get(key));");
        pw.println("                else");
        pw.println("                    call.setScopedProperty(key, super.cachedProperties.get(key));");
        pw.println("            }");
        if (types.size() > 0) {
            pw.println("            // " + JavaUtils.getMessage("typeMap00"));
            pw.println("            // " + JavaUtils.getMessage("typeMap01"));
            pw.println("            // " + JavaUtils.getMessage("typeMap02"));
            pw.println("            // " + JavaUtils.getMessage("typeMap03"));
            pw.println("            // " + JavaUtils.getMessage("typeMap04"));
            pw.println("            synchronized (this) {");
            pw.println("                if (firstCall()) {");
            pw.println("                    // " + JavaUtils.getMessage("mustSetStyle"));
            if (this.bEntry.hasLiteral()) {
                pw.println("                    call.setEncodingStyle(null);");
            } else {
                pw.println("                    call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP11_ENC);");
            }
            pw.println("                    for (int i = 0; i < cachedSerFactories.size(); ++i) {");
            pw.println("                        Class cls = (Class) cachedSerClasses.get(i);");
            pw.println("                        javax.xml.namespace.QName qName =");
            pw.println("                                (javax.xml.namespace.QName) cachedSerQNames.get(i);");
            pw.println("                        Class sf = (Class)");
            pw.println("                                 cachedSerFactories.get(i);");
            pw.println("                        Class df = (Class)");
            pw.println("                                 cachedDeserFactories.get(i);");
            pw.println("                        call.registerTypeMapping(cls, qName, sf, df, false);");
            pw.println("                    }");
            pw.println("                }");
            pw.println("            }");
        }
        pw.println("            return call;");
        pw.println("        }");
        pw.println("        catch (Throwable t) {");
        pw.println("            throw new org.apache.axis.AxisFault(\"" + JavaUtils.getMessage("badCall01") + "\", t);");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        List operations = this.binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            String soapAction = "";
            Iterator operationExtensibilityIterator = operation.getExtensibilityElements().iterator();
            while (operationExtensibilityIterator.hasNext()) {
                Object obj = operationExtensibilityIterator.next();
                if (!(obj instanceof SOAPOperation)) continue;
                soapAction = ((SOAPOperation)obj).getSoapActionURI();
                break;
            }
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(parameters.signature);
                pw.println();
            } else {
                this.writeOperation(pw, operation, parameters, soapAction, isRPC);
            }
            ++i;
        }
    }

    private HashSet getTypesInPortType(PortType portType) {
        HashSet<TypeEntry> types = new HashSet<TypeEntry>();
        HashSet firstPassTypes = new HashSet();
        List operations = portType.getOperations();
        int i = 0;
        while (i < operations.size()) {
            Operation op = (Operation)operations.get(i);
            firstPassTypes.addAll(this.getTypesInOperation(op));
            ++i;
        }
        Iterator i2 = firstPassTypes.iterator();
        while (i2.hasNext()) {
            TypeEntry type = (TypeEntry)i2.next();
            if (types.contains(type)) continue;
            types.add(type);
            types.addAll(org.apache.axis.wsdl.symbolTable.Utils.getNestedTypes(type, this.symbolTable, true));
        }
        return types;
    }

    private HashSet getTypesInOperation(Operation operation) {
        Map faults;
        HashSet types = new HashSet();
        Vector<TypeEntry> v = new Vector<TypeEntry>();
        Parameters params = this.bEntry.getParameters(operation);
        int i = 0;
        while (i < params.list.size()) {
            Parameter p = (Parameter)params.list.get(i);
            v.add(p.getType());
            ++i;
        }
        if (params.returnType != null) {
            v.add(params.returnType);
        }
        if ((faults = operation.getFaults()) != null) {
            Iterator i2 = faults.values().iterator();
            while (i2.hasNext()) {
                Fault f = (Fault)i2.next();
                this.partTypes(v, f.getMessage().getOrderedParts(null), this.bEntry.getFaultBodyType(operation, f.getName()) == 1);
            }
        }
        int i3 = 0;
        while (i3 < v.size()) {
            types.add(v.get(i3));
            ++i3;
        }
        return types;
    }

    private void partTypes(Vector v, Collection parts, boolean literal) {
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            QName qType = part.getTypeName();
            if (qType != null) {
                v.add(this.symbolTable.getType(qType));
                continue;
            }
            qType = part.getElementName();
            if (qType == null) continue;
            v.add(this.symbolTable.getElement(qType));
        }
    }

    private void writeSerializationInit(PrintWriter pw, TypeEntry type) throws IOException {
        boolean process = true;
        if (type.getBaseType() != null && type.getRefType() == null || type instanceof CollectionType || type instanceof Element || !type.isReferenced() || type.isOnlyLiteralReferenced()) {
            process = false;
        }
        if (!process) {
            return;
        }
        if (this.firstSer) {
            pw.println("            Class cls;");
            pw.println("            javax.xml.namespace.QName qName;");
            pw.println("            Class beansf = org.apache.axis.encoding.ser.BeanSerializerFactory.class;");
            pw.println("            Class beandf = org.apache.axis.encoding.ser.BeanDeserializerFactory.class;");
            pw.println("            Class enumsf = org.apache.axis.encoding.ser.EnumSerializerFactory.class;");
            pw.println("            Class enumdf = org.apache.axis.encoding.ser.EnumDeserializerFactory.class;");
            pw.println("            Class arraysf = org.apache.axis.encoding.ser.ArraySerializerFactory.class;");
            pw.println("            Class arraydf = org.apache.axis.encoding.ser.ArrayDeserializerFactory.class;");
            pw.println("            Class simplesf = org.apache.axis.encoding.ser.SimpleNonPrimitiveSerializerFactory.class;");
            pw.println("            Class simpledf = org.apache.axis.encoding.ser.SimpleDeserializerFactory.class;");
        }
        this.firstSer = false;
        QName qname = type.getQName();
        pw.println("            qName = new javax.xml.namespace.QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
        pw.println("            cachedSerQNames.add(qName);");
        pw.println("            cls = " + type.getName() + ".class;");
        pw.println("            cachedSerClasses.add(cls);");
        if (type.getName().endsWith("[]")) {
            pw.println("            cachedSerFactories.add(arraysf);");
            pw.println("            cachedDeserFactories.add(arraydf);");
        } else if (type.getNode() != null && Utils.getEnumerationBaseAndValues(type.getNode(), this.symbolTable) != null) {
            pw.println("            cachedSerFactories.add(enumsf);");
            pw.println("            cachedDeserFactories.add(enumdf);");
        } else if (type.isSimpleType()) {
            pw.println("            cachedSerFactories.add(simplesf);");
            pw.println("            cachedDeserFactories.add(simpledf);");
        } else if (type.getBaseType() != null) {
            pw.println("            cachedSerFactories.add(null);");
            pw.println("            cachedDeserFactories.add(simpledf);");
        } else {
            pw.println("            cachedSerFactories.add(beansf);");
            pw.println("            cachedDeserFactories.add(beandf);");
        }
        pw.println();
    }

    private void writeOperation(PrintWriter pw, BindingOperation operation, Parameters parms, String soapAction, boolean isRPC) throws IOException {
        int use;
        TypeEntry type;
        this.writeComment(pw, operation.getDocumentationElement());
        pw.println(parms.signature + "{");
        pw.println("        if (super.cachedEndpoint == null) {");
        pw.println("            throw new org.apache.axis.NoEndPointException();");
        pw.println("        }");
        pw.println("        org.apache.axis.client.Call call = createCall();");
        int i = 0;
        while (i < parms.list.size()) {
            Parameter p = (Parameter)parms.list.get(i);
            type = p.getType();
            if (type instanceof DefinedElement && type.getRefType() != null) {
                type = type.getRefType();
            }
            QName qn = type.getQName();
            String javaType = type.getName();
            javaType = javaType != null ? javaType + ".class, " : "";
            String typeString = "new javax.xml.namespace.QName(\"" + qn.getNamespaceURI() + "\", \"" + qn.getLocalPart() + "\")";
            QName paramQName = p.getQName();
            String qnName = "p" + i + "QName";
            pw.println("        javax.xml.namespace.QName " + qnName + " = new javax.xml.namespace.QName(\"" + paramQName.getNamespaceURI() + "\", \"" + paramQName.getLocalPart() + "\");");
            if (p.getMode() == 1) {
                pw.println("        call.addParameter(" + qnName + ", " + typeString + ", " + javaType + "javax.xml.rpc.ParameterMode.IN);");
            } else if (p.getMode() == 3) {
                pw.println("        call.addParameter(" + qnName + ", " + typeString + ", " + javaType + "javax.xml.rpc.ParameterMode.INOUT);");
            } else {
                pw.println("        call.addParameter(" + qnName + ", " + typeString + ", " + javaType + "javax.xml.rpc.ParameterMode.OUT);");
            }
            ++i;
        }
        if (parms.returnType != null) {
            QName qn = parms.returnType.getQName();
            if (parms.returnType instanceof DefinedElement && (type = ((DefinedElement)parms.returnType).getRefType()) != null && type.getQName() != null) {
                qn = type.getQName();
            }
            String outputType = "new javax.xml.namespace.QName(\"" + qn.getNamespaceURI() + "\", \"" + qn.getLocalPart() + "\")";
            pw.println("        call.setReturnType(" + outputType + ");");
        } else {
            pw.println("        call.setReturnType(org.apache.axis.encoding.XMLType.AXIS_VOID);");
        }
        if (soapAction != null) {
            pw.println("        call.setUseSOAPAction(true);");
            pw.println("        call.setSOAPActionURI(\"" + soapAction + "\");");
        }
        if ((use = this.bEntry.getInputBodyType(operation.getOperation())) == 1) {
            pw.println("        call.setEncodingStyle(null);");
            pw.println("        call.setScopedProperty(org.apache.axis.AxisEngine.PROP_DOMULTIREFS, Boolean.FALSE);");
            pw.println("        call.setScopedProperty(org.apache.axis.client.Call.SEND_TYPE_ATTR, Boolean.FALSE);");
        }
        int style = this.bEntry.getBindingStyle();
        String styleStr = "rpc";
        if (style == 1) {
            styleStr = this.symbolTable.isWrapped() ? "wrapped" : "document";
        }
        pw.println("        call.setOperationStyle(\"" + styleStr + "\");");
        if (styleStr.equals("wrapped")) {
            Map partsMap = operation.getOperation().getInput().getMessage().getParts();
            Part p = (Part)partsMap.values().iterator().next();
            QName q = p.getElementName();
            pw.println("        call.setOperationName(new javax.xml.namespace.QName(\"" + q.getNamespaceURI() + "\", \"" + q.getLocalPart() + "\"));");
        } else {
            QName elementQName = Utils.getOperationQName(operation);
            if (elementQName != null) {
                pw.println("        call.setOperationName(" + Utils.getNewQName(elementQName) + ");");
            }
        }
        pw.println();
        pw.print("        Object resp = call.invoke(");
        pw.print("new Object[] {");
        boolean needComma = false;
        int i2 = 0;
        while (i2 < parms.list.size()) {
            Parameter p = (Parameter)parms.list.get(i2);
            String javifiedName = Utils.xmlNameToJava(p.getName());
            if (p.getMode() != 2) {
                if (needComma) {
                    pw.print(", ");
                } else {
                    needComma = true;
                }
                if (p.getMode() == 1) {
                    pw.print(Utils.wrapPrimitiveType(p.getType(), javifiedName));
                } else {
                    pw.print(Utils.wrapPrimitiveType(p.getType(), javifiedName + ".value"));
                }
            }
            ++i2;
        }
        pw.println("});");
        pw.println();
        pw.println("        if (resp instanceof java.rmi.RemoteException) {");
        pw.println("            throw (java.rmi.RemoteException)resp;");
        pw.println("        }");
        int allOuts = parms.outputs + parms.inouts;
        if (allOuts > 0) {
            pw.println("        else {");
            if (allOuts == 1) {
                if (parms.returnType != null) {
                    this.writeOutputAssign(pw, "return ", parms.returnType, "resp");
                } else {
                    int i3 = 0;
                    Parameter p = (Parameter)parms.list.get(i3);
                    while (p.getMode() == 1) {
                        p = (Parameter)parms.list.get(++i3);
                    }
                    String javifiedName = Utils.xmlNameToJava(p.getName());
                    String qnameName = Utils.getNewQName(p.getQName());
                    pw.println("            java.util.Map output;");
                    pw.println("            output = call.getOutputParams();");
                    this.writeOutputAssign(pw, javifiedName + ".value =", p.getType(), "output.get(" + qnameName + ")");
                }
            } else {
                pw.println("            java.util.Map output;");
                pw.println("            output = call.getOutputParams();");
                int i4 = 0;
                while (i4 < parms.list.size()) {
                    Parameter p = (Parameter)parms.list.get(i4);
                    String javifiedName = Utils.xmlNameToJava(p.getName());
                    String qnameName = Utils.getNewQName(p.getQName());
                    if (p.getMode() != 1) {
                        this.writeOutputAssign(pw, javifiedName + ".value =", p.getType(), "output.get(" + qnameName + ")");
                    }
                    ++i4;
                }
                if (parms.returnType != null) {
                    this.writeOutputAssign(pw, "return ", parms.returnType, "resp");
                }
            }
            pw.println("        }");
        }
        pw.println("    }");
        pw.println();
    }

    private void writeOutputAssign(PrintWriter pw, String target, TypeEntry type, String source) {
        if (type != null && type.getName() != null) {
            pw.println("            try {");
            pw.println("                " + target + Utils.getResponseString(type, source));
            pw.println("            } catch (java.lang.Exception e) {");
            pw.println("                " + target + Utils.getResponseString(type, "org.apache.axis.utils.JavaUtils.convert(" + source + ", " + type.getName() + ".class)"));
            pw.println("            }");
        } else {
            pw.println("              " + target + Utils.getResponseString(type, source));
        }
    }
}

