/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaTestCaseWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    private int counter = 1;

    protected JavaTestCaseWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "TestCase", "testCase");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends junit.framework.TestCase ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        pw.print("    public ");
        pw.print(this.getClassName());
        pw.println("(String name) {");
        pw.println("        super(name);");
        pw.println("    }");
        Map portMap = this.sEntry.getService().getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry.getBindingType() != 0) continue;
            String portName = Utils.xmlNameToJavaClass(p.getName());
            PortType portType = binding.getPortType();
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
            this.writeComment(pw, p.getDocumentationElement());
            this.writeServiceTestCode(pw, portName, portType, ptEntry, binding, bEntry);
        }
    }

    private final void writeServiceTestCode(PrintWriter pw, String portName, PortType portType, PortTypeEntry ptEntry, Binding binding, BindingEntry bEntry) throws IOException {
        Iterator ops = portType.getOperations().iterator();
        while (ops.hasNext()) {
            Operation op = (Operation)ops.next();
            OperationType type = op.getStyle();
            Parameters params = bEntry.getParameters(op);
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println("    " + params.signature);
                continue;
            }
            String javaOpName = Utils.xmlNameToJavaClass(op.getName());
            String testMethodName = "test" + this.counter++ + portName + javaOpName;
            pw.println("    public void " + testMethodName + "() {");
            String bindingType = (String)bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
            this.writeBindingAssignment(pw, bindingType, portName);
            pw.println("        try {");
            if (params.returnType != null) {
                pw.print("            ");
                pw.print(params.returnType.getName());
                pw.print(" value = ");
                if (Utils.isPrimitiveType(params.returnType)) {
                    if ("boolean".equals(params.returnType.getName())) {
                        pw.println("false;");
                    } else {
                        pw.println("-3;");
                    }
                } else {
                    pw.println("null;");
                }
            }
            pw.print("            ");
            if (params.returnType != null) {
                pw.print("value = ");
            }
            pw.print("binding.");
            pw.print(Utils.xmlNameToJava(op.getName()));
            pw.print("(");
            Iterator iparam = ((AbstractList)params.list).iterator();
            boolean isFirst = true;
            while (iparam.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    pw.print(", ");
                }
                Parameter param = (Parameter)iparam.next();
                String paramType = param.getType().getName();
                String suffix = "";
                if (param.getMode() != 1) {
                    pw.print("new " + Utils.holder(param.getType(), this.emitter) + "(");
                    suffix = ")";
                }
                if (param.getMode() != 2) {
                    if (Utils.isPrimitiveType(param.getType())) {
                        if ("boolean".equals(paramType)) {
                            pw.print("true");
                        } else if ("byte".equals(paramType)) {
                            pw.print("(byte)0");
                        } else if ("short".equals(paramType)) {
                            pw.print("(short)0");
                        } else {
                            pw.print("0");
                        }
                    } else if (paramType.equals("java.lang.Boolean")) {
                        pw.print("new java.lang.Boolean(false)");
                    } else if (paramType.equals("java.lang.Byte")) {
                        pw.print("new java.lang.Byte((byte)0)");
                    } else if (paramType.equals("java.lang.Double")) {
                        pw.print("new java.lang.Double(0)");
                    } else if (paramType.equals("java.lang.Float")) {
                        pw.print("new java.lang.Float(0)");
                    } else if (paramType.equals("java.lang.Integer")) {
                        pw.print("new java.lang.Integer(0)");
                    } else if (paramType.equals("java.lang.Long")) {
                        pw.print("new java.lang.Long(0)");
                    } else if (paramType.equals("java.lang.Short")) {
                        pw.print("new java.lang.Short((short)0)");
                    } else if (paramType.equals("java.math.BigDecimal")) {
                        pw.print("new java.math.BigDecimal(0)");
                    } else if (paramType.equals("java.math.BigInteger")) {
                        pw.print("new java.math.BigInteger(\"0\")");
                    } else if (paramType.equals("java.lang.Object")) {
                        pw.print("new java.lang.String()");
                    } else if (paramType.equals("byte[]")) {
                        pw.print("new byte[0]");
                    } else if (paramType.equals("java.util.Calendar")) {
                        pw.print("java.util.Calendar.getInstance()");
                    } else if (paramType.equals("javax.xml.namespace.QName")) {
                        pw.print("new javax.xml.namespace.QName(\"http://double-double\", \"toil-and-trouble\")");
                    } else if (paramType.endsWith("[]")) {
                        pw.print("new " + JavaUtils.replace(paramType, "[]", "[0]"));
                    } else {
                        Vector v = Utils.getEnumerationBaseAndValues(param.getType().getNode(), this.symbolTable);
                        if (v != null) {
                            String enumeration = (String)JavaEnumTypeWriter.getEnumValueIds(v).get(0);
                            pw.print(paramType + "." + enumeration);
                        } else {
                            pw.print("new " + paramType + "()");
                        }
                    }
                }
                pw.print(suffix);
            }
            pw.println(");");
            pw.println("        }");
            Map faultMap = op.getFaults();
            if (faultMap != null) {
                Iterator i = faultMap.values().iterator();
                int count = 0;
                while (i.hasNext()) {
                    Fault f = (Fault)i.next();
                    pw.print("        catch (");
                    pw.print(Utils.getFullExceptionName(f, this.emitter));
                    pw.println(" e" + ++count + ") {");
                    pw.print("            ");
                    pw.println("throw new junit.framework.AssertionFailedError(\"" + f.getName() + " Exception caught: \" + e" + count + ");");
                    pw.println("        }");
                }
            }
            pw.println("        catch (java.rmi.RemoteException re) {");
            pw.print("            ");
            pw.println("throw new junit.framework.AssertionFailedError(\"Remote Exception caught: \" + re);");
            pw.println("        }");
            pw.println("    }");
            pw.println();
        }
    }

    public final void writeBindingAssignment(PrintWriter pw, String bindingType, String portName) throws IOException {
        pw.println("        " + bindingType + " binding;");
        pw.println("        try {");
        pw.print("            binding = new " + this.sEntry.getName());
        pw.println("Locator().get" + portName + "();");
        pw.println("        }");
        pw.println("        catch (javax.xml.rpc.ServiceException jre) {");
        pw.println("            throw new junit.framework.AssertionFailedError(\"JAX-RPC ServiceException caught: \" + jre);");
        pw.println("        }");
        pw.println("        assertTrue(\"" + JavaUtils.getMessage("null00", "binding") + "\", binding != null);");
        pw.println();
    }
}

