/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.toJava.Emitter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class JavaWriter
implements Generator {
    protected Emitter emitter;
    protected String type;

    protected JavaWriter(Emitter emitter, String type) {
        this.emitter = emitter;
        this.type = type;
    }

    public void generate() throws IOException {
        String msg;
        String file = this.getFileName();
        if (this.isFileGenerated(file)) {
            throw new IOException(JavaUtils.getMessage("duplicateFile00", file));
        }
        this.registerFile(file);
        if (this.emitter.isVerbose() && (msg = this.verboseMessage(file)) != null) {
            System.out.println(msg);
        }
        PrintWriter pw = this.getPrintWriter(file);
        this.writeFileHeader(pw);
        this.writeFileBody(pw);
        this.writeFileFooter(pw);
        this.closePrintWriter(pw);
    }

    protected abstract String getFileName();

    protected boolean isFileGenerated(String file) {
        return this.emitter.getGeneratedFileNames().contains(file);
    }

    protected void registerFile(String file) {
        this.emitter.getGeneratedFileInfo().add(file, null, this.type);
    }

    protected String verboseMessage(String file) {
        return JavaUtils.getMessage("generating", file);
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        File file = new File(filename);
        File parent = new File(file.getParent());
        parent.mkdirs();
        return new PrintWriter(new FileWriter(file));
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
    }

    protected abstract void writeFileBody(PrintWriter var1) throws IOException;

    protected void writeFileFooter(PrintWriter pw) throws IOException {
    }

    protected void closePrintWriter(PrintWriter pw) {
        pw.close();
    }

    protected void writeComment(PrintWriter pw, Element element) {
        int LINE_LENGTH = 65;
        if (element == null) {
            return;
        }
        Node child = element.getFirstChild();
        if (child == null) {
            return;
        }
        String comment = child.getNodeValue();
        comment = comment.replace('\r', ' ');
        if ((comment = comment.replace('\n', ' ')) != null) {
            int start = 0;
            pw.println();
            pw.println("    /**");
            while (start < comment.length()) {
                int end = start + 65;
                if (end > comment.length()) {
                    end = comment.length();
                }
                while (end < comment.length() && !Character.isWhitespace(comment.charAt(end))) {
                    ++end;
                }
                pw.println("     * " + comment.substring(start, end).trim());
                start = end + 1;
            }
            pw.println("     */");
        }
    }
}

