/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils
extends org.apache.axis.wsdl.symbolTable.Utils {
    private static HashMap TYPES = new HashMap(7);

    public static String holder(TypeEntry type, Emitter emitter) {
        String typeValue = type.getName();
        if (typeValue.equals("byte[]")) {
            return "javax.xml.rpc.holders.ByteArrayHolder";
        }
        if (typeValue.endsWith("[]")) {
            String name = emitter.getJavaName(type.getQName());
            name = JavaUtils.replace(name, "[]", "Array");
            name = Utils.addPackageName(name, "holders");
            return name + "Holder";
        }
        if (typeValue.equals("String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (typeValue.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (typeValue.equals("Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (typeValue.equals("java.lang.Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (typeValue.equals("int") || typeValue.equals("long") || typeValue.equals("short") || typeValue.equals("float") || typeValue.equals("double") || typeValue.equals("boolean") || typeValue.equals("byte")) {
            return "javax.xml.rpc.holders." + Utils.capitalizeFirstChar(typeValue) + "Holder";
        }
        if (typeValue.startsWith("java.lang.")) {
            return "javax.xml.rpc.holders" + typeValue.substring(typeValue.lastIndexOf(".")) + "WrapperHolder";
        }
        if (typeValue.indexOf(".") < 0) {
            return "javax.xml.rpc.holders" + typeValue + "WrapperHolder";
        }
        if (typeValue.equals("java.math.BigDecimal")) {
            return "javax.xml.rpc.holders.BigDecimalHolder";
        }
        if (typeValue.equals("java.math.BigInteger")) {
            return "javax.xml.rpc.holders.BigIntegerHolder";
        }
        if (typeValue.equals("java.util.Date")) {
            return "javax.xml.rpc.holders.DateHolder";
        }
        if (typeValue.equals("java.util.Calendar")) {
            return "javax.xml.rpc.holders.CalendarHolder";
        }
        if (typeValue.equals("javax.xml.namespace.QName")) {
            return "javax.xml.rpc.holders.QNameHolder";
        }
        return Utils.addPackageName(typeValue, "holders") + "Holder";
    }

    public static String addPackageName(String className, String newPkg) {
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            return className.substring(0, index) + "." + newPkg + className.substring(index);
        }
        return newPkg + "." + className;
    }

    public static String getFullExceptionName(Fault fault, Emitter emitter) {
        Message faultMessage = fault.getMessage();
        MessageEntry me = emitter.getSymbolTable().getMessageEntry(faultMessage.getQName());
        return (String)me.getDynamicVar(JavaGeneratorFactory.EXCEPTION_CLASS_NAME);
    }

    public static Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable) {
        int j;
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            j = 0;
            while (j < children.getLength() && simpleNode == null) {
                QName simpleKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(children.item(j));
                if (simpleKind != null && simpleKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(simpleKind.getNamespaceURI())) {
                    node = simpleNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            String javaName;
            QName baseType;
            children = node.getChildNodes();
            Node restrictionNode = null;
            j = 0;
            while (j < children.getLength() && restrictionNode == null) {
                QName restrictionKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(children.item(j));
                if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                    restrictionNode = children.item(j);
                }
                ++j;
            }
            Type baseEType = null;
            if (!(restrictionNode == null || (baseEType = symbolTable.getType(baseType = org.apache.axis.wsdl.symbolTable.Utils.getNodeTypeRefQName(restrictionNode, "base"))) == null || (javaName = baseEType.getName()).equals("java.lang.String") || javaName.equals("java.math.BigInteger") || javaName.equals("java.math.BigDecimal") || javaName.equals("int") || javaName.equals("long") || javaName.equals("short") || javaName.equals("float") || javaName.equals("double") || javaName.equals("byte"))) {
                baseEType = null;
            }
            if (baseEType != null && restrictionNode != null) {
                Vector<Object> v = new Vector<Object>();
                NodeList enums = restrictionNode.getChildNodes();
                int i = 0;
                while (i < enums.getLength()) {
                    Node enumNode;
                    String value;
                    QName enumKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(enums.item(i));
                    if (enumKind != null && enumKind.getLocalPart().equals("enumeration") && Constants.isSchemaXSD(enumKind.getNamespaceURI()) && (value = org.apache.axis.wsdl.symbolTable.Utils.getAttribute(enumNode = enums.item(i), "value")) != null) {
                        v.add(value);
                    }
                    ++i;
                }
                if (v.isEmpty()) {
                    return null;
                }
                v.add(0, baseEType);
                return v;
            }
        }
        return null;
    }

    public static String capitalizeFirstChar(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char start = name.charAt(0);
        if (Character.isLowerCase(start)) {
            start = Character.toUpperCase(start);
            return start + name.substring(1);
        }
        return name;
    }

    public static String xmlNameToJava(String name) {
        return JavaUtils.xmlNameToJava(name);
    }

    public static String xmlNameToJavaClass(String name) {
        return Utils.capitalizeFirstChar(Utils.xmlNameToJava(name));
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        try {
            hostname = new URL(namespace).getHost();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        StringTokenizer st = new StringTokenizer(hostname, ".");
        String[] words = new String[st.countTokens()];
        int i = 0;
        while (i < words.length) {
            words[i] = st.nextToken();
            ++i;
        }
        StringBuffer sb = new StringBuffer(80);
        int i2 = words.length - 1;
        while (i2 >= 0) {
            String word = words[i2];
            if (JavaUtils.isJavaKeyword(word)) {
                word = JavaUtils.makeNonJavaKeyword(word);
            }
            if (i2 != words.length - 1) {
                sb.append('.');
            }
            if (Character.isDigit(word.charAt(0))) {
                sb.append('_');
            }
            sb.append(word);
            --i2;
        }
        return sb.toString();
    }

    public static String getJavaLocalName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public static String getJavaPackageName(String fullName) {
        if (fullName.lastIndexOf(46) > 0) {
            return fullName.substring(0, fullName.lastIndexOf(46));
        }
        return "";
    }

    public static boolean fileExists(String name, String namespace, Namespaces namespaces) throws IOException {
        String packageName = namespaces.getAsDir(namespace);
        String fullName = packageName + name;
        return new File(fullName).exists();
    }

    public static String wrapPrimitiveType(TypeEntry type, String var) {
        String objType;
        String string = objType = type == null ? null : (String)TYPES.get(type.getName());
        if (objType != null) {
            return "new " + objType + "(" + var + ")";
        }
        if (type != null && type.getName().equals("byte[]") && type.getQName().getLocalPart().equals("hexBinary")) {
            return "new org.apache.axis.encoding.Hex(" + var + ")";
        }
        return var;
    }

    public static String getResponseString(TypeEntry type, String var) {
        if (type == null) {
            return ";";
        }
        String objType = (String)TYPES.get(type.getName());
        if (objType != null) {
            return "((" + objType + ") " + var + ")." + type.getName() + "Value();";
        }
        return "(" + type.getName() + ") " + var + ";";
    }

    public static boolean isPrimitiveType(TypeEntry type) {
        return TYPES.get(type.getName()) != null;
    }

    public static QName getOperationQName(BindingOperation bindingOper) {
        Map parts;
        Input input;
        Operation operation = bindingOper.getOperation();
        String operationName = operation.getName();
        String javaOperName = JavaUtils.xmlNameToJava(operation.getName());
        QName elementQName = null;
        String ns = null;
        BindingInput bindInput = bindingOper.getBindingInput();
        if (bindInput != null) {
            Iterator it = bindInput.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                ExtensibilityElement elem = (ExtensibilityElement)it.next();
                if (!(elem instanceof SOAPBody)) continue;
                SOAPBody body = (SOAPBody)elem;
                ns = body.getNamespaceURI();
                break;
            }
        }
        if (ns == null) {
            ns = "";
        }
        if ((input = operation.getInput()) != null && (parts = input.getMessage().getParts()) != null && !parts.isEmpty()) {
            Iterator i = parts.values().iterator();
            Part p = (Part)i.next();
            elementQName = p.getElementName();
        }
        if (elementQName == null) {
            elementQName = new QName(ns, operationName);
        }
        return elementQName;
    }

    public static String getNewQName(QName qname) {
        return "new javax.xml.namespace.QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\")";
    }

    static {
        TYPES.put("int", "Integer");
        TYPES.put("float", "Float");
        TYPES.put("boolean", "Boolean");
        TYPES.put("double", "Double");
        TYPES.put("byte", "Byte");
        TYPES.put("short", "Short");
        TYPES.put("long", "Long");
    }
}

