/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Attribute;
import com.techtrader.modules.tools.bytecode.BCEntity;
import com.techtrader.modules.tools.bytecode.LineNumber;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LineNumberTableAttribute
extends Attribute {
    private List _lineNumbers = new LinkedList();

    public LineNumber[] getLineNumbers() {
        return this._lineNumbers.toArray(new LineNumber[this._lineNumbers.size()]);
    }

    public LineNumber importLineNumber(LineNumber lineNumber) {
        if (lineNumber == null) {
            throw new NullPointerException();
        }
        LineNumber lineNumber2 = this.addLineNumber();
        lineNumber2.setStartPc(lineNumber.getStartPc());
        lineNumber2.setLineNumber(lineNumber.getLineNumber());
        return lineNumber2;
    }

    public void importLineNumbers(LineNumberTableAttribute lineNumberTableAttribute) {
        LineNumber[] lineNumberArray = lineNumberTableAttribute.getLineNumbers();
        int n = 0;
        while (n < lineNumberArray.length) {
            this.importLineNumber(lineNumberArray[n]);
            ++n;
        }
    }

    public LineNumber addLineNumber() {
        LineNumber lineNumber = new LineNumber(this);
        this._lineNumbers.add(lineNumber);
        return lineNumber;
    }

    public void clearLineNumbers() {
        this._lineNumbers.clear();
    }

    public boolean removeLineNumber(LineNumber lineNumber) {
        if (lineNumber == null || !this._lineNumbers.remove(lineNumber)) {
            return false;
        }
        lineNumber.invalidate();
        return true;
    }

    public int getLength() {
        return 2 + 4 * this._lineNumbers.size();
    }

    protected void copy(Attribute attribute) {
        this.importLineNumbers((LineNumberTableAttribute)attribute);
    }

    protected void readData(DataInput dataInput, int n) throws IOException {
        this._lineNumbers.clear();
        int n2 = dataInput.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            LineNumber lineNumber = this.addLineNumber();
            lineNumber.readData(dataInput);
            ++n3;
        }
    }

    protected void writeData(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._lineNumbers.size());
        Iterator iterator = this._lineNumbers.iterator();
        while (iterator.hasNext()) {
            ((LineNumber)iterator.next()).writeData(dataOutput);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLineNumberTableAttribute(this);
        Iterator iterator = this._lineNumbers.iterator();
        while (iterator.hasNext()) {
            ((LineNumber)iterator.next()).acceptVisit(bCVisitor);
        }
        bCVisitor.exitLineNumberTableAttribute(this);
    }

    public LineNumberTableAttribute(int n, BCEntity bCEntity) {
        super(n, bCEntity);
    }
}

