/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Attribute;
import com.techtrader.modules.tools.bytecode.BCEntity;
import com.techtrader.modules.tools.bytecode.LocalVariable;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LocalVariableTableAttribute
extends Attribute {
    private List _localVariables = new LinkedList();

    public LocalVariable[] getLocalVariables() {
        return this._localVariables.toArray(new LocalVariable[this._localVariables.size()]);
    }

    public LocalVariable getLocalVariable(String string) {
        Iterator iterator = this._localVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!localVariable.getName().equals(string)) continue;
            return localVariable;
        }
        return null;
    }

    public LocalVariable importLocalVariable(LocalVariable localVariable) {
        LocalVariable localVariable2 = this.addLocalVariable(localVariable.getName(), localVariable.getTypeName());
        localVariable2.setStartPc(localVariable.getStartPc());
        localVariable2.setLength(localVariable.getLength());
        return localVariable2;
    }

    public void importLocalVariables(LocalVariableTableAttribute localVariableTableAttribute) {
        LocalVariable[] localVariableArray = localVariableTableAttribute.getLocalVariables();
        int n = 0;
        while (n < localVariableArray.length) {
            this.importLocalVariable(localVariableArray[n]);
            ++n;
        }
    }

    public LocalVariable addLocalVariable() {
        LocalVariable localVariable = new LocalVariable(this);
        localVariable.setIndex(this._localVariables.size());
        this._localVariables.add(localVariable);
        return localVariable;
    }

    public LocalVariable addLocalVariable(String string, String string2) {
        LocalVariable localVariable = this.addLocalVariable();
        localVariable.setName(string);
        localVariable.setTypeName(string2);
        return localVariable;
    }

    public LocalVariable addLocalVariable(String string, Class clazz) {
        return this.addLocalVariable(string, clazz.getName());
    }

    public void clearLocalVariables() {
        this._localVariables.clear();
    }

    public boolean removeLocalVariable(String string) {
        return this.removeLocalVariable(this.getLocalVariable(string));
    }

    public boolean removeLocalVariable(LocalVariable localVariable) {
        if (localVariable == null || !this._localVariables.remove(localVariable)) {
            return false;
        }
        localVariable.invalidate();
        return true;
    }

    public int getLength() {
        return 2 + 10 * this._localVariables.size();
    }

    protected void copy(Attribute attribute) {
        this.importLocalVariables((LocalVariableTableAttribute)attribute);
    }

    protected void readData(DataInput dataInput, int n) throws IOException {
        this._localVariables.clear();
        int n2 = dataInput.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            LocalVariable localVariable = this.addLocalVariable();
            localVariable.readData(dataInput);
            ++n3;
        }
    }

    protected void writeData(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._localVariables.size());
        Iterator iterator = this._localVariables.iterator();
        while (iterator.hasNext()) {
            ((LocalVariable)iterator.next()).writeData(dataOutput);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLocalVariableTableAttribute(this);
        Iterator iterator = this._localVariables.iterator();
        while (iterator.hasNext()) {
            ((LocalVariable)iterator.next()).acceptVisit(bCVisitor);
        }
        bCVisitor.exitLocalVariableTableAttribute(this);
    }

    public LocalVariableTableAttribute(int n, BCEntity bCEntity) {
        super(n, bCEntity);
    }
}

