/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode.lowlevel;

import com.techtrader.modules.tools.bytecode.BCClass;
import com.techtrader.modules.tools.bytecode.lowlevel.ClassEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.ComplexEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.ConstantEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.DoubleEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.Entry;
import com.techtrader.modules.tools.bytecode.lowlevel.FieldEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.FloatEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.IntEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.InterfaceMethodEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.LongEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.LowLevelConstants;
import com.techtrader.modules.tools.bytecode.lowlevel.MethodEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.NameAndTypeEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.PlaceHolderEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.StringEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.UTF8Entry;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import com.techtrader.modules.tools.bytecode.visitor.VisitAcceptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConstantPool
implements LowLevelConstants,
VisitAcceptor {
    private static final Map _consts = new HashMap();
    private List _entries = new LinkedList();
    private Map _lookup = new HashMap();
    private BCClass _owner = null;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry;
    private static /* synthetic */ Class class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry;

    public static Entry createEntry(int n) {
        switch (n) {
            case 0: {
                return new PlaceHolderEntry();
            }
            case 7: {
                return new ClassEntry();
            }
            case 9: {
                return new FieldEntry();
            }
            case 10: {
                return new MethodEntry();
            }
            case 11: {
                return new InterfaceMethodEntry();
            }
            case 8: {
                return new StringEntry();
            }
            case 3: {
                return new IntEntry();
            }
            case 4: {
                return new FloatEntry();
            }
            case 5: {
                return new LongEntry();
            }
            case 6: {
                return new DoubleEntry();
            }
            case 12: {
                return new NameAndTypeEntry();
            }
            case 1: {
                return new UTF8Entry();
            }
        }
        return null;
    }

    public Entry[] getEntries() {
        return this._entries.toArray(new Entry[this._entries.size()]);
    }

    public Entry getEntry(int n) {
        if (n < 1 || n > this._entries.size()) {
            return null;
        }
        return (Entry)this._entries.get(n - 1);
    }

    public Entry setEntry(int n, Entry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        Entry entry2 = this._entries.set(n - 1, entry);
        this.removeHash(entry2);
        if (entry2 != null && (entry2.getType() == 5 || entry2.getType() == 6)) {
            this._entries.remove(n);
        }
        if (entry.getType() == 5 || entry.getType() == 6) {
            this._entries.add(n, new PlaceHolderEntry());
        }
        this.hash(entry, n);
        return entry2;
    }

    public void addEntry(int n, Entry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        this._entries.add(n - 1, entry);
        this.hash(entry, n);
        if (entry.getType() == 5 || entry.getType() == 6) {
            this._entries.add(n, new PlaceHolderEntry());
        }
    }

    public int addEntry(Entry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        this._entries.add(entry);
        int n = this._entries.size();
        this.hash(entry, n);
        if (entry.getType() == 5 || entry.getType() == 6) {
            this._entries.add(new PlaceHolderEntry());
        }
        return n;
    }

    public Entry removeEntry(int n) {
        if (n < 1 || n > this._entries.size()) {
            return null;
        }
        Entry entry = (Entry)this._entries.remove(n - 1);
        this.removeHash(entry);
        if (entry != null && (entry.getType() == 5 || entry.getType() == 6)) {
            this._entries.remove(n - 1);
        }
        return entry;
    }

    public boolean removeEntry(Entry entry) {
        if (entry == null) {
            return false;
        }
        int n = this._entries.indexOf(entry);
        if (n != -1) {
            this._entries.remove(n);
            this.removeHash(entry);
            if (entry.getType() == 5 || entry.getType() == 6) {
                this._entries.remove(n);
            }
            return true;
        }
        return false;
    }

    public int size() {
        return this._entries.size();
    }

    public int getUTFIndex(String string) {
        if (string == null) {
            string = "";
        }
        return this.find("1|" + string);
    }

    public String getUTF(int n) {
        UTF8Entry uTF8Entry = (UTF8Entry)this.getEntry(n);
        if (uTF8Entry == null) {
            return "";
        }
        return uTF8Entry.getValue();
    }

    public int setUTF(int n, String string) {
        if (string == null) {
            string = "";
        }
        if (n <= 0 && (n = this.getUTFIndex(string)) > 0) {
            return n;
        }
        UTF8Entry uTF8Entry = (UTF8Entry)this.getEntry(n);
        if (uTF8Entry == null) {
            uTF8Entry = new UTF8Entry();
            uTF8Entry.setValue(string);
            return this.addEntry(uTF8Entry);
        }
        uTF8Entry.setValue(string);
        this.rehash(uTF8Entry, n);
        return n;
    }

    public int getClassIndex(String string) {
        int n = this.getUTFIndex(string);
        if (n == 0) {
            return 0;
        }
        return this.find("7|" + n);
    }

    public String getClassName(int n) {
        ClassEntry classEntry = (ClassEntry)this.getEntry(n);
        if (classEntry == null) {
            return "";
        }
        return this.getUTF(classEntry.getNameIndex());
    }

    public int setClassName(int n, String string) {
        if (n <= 0 && (n = this.getClassIndex(string)) > 0) {
            return n;
        }
        ClassEntry classEntry = (ClassEntry)this.getEntry(n);
        if (classEntry == null) {
            classEntry = new ClassEntry();
            classEntry.setNameIndex(this.setUTF(0, string));
            return this.addEntry(classEntry);
        }
        classEntry.setNameIndex(this.setUTF(0, string));
        this.rehash(classEntry, n);
        return n;
    }

    public int getNameAndTypeIndex(String string, String string2) {
        int n = this.getUTFIndex(string);
        if (n == 0) {
            return 0;
        }
        int n2 = this.getUTFIndex(string2);
        if (n2 == 0) {
            return 0;
        }
        return this.find("12|" + n + "|" + n2);
    }

    public int setNameAndType(int n, String string, String string2) {
        if (n <= 0 && (n = this.getNameAndTypeIndex(string, string2)) > 0) {
            return n;
        }
        NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.getEntry(n);
        if (nameAndTypeEntry == null) {
            nameAndTypeEntry = new NameAndTypeEntry();
            nameAndTypeEntry.setNameIndex(this.setUTF(0, string));
            nameAndTypeEntry.setDescriptorIndex(this.setUTF(0, string2));
            return this.addEntry(nameAndTypeEntry);
        }
        nameAndTypeEntry.setNameIndex(this.setUTF(0, string));
        nameAndTypeEntry.setDescriptorIndex(this.setUTF(0, string2));
        this.rehash(nameAndTypeEntry, n);
        return n;
    }

    public int getComplexIndex(String string, String string2, String string3, Class clazz) {
        int n = this.getClassIndex(string3);
        if (n == 0) {
            return 0;
        }
        int n2 = this.getNameAndTypeIndex(string, string2);
        if (n2 == 0) {
            return 0;
        }
        int n3 = clazz.equals(class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry != null ? class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry : (class$Lcom$techtrader$modules$tools$bytecode$lowlevel$FieldEntry = ConstantPool.class$("com.techtrader.modules.tools.bytecode.lowlevel.FieldEntry"))) ? 9 : (clazz.equals(class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry != null ? class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry : (class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry = ConstantPool.class$("com.techtrader.modules.tools.bytecode.lowlevel.MethodEntry"))) ? 10 : 11);
        return this.find(n3 + "|" + n + "|" + n2);
    }

    public int setComplex(int n, String string, String string2, String string3, Class clazz) {
        if (n <= 0 && (n = this.getComplexIndex(string, string2, string3, clazz)) > 0) {
            return n;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getEntry(n);
        if (complexEntry == null) {
            try {
                complexEntry = (ComplexEntry)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
            complexEntry.setClassIndex(this.setClassName(0, string3));
            complexEntry.setNameAndTypeIndex(this.setNameAndType(0, string, string2));
            return this.addEntry(complexEntry);
        }
        complexEntry.setClassIndex(this.setClassName(0, string3));
        complexEntry.setNameAndTypeIndex(this.setNameAndType(0, string, string2));
        this.rehash(complexEntry, n);
        return n;
    }

    public String getComplexName(int n) {
        ComplexEntry complexEntry = (ComplexEntry)this.getEntry(n);
        if (complexEntry == null) {
            return "";
        }
        NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.getEntry(complexEntry.getNameAndTypeIndex());
        if (nameAndTypeEntry == null) {
            return "";
        }
        return this.getUTF(nameAndTypeEntry.getNameIndex());
    }

    public String getComplexTypeName(int n) {
        ComplexEntry complexEntry = (ComplexEntry)this.getEntry(n);
        if (complexEntry == null) {
            return "";
        }
        NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.getEntry(complexEntry.getNameAndTypeIndex());
        if (nameAndTypeEntry == null) {
            return "";
        }
        return this.getUTF(nameAndTypeEntry.getDescriptorIndex());
    }

    public String getComplexOwnerTypeName(int n) {
        ComplexEntry complexEntry = (ComplexEntry)this.getEntry(n);
        if (complexEntry == null) {
            return "";
        }
        return this.getClassName(complexEntry.getClassIndex());
    }

    public int getConstantIndex(Object object) {
        if (object == null) {
            return 0;
        }
        int n = (Integer)_consts.get(object.getClass());
        if (n == 8) {
            return this.find(n + "|" + this.getUTFIndex(object.toString()));
        }
        return this.find(n + "|" + object);
    }

    public Object getConstant(int n) {
        ConstantEntry constantEntry = (ConstantEntry)this.getEntry(n);
        if (constantEntry == null) {
            return null;
        }
        if (constantEntry instanceof StringEntry) {
            return this.getUTF(((StringEntry)constantEntry).getStringIndex());
        }
        return constantEntry.getConstantValue();
    }

    public int setConstant(int n, Object object) {
        if (n <= 0 && (n = this.getConstantIndex(object)) > 0) {
            return n;
        }
        ConstantEntry constantEntry = (ConstantEntry)this.getEntry(n);
        if (constantEntry == null) {
            int n2 = (Integer)_consts.get(object.getClass());
            constantEntry = (ConstantEntry)ConstantPool.createEntry(n2);
            if (constantEntry instanceof StringEntry) {
                ((StringEntry)constantEntry).setStringIndex(this.setUTF(0, object.toString()));
            } else {
                constantEntry.setConstantValue(object);
            }
            return this.addEntry(constantEntry);
        }
        if (constantEntry instanceof StringEntry) {
            ((StringEntry)constantEntry).setStringIndex(this.setUTF(0, object.toString()));
        } else {
            constantEntry.setConstantValue(object);
        }
        this.rehash(constantEntry, n);
        return n;
    }

    public void rehash(Entry entry, int n) {
        if (entry != null) {
            Iterator iterator = this._lookup.values().iterator();
            while (iterator.hasNext()) {
                if (!((HashedEntry)iterator.next()).entry.equals(entry)) continue;
                iterator.remove();
            }
            this.hash(entry, n);
        }
    }

    public void readData(DataInput dataInput) throws IOException {
        this._entries.clear();
        this._lookup.clear();
        int n = dataInput.readUnsignedShort();
        int n2 = 1;
        while (n2 < n) {
            Entry entry = ConstantPool.createEntry(dataInput.readUnsignedByte());
            entry.readData(dataInput);
            this.addEntry(entry);
            if (entry.getType() == 5 || entry.getType() == 6) {
                ++n2;
            }
            ++n2;
        }
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._entries.size() + 1);
        Iterator iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.getType() == 0) continue;
            dataOutput.writeByte(entry.getType());
            entry.writeData(dataOutput);
        }
    }

    private int find(String string) {
        HashedEntry hashedEntry = (HashedEntry)this._lookup.get(string);
        if (hashedEntry == null) {
            return 0;
        }
        return hashedEntry.index;
    }

    private void hash(Entry entry, int n) {
        if (entry != null) {
            this._lookup.put(entry.getKey(), new HashedEntry(entry, n));
        }
    }

    private void removeHash(Entry entry) {
        if (entry != null) {
            this._lookup.remove(entry.getKey());
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConstantPool(this);
        Iterator iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            bCVisitor.enterEntry(entry);
            entry.acceptVisit(bCVisitor);
            bCVisitor.exitEntry(entry);
        }
        bCVisitor.exitConstantPool(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ConstantPool(BCClass bCClass) {
        this._owner = bCClass;
    }

    static {
        _consts.put(class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ConstantPool.class$("java.lang.Integer")), new Integer(3));
        _consts.put(class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = ConstantPool.class$("java.lang.Long")), new Integer(5));
        _consts.put(class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = ConstantPool.class$("java.lang.Double")), new Integer(6));
        _consts.put(class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = ConstantPool.class$("java.lang.Float")), new Integer(4));
        _consts.put(class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConstantPool.class$("java.lang.String")), new Integer(8));
    }

    private static class HashedEntry {
        public Entry entry = null;
        public int index = 0;

        public HashedEntry(Entry entry, int n) {
            this.entry = entry;
            this.index = n;
        }
    }
}

