/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SunJavaCompiler;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspEngineContext
implements JspCompilationContext {
    private JspReader reader;
    private ServletWriter writer;
    private ServletContext context;
    private URLClassLoader jspLoader;
    private Compiler jspCompiler;
    private boolean isErrPage;
    private String jspUri;
    private String baseURI;
    private String outDir;
    private URL[] outUrls = new URL[1];
    private Class servletClass;
    private String servletClassName;
    private String servletPackageName = "org.apache.jsp";
    private String servletJavaFileName;
    private String contentType;
    private Options options;
    private JspRuntimeContext rctxt;
    private boolean reload = true;
    private int removed = 0;
    private JspServletWrapper jsw;

    public JspEngineContext(JspRuntimeContext rctxt, ServletContext context, String jspUri, JspServletWrapper jsw, boolean isErrPage, Options options) throws JasperException {
        this.rctxt = rctxt;
        this.context = context;
        this.jspUri = jspUri;
        this.jsw = jsw;
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        this.isErrPage = isErrPage;
        this.options = options;
        this.createOutdir();
        this.createCompiler();
    }

    public void compile() throws JasperException, FileNotFoundException {
        if (this.jspCompiler.isOutDated()) {
            try {
                this.jspCompiler.compile();
                this.reload = true;
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString((String)"jsp.error.unable.compile"), (Throwable)ex);
            }
        }
    }

    public Compiler createCompiler() throws JasperException {
        JavaCompiler javac;
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        String compilerPath = this.options.getJspCompilerPath();
        Class jspCompilerPlugin = this.options.getJspCompilerPlugin();
        if (jspCompilerPlugin != null) {
            try {
                javac = (JavaCompiler)jspCompilerPlugin.newInstance();
            }
            catch (Exception ex) {
                Constants.message((String)"jsp.warning.compiler.class.cantcreate", (Object[])new Object[]{jspCompilerPlugin, ex}, (int)Integer.MIN_VALUE);
                javac = new SunJavaCompiler();
            }
        } else {
            javac = new SunJavaCompiler();
        }
        if (compilerPath != null) {
            javac.setCompilerPath(compilerPath);
        }
        this.jspCompiler = new JspCompiler(this, this.jsw);
        this.jspCompiler.setJavaCompiler(javac);
        return this.jspCompiler;
    }

    private void createOutdir() {
        File outDir = null;
        try {
            URL outURL = this.options.getScratchDir().toURL();
            String outURI = outURL.toString();
            outURI = outURI.endsWith("/") ? String.valueOf(outURI) + this.jspUri.substring(1, this.jspUri.lastIndexOf("/") + 1) : String.valueOf(outURI) + this.jspUri.substring(0, this.jspUri.lastIndexOf("/") + 1);
            outURL = new URL(outURI);
            outDir = new File(this.normalize(outURL.getFile()));
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            this.outDir = String.valueOf(outDir.toString()) + File.separator;
            this.outUrls[0] = new URL(String.valueOf(outDir.toURL().toString()) + File.separator);
        }
        catch (Exception e) {
            throw new IllegalStateException("No output directory: " + e.getMessage());
        }
    }

    public ClassLoader getClassLoader() {
        return this.rctxt.getParentClassLoader();
    }

    public String getClassPath() {
        return this.rctxt.getClassPath();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getJavacOutputDir() {
        return null;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getOutputDir() {
        return this.outDir;
    }

    public JspReader getReader() {
        return this.reader;
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public URL getResource(String res) throws MalformedURLException {
        return this.context.getResource(res);
    }

    public InputStream getResourceAsStream(String res) {
        return this.context.getResourceAsStream(res);
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public String[] getTldLocation(String uri) throws JasperException {
        String[] location = this.options.getTldLocationsCache().getLocation(uri);
        return location;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void incrementRemoved() {
        if (this.removed > 1) {
            this.jspCompiler.removeGeneratedFiles();
            this.rctxt.removeWrapper(this.jspUri);
        }
        ++this.removed;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public boolean isReload() {
        return this.reload;
    }

    public boolean isRemoved() {
        return this.removed > 1;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public Class load() throws JasperException, FileNotFoundException {
        try {
            if (this.servletClass == null && !this.options.getDevelopment()) {
                this.compile();
            }
            this.jspLoader = new JasperLoader(this.outUrls, String.valueOf(this.getServletPackageName()) + "." + this.getServletClassName(), this.rctxt.getParentClassLoader(), this.rctxt.getPermissionCollection(), this.rctxt.getCodeSource());
            this.servletClass = this.jspLoader.loadClass(String.valueOf(this.getServletPackageName()) + "." + this.getServletClassName());
        }
        catch (FileNotFoundException ex) {
            this.jspCompiler.removeGeneratedFiles();
            throw ex;
        }
        catch (ClassNotFoundException cex) {
            throw new JasperException(Constants.getString((String)"jsp.error.unable.load"), (Throwable)cex);
        }
        catch (JasperException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JasperException(Constants.getString((String)"jsp.error.unable.compile"), (Throwable)ex);
        }
        this.removed = 0;
        this.reload = false;
        return this.servletClass;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.charAt(0) == '/') {
            return uri;
        }
        return String.valueOf(this.baseURI) + uri;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.servletPackageName = servletPackageName;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }
}

