/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.Validator;
import org.xml.sax.Attributes;

public class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private PageInfo pageInfo;

    public Compiler(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
        this.errDispatcher = new ErrorDispatcher();
    }

    public String changeEncodingIfNecessary(JspReader tmpReader) throws JasperException {
        while (tmpReader.skipUntil("<%@") != null) {
            tmpReader.skipSpaces();
            if (!tmpReader.matches("page")) continue;
            tmpReader.advance(4);
            tmpReader.skipSpaces();
            try {
                int loc;
                Attributes attrs = tmpReader.parseTagAttributes();
                String ct = attrs.getValue("contentType");
                if (ct == null || (loc = ct.indexOf("charset=")) <= 0) continue;
                String encoding = ct.substring(loc + 8);
                return encoding;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public void compile() throws FileNotFoundException, JasperException, Exception {
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader()));
        String javaFileName = this.ctxt.getServletJavaFileName();
        Constants.message((String)"jsp.message.java_file_name_is", (Object[])new Object[]{javaFileName}, (int)4);
        String javaEncoding = "UTF8";
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            if (javaEncoding != null) {
                try {
                    osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    this.errDispatcher.jspError("jsp.error.invalid.javaEncoding", "UTF8", javaEncoding);
                }
            }
            this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", "UTF8");
        }
        ServletWriter writer = new ServletWriter(new PrintWriter(osw));
        this.ctxt.setWriter(writer);
        ParserController parserCtl = new ParserController(this.ctxt, this);
        Node.Nodes pageNodes = parserCtl.parse(this.ctxt.getJspFile());
        Validator.validate(this, pageNodes);
        Generator.generate(writer, this, pageNodes);
        writer.close();
        String classpath = this.ctxt.getClassPath();
        String sep = System.getProperty("path.separator");
        String[] argv = new String[]{"-encoding", javaEncoding, "-classpath", String.valueOf(System.getProperty("java.class.path")) + sep + classpath, "-d", this.ctxt.getOutputDir(), javaFileName};
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < argv.length) {
            b.append(argv[i]);
            b.append(" ");
            ++i;
        }
        Constants.message((String)"jsp.message.compiling_with", (Object[])new Object[]{b.toString()}, (int)4);
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        if (this.javac == null) {
            return;
        }
        this.javac.setEncoding(javaEncoding);
        this.javac.setClasspath(String.valueOf(System.getProperty("java.class.path")) + sep + classpath);
        this.javac.setOutputDir(this.ctxt.getJavacOutputDir());
        this.javac.setMsgOutput(out);
        this.javac.setClassDebugInfo(this.ctxt.getOptions().getClassDebugInfo());
        boolean success = this.javac.compile(javaFileName);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!success) {
            this.errDispatcher.javacError(out.toString(), javaFileName, pageNodes);
        }
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public boolean isOutDated() {
        return true;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.mangler.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                classFile.delete();
            }
        }
        catch (Exception exception) {}
        try {
            String javaFileName = this.mangler.getJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                javaFile.delete();
            }
        }
        catch (Exception exception) {}
    }

    public void setJavaCompiler(JavaCompiler javac) {
        this.javac = javac;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
        this.ctxt.setServletJavaFileName(mangler.getJavaFileName());
    }
}

