/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Node;
import org.xml.sax.Attributes;

public class Dumper {
    public static void dump(Node.Nodes page) {
        try {
            page.visit(new DumpVisitor());
        }
        catch (JasperException e) {
            e.printStackTrace();
        }
    }

    public static void dump(Node n) {
        try {
            n.accept(new DumpVisitor());
        }
        catch (JasperException e) {
            e.printStackTrace();
        }
    }

    static class DumpVisitor
    extends Node.Visitor {
        private int indent = 0;

        DumpVisitor() {
        }

        private void dumpBody(Node n) throws JasperException {
            Node.Nodes page = n.getBody();
            if (page != null) {
                page.visit(this);
            }
        }

        private String getAttributes(Attributes attrs) {
            if (attrs == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < attrs.getLength()) {
                buf.append(" " + attrs.getQName(i) + "=\"" + attrs.getValue(i) + "\"");
                ++i;
            }
            return buf.toString();
        }

        private void printAttributes(String prefix, Attributes attrs, String suffix) {
            this.printString(prefix, this.getAttributes(attrs), suffix);
        }

        private void printIndent() {
            int i = 0;
            while (i < this.indent) {
                System.out.print("  ");
                ++i;
            }
        }

        private void printString(String str) {
            this.printIndent();
            System.out.print(str);
        }

        private void printString(String prefix, String str, String suffix) {
            this.printIndent();
            if (str != null) {
                System.out.print(String.valueOf(prefix) + str + suffix);
            } else {
                System.out.print(String.valueOf(prefix) + suffix);
            }
        }

        private void printString(String prefix, char[] chars, String suffix) {
            String str = null;
            if (chars != null) {
                str = new String(chars);
            }
            this.printString(prefix, str, suffix);
        }

        public void visit(Node.Comment n) throws JasperException {
            this.printString("<%--", n.getText(), "--%>");
        }

        public void visit(Node.CustomTag n) throws JasperException {
            this.printAttributes("<" + n.getName(), n.getAttributes(), ">");
            this.dumpBody(n);
            this.printString("</" + n.getName() + ">");
        }

        public void visit(Node.Declaration n) throws JasperException {
            this.printString("<%!", n.getText(), "%>");
        }

        public void visit(Node.Expression n) throws JasperException {
            this.printString("<%=", n.getText(), "%>");
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            this.printAttributes("<jsp:forward", n.getAttributes(), ">");
            this.dumpBody(n);
            this.printString("</jsp:forward>");
        }

        public void visit(Node.GetProperty n) throws JasperException {
            this.printAttributes("<jsp:getProperty", n.getAttributes(), "/>");
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            this.printAttributes("<jsp:include", n.getAttributes(), "/>");
            this.dumpBody(n);
        }

        public void visit(Node.IncludeDirective n) throws JasperException {
            this.printAttributes("<%@ include", n.getAttributes(), "%>");
            this.dumpBody(n);
        }

        public void visit(Node.PageDirective n) throws JasperException {
            this.printAttributes("<%@ page", n.getAttributes(), "%>");
        }

        public void visit(Node.PlugIn n) throws JasperException {
            this.printAttributes("<jsp:plugin", n.getAttributes(), ">");
            this.dumpBody(n);
            this.printString("</jsp:plugin>");
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            this.printString("<%", n.getText(), "%>");
        }

        public void visit(Node.SetProperty n) throws JasperException {
            this.printAttributes("<jsp:setProperty", n.getAttributes(), "/>");
        }

        public void visit(Node.TaglibDirective n) throws JasperException {
            this.printAttributes("<%@ taglib", n.getAttributes(), "%>");
        }

        public void visit(Node.TemplateText n) throws JasperException {
            this.printString(new String(n.getText()));
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            String tag = n.getName();
            this.printAttributes("<" + tag, n.getAttributes(), ">");
            this.dumpBody(n);
            this.printString("</" + tag + ">");
        }

        public void visit(Node.UseBean n) throws JasperException {
            this.printAttributes("<jsp:usebean", n.getAttributes(), ">");
            this.dumpBody(n);
            this.printString("</jsp:usebean>");
        }
    }
}

