/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.xml.sax.Attributes;

public class Generator {
    private ServletWriter out;
    private ErrorDispatcher err;
    private BeanRepository beanInfo;
    private JspCompilationContext ctxt;
    private boolean breakAtLF;
    private PageInfo pageInfo;
    private FinallyApplyer finallies;
    private int tryBit;
    private Stack tryStack;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$TryCatchFinally;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$BodyTag;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$IterationTag;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;

    Generator(ServletWriter out, Compiler compiler) {
        this.out = out;
        this.err = compiler.getErrorDispatcher();
        this.ctxt = compiler.getCompilationContext();
        this.pageInfo = compiler.getPageInfo();
        this.beanInfo = this.pageInfo.getBeanRepository();
        this.breakAtLF = this.ctxt.getOptions().getMappedFile();
        this.finallies = new FinallyApplyer();
        this.tryStack = new Stack();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void generate(ServletWriter out, Compiler compiler, Node.Nodes page) throws JasperException {
        Generator gen = new Generator(out, compiler);
        gen.generatePreamble(page);
        page.visit(gen.new GenerateVisitor());
        gen.generatePostamble(page);
    }

    private void generateDeclarations(Node.Nodes page) throws JasperException {
        this.out.println();
        class DeclarationVisitor
        extends Node.Visitor {
            private final /* synthetic */ Generator this$0;

            DeclarationVisitor(Generator this$0) {
                this.this$0 = this$0;
            }

            public void visit(Node.Declaration n) throws JasperException {
                Generator.access$0(this.this$0).printMultiLn(new String(n.getText()));
            }

            public void visit(Node.PageDirective n) throws JasperException {
                String info = n.getAttributeValue("info");
                if (info == null) {
                    return;
                }
                Generator.access$0(this.this$0).printil("public String getServletInfo() {");
                Generator.access$0(this.this$0).pushIndent();
                Generator.access$0(this.this$0).printin("return ");
                Generator.access$0(this.this$0).print(Generator.access$1(info));
                Generator.access$0(this.this$0).println(";");
                Generator.access$0(this.this$0).popIndent();
                Generator.access$0(this.this$0).print('}');
                Generator.access$0(this.this$0).println();
            }
        }
        page.visit(new DeclarationVisitor(this));
    }

    private void generatePostamble(Node.Nodes page) {
        this.out.popIndent();
        this.out.printil("} catch (Throwable t) {");
        this.out.pushIndent();
        this.out.printil("if (out != null && out.getBufferSize() != 0)");
        this.out.pushIndent();
        this.out.printil("out.clearBuffer();");
        this.out.popIndent();
        this.out.printil("if (pageContext != null) pageContext.handlePageException(t);");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printil("finallies(bitmask, out, tags, pageContext);");
        this.out.popIndent();
        this.out.printil("} catch (javax.servlet.jsp.JspException e) {");
        this.out.pushIndent();
        this.out.printil("if (pageContext != null) pageContext.handlePageException(e);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.printil("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.finallies.done();
        this.out.printil(this.finallies.toString());
        this.out.popIndent();
        this.out.printil("}");
    }

    private void generatePreamble(Node.Nodes page) throws JasperException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        String serviceMethodName = "_jspService";
        if (!"".equals(servletPackageName) && servletPackageName != null) {
            this.out.printil("package " + servletPackageName + ";");
            this.out.println();
        }
        Iterator iter = this.pageInfo.getImports().iterator();
        while (iter.hasNext()) {
            this.out.printin("import ");
            this.out.print((String)iter.next());
            this.out.println(";");
        }
        this.out.println();
        this.out.printin("public class ");
        this.out.print(servletClassName);
        this.out.print(" extends ");
        this.out.print(this.pageInfo.getExtends());
        if (!this.pageInfo.isThreadSafe()) {
            this.out.print("implements SingleThreadModel");
        }
        this.out.println(" {");
        this.out.pushIndent();
        this.generateDeclarations(page);
        this.out.println();
        this.out.printil("private static java.util.Vector _jspx_includes;");
        this.out.println();
        this.out.println();
        List includes = this.pageInfo.getIncludes();
        iter = includes.iterator();
        if (!includes.isEmpty()) {
            this.out.printil("static {");
            this.out.pushIndent();
            this.out.printin("_jspx_includes = new java.util.Vector(");
            this.out.print(String.valueOf(includes.size()));
            this.out.println(");");
            while (iter.hasNext()) {
                this.out.printin("_jspx_includes.add(\"");
                this.out.print((String)iter.next());
                this.out.println("\");");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
            this.out.println();
        }
        this.out.printil("public java.util.List getIncludes() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_includes;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.println();
        this.out.printil("private void addTagToVector(java.util.Vector tags, int index, Object tag) {");
        this.out.pushIndent();
        this.out.printil("if (index + 1 > tags.size())");
        this.out.pushIndent();
        this.out.printil("tags.setSize(index + 1);");
        this.out.popIndent();
        this.out.printil("tags.setElementAt(tag, index);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.println();
        this.out.printin("public void ");
        this.out.print(serviceMethodName);
        this.out.println("(HttpServletRequest request, HttpServletResponse response)");
        this.out.println("        throws java.io.IOException, ServletException {");
        this.out.pushIndent();
        this.out.println();
        this.out.printil("JspFactory _jspxFactory = null;");
        this.out.printil("PageContext pageContext = null;");
        if (this.pageInfo.isSession()) {
            this.out.printil("HttpSession session = null;");
        }
        if (this.pageInfo.isIsErrorPage()) {
            this.out.printil("Throwable exception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.out.printil("ServletContext application = null;");
        this.out.printil("ServletConfig config = null;");
        this.out.printil("JspWriter out = null;");
        this.out.printil("Object page = this;");
        this.out.printil("java.util.BitSet bitmask = new java.util.BitSet();");
        this.out.printil("java.util.Vector tags = new java.util.Vector();");
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printil("_jspxFactory = JspFactory.getDefaultFactory();");
        this.out.printin("response.setContentType(");
        this.out.print(Generator.quote(this.pageInfo.getContentType()));
        this.out.println(");");
        this.out.printil("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.out.printin("\t\t\t");
        this.out.print(Generator.quote(this.pageInfo.getErrorPage()));
        this.out.print(", " + this.pageInfo.isSession());
        this.out.print(", " + this.pageInfo.getBuffer());
        this.out.print(", " + this.pageInfo.isAutoFlush());
        this.out.println(");");
        this.out.printil("application = pageContext.getServletContext();");
        this.out.printil("config = pageContext.getServletConfig();");
        if (this.pageInfo.isSession()) {
            this.out.printil("session = pageContext.getSession();");
        }
        this.out.printil("out = pageContext.getOut();");
        this.out.println();
    }

    private static String quote(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        b.append('\"');
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
            } else if (c == '\\') {
                b.append('\\').append('\\');
            } else if (c == '\n') {
                b.append('\\').append('n');
            } else if (c == '\r') {
                b.append('\\').append('r');
            } else {
                b.append(c);
            }
            ++i;
        }
        b.append('\"');
        return b.toString();
    }

    class GenerateVisitor
    extends Node.Visitor {
        private Hashtable handlerInfos = new Hashtable();
        private Hashtable tagVarNumbers = new Hashtable();
        private String parent;
        private static final String SINGLE_QUOTE = "'";
        private static final String DOUBLE_QUOTE = "\\\"";
        private static final int CHUNKSIZE = 1024;

        static /* synthetic */ Generator access$0(GenerateVisitor $0) {
            return $0.Generator.this;
        }

        static /* synthetic */ String access$1(GenerateVisitor $0, Node.JspAttribute $1, boolean $2) {
            return $0.attributeValue($1, $2);
        }

        static /* synthetic */ String access$2(GenerateVisitor $0, String $1, String $2) {
            return $0.makeAttr($1, $2);
        }

        private String attributeValue(Node.JspAttribute attr, boolean encode) {
            String v = attr.getValue();
            if (attr.isExpression()) {
                if (encode) {
                    return "java.net.URLEncoder.encode(" + v + ")";
                }
                return v;
            }
            if (encode) {
                v = URLEncoder.encode(v);
            }
            return Generator.quote(v);
        }

        private String convertString(Class c, String s, String attrName, Class propEditorClass) throws JasperException {
            if (propEditorClass != null) {
                return "(" + c.getName() + ")JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + c.getName() + ".class, \"" + attrName + "\", " + Generator.quote(s) + ", " + propEditorClass.getName() + ".class)";
            }
            if (c == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Generator.class$("java.lang.String")))) {
                return Generator.quote(s);
            }
            if (c == Boolean.TYPE) {
                return Boolean.valueOf(s).toString();
            }
            if (c == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = Generator.class$("java.lang.Boolean")))) {
                return "new Boolean(" + Boolean.valueOf(s).toString() + ")";
            }
            if (c == Byte.TYPE) {
                return "((byte)" + Byte.valueOf(s).toString() + ")";
            }
            if (c == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = Generator.class$("java.lang.Byte")))) {
                return "new Byte((byte)" + Byte.valueOf(s).toString() + ")";
            }
            if (c == Character.TYPE) {
                if (s.length() > 0) {
                    char ch = s.charAt(0);
                    return "((char) " + ch + ")";
                }
                throw new NumberFormatException(Generator.this.err.getString("jsp.error.bad_string_char"));
            }
            if (c == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = Generator.class$("java.lang.Character")))) {
                if (s.length() > 0) {
                    char ch = s.charAt(0);
                    return "new Character((char) " + ch + ")";
                }
                throw new NumberFormatException(Generator.this.err.getString("jsp.error.bad_string_Character"));
            }
            if (c == Double.TYPE) {
                return Double.valueOf(s).toString();
            }
            if (c == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = Generator.class$("java.lang.Double")))) {
                return "new Double(" + Double.valueOf(s).toString() + ")";
            }
            if (c == Float.TYPE) {
                return String.valueOf(Float.valueOf(s).toString()) + "f";
            }
            if (c == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = Generator.class$("java.lang.Float")))) {
                return "new Float(" + Float.valueOf(s).toString() + "f)";
            }
            if (c == Integer.TYPE) {
                return Integer.valueOf(s).toString();
            }
            if (c == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Generator.class$("java.lang.Integer")))) {
                return "new Integer(" + Integer.valueOf(s).toString() + ")";
            }
            if (c == Short.TYPE) {
                return "((short) " + Short.valueOf(s).toString() + ")";
            }
            if (c == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = Generator.class$("java.lang.Short")))) {
                return "new Short(" + Short.valueOf(s).toString() + ")";
            }
            if (c == Long.TYPE) {
                return String.valueOf(Long.valueOf(s).toString()) + "l";
            }
            if (c == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = Generator.class$("java.lang.Long")))) {
                return "new Long(" + Long.valueOf(s).toString() + "l)";
            }
            if (c == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Generator.class$("java.lang.Object")))) {
                return "new String(" + Generator.quote(s) + ")";
            }
            return "(" + c.getName() + ")JspRuntimeLibrary.getValueFromPropertyEditorManager(" + c.getName() + ".class, \"" + attrName + "\", " + Generator.quote(s) + ")";
        }

        private String createTagVarName(String fullName, String prefix, String shortName) {
            if (prefix.indexOf(45) >= 0) {
                prefix = this.replace(prefix, '-', "$1");
            }
            if (prefix.indexOf(46) >= 0) {
                prefix = this.replace(prefix, '.', "$2");
            }
            if (shortName.indexOf(45) >= 0) {
                shortName = this.replace(shortName, '-', "$1");
            }
            if (shortName.indexOf(46) >= 0) {
                shortName = this.replace(shortName, '.', "$2");
            }
            if (shortName.indexOf(58) >= 0) {
                shortName = this.replace(shortName, ':', "$3");
            }
            Hashtable hashtable = this.tagVarNumbers;
            synchronized (hashtable) {
                String varName = String.valueOf(prefix) + "_" + shortName + "_";
                if (this.tagVarNumbers.get(fullName) != null) {
                    Integer i = (Integer)this.tagVarNumbers.get(fullName);
                    varName = String.valueOf(varName) + i;
                    this.tagVarNumbers.put(fullName, new Integer(i + 1));
                    String string = varName;
                    Object var6_9 = null;
                    return string;
                }
                this.tagVarNumbers.put(fullName, new Integer(1));
                String string = String.valueOf(varName) + "0";
                Object var6_10 = null;
                return string;
            }
        }

        private void declareTagVariableInfos(TagVariableInfo[] tagVarInfos, TagData tagData, int scope) {
            if (tagVarInfos == null) {
                return;
            }
            int i = 0;
            while (i < tagVarInfos.length) {
                String name = tagVarInfos[i].getNameGiven();
                if (name == null) {
                    name = tagData.getAttributeString(tagVarInfos[i].getNameFromAttribute());
                }
                if (tagVarInfos[i].getScope() == scope && tagVarInfos[i].getDeclare()) {
                    Generator.this.out.printin(tagVarInfos[i].getClassName());
                    Generator.this.out.print(" ");
                    Generator.this.out.print(name);
                    Generator.this.out.println(" = null;");
                }
                ++i;
            }
        }

        private void declareVariableInfos(VariableInfo[] varInfos, int scope) {
            if (varInfos == null) {
                return;
            }
            int i = 0;
            while (i < varInfos.length) {
                if (varInfos[i].getScope() == scope && varInfos[i].getDeclare()) {
                    Generator.this.out.printin(varInfos[i].getClassName());
                    Generator.this.out.print(" ");
                    Generator.this.out.print(varInfos[i].getVarName());
                    Generator.this.out.println(" = null;");
                }
                ++i;
            }
        }

        private void generateCustomEnd(Node.CustomTag n, VariableInfo[] varInfos, TagVariableInfo[] tagVarInfos, Class tagHandlerClass, String tagHandlerVar, String tagEvalVar) {
            Integer tryBitVal;
            boolean implementsIterationTag = (class$javax$servlet$jsp$tagext$IterationTag != null ? class$javax$servlet$jsp$tagext$IterationTag : (class$javax$servlet$jsp$tagext$IterationTag = Generator.class$("javax.servlet.jsp.tagext.IterationTag"))).isAssignableFrom(tagHandlerClass);
            boolean implementsBodyTag = (class$javax$servlet$jsp$tagext$BodyTag != null ? class$javax$servlet$jsp$tagext$BodyTag : (class$javax$servlet$jsp$tagext$BodyTag = Generator.class$("javax.servlet.jsp.tagext.BodyTag"))).isAssignableFrom(tagHandlerClass);
            boolean implementsTryCatchFinally = (class$javax$servlet$jsp$tagext$TryCatchFinally != null ? class$javax$servlet$jsp$tagext$TryCatchFinally : (class$javax$servlet$jsp$tagext$TryCatchFinally = Generator.class$("javax.servlet.jsp.tagext.TryCatchFinally"))).isAssignableFrom(tagHandlerClass);
            if (n.getBody() != null && implementsIterationTag) {
                Generator.this.out.popIndent();
                Generator.this.out.printin("} while (");
                Generator.this.out.print(tagHandlerVar);
                Generator.this.out.println(".doAfterBody() == javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_AGAIN);");
            }
            this.updateVariableInfos(varInfos, 1, false);
            this.updateTagVariableInfos(tagVarInfos, n.getTagData(), 1, false);
            if (n.getBody() != null) {
                if (implementsBodyTag) {
                    tryBitVal = (Integer)Generator.this.tryStack.pop();
                    Generator.this.out.printil("// } finally {");
                    Generator.this.out.printin("bitmask.clear(");
                    Generator.this.out.print(tryBitVal.toString());
                    Generator.this.out.println(");");
                    Generator.this.out.printin("if (");
                    Generator.this.out.print(tagEvalVar);
                    Generator.this.out.println(" != javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE)");
                    Generator.this.out.pushIndent();
                    Generator.this.out.printil("out = pageContext.popBody();");
                    Generator.this.out.popIndent();
                    Generator.this.finallies.beginPartMethod(tryBitVal);
                    Generator.this.finallies.print("      if (");
                    Generator.this.finallies.print("((Integer)tags.elementAt(");
                    Generator.this.finallies.print(tryBitVal.toString());
                    Generator.this.finallies.print(")).intValue()");
                    Generator.this.finallies.println(" != javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE)");
                    Generator.this.finallies.println("        out = pageContext.popBody();");
                    Generator.this.finallies.endPartMethod();
                    Generator.this.out.printil("// }");
                }
                Generator.this.out.popIndent();
                Generator.this.out.printil("}");
            }
            Generator.this.out.printin("if (");
            Generator.this.out.print(tagHandlerVar);
            Generator.this.out.println(".doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE)");
            Generator.this.out.pushIndent();
            Generator.this.out.printil("return;");
            Generator.this.out.popIndent();
            if (implementsTryCatchFinally) {
                Generator.this.out.popIndent();
                Generator.this.out.printil("} catch (Throwable _jspx_exception) {");
                Generator.this.out.pushIndent();
                Generator.this.out.printin(tagHandlerVar);
                Generator.this.out.println(".doCatch(_jspx_exception);");
                Generator.this.out.popIndent();
                Generator.this.out.printil("} finally {");
                Generator.this.out.pushIndent();
                Generator.this.out.printin(tagHandlerVar);
                Generator.this.out.println(".doFinally();");
                Generator.this.out.printin(tagHandlerVar);
                Generator.this.out.println(".release();");
                Generator.this.out.popIndent();
                Generator.this.out.printil("}");
            } else {
                tryBitVal = (Integer)Generator.this.tryStack.pop();
                Generator.this.out.printil("// } finally {");
                Generator.this.out.printin("bitmask.clear(");
                Generator.this.out.print(tryBitVal.toString());
                Generator.this.out.println(");");
                Generator.this.out.printin(tagHandlerVar);
                Generator.this.out.println(".release();");
                Generator.this.out.printil("// }");
                Generator.this.finallies.beginPartMethod(tryBitVal);
                Generator.this.finallies.printin("((javax.servlet.jsp.tagext.Tag)tags.elementAt(");
                Generator.this.finallies.print(tryBitVal.toString());
                Generator.this.finallies.print("))");
                Generator.this.finallies.println(".release();");
                Generator.this.finallies.endPartMethod();
            }
            this.updateVariableInfos(varInfos, 2, true);
            this.updateTagVariableInfos(tagVarInfos, n.getTagData(), 2, true);
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        private void generateCustomStart(Node.CustomTag n, VariableInfo[] varInfos, TagVariableInfo[] tagVarInfos, TagHandlerInfo handlerInfo, String tagHandlerVar, String tagEvalVar) throws JasperException {
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            Generator.this.out.printin("/* ----  ");
            Generator.this.out.print(n.getName());
            Generator.this.out.println(" ---- */");
            Class tagHandlerClass = handlerInfo.getTagHandlerClass();
            boolean implementsTryCatchFinally = (class$javax$servlet$jsp$tagext$TryCatchFinally != null ? class$javax$servlet$jsp$tagext$TryCatchFinally : (class$javax$servlet$jsp$tagext$TryCatchFinally = Generator.class$("javax.servlet.jsp.tagext.TryCatchFinally"))).isAssignableFrom(tagHandlerClass);
            Generator.this.out.printin(tagHandlerClass.getName());
            Generator.this.out.print(" ");
            Generator.this.out.print(tagHandlerVar);
            Generator.this.out.print(" = new ");
            Generator.this.out.print(tagHandlerClass.getName());
            Generator.this.out.println("();");
            this.generateSetters(n, tagHandlerVar, handlerInfo);
            this.declareVariableInfos(varInfos, 1);
            this.declareTagVariableInfos(tagVarInfos, n.getTagData(), 1);
            if (implementsTryCatchFinally) {
                Generator.this.out.printil("try {");
                Generator.this.out.pushIndent();
            } else {
                Generator.this.out.printil("// try {");
                Generator.this.out.printin("bitmask.set(");
                Generator generator = Generator.this;
                int n2 = generator.tryBit;
                generator.tryBit = n2 + 1;
                Integer tryBitVal = new Integer(n2);
                Generator.this.tryStack.push(tryBitVal);
                Generator.this.out.print(tryBitVal.toString());
                Generator.this.out.println(");");
                Generator.this.out.printin("addTagToVector(tags, ");
                Generator.this.out.print(tryBitVal.toString());
                Generator.this.out.print(", ");
                Generator.this.out.print(tagHandlerVar);
                Generator.this.out.println(");");
            }
            Generator.this.out.printin("int ");
            Generator.this.out.print(tagEvalVar);
            Generator.this.out.print(" = ");
            Generator.this.out.print(tagHandlerVar);
            Generator.this.out.println(".doStartTag();");
            boolean isBodyTag = (class$javax$servlet$jsp$tagext$BodyTag != null ? class$javax$servlet$jsp$tagext$BodyTag : (class$javax$servlet$jsp$tagext$BodyTag = Generator.class$("javax.servlet.jsp.tagext.BodyTag"))).isAssignableFrom(tagHandlerClass);
            this.updateVariableInfos(varInfos, 1, false);
            this.updateTagVariableInfos(tagVarInfos, n.getTagData(), 1, false);
            if (n.getBody() != null) {
                Generator.this.out.printin("if (");
                Generator.this.out.print(tagEvalVar);
                Generator.this.out.println(" != javax.servlet.jsp.tagext.Tag.SKIP_BODY) {");
                Generator.this.out.pushIndent();
                if (isBodyTag) {
                    Generator.this.out.printil("// try {");
                    Generator.this.out.printin("bitmask.set(");
                    Generator generator = Generator.this;
                    int n3 = generator.tryBit;
                    generator.tryBit = n3 + 1;
                    Integer tryBitVal = new Integer(n3);
                    Generator.this.tryStack.push(tryBitVal);
                    Generator.this.out.print(tryBitVal.toString());
                    Generator.this.out.println(");");
                    Generator.this.out.printin("addTagToVector(tags, ");
                    Generator.this.out.print(tryBitVal.toString());
                    Generator.this.out.print(", new Integer(");
                    Generator.this.out.print(tagEvalVar);
                    Generator.this.out.println("));");
                    Generator.this.out.printin("if (");
                    Generator.this.out.print(tagEvalVar);
                    Generator.this.out.println(" != javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE) {");
                    Generator.this.out.pushIndent();
                    Generator.this.out.printil("out = pageContext.pushBody();");
                    Generator.this.out.printin(tagHandlerVar);
                    Generator.this.out.println(".setBodyContent((javax.servlet.jsp.tagext.BodyContent) out);");
                    Generator.this.out.printin(tagHandlerVar);
                    Generator.this.out.println(".doInitBody();");
                    Generator.this.out.popIndent();
                    Generator.this.out.printil("}");
                }
                if ((class$javax$servlet$jsp$tagext$IterationTag != null ? class$javax$servlet$jsp$tagext$IterationTag : (class$javax$servlet$jsp$tagext$IterationTag = Generator.class$("javax.servlet.jsp.tagext.IterationTag"))).isAssignableFrom(tagHandlerClass)) {
                    Generator.this.out.printil("do {");
                    Generator.this.out.pushIndent();
                }
            }
            this.updateVariableInfos(varInfos, 0, true);
            this.updateTagVariableInfos(tagVarInfos, n.getTagData(), 0, true);
            this.updateVariableInfos(varInfos, 1, false);
            this.updateTagVariableInfos(tagVarInfos, n.getTagData(), 1, false);
        }

        private void generateSetters(Node.CustomTag n, String tagHandlerVar, TagHandlerInfo handlerInfo) throws JasperException {
            Generator.this.out.printin(tagHandlerVar);
            Generator.this.out.println(".setPageContext(pageContext);");
            Generator.this.out.printin(tagHandlerVar);
            Generator.this.out.print(".setParent(");
            Generator.this.out.print(this.parent);
            Generator.this.out.println(");");
            Node.JspAttribute[] attrs = n.getJspAttributes();
            int i = 0;
            while (i < attrs.length) {
                String attrValue = attrs[i].getValue();
                if (attrValue != null) {
                    String attrName = attrs[i].getName();
                    Method m = handlerInfo.getSetterMethod(attrName);
                    if (m == null) {
                        Generator.this.err.jspError(n, "jsp.error.unable.to_find_method", attrName);
                    }
                    Class<?>[] c = m.getParameterTypes();
                    if (!attrs[i].isExpression()) {
                        attrValue = this.convertString(c[0], attrValue, attrName, handlerInfo.getPropertyEditorClass(attrName));
                    }
                    Generator.this.out.printin(tagHandlerVar);
                    Generator.this.out.print(".");
                    Generator.this.out.print(m.getName());
                    Generator.this.out.print("(");
                    Generator.this.out.print(attrValue);
                    Generator.this.out.println(");");
                }
                ++i;
            }
        }

        private String makeAttr(String attr, String value) {
            if (value == null) {
                return "";
            }
            return " " + attr + "=\"" + value + '\"';
        }

        private void printParams(Node n) throws JasperException {
            if (n.getBody() != null) {
                class ParamVisitor
                extends Node.Visitor {
                    private final /* synthetic */ GenerateVisitor this$1;
                    char separator;

                    ParamVisitor(GenerateVisitor this$1) {
                        this.this$1 = this$1;
                        this.separator = (char)63;
                    }

                    public void visit(Node.ParamAction n) throws JasperException {
                        Generator.access$0(GenerateVisitor.access$0(this.this$1)).print(" + \"");
                        Generator.access$0(GenerateVisitor.access$0(this.this$1)).print(this.separator);
                        Generator.access$0(GenerateVisitor.access$0(this.this$1)).print(n.getAttributeValue("name"));
                        Generator.access$0(GenerateVisitor.access$0(this.this$1)).print("=\" + ");
                        Generator.access$0(GenerateVisitor.access$0(this.this$1)).print(GenerateVisitor.access$1(this.this$1, n.getValue(), true));
                        this.separator = (char)38;
                    }
                }
                n.getBody().visit(new ParamVisitor(this));
            }
        }

        private String replace(String name, char replace, String with) {
            StringBuffer buf = new StringBuffer();
            int begin = 0;
            int last = name.length();
            while (true) {
                int end;
                if ((end = name.indexOf(replace, begin)) < 0) {
                    end = last;
                }
                buf.append(name.substring(begin, end));
                if (end == last) break;
                buf.append(with);
                begin = end + 1;
            }
            return buf.toString();
        }

        private void updateTagVariableInfos(TagVariableInfo[] tagVarInfos, TagData tagData, int scope, boolean declare) {
            if (tagVarInfos == null) {
                return;
            }
            int i = 0;
            while (i < tagVarInfos.length) {
                String name = tagVarInfos[i].getNameGiven();
                if (name == null) {
                    name = tagData.getAttributeString(tagVarInfos[i].getNameFromAttribute());
                }
                if (tagVarInfos[i].getScope() == scope) {
                    if (declare && tagVarInfos[i].getDeclare()) {
                        Generator.this.out.printin(String.valueOf(tagVarInfos[i].getClassName()) + " ");
                    }
                    Generator.this.out.printin(name);
                    Generator.this.out.print(" = (");
                    Generator.this.out.print(tagVarInfos[i].getClassName());
                    Generator.this.out.print(") pageContext.findAttribute(");
                    Generator.this.out.print(Generator.quote(name));
                    Generator.this.out.println(");");
                }
                ++i;
            }
        }

        private void updateVariableInfos(VariableInfo[] varInfos, int scope, boolean declare) {
            if (varInfos == null) {
                return;
            }
            int i = 0;
            while (i < varInfos.length) {
                if (varInfos[i].getScope() == scope) {
                    if (declare && varInfos[i].getDeclare()) {
                        Generator.this.out.printin(String.valueOf(varInfos[i].getClassName()) + " ");
                    }
                    Generator.this.out.printin(varInfos[i].getVarName());
                    Generator.this.out.print(" = (");
                    Generator.this.out.print(varInfos[i].getClassName());
                    Generator.this.out.print(") pageContext.findAttribute(");
                    Generator.this.out.print(Generator.quote(varInfos[i].getVarName()));
                    Generator.this.out.println(");");
                }
                ++i;
            }
        }

        public void visit(Node.CustomTag n) throws JasperException {
            TagHandlerInfo handlerInfo;
            TagLibraryInfo tagLibInfo = (TagLibraryInfo)Generator.this.pageInfo.getTagLibraries().get(n.getPrefix());
            TagInfo tagInfo = tagLibInfo.getTag(n.getShortName());
            VariableInfo[] varInfos = tagInfo.getVariableInfo(n.getTagData());
            TagVariableInfo[] tagVarInfos = tagInfo.getTagVariableInfos();
            Hashtable<String, TagHandlerInfo> handlerInfosByShortName = (Hashtable<String, TagHandlerInfo>)this.handlerInfos.get(n.getPrefix());
            if (handlerInfosByShortName == null) {
                handlerInfosByShortName = new Hashtable<String, TagHandlerInfo>();
                this.handlerInfos.put(n.getPrefix(), handlerInfosByShortName);
            }
            if ((handlerInfo = (TagHandlerInfo)handlerInfosByShortName.get(n.getShortName())) == null) {
                handlerInfo = new TagHandlerInfo(n, tagInfo.getTagClassName(), Generator.this.ctxt.getClassLoader(), Generator.this.err);
                handlerInfosByShortName.put(n.getShortName(), handlerInfo);
            }
            String baseVar = this.createTagVarName(n.getName(), n.getPrefix(), n.getShortName());
            String tagEvalVar = "_jspx_eval_" + baseVar;
            String tagHandlerVar = "_jspx_th_" + baseVar;
            this.generateCustomStart(n, varInfos, tagVarInfos, handlerInfo, tagHandlerVar, tagEvalVar);
            String tmpParent = this.parent;
            this.parent = tagHandlerVar;
            this.visitBody(n);
            this.parent = tmpParent;
            this.generateCustomEnd(n, varInfos, tagVarInfos, handlerInfo.getTagHandlerClass(), tagHandlerVar, tagEvalVar);
        }

        public void visit(Node.Expression n) throws JasperException {
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            Generator.this.out.printil("out.print(" + new String(n.getText()) + ");");
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            String page = n.getAttributeValue("page");
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            Generator.this.out.printil("if (true) {");
            Generator.this.out.pushIndent();
            Generator.this.out.printin("pageContext.forward(");
            Generator.this.out.print(this.attributeValue(n.getPage(), false));
            this.printParams(n);
            Generator.this.out.println(");");
            Generator.this.out.printil("return;");
            Generator.this.out.popIndent();
            Generator.this.out.printil("}");
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.GetProperty n) throws JasperException {
            String name = n.getAttributeValue("name");
            String property = n.getAttributeValue("property");
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            if (Generator.this.beanInfo.checkVariable(name)) {
                Class bean = Generator.this.beanInfo.getBeanType(name);
                String beanName = bean.getName();
                Method meth = JspRuntimeLibrary.getReadMethod((Class)bean, (String)property);
                String methodName = meth.getName();
                Generator.this.out.printil("out.print(JspRuntimeLibrary.toString((((" + beanName + ")pageContext.findAttribute(" + "\"" + name + "\"))." + methodName + "())));");
            } else {
                Generator.this.out.printil("out.print(JspRuntimeLibrary.toString(JspRuntimeLibrary.handleGetProperty(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\")));");
            }
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            String flush = n.getAttributeValue("flush");
            boolean isFlush = false;
            if ("true".equals(flush)) {
                isFlush = true;
            }
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            Generator.this.out.printin("JspRuntimeLibrary.include(request, response, ");
            Generator.this.out.print(this.attributeValue(n.getPage(), false));
            this.printParams(n);
            Generator.this.out.println(", out, " + isFlush + ");");
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.PlugIn n) throws JasperException {
            class ParamVisitor
            extends Node.Visitor {
                private final /* synthetic */ GenerateVisitor this$1;
                private boolean ie;

                ParamVisitor(GenerateVisitor this$1, boolean ie) {
                    this.this$1 = this$1;
                    this.ie = ie;
                }

                public void visit(Node.ParamAction n) throws JasperException {
                    String name = n.getAttributeValue("name");
                    if (name.equalsIgnoreCase("object")) {
                        name = "java_object";
                    } else if (name.equalsIgnoreCase("type")) {
                        name = "java_type";
                    }
                    String s0 = String.valueOf(GenerateVisitor.access$2(this.this$1, "name", name)) + " value=" + GenerateVisitor.access$1(this.this$1, n.getValue(), false);
                    if (this.ie) {
                        s0 = "<PARAM" + s0 + '>';
                    }
                    n.setBeginJavaLine(Generator.access$0(GenerateVisitor.access$0(this.this$1)).getJavaLine());
                    Generator.access$0(GenerateVisitor.access$0(this.this$1)).printil("out.println(" + Generator.access$1(s0) + ");");
                    n.setEndJavaLine(Generator.access$0(GenerateVisitor.access$0(this.this$1)).getJavaLine());
                }
            }
            String type = n.getAttributeValue("type");
            String code = n.getAttributeValue("code");
            String name = n.getAttributeValue("name");
            String width = n.getAttributeValue("width");
            String height = n.getAttributeValue("height");
            String hspace = n.getAttributeValue("hspace");
            String vspace = n.getAttributeValue("vspace");
            String align = n.getAttributeValue("align");
            String iepluginurl = n.getAttributeValue("iepluginurl");
            String nspluginurl = n.getAttributeValue("nspluginurl");
            String codebase = n.getAttributeValue("codebase");
            String archive = n.getAttributeValue("archive");
            String jreversion = n.getAttributeValue("jreversion");
            if (iepluginurl == null) {
                iepluginurl = "http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0";
            }
            if (nspluginurl == null) {
                nspluginurl = "http://java.sun.com/products/plugin/";
            }
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            String s0 = "<OBJECT classid=" + Generator.this.ctxt.getOptions().getIeClassId() + this.makeAttr("name", name) + this.makeAttr("width", width) + this.makeAttr("height", height) + this.makeAttr("hspace", hspace) + this.makeAttr("vspace", vspace) + this.makeAttr("align", align) + this.makeAttr("codebase", iepluginurl) + '>';
            Generator.this.out.printil("out.println(" + Generator.quote(s0) + ");");
            s0 = "<PARAM name=\"java_code\"" + this.makeAttr("value", code) + '>';
            Generator.this.out.printil("out.println(" + Generator.quote(s0) + ");");
            if (codebase != null) {
                s0 = "<PARAM name=\"java_codebase\"" + this.makeAttr("value", codebase) + '>';
                Generator.this.out.printil("out.println(" + Generator.quote(s0) + ");");
            }
            if (archive != null) {
                s0 = "<PARAM name=\"java_archive\"" + this.makeAttr("value", archive) + '>';
                Generator.this.out.printil("out.println(" + Generator.quote(s0) + ");");
            }
            s0 = "<PARAM name=\"type\"" + this.makeAttr("value", "application/x-java-" + type + ";" + (jreversion == null ? "" : "version=" + jreversion)) + '>';
            Generator.this.out.printil("out.println(" + Generator.quote(s0) + ");");
            if (n.getBody() != null) {
                n.getBody().visit(new ParamVisitor(this, true));
            }
            Generator.this.out.printil("out.println(" + Generator.quote("<COMMENT>") + ");");
            s0 = "<EMBED" + this.makeAttr("type", "application/x-java-" + type + ";" + (jreversion == null ? "" : "version=" + jreversion)) + this.makeAttr("name", name) + this.makeAttr("width", width) + this.makeAttr("height", height) + this.makeAttr("hspace", hspace) + this.makeAttr("vspace", vspace) + this.makeAttr("align", align) + this.makeAttr("pluginspage", nspluginurl) + this.makeAttr("java_codebase", codebase) + this.makeAttr("java_archive", archive);
            Generator.this.out.printil("out.println(" + Generator.quote(s0) + ");");
            if (n.getBody() != null) {
                n.getBody().visit(new ParamVisitor(this, false));
            }
            Generator.this.out.printil("out.println(" + Generator.quote(">") + ");");
            Generator.this.out.printil("out.println(" + Generator.quote("<NOEMBED>") + ");");
            Generator.this.out.printil("out.println(" + Generator.quote("</COMMENT>") + ");");
            if (n.getBody() != null) {
                n.getBody().visit(new Node.Visitor(this){
                    private final /* synthetic */ GenerateVisitor this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void visit(Node.FallBackAction n) {
                        n.setBeginJavaLine(Generator.access$0(GenerateVisitor.access$0(this.this$1)).getJavaLine());
                        Generator.access$0(GenerateVisitor.access$0(this.this$1)).printil("out.println(" + Generator.access$1(new String(n.getText())) + ");");
                        n.setEndJavaLine(Generator.access$0(GenerateVisitor.access$0(this.this$1)).getJavaLine());
                    }
                });
            }
            Generator.this.out.printil("out.println(" + Generator.quote("</NOEMBED></EMBED>") + ");");
            Generator.this.out.printil("out.println(" + Generator.quote("</OBJECT>") + ");");
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            Generator.this.out.printMultiLn(new String(n.getText()));
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.SetProperty n) throws JasperException {
            String name = n.getAttributeValue("name");
            String property = n.getAttributeValue("property");
            String param = n.getAttributeValue("param");
            Node.JspAttribute value = n.getValue();
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            if ("*".equals(property)) {
                Generator.this.out.printil("JspRuntimeLibrary.introspect(pageContext.findAttribute(\"" + name + "\"), request);");
            } else if (value == null) {
                if (param == null) {
                    param = property;
                }
                Generator.this.out.printil("JspRuntimeLibrary.introspecthelper(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", request.getParameter(\"" + param + "\"), " + "request, \"" + param + "\", false);");
            } else if (value.isExpression()) {
                Generator.this.out.printil("JspRuntimeLibrary.handleSetProperty(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\",");
                Generator.this.out.print(this.attributeValue(value, false));
                Generator.this.out.println(");");
            } else {
                Generator.this.out.printil("JspRuntimeLibrary.introspecthelper(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\",");
                Generator.this.out.print(this.attributeValue(value, false));
                Generator.this.out.println(",null, null, false);");
            }
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.TemplateText n) throws JasperException {
            char[] chars = n.getText();
            int size = chars.length;
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            Generator.this.out.printin();
            StringBuffer sb = new StringBuffer("out.write(\"");
            int initLength = sb.length();
            int count = 1024;
            int i = 0;
            while (i < size) {
                char ch = chars[i];
                --count;
                switch (ch) {
                    case '\"': {
                        sb.append('\\').append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\').append('\\');
                        break;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        break;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        if (!Generator.this.breakAtLF && count >= 0) break;
                        sb.append("\");");
                        Generator.this.out.println(sb.toString());
                        Generator.this.out.printin();
                        sb.setLength(initLength);
                        count = 1024;
                        break;
                    }
                    case '\t': {
                        sb.append('\\').append('t');
                        break;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
                ++i;
            }
            if (sb.length() > initLength) {
                sb.append("\");");
                Generator.this.out.println(sb.toString());
            }
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            Generator.this.out.printin("out.write(\"<");
            Generator.this.out.print(n.getName());
            Attributes attrs = n.getAttributes();
            if (attrs != null) {
                int attrsLength = attrs.getLength();
                int i = 0;
                while (i < attrsLength) {
                    String quote = DOUBLE_QUOTE;
                    String value = attrs.getValue(i);
                    if (value.indexOf(34) != -1) {
                        quote = SINGLE_QUOTE;
                    }
                    Generator.this.out.print(" ");
                    Generator.this.out.print(attrs.getQName(i));
                    Generator.this.out.print("=");
                    Generator.this.out.print(quote);
                    Generator.this.out.print(value);
                    Generator.this.out.print(quote);
                    ++i;
                }
            }
            if (n.getBody() != null) {
                Generator.this.out.println(">\");");
                this.visitBody(n);
                Generator.this.out.printin("out.write(\"</");
                Generator.this.out.print(n.getName());
                Generator.this.out.println(">\");");
            } else {
                Generator.this.out.println("/>\");");
            }
        }

        public void visit(Node.UseBean n) throws JasperException {
            String name = n.getAttributeValue("id");
            String scope = n.getAttributeValue("scope");
            String klass = n.getAttributeValue("class");
            String type = n.getAttributeValue("type");
            Node.JspAttribute beanName = n.getBeanName();
            if (type == null) {
                type = klass;
            }
            String scopename = "PageContext.PAGE_SCOPE";
            String lock = "pageContext";
            if ("request".equals(scope)) {
                scopename = "PageContext.REQUEST_SCOPE";
                lock = "request";
            } else if ("session".equals(scope)) {
                scopename = "PageContext.SESSION_SCOPE";
                lock = "session";
            } else if ("application".equals(scope)) {
                scopename = "PageContext.APPLICATION_SCOPE";
                lock = "application";
            }
            n.setBeginJavaLine(Generator.this.out.getJavaLine());
            Generator.this.out.printin(type);
            Generator.this.out.print(' ');
            Generator.this.out.print(name);
            Generator.this.out.println(" = null;");
            Generator.this.out.printin("synchronized (");
            Generator.this.out.print(lock);
            Generator.this.out.println(") {");
            Generator.this.out.pushIndent();
            Generator.this.out.printin(name);
            Generator.this.out.print(" = (");
            Generator.this.out.print(type);
            Generator.this.out.print(") pageContext.getAttribute(");
            Generator.this.out.print(Generator.quote(name));
            Generator.this.out.print(", ");
            Generator.this.out.print(scopename);
            Generator.this.out.println(");");
            Generator.this.out.printin("if (");
            Generator.this.out.print(name);
            Generator.this.out.println(" == null){");
            Generator.this.out.pushIndent();
            if (klass == null && beanName == null) {
                Generator.this.out.printin("throw new java.lang.InstantiationException(\"bean ");
                Generator.this.out.print(name);
                Generator.this.out.println(" not found within scope\");");
            } else {
                String className = beanName != null ? this.attributeValue(beanName, false) : Generator.quote(klass);
                Generator.this.out.printil("try {");
                Generator.this.out.pushIndent();
                Generator.this.out.printin(name);
                Generator.this.out.print(" = (");
                Generator.this.out.print(type);
                Generator.this.out.print(") java.beans.Beans.instantiate(");
                Generator.this.out.print("this.getClass().getClassLoader(), ");
                Generator.this.out.print(className);
                Generator.this.out.println(");");
                Generator.this.out.popIndent();
                Generator.this.out.printil("} catch (ClassNotFoundException exc) {");
                Generator.this.out.pushIndent();
                Generator.this.out.printil("throw new InstantiationException(exc.getMessage());");
                Generator.this.out.popIndent();
                Generator.this.out.printil("} catch (Exception exc) {");
                Generator.this.out.pushIndent();
                Generator.this.out.printin("throw new ServletException(");
                Generator.this.out.print("\"Cannot create bean of class \" + ");
                Generator.this.out.print(className);
                Generator.this.out.println(", exc);");
                Generator.this.out.popIndent();
                Generator.this.out.printil("}");
                Generator.this.out.printin("pageContext.setAttribute(");
                Generator.this.out.print(Generator.quote(name));
                Generator.this.out.print(", ");
                Generator.this.out.print(name);
                Generator.this.out.print(", ");
                Generator.this.out.print(scopename);
                Generator.this.out.println(");");
                this.visitBody(n);
            }
            Generator.this.out.popIndent();
            Generator.this.out.printil("}");
            Generator.this.out.popIndent();
            Generator.this.out.printil("}");
            n.setEndJavaLine(Generator.this.out.getJavaLine());
        }
    }

    private static class TagHandlerInfo {
        private Hashtable methodMaps;
        private Hashtable propertyEditorMaps;
        private Class tagHandlerClass = null;

        TagHandlerInfo(Node n, String tagClassName, ClassLoader loader, ErrorDispatcher err) throws JasperException {
            try {
                this.tagHandlerClass = loader.loadClass(tagClassName);
            }
            catch (Exception e) {
                err.jspError(n, "jsp.error.unable.loadclass", tagClassName, e);
            }
            this.methodMaps = new Hashtable();
            this.propertyEditorMaps = new Hashtable();
            try {
                BeanInfo tagClassInfo = Introspector.getBeanInfo(this.tagHandlerClass);
                PropertyDescriptor[] pd = tagClassInfo.getPropertyDescriptors();
                int i = 0;
                while (i < pd.length) {
                    if (pd[i].getWriteMethod() != null) {
                        this.methodMaps.put(pd[i].getName(), pd[i].getWriteMethod());
                    }
                    if (pd[i].getPropertyEditorClass() != null) {
                        this.propertyEditorMaps.put(pd[i].getName(), pd[i].getPropertyEditorClass());
                    }
                    ++i;
                }
            }
            catch (IntrospectionException ie) {
                err.jspError(n, "jsp.error.introspect.taghandler", tagClassName, ie);
            }
        }

        public Class getPropertyEditorClass(String attrName) {
            return (Class)this.propertyEditorMaps.get(attrName);
        }

        public Method getSetterMethod(String attrName) {
            return (Method)this.methodMaps.get(attrName);
        }

        public Class getTagHandlerClass() {
            return this.tagHandlerClass;
        }
    }

    private static class FinallyApplyer {
        private PrintStream finalOutput;
        private ByteArrayOutputStream rawOutput = new ByteArrayOutputStream();

        FinallyApplyer() {
            this.finalOutput = new PrintStream(this.rawOutput, true);
            this.finalOutput.println();
            this.finalOutput.println("  private void finallies(java.util.BitSet bitmask, JspWriter out, java.util.Vector tags, PageContext pageContext)");
            this.finalOutput.println("  throws javax.servlet.jsp.JspException {");
        }

        public void beginPartMethod(int bit) {
            this.finalOutput.print("    if (bitmask.get(");
            this.finalOutput.print(bit);
            this.finalOutput.println(")) {");
        }

        public void done() {
            this.finalOutput.println("  }");
        }

        public void endPartMethod() {
            this.finalOutput.println("    }");
            this.finalOutput.println();
        }

        public void print(String partLine) {
            this.finalOutput.print(partLine);
        }

        public void printin(String partLine) {
            this.finalOutput.print("      ");
            this.finalOutput.print(partLine);
        }

        public void println(String aLine) {
            if (aLine != null) {
                this.finalOutput.print(aLine);
            }
            this.finalOutput.println();
        }

        public String toString() {
            return this.rawOutput.toString();
        }
    }
}

