/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspCompiler
extends Compiler
implements Mangler {
    private String javaFileName;
    private String classFileName;
    private String realClassName;
    private String jsp;
    private String outputDir;
    private JspServletWrapper jsw;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspCompiler");

    public JspCompiler(JspCompilationContext ctxt, JspServletWrapper jsw) throws JasperException {
        super(ctxt);
        this.jsp = ctxt.getJspFile();
        this.jsw = jsw;
        this.outputDir = ctxt.getOutputDir();
        this.setMangler(this);
    }

    private final String getBaseClassName() {
        int iSep = this.jsp.lastIndexOf(47) + 1;
        int iEnd = this.jsp.length();
        StringBuffer modifiedClassName = new StringBuffer(this.jsp.length() - iSep);
        if (!Character.isJavaIdentifierStart(this.jsp.charAt(iSep))) {
            modifiedClassName.append('$');
        }
        int i = iSep;
        while (i < iEnd) {
            char ch = this.jsp.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                modifiedClassName.append(ch);
            } else if (ch == '.') {
                modifiedClassName.append('$');
            } else {
                modifiedClassName.append(JspCompiler.mangleChar(ch));
            }
            ++i;
        }
        return modifiedClassName.toString();
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        this.classFileName = String.valueOf(this.getClassName()) + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public final String getClassName() {
        if (this.realClassName == null) {
            this.realClassName = this.getBaseClassName();
            this.ctxt.setServletClassName(this.realClassName);
        }
        return this.realClassName;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        this.javaFileName = String.valueOf(this.getClassName()) + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + this.javaFileName;
        }
        return this.javaFileName;
    }

    public boolean isOutDated() {
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(this.jsp);
            if (jspUrl == null) {
                ((JspEngineContext)this.ctxt).incrementRemoved();
                return false;
            }
            jspRealLastModified = jspUrl.openConnection().getLastModified();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        File classFile = new File(this.getClassFileName());
        if (!classFile.exists()) {
            return true;
        }
        long classLastModified = classFile.lastModified();
        if (classLastModified < jspRealLastModified) {
            return true;
        }
        HttpJspBase servlet = this.jsw.getServlet();
        if (servlet == null) {
            return false;
        }
        List includes = servlet.getIncludes();
        if (includes == null) {
            return false;
        }
        Iterator it = includes.iterator();
        while (it.hasNext()) {
            String include = (String)it.next();
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                if (includeUrl.openConnection().getLastModified() <= classLastModified) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    private static final String mangleChar(char ch) {
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }
}

