/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagData;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.xml.sax.Attributes;

public abstract class Node {
    private Attributes attrs;
    private Nodes body;
    private char[] text;
    private Mark startMark;
    private int beginJavaLine;
    private int endJavaLine;
    protected Node parent;

    public Node(Mark start, Node parent) {
        this.startMark = start;
        this.addToParent(parent);
    }

    public Node(Attributes attrs, Mark start, Node parent) {
        this.attrs = attrs;
        this.startMark = start;
        this.addToParent(parent);
    }

    public Node(char[] text, Mark start, Node parent) {
        this.text = text;
        this.startMark = start;
        this.addToParent(parent);
    }

    abstract void accept(Visitor var1) throws JasperException;

    private void addToParent(Node parent) {
        if (parent != null) {
            this.parent = parent;
            Nodes parentBody = parent.getBody();
            if (parentBody == null) {
                parentBody = new Nodes();
                parent.setBody(parentBody);
            }
            parentBody.add(this);
        }
    }

    public String getAttributeValue(String name) {
        return this.attrs == null ? null : this.attrs.getValue(name);
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public int getBeginJavaLine() {
        return this.beginJavaLine;
    }

    public Nodes getBody() {
        return this.body;
    }

    public int getEndJavaLine() {
        return this.endJavaLine;
    }

    public Node getParent() {
        return this.parent;
    }

    public Mark getStart() {
        return this.startMark;
    }

    public char[] getText() {
        return this.text;
    }

    public boolean isXmlSyntax() {
        Node r = this;
        while (!(r instanceof Root)) {
            if ((r = r.getParent()) != null) continue;
            return false;
        }
        return r.isXmlSyntax();
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public void setBeginJavaLine(int begin) {
        this.beginJavaLine = begin;
    }

    public void setBody(Nodes body) {
        this.body = body;
    }

    public void setEndJavaLine(int end) {
        this.endJavaLine = end;
    }

    public static class Root
    extends Node {
        private Root parentRoot;

        Root(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
            Node r = parent;
            while (r != null && !(r instanceof Root)) {
                r = r.getParent();
            }
            this.parentRoot = (Root)r;
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public Root getParentRoot() {
            return this.parentRoot;
        }

        public boolean isXmlSyntax() {
            return false;
        }
    }

    public static class JspRoot
    extends Root {
        public JspRoot(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public boolean isXmlSyntax() {
            return true;
        }
    }

    public static class PageDirective
    extends Node {
        private Vector imports = new Vector();

        public PageDirective(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public void addImport(String value) {
            int index;
            int start = 0;
            while ((index = value.indexOf(44, start)) != -1) {
                this.imports.add(value.substring(start, index).trim());
                start = index + 1;
            }
            if (start == 0) {
                this.imports.add(value.trim());
            } else {
                this.imports.add(value.substring(start).trim());
            }
        }

        public List getImports() {
            return this.imports;
        }
    }

    public static class IncludeDirective
    extends Node {
        public IncludeDirective(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class TaglibDirective
    extends Node {
        public TaglibDirective(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class Comment
    extends Node {
        public Comment(char[] text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static abstract class ScriptingElement
    extends Node {
        public ScriptingElement(Mark start, Node parent) {
            super(start, parent);
        }

        public ScriptingElement(char[] text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public char[] getText() {
            char[] ret = ((Node)this).text;
            if (ret == null && ((Node)this).body != null) {
                CharArrayWriter chars = new CharArrayWriter();
                int size = ((Node)this).body.size();
                int i = 0;
                while (i < size) {
                    chars.write(((Node)this).body.getNode(i).getText(), 0, ((Node)this).body.getNode(i).getText().length);
                    ++i;
                }
                ret = chars.toCharArray();
            }
            return ret;
        }
    }

    public static class Declaration
    extends ScriptingElement {
        public Declaration(Mark start, Node parent) {
            super(start, parent);
        }

        public Declaration(char[] text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class Expression
    extends ScriptingElement {
        public Expression(Mark start, Node parent) {
            super(start, parent);
        }

        public Expression(char[] text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class Scriptlet
    extends ScriptingElement {
        public Scriptlet(Mark start, Node parent) {
            super(start, parent);
        }

        public Scriptlet(char[] text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class ParamAction
    extends Node {
        JspAttribute value;

        public ParamAction(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public JspAttribute getValue() {
            return this.value;
        }

        public void setValue(JspAttribute value) {
            this.value = value;
        }
    }

    public static class ParamsAction
    extends Node {
        public ParamsAction(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class FallBackAction
    extends Node {
        public FallBackAction(Mark start, char[] text, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class IncludeAction
    extends Node {
        private JspAttribute page;

        public IncludeAction(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public JspAttribute getPage() {
            return this.page;
        }

        public void setPage(JspAttribute page) {
            this.page = page;
        }
    }

    public static class ForwardAction
    extends Node {
        private JspAttribute page;

        public ForwardAction(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public JspAttribute getPage() {
            return this.page;
        }

        public void setPage(JspAttribute page) {
            this.page = page;
        }
    }

    public static class GetProperty
    extends Node {
        public GetProperty(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class SetProperty
    extends Node {
        private JspAttribute value;

        public SetProperty(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public JspAttribute getValue() {
            return this.value;
        }

        public void setValue(JspAttribute value) {
            this.value = value;
        }
    }

    public static class UseBean
    extends Node {
        JspAttribute beanName;

        public UseBean(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public JspAttribute getBeanName() {
            return this.beanName;
        }

        public void setBeanName(JspAttribute beanName) {
            this.beanName = beanName;
        }
    }

    public static class PlugIn
    extends Node {
        public PlugIn(Attributes attrs, Mark start, Node parent) {
            super(attrs, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class UninterpretedTag
    extends Node {
        private String tagName;

        public UninterpretedTag(Attributes attrs, Mark start, String name, Node parent) {
            super(attrs, start, parent);
            this.tagName = name;
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public String getName() {
            return this.tagName;
        }
    }

    public static class CustomTag
    extends Node {
        private String name;
        private String prefix;
        private String shortName;
        private JspAttribute[] jspAttrs;
        private TagData tagData;

        public CustomTag(Attributes attrs, Mark start, String name, String prefix, String shortName, Node parent) {
            super(attrs, start, parent);
            this.name = name;
            this.prefix = prefix;
            this.shortName = shortName;
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getShortName() {
            return this.shortName;
        }

        public TagData getTagData() {
            return this.tagData;
        }

        public void setJspAttributes(JspAttribute[] jspAttrs) {
            this.jspAttrs = jspAttrs;
        }

        public void setTagData(TagData tagData) {
            this.tagData = tagData;
        }
    }

    public static class JspText
    extends Node {
        public JspText(Mark start, Node parent) {
            super(start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class TemplateText
    extends Node {
        public TemplateText(char[] text, Mark start, Node parent) {
            super(text, start, parent);
        }

        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }
    }

    public static class JspAttribute {
        private String name;
        private String value;
        private boolean expression;

        JspAttribute(String name, String value, boolean expr) {
            this.name = name;
            this.value = value;
            this.expression = expr;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isExpression() {
            return this.expression;
        }
    }

    public static class Nodes {
        private List list;
        private Root root;

        public Nodes() {
            this.list = new Vector();
        }

        public Nodes(Root root) {
            this.root = root;
            this.list = new Vector();
            this.list.add(root);
        }

        public void add(Node n) {
            this.list.add(n);
        }

        public Node getNode(int index) {
            Node n = null;
            try {
                n = (Node)this.list.get(index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            return n;
        }

        public Root getRoot() {
            return this.root;
        }

        public int size() {
            return this.list.size();
        }

        public void visit(Visitor v) throws JasperException {
            Iterator iter = this.list.iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                n.accept(v);
            }
        }
    }

    public static class Visitor {
        protected void doVisit(Node n) throws JasperException {
        }

        public void visit(Comment n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(CustomTag n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(Declaration n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(Expression n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(FallBackAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(ForwardAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(GetProperty n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(IncludeAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(IncludeDirective n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspRoot n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspText n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(PageDirective n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(ParamAction n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(ParamsAction n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(PlugIn n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(Root n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(Scriptlet n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(SetProperty n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(TaglibDirective n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(TemplateText n) throws JasperException {
            this.doVisit(n);
        }

        public void visit(UninterpretedTag n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(UseBean n) throws JasperException {
            this.doVisit(n);
            this.visitBody(n);
        }

        protected void visitBody(Node n) throws JasperException {
            if (n.getBody() != null) {
                n.getBody().visit(this);
            }
        }
    }
}

