/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.runtime.HttpJspBase;

public class JspServletWrapper {
    private Servlet theServlet;
    private String jspUri;
    private Class servletClass;
    private JspEngineContext ctxt;
    private long available = 0L;
    private ServletConfig config;
    private Options options;

    JspServletWrapper(ServletConfig config, Options options, String jspUri, boolean isErrorPage, JspRuntimeContext rctxt) throws JasperException {
        this.config = config;
        this.options = options;
        this.jspUri = jspUri;
        this.ctxt = new JspEngineContext(rctxt, config.getServletContext(), jspUri, this, isErrorPage, options);
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
        }
    }

    public JspEngineContext getJspEngineContext() {
        return this.ctxt;
    }

    public HttpJspBase getServlet() {
        return (HttpJspBase)this.theServlet;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
        block26: {
            try {
                JspServletWrapper jspServletWrapper;
                if (this.ctxt.isRemoved()) {
                    throw new FileNotFoundException(this.jspUri);
                }
                if (this.available > 0L && this.available < Long.MAX_VALUE) {
                    response.setDateHeader("Retry-After", this.available);
                    response.sendError(503, Constants.getString((String)"jsp.error.unavailable"));
                }
                if (this.options.getDevelopment()) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        this.ctxt.compile();
                    }
                }
                if (this.ctxt.isReload()) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.ctxt.isReload()) {
                            this.servletClass = this.ctxt.load();
                            this.destroy();
                            this.theServlet = (Servlet)this.servletClass.newInstance();
                            this.theServlet.init(this.config);
                        }
                    }
                }
                if (precompile) {
                    return;
                }
                if (this.theServlet instanceof SingleThreadModel) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                        break block26;
                    }
                }
                this.theServlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (UnavailableException ex) {
                String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (includeRequestUri != null) {
                    throw ex;
                }
                int unavailableSeconds = ex.getUnavailableSeconds();
                if (unavailableSeconds <= 0) {
                    unavailableSeconds = 60;
                }
                this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
                response.sendError(503, ex.getMessage());
            }
            catch (FileNotFoundException ex) {
                String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (includeRequestUri != null) {
                    throw new ServletException((Throwable)ex);
                }
                try {
                    response.sendError(404, ex.getMessage());
                }
                catch (IllegalStateException illegalStateException) {
                    Constants.jasperLog.log(Constants.getString((String)"jsp.error.file.not.found", (Object[])new Object[]{ex.getMessage()}), (Throwable)ex, 1);
                }
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JasperException((Throwable)ex);
            }
        }
    }
}

