/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public abstract class LogFactory {
    protected static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    protected static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    protected static Hashtable factories;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;
    static /* synthetic */ Class class$java$lang$Thread;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public static LogFactory getFactory() throws LogConfigurationException {
        LogFactory factory;
        ClassLoader contextClassLoader;
        block19: {
            contextClassLoader = LogFactory.getContextClassLoader();
            factory = LogFactory.getCachedFactory(contextClassLoader);
            if (factory != null) {
                return factory;
            }
            try {
                String factoryClass = System.getProperty(FACTORY_PROPERTY);
                if (factoryClass != null) {
                    factory = LogFactory.newFactory(factoryClass, contextClassLoader);
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (factory == null) {
                try {
                    BufferedReader rd;
                    InputStream is;
                    InputStream inputStream = is = contextClassLoader == null ? ClassLoader.getSystemResourceAsStream(SERVICE_ID) : contextClassLoader.getResourceAsStream(SERVICE_ID);
                    if (is == null) break block19;
                    try {
                        rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        rd = new BufferedReader(new InputStreamReader(is));
                    }
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        factory = LogFactory.newFactory(factoryClassName, contextClassLoader);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        Properties props = null;
        try {
            InputStream stream = contextClassLoader.getResourceAsStream(FACTORY_PROPERTIES);
            if (stream != null) {
                props = new Properties();
                props.load(stream);
                stream.close();
                String factoryClass = props.getProperty(FACTORY_PROPERTY);
                if (factory == null) {
                    if (factoryClass == null) {
                        factoryClass = FACTORY_DEFAULT;
                    }
                    factory = LogFactory.newFactory(factoryClass, contextClassLoader);
                }
            }
        }
        catch (IOException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (factory == null) {
            factory = LogFactory.newFactory(FACTORY_DEFAULT, (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader());
        }
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                factory.setAttribute(name, value);
            }
        }
        return factory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration elements = factories.elements();
            while (elements.hasMoreElements()) {
                LogFactory element = (LogFactory)elements.nextElement();
                element.release();
            }
            factories.clear();
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = LogFactory.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException e) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", e.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException e) {
            classLoader = (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader();
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(ClassLoader contextClassLoader) {
        LogFactory factory = null;
        if (contextClassLoader != null) {
            factory = (LogFactory)factories.get(contextClassLoader);
        }
        if (factory == null) {
            factory = (LogFactory)factories.get((class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader());
        }
        return factory;
    }

    private static void cacheFactory(ClassLoader classLoader, LogFactory factory) {
        if (classLoader != null && factory != null) {
            factories.put(classLoader, factory);
        }
    }

    protected static LogFactory newFactory(String factoryClass, ClassLoader classLoader) throws LogConfigurationException {
        try {
            Class<?> clazz;
            block5: {
                if (classLoader == null) {
                    classLoader = (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader();
                }
                clazz = null;
                try {
                    clazz = classLoader.loadClass(factoryClass);
                }
                catch (ClassNotFoundException ex) {
                    if (classLoader == (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader()) break block5;
                    classLoader = (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader();
                    clazz = classLoader.loadClass(factoryClass);
                }
            }
            LogFactory factory = (LogFactory)clazz.newInstance();
            LogFactory.cacheFactory(classLoader, factory);
            return factory;
        }
        catch (Exception e) {
            throw new LogConfigurationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FACTORY_DEFAULT = FACTORY_DEFAULT;
        FACTORY_PROPERTIES = FACTORY_PROPERTIES;
        SERVICE_ID = SERVICE_ID;
        FACTORY_PROPERTY = FACTORY_PROPERTY;
        factories = new Hashtable();
    }
}

