/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.httpd;

import com.mwc.httpd.SessionData;
import com.mwc.util.ReadWriteLock;
import com.mwc.util.TemplateWebPage;
import com.mwc.util.ThreadPool;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.internal.ssl.Provider;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.Principal;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import sun.misc.BASE64Decoder;

public class httpd
implements Runnable {
    public static final String VERSION = "Servlet Factory V0.0.1b";
    private boolean _debugMode;
    private boolean _debugMode2;
    private TemplateWebPage _errorPage;
    private String _propFileName;
    private Properties _props;
    private ServerSocket _svr;
    private String _docRoot;
    private int _timeout;
    private int _maxHeaders;
    private Hashtable _servletTable;
    private Hashtable _servletLastMod;
    private FileServlet _fileServlet;
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z");
    private SimpleDateFormat _cookieDateFormat = new SimpleDateFormat("E, dd-MMM-yyyy HH:mm:ss z");
    private LinkedList _filterList = new LinkedList();
    private LinkedList _patternList = new LinkedList();
    private LogFile _servletLogFile;
    private AccepterThread[] _accepterThreadArray;
    private ThreadPool _threadPool;
    private Hashtable _sessionTbl = new Hashtable();
    private Hashtable _sessionReadWriteLockTbl = new Hashtable();
    private boolean _sessionManagement;
    private String _sessionSaveDir;
    private ServletBinding[] _servletBindingArray;
    private static httpd _server = null;
    private static boolean _stopFlag = false;
    private static Object _stopFlagMutex = new Object();

    private void _debug(String msg) {
        if (this._debugMode) {
            System.out.println("[" + Thread.currentThread().getName() + "]" + msg);
        }
    }

    private void _debug2(String msg) {
        if (this._debugMode2) {
            System.out.println("[" + Thread.currentThread().getName() + "]" + msg);
        }
    }

    private static boolean _isRunning() {
        Object object = _stopFlagMutex;
        synchronized (object) {
            boolean bl = !_stopFlag;
            return bl;
        }
    }

    private static void _stop() {
        Object object = _stopFlagMutex;
        synchronized (object) {
            _stopFlag = true;
            try {
                httpd._server._svr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        httpd._server._threadPool.stop();
    }

    public httpd(String propFileName) throws Exception {
        Security.addProvider((java.security.Provider)new Provider());
        this._dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this._cookieDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this._servletLastMod = new Hashtable();
        this._propFileName = propFileName;
        FileInputStream fin = new FileInputStream(propFileName);
        this._props = new Properties();
        this._props.load(fin);
        fin.close();
        this._maxHeaders = Integer.parseInt(this._props.getProperty("server.max.headers"));
        this._timeout = Integer.parseInt(this._props.getProperty("server.timeout"));
        this._docRoot = this._props.getProperty("server.document.root");
        this._debugMode = Boolean.valueOf(this._props.getProperty("server.debug.mode"));
        this._debugMode2 = Boolean.valueOf(this._props.getProperty("server.debug2.mode"));
        this._sessionManagement = this._props.getProperty("server.session.management").compareTo("file") == 0;
        this._sessionSaveDir = this._props.getProperty("server.session.save.dir");
        this._servletBindingArray = new ServletBinding[Integer.parseInt(this._props.getProperty("servlet.n"))];
        int i = 1;
        while (i <= this._servletBindingArray.length) {
            this._servletBindingArray[i - 1] = new ServletBinding(this._props.getProperty("servlet." + i + ".pattern"), this._props.getProperty("servlet." + i + ".class"));
            ++i;
        }
        ServerSocketFactory ssf = this._getServerSocketFactory(this._props.getProperty("server.type"));
        String addr = this._props.getProperty("server.ifAddress");
        this._svr = addr.compareTo("ANY") == 0 ? ssf.createServerSocket(Integer.parseInt(this._props.getProperty("server.port")), Integer.parseInt(this._props.getProperty("server.backlog"))) : ssf.createServerSocket(Integer.parseInt(this._props.getProperty("server.port")), Integer.parseInt(this._props.getProperty("server.backlog")), InetAddress.getByName(addr));
        this._errorPage = new TemplateWebPage();
        this._errorPage.loadTemplate(this._props.getProperty("server.error.page"));
        this._servletTable = new Hashtable();
        this._servletLogFile = new LogFile(this._props.getProperty("server.servlet.log.file"));
        this._fileServlet = new FileServlet();
        this._fileServlet.init(new ConfigImpl(new ContextImpl(((Object)((Object)this._fileServlet)).getClass().getName(), null)));
        this._loadFilters();
    }

    private void _loadFilters() throws Exception {
        int n = Integer.parseInt(this._props.getProperty("filter.n"));
        int i = 1;
        while (i <= n) {
            String name = this._props.getProperty("filter." + i + ".name");
            String pattern = this._props.getProperty("filter." + i + ".pattern");
            String className = this._props.getProperty("filter." + i + ".className");
            Class<?> c = Class.forName(className);
            Filter f = (Filter)c.newInstance();
            f.init((FilterConfig)new FilterConfigImpl(name, pattern, className));
            this._patternList.add(new RE((Object)pattern));
            this._filterList.add(f);
            ++i;
        }
    }

    private ServerSocketFactory _getServerSocketFactory(String type) throws Exception {
        if (type.compareTo("TLS") == 0) {
            SSLServerSocketFactory ssf = null;
            char[] passphrase = this._props.getProperty("server.keyfile.passphrase").toCharArray();
            SSLContext ctx = SSLContext.getInstance((String)"TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)"SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(this._props.getProperty("server.keyfile")), passphrase);
            kmf.init(ks, this._props.getProperty("server.key.passphrase").toCharArray());
            ctx.init(kmf.getKeyManagers(), null, null);
            ssf = ctx.getServerSocketFactory();
            return ssf;
        }
        return ServerSocketFactory.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    private LinkedList _readHeaderList(Socket client, BufferedReader br) throws Exception {
        String line;
        LinkedList<void> l = new LinkedList<void>();
        while ((line = br.readLine()) != null && l.size() < this._maxHeaders) {
            void var3_4;
            this._debug("READ: " + (String)var3_4);
            if (var3_4.compareTo("") == 0) break;
            l.add(var3_4);
        }
        return l;
    }

    private String _headerValue(LinkedList headerList, String headerName) {
        Iterator it = headerList.iterator();
        String ret = null;
        while (it.hasNext()) {
            String name;
            String header = it.next().toString();
            int i = header.indexOf(58);
            if (i < 0 || !(name = header.substring(0, i)).equalsIgnoreCase(headerName)) continue;
            ++i;
            while (i < header.length() && Character.isWhitespace(header.charAt(i))) {
                ++i;
            }
            if (i < header.length()) {
                ret = header.substring(i);
                break;
            }
            ret = "";
            break;
        }
        return ret;
    }

    private String _getPath(String method) {
        int index = 0;
        while (index < method.length() && !Character.isWhitespace(method.charAt(index))) {
            ++index;
        }
        while (index < method.length() && Character.isWhitespace(method.charAt(index))) {
            ++index;
        }
        int index2 = index;
        while (index2 < method.length() && !Character.isWhitespace(method.charAt(index2))) {
            ++index2;
        }
        return method.substring(index, index2);
    }

    private String _translatePath(String path) {
        if (path.indexOf("..") >= 0) {
            return null;
        }
        String f = this._docRoot + path;
        File ff = new File(f);
        if (ff.isDirectory()) {
            if (f.charAt(f.length() - 1) != '/') {
                f = f + "/";
            }
            f = f + this._props.getProperty("server.default.document");
            ff = new File(f);
        }
        if (ff.exists()) {
            return f;
        }
        return null;
    }

    private Servlet _findServlet(String path) throws Exception {
        if (path.indexOf("/servlet/") == 0) {
            String servletName = path.substring("/servlet/".length());
            Hashtable hashtable = this._servletTable;
            synchronized (hashtable) {
                Long llm;
                Servlet servlet = (Servlet)this._servletTable.get(servletName);
                if (servlet == null) {
                    servlet = (Servlet)Class.forName(servletName, false, new ServletClassLoader()).newInstance();
                    servlet.init((ServletConfig)new ConfigImpl(new ContextImpl(servletName, this._props.getProperty(servletName + ".initParameters"))));
                    this._servletTable.put(servletName, servlet);
                    HttpServlet hs = (HttpServlet)servlet;
                    ClassLoader cl = hs.getClass().getClassLoader();
                    URL classURL = cl.getResource(servletName.replace('.', '/') + ".class");
                    long lm = new File(classURL.getFile()).lastModified();
                    this._servletLastMod.put(servletName, new Long(lm));
                    Servlet servlet2 = servlet;
                    return servlet2;
                }
                HttpServlet hs = (HttpServlet)servlet;
                ServletClassLoader cl = new ServletClassLoader();
                URL classURL = cl.getResource(servletName.replace('.', '/') + ".class");
                long lm = new File(classURL.getFile()).lastModified();
                if (lm > (llm = (Long)this._servletLastMod.get(servletName))) {
                    this._debug2("RELOAD " + servletName + " SERVLET CLASS FILE");
                    hs.destroy();
                    servlet = (Servlet)cl.findClass(servletName).newInstance();
                    servlet.init((ServletConfig)new ConfigImpl(new ContextImpl(servletName, this._props.getProperty(servletName + ".initParameters"))));
                    this._servletTable.put(servletName, servlet);
                    this._servletLastMod.put(servletName, new Long(lm));
                }
                Servlet servlet3 = servlet;
                return servlet3;
            }
        }
        int i = 0;
        while (i < this._servletBindingArray.length) {
            if (this._servletBindingArray[i]._isMatch(path)) {
                return this._findServlet("/servlet/" + this._servletBindingArray[i]._className);
            }
            ++i;
        }
        return this._fileServlet;
    }

    private LinkedList _getFilterList(String path) {
        LinkedList<Filter> filterList = new LinkedList<Filter>();
        Iterator it = this._filterList.iterator();
        Iterator it2 = this._patternList.iterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            RE p = (RE)it2.next();
            REMatch m = p.getMatch((Object)path);
            if (m == null || m.getStartIndex() != 0 || m.getEndIndex() != path.length()) continue;
            filterList.add(f);
        }
        return filterList;
    }

    private void _handleClient(Socket client) throws Exception {
        block17: {
            client.setSoTimeout(this._timeout);
            client.setSoLinger(false, 0);
            InputStream in = client.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            LinkedList headerList = this._readHeaderList(client, br);
            if (headerList.size() > 0) {
                String method = headerList.get(0).toString();
                String path = this._getPath(method);
                int i = path.indexOf(63);
                String queryString = null;
                if (i >= 0) {
                    if (i + 1 < path.length()) {
                        queryString = path.substring(i + 1);
                    }
                    path = path.substring(0, i);
                }
                LinkedList filterList = this._getFilterList(path);
                RequestImpl request = new RequestImpl(client, headerList, method, path, queryString, br);
                ResponseImpl response = new ResponseImpl(client, request);
                if (filterList.size() != 0) {
                    FilterChainImpl chain = new FilterChainImpl(filterList, path);
                    try {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        HttpSessionImpl session = (HttpSessionImpl)request.getSession();
                        if (session == null) break block17;
                        HttpSessionImpl httpSessionImpl = session;
                        synchronized (httpSessionImpl) {
                            session._lastAccessedDate = new Date();
                            break block17;
                        }
                    }
                    catch (Throwable filterError) {
                        filterError.printStackTrace();
                        this._servletLogFile.log("httpd", "Filter exception", filterError);
                        if (!response._isCommitted) {
                            response.sendError(500, path + ": Filter exception.  Check log file.");
                        }
                        break block17;
                    }
                }
                Servlet servlet = this._findServlet(path);
                if (servlet != null) {
                    try {
                        servlet.service((ServletRequest)request, (ServletResponse)response);
                        response.flushBuffer();
                        HttpSessionImpl session = (HttpSessionImpl)request.getSession();
                        if (session == null) break block17;
                        HttpSessionImpl httpSessionImpl = session;
                        synchronized (httpSessionImpl) {
                            session._lastAccessedDate = new Date();
                            break block17;
                        }
                    }
                    catch (Throwable servletError) {
                        servletError.printStackTrace();
                        this._servletLogFile.log("httpd", "Servlet exception", servletError);
                        if (!response._isCommitted) {
                            response.sendError(500, path + ": Servlet exception.  Check log file.");
                        }
                        break block17;
                    }
                }
                response.sendError(500, path + ": No such servlet");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this._debug2("httpd.run()");
        this._threadPool = new ThreadPool(Integer.parseInt(this._props.getProperty("server.min.handler.thread.pool.size")), Integer.parseInt(this._props.getProperty("server.max.handler.thread.pool.size")), new Long(this._props.getProperty("server.handler.thread.timeout")), Integer.parseInt(this._props.getProperty("server.connection.queue.max.size")));
        this._accepterThreadArray = new AccepterThread[Integer.parseInt(this._props.getProperty("server.accept.thread.pool.size"))];
        int i = 0;
        while (true) {
            AccepterThread at;
            if (i >= this._accepterThreadArray.length) break;
            this._accepterThreadArray[i] = at = new AccepterThread();
            at.start();
            ++i;
        }
        int sleepN = Integer.parseInt(this._props.getProperty("server.run.clean.thread.every"));
        boolean printStats = Boolean.valueOf(this._props.getProperty("server.print.thread.pool.stats"));
        while (httpd._isRunning()) {
            long dif;
            try {
                Thread.sleep(sleepN * 1000);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (this._sessionManagement) {
                File dir = new File(this._sessionSaveDir);
                String[] sessionFileArray = dir.list();
                int i2 = 0;
                while (i2 < sessionFileArray.length) {
                    block28: {
                        String id;
                        int index;
                        File f = new File(this._sessionSaveDir + "/" + sessionFileArray[i2]);
                        if (!f.isDirectory() && (index = (id = sessionFileArray[i2]).indexOf(46)) >= 0) {
                            ReadWriteLock rwLock;
                            id = id.substring(0, index);
                            this._debug2("CHECKING VALIDITY OF SESSION ID=" + id);
                            Hashtable hashtable = this._sessionReadWriteLockTbl;
                            synchronized (hashtable) {
                                rwLock = (ReadWriteLock)this._sessionReadWriteLockTbl.get(id);
                                if (rwLock == null) {
                                    rwLock = new ReadWriteLock();
                                    this._sessionReadWriteLockTbl.put(id, rwLock);
                                }
                            }
                            try {
                                Object var23_21;
                                Object var20_20;
                                SessionData sd;
                                rwLock.readLock();
                                try {
                                    FileInputStream fin = new FileInputStream(f);
                                    BufferedInputStream bin = new BufferedInputStream(fin);
                                    ObjectInputStream oin = new ObjectInputStream(bin);
                                    sd = (SessionData)oin.readObject();
                                    fin.close();
                                    var20_20 = null;
                                    rwLock.readUnlock();
                                }
                                catch (Throwable throwable) {
                                    var20_20 = null;
                                    rwLock.readUnlock();
                                    throw throwable;
                                }
                                dif = new Date().getTime() - sd.lastAccessedDate.getTime();
                                if ((dif /= 1000L) < (long)sd.maxInactiveInterval) break block28;
                                this._debug2("Invalidation of session id=" + sd.id);
                                rwLock.writeLock();
                                try {
                                    f.delete();
                                    Hashtable hashtable2 = this._sessionReadWriteLockTbl;
                                    synchronized (hashtable2) {
                                        this._sessionReadWriteLockTbl.remove(id);
                                    }
                                    var23_21 = null;
                                    rwLock.writeUnlock();
                                }
                                catch (Throwable throwable) {
                                    var23_21 = null;
                                    rwLock.writeUnlock();
                                    throw throwable;
                                }
                            }
                            catch (Throwable th) {
                                this._servletLogFile.log(null, "Unable to read session file (" + this._sessionSaveDir + "/" + sessionFileArray[i2] + ")!", th);
                            }
                        }
                    }
                    ++i2;
                }
            } else {
                Hashtable hashtable = this._sessionTbl;
                synchronized (hashtable) {
                    block19: while (true) {
                        Enumeration vals = this._sessionTbl.elements();
                        while (true) {
                            HttpSessionImpl session;
                            if (!vals.hasMoreElements()) {
                                break block19;
                            }
                            HttpSessionImpl httpSessionImpl = session = (HttpSessionImpl)vals.nextElement();
                            synchronized (httpSessionImpl) {
                                dif = new Date().getTime() - session._lastAccessedDate.getTime();
                                if ((dif /= 1000L) >= (long)session._maxInactiveInterval) {
                                    this._debug2("Invalidation of session id=" + session._id);
                                    session._valid = false;
                                    this._sessionTbl.remove(session._id);
                                    continue block19;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            if (!printStats) continue;
            System.out.print(this._threadPool.getStats().toString() + "\n");
        }
        return;
    }

    public static void stopApplication() {
        httpd._stop();
    }

    public static void main(String[] args) {
        ((Hashtable)System.getProperties()).put("shutdown.method", "stopApplication");
        if (args.length != 1) {
            System.out.println("Usage: httpd <properties file>");
            System.exit(1);
        }
        try {
            _server = new httpd(args[0]);
        }
        catch (Throwable th) {
            th.printStackTrace();
            System.exit(1);
        }
        _server.run();
    }

    private class FilterChainImpl
    implements FilterChain {
        private LinkedList _filterList;
        private Iterator _it;
        private String _path;

        FilterChainImpl(LinkedList filterList, String path) {
            this._filterList = filterList;
            this._path = path;
            this._it = this._filterList.iterator();
        }

        /*
         * Handled impossible loop by duplicating code
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            Exception ex2;
            block8: {
                Throwable t;
                boolean stop;
                ServletException se;
                block7: {
                    block6: {
                        if (this._it.hasNext()) {
                            httpd.this._debug("FILTER NEXT");
                            Filter f = (Filter)this._it.next();
                            f.doFilter(request, response, (FilterChain)this);
                            response.flushBuffer();
                            return;
                        }
                        try {
                            httpd.this._debug("BOTTOM OF THE FILTER CHAIN CALLING A SERVLET!");
                            httpd.this._debug2("Find servlet next...");
                            Servlet s = httpd.this._findServlet(this._path);
                            httpd.this._debug2("Back from call to findServlet...");
                            if (s == null) return;
                            httpd.this._debug2("Calling service...");
                            s.service(request, response);
                            httpd.this._debug2("Back from call to service...");
                            response.flushBuffer();
                            return;
                        }
                        catch (Exception ex2) {
                            if (!(ex2 instanceof ServletException)) break block6;
                            se = (ServletException)ex2;
                            se.printStackTrace();
                            stop = false;
                            if (!true) break block7;
                            t = se.getRootCause();
                            if (t == null) throw new ServletException(ex2.getMessage(), (Throwable)ex2);
                            if (stop) break block8;
                        }
                    }
                    ex2.printStackTrace();
                    throw new ServletException(ex2.getMessage(), (Throwable)ex2);
                }
                do {
                    void var5_8;
                    if (var5_8 instanceof ServletException) {
                        se = (ServletException)var5_8;
                    } else {
                        stop = true;
                    }
                    var5_8.printStackTrace();
                    t = se.getRootCause();
                    if (t == null) throw new ServletException(ex2.getMessage(), (Throwable)ex2);
                } while (!stop);
            }
            throw new ServletException(ex2.getMessage(), (Throwable)ex2);
        }
    }

    public class FilterConfigImpl
    implements FilterConfig {
        private String _filterName;
        private String _pattern;
        private String _className;

        FilterConfigImpl(String filterName, String pattern, String className) {
            this._filterName = filterName;
            this._pattern = pattern;
            this._className = className;
        }

        public String getFilterName() {
            return this._filterName;
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return null;
        }

        public ServletContext getServletContext() {
            return new ContextImpl(this._className, httpd.this._props.getProperty(this._className + ".initParameters"));
        }
    }

    private class ResponseImpl
    implements HttpServletResponse {
        private Socket _client;
        private String _contentType;
        private boolean _isCommitted;
        private LinkedList _headerList;
        private int _status;
        private String _statusMessage;
        private LinkedList _cookieList;
        private Locale _loc;
        private java.io.OutputStream _os;
        private OutputStream _out;
        private String _location;
        private RequestImpl _req;

        private void _setCookies(PrintWriter out) {
            if (this._cookieList.size() > 0) {
                Iterator it = this._cookieList.iterator();
                while (it.hasNext()) {
                    Cookie c = (Cookie)it.next();
                    StringBuffer buf = new StringBuffer();
                    buf.append("Set-Cookie: ");
                    buf.append(URLEncoder.encode(c.getName()) + "=" + URLEncoder.encode(c.getValue()));
                    if (c.getDomain() != null) {
                        buf.append(";domain=" + c.getDomain());
                    }
                    if (c.getMaxAge() != -1) {
                        GregorianCalendar gc = new GregorianCalendar();
                        gc.add(13, c.getMaxAge());
                        buf.append(";expires=" + httpd.this._cookieDateFormat.format(gc.getTime()));
                    }
                    if (c.getPath() != null) {
                        buf.append(";path=" + c.getPath());
                    }
                    if (c.getSecure()) {
                        buf.append("secure");
                    }
                    httpd.this._debug("WRITE: " + buf.toString());
                    buf.append("\r\n");
                    out.print(buf.toString());
                    out.flush();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void _writeHeaders() throws IOException {
            PrintWriter out;
            block13: {
                block12: {
                    HttpSessionImpl session = (HttpSessionImpl)this._req.getSession();
                    if (session != null) {
                        session._isNew = false;
                        session._lastAccessedDate = new Date();
                        String s = httpd.this._props.getProperty("session.cookie.id");
                        Cookie c = new Cookie(s, session.getId());
                        if (session.getMaxInactiveInterval() != -1) {
                            c.setMaxAge(session.getMaxInactiveInterval());
                        }
                        this.addCookie(c);
                        if (httpd.this._sessionManagement) {
                            ReadWriteLock rwLock;
                            Hashtable hashtable = httpd.this._sessionReadWriteLockTbl;
                            synchronized (hashtable) {
                                rwLock = (ReadWriteLock)httpd.this._sessionReadWriteLockTbl.get(session._id);
                                if (rwLock == null) {
                                    rwLock = new ReadWriteLock();
                                    httpd.this._sessionReadWriteLockTbl.put(session._id, rwLock);
                                }
                            }
                            rwLock.writeLock();
                            try {
                                Object var11_11;
                                try {
                                    File f = new File(httpd.this._sessionSaveDir + "/" + session._id + ".dat");
                                    FileOutputStream fout = new FileOutputStream(f);
                                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                                    oout.writeObject(session._getSessionData());
                                    oout.flush();
                                    fout.close();
                                }
                                catch (Throwable th) {
                                    httpd.this._servletLogFile.log(null, "error writeing session save file!", th);
                                    var11_11 = null;
                                    rwLock.writeUnlock();
                                    break block12;
                                }
                                var11_11 = null;
                                rwLock.writeUnlock();
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                rwLock.writeUnlock();
                                throw throwable;
                            }
                        }
                    }
                }
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this._os)));
                httpd.this._debug("WRITE: HTTP/1.0 " + this._status + " " + this._statusMessage);
                out.print("HTTP/1.0 " + this._status + " " + this._statusMessage + "\r\n");
                Iterator it = this._headerList.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        this._setCookies(out);
                        if (this._location != null || this._req.getHeader("Content-Type") != null) break;
                        httpd.this._debug("WRITE: Content-Type: " + this._contentType + "\r\n");
                        out.print("Content-Type: " + this._contentType + "\r\n\r\n");
                        break block13;
                    }
                    String h = it.next().toString();
                    httpd.this._debug("WRITE: " + h);
                    out.print(h + "\r\n");
                    out.flush();
                }
                httpd.this._debug("Location: " + this._location + "\r\n");
                out.print("Location: " + this._location + "\r\n\r\n");
            }
            out.flush();
        }

        ResponseImpl(Socket client, RequestImpl req) throws IOException {
            this._contentType = httpd.this._props.getProperty("server.default.content.type");
            this._isCommitted = false;
            this._headerList = new LinkedList();
            this._status = 200;
            this._statusMessage = "OK";
            this._cookieList = new LinkedList();
            this._loc = Locale.getDefault();
            this._location = null;
            this._req = req;
            this._client = client;
            this._os = this._client.getOutputStream();
            this._out = new OutputStream();
            this.addHeader("Server", httpd.VERSION);
            this.addDateHeader("Date", new Date().getTime());
        }

        public void addCookie(Cookie cookie) {
            this._cookieList.add(cookie);
        }

        public void addDateHeader(String name, long date) {
            this._headerList.add(name + ": " + httpd.this._dateFormat.format(new Date(date)));
        }

        public void addHeader(String name, String value) {
            this._headerList.add(name + ": " + value);
        }

        public void addIntHeader(String name, int value) {
            this._headerList.add(name + ": " + value);
        }

        public boolean containsHeader(String name) {
            return httpd.this._headerValue(this._headerList, name) != null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public String encodeURL(String url) {
            return null;
        }

        public void sendError(int sc) throws IOException, IllegalStateException {
            if (this._isCommitted) {
                throw new IllegalStateException("Response has been committed");
            }
            this.setStatus(sc);
            this.setContentType("text/html");
            TemplateWebPage errorPage = new TemplateWebPage(httpd.this._errorPage);
            errorPage.expandTemplate("#error.code#", sc + "");
            errorPage.expandTemplate("#error.message#", this._statusMessage);
            errorPage.expandTemplate("#optional.message#", "");
            errorPage.sendTo(this.getWriter());
        }

        public void sendError(int sc, String msg) throws IOException, IllegalStateException {
            if (this._isCommitted) {
                throw new IllegalStateException("Response has been committed");
            }
            this.setStatus(sc);
            this.setContentType("text/html");
            TemplateWebPage errorPage = new TemplateWebPage(httpd.this._errorPage);
            errorPage.expandTemplate("#error.code#", sc + "");
            errorPage.expandTemplate("#error.message#", this._statusMessage);
            errorPage.expandTemplate("#optional.message#", msg);
            errorPage.sendTo(this.getWriter());
        }

        public void sendRedirect(String location) throws IOException {
            this.setStatus(300);
            this._location = location;
            this.getWriter().flush();
        }

        public void setDateHeader(String name, long date) {
            Iterator it = this._headerList.iterator();
            int index = 0;
            boolean found = false;
            while (it.hasNext()) {
                String h = it.next().toString();
                int i = h.indexOf(58);
                if (i >= 0 && name.equalsIgnoreCase(h = h.substring(0, i))) {
                    this._headerList.set(index, name + ": " + httpd.this._dateFormat.format(new Date(date)));
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                this.addDateHeader(name, date);
            }
        }

        public void setHeader(String name, String value) {
            Iterator it = this._headerList.iterator();
            int index = 0;
            boolean found = false;
            while (it.hasNext()) {
                String h = it.next().toString();
                int i = h.indexOf(58);
                if (i >= 0 && name.equalsIgnoreCase(h = h.substring(0, i))) {
                    this._headerList.set(index, name + ": " + value);
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                this.addHeader(name, value);
            }
        }

        public void setIntHeader(String name, int value) {
            Iterator it = this._headerList.iterator();
            int index = 0;
            boolean found = false;
            while (it.hasNext()) {
                String h = it.next().toString();
                int i = h.indexOf(58);
                if (i >= 0 && name.equalsIgnoreCase(h = h.substring(0, i))) {
                    this._headerList.set(index, name + ": " + value);
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                this.addIntHeader(name, value);
            }
        }

        public void setStatus(int sc) {
            this._status = sc;
            switch (this._status) {
                case 200: {
                    this._statusMessage = "OK";
                    break;
                }
                case 201: {
                    this._statusMessage = "Created";
                    break;
                }
                case 202: {
                    this._statusMessage = "Accepted";
                    break;
                }
                case 204: {
                    this._statusMessage = "No Content";
                    break;
                }
                case 300: {
                    this._statusMessage = "Multiple Choices";
                    break;
                }
                case 301: {
                    this._statusMessage = "Moved Permanently";
                    break;
                }
                case 302: {
                    this._statusMessage = "Moved Temporarily";
                    break;
                }
                case 304: {
                    this._statusMessage = "Not Modified";
                    break;
                }
                case 400: {
                    this._statusMessage = "Bad Request";
                    break;
                }
                case 401: {
                    this._statusMessage = "Unautorized";
                    break;
                }
                case 403: {
                    this._statusMessage = "Forbidden";
                    break;
                }
                case 404: {
                    this._statusMessage = "Not Found";
                    break;
                }
                case 500: {
                    this._statusMessage = "Internal Server Error";
                    break;
                }
                case 501: {
                    this._statusMessage = "Not Implemented";
                    break;
                }
                case 502: {
                    this._statusMessage = "Bad Gateway";
                    break;
                }
                case 503: {
                    this._statusMessage = "Service Unavailable";
                    break;
                }
                default: {
                    this._statusMessage = "OK";
                }
            }
        }

        public void setStatus(int sc, String sm) {
            this.setStatus(sc);
        }

        public void flushBuffer() throws IOException {
            this._out.flush();
        }

        public int getBufferSize() {
            return this._out._charList.size();
        }

        public String getCharacterEncoding() {
            return null;
        }

        public Locale getLocale() {
            return this._loc;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this._isCommitted) {
                throw new IllegalStateException("Response has been committed");
            }
            return this._out;
        }

        public PrintWriter getWriter() throws IOException {
            if (this._isCommitted) {
                throw new IllegalStateException("Response has been committed");
            }
            return new PrintWriter(new OutputStreamWriter((java.io.OutputStream)((Object)this._out)));
        }

        public boolean isCommitted() {
            return this._isCommitted;
        }

        public void reset() {
            this._status = 200;
            this._statusMessage = "OK";
            this._headerList = new LinkedList();
            this._contentType = httpd.this._props.getProperty("server.default.content.type");
            this._cookieList = new LinkedList();
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int size) {
        }

        public void setContentLength(int len) {
            this.setIntHeader("Content-Length", len);
        }

        public void setContentType(String type) {
            this._contentType = type;
        }

        public void setLocale(Locale loc) {
            this._loc = loc;
        }

        private class OutputStream
        extends ServletOutputStream {
            LinkedList _charList = new LinkedList();

            private OutputStream() {
            }

            public void write(int b) throws IOException {
                this._charList.add(new Integer(b));
            }

            public void flush() throws IOException {
                if (!ResponseImpl.this._isCommitted) {
                    ResponseImpl.this._isCommitted = true;
                    ResponseImpl.this._writeHeaders();
                }
                Iterator it = this._charList.iterator();
                byte[] buf = new byte[this._charList.size()];
                int i = 0;
                while (it.hasNext()) {
                    Integer ii = (Integer)it.next();
                    buf[i] = (byte)ii.intValue();
                    ++i;
                }
                ResponseImpl.this._os.write(buf);
                ResponseImpl.this._os.flush();
                this._charList = new LinkedList();
            }
        }
    }

    private class RequestImpl
    implements HttpServletRequest {
        private Socket _client;
        private LinkedList _headerList;
        private String _method;
        private String _mMethod;
        private String _path;
        private Cookie[] _cookieArray = null;
        private String _queryString;
        private Vector _paramVec = new Vector();
        private HashMap _paramMap = new HashMap();
        private String _contentType;
        private int _contentLength = -1;
        private BufferedReader _br;
        private StringBufferInputStream _sbi = null;
        private Hashtable _attrs = new Hashtable();
        private String _newSessionID = null;
        private HttpSessionImpl _newSession = null;

        RequestImpl(Socket client, LinkedList headerList, String method, String path, String queryString, BufferedReader br) throws IOException {
            String temp;
            this._br = br;
            this._queryString = queryString;
            this._client = client;
            this._headerList = headerList;
            this._method = method;
            this._path = path;
            int i = 0;
            while (i < this._method.length()) {
                if (Character.isWhitespace(this._method.charAt(i))) {
                    this._mMethod = this._method.substring(0, i);
                    break;
                }
                ++i;
            }
            String cookieString = httpd.this._headerValue(this._headerList, "Cookie");
            if (cookieString != null) {
                int i2;
                StringTokenizer sTok = new StringTokenizer(cookieString, ";");
                LinkedList<Cookie> cookieList = new LinkedList<Cookie>();
                while (sTok.hasMoreTokens()) {
                    String c = sTok.nextToken();
                    i2 = c.indexOf(61);
                    if (i2 < 0) continue;
                    String name = c.substring(0, i2);
                    name = name.trim();
                    String value = i2 + 1 < c.length() ? c.substring(i2 + 1) : "";
                    httpd.this._debug("COOKIE(" + name + "," + value + ")");
                    Cookie cookie = new Cookie(URLDecoder.decode(name), URLDecoder.decode(value));
                    cookieList.add(cookie);
                }
                if (cookieList.size() > 0) {
                    this._cookieArray = new Cookie[cookieList.size()];
                    i2 = 0;
                    while (i2 < cookieList.size()) {
                        this._cookieArray[i2] = (Cookie)cookieList.get(i2);
                        ++i2;
                    }
                }
            }
            if (this._queryString != null) {
                this._parseFormData(this._queryString);
            }
            if ((temp = httpd.this._headerValue(this._headerList, "Content-Length")) != null) {
                this._contentLength = Integer.parseInt(temp);
            } else if (this._queryString != null) {
                this._contentLength = this._queryString.length();
            }
            this._contentType = httpd.this._headerValue(this._headerList, "Content-Type");
            if (this._contentType != null && this._contentType.compareTo("application/x-www-form-urlencoded") == 0 && this._mMethod.equalsIgnoreCase("POST") && this._contentLength != -1) {
                char[] buffer = new char[this._contentLength];
                StringBuffer buf = new StringBuffer();
                int n = -1;
                int nn = 0;
                while (nn < this._contentLength && (n = this._br.read(buffer)) > 0) {
                    nn += n;
                    httpd.this._debug("READ: " + new String(buffer, 0, n));
                    buf.append(new String(buffer, 0, n));
                }
                this._sbi = new StringBufferInputStream(buf.toString());
                this._parseFormData(buf.toString());
            }
        }

        private void _parseFormData(String data) {
            StringTokenizer sTok = new StringTokenizer(data, ";&");
            while (sTok.hasMoreTokens()) {
                String tok = sTok.nextToken();
                int i = tok.indexOf(61);
                if (i < 0) continue;
                String name = tok.substring(0, i);
                String value = ++i < tok.length() ? tok.substring(i) : "";
                name = URLDecoder.decode(name);
                value = URLDecoder.decode(value);
                Parameter param = new Parameter(name, value);
                this._paramVec.addElement(param);
                LinkedList<Parameter> l = (LinkedList<Parameter>)this._paramMap.get(name);
                if (l == null) {
                    l = new LinkedList<Parameter>();
                    l.add(param);
                    this._paramMap.put(name, l);
                    continue;
                }
                l.add(param);
                this._paramMap.put(name, l);
            }
        }

        public String getAuthType() {
            httpd.this._debug2("getAuthType()");
            return null;
        }

        public String getContextPath() {
            httpd.this._debug2("getContextPath()");
            return "";
        }

        public Cookie[] getCookies() {
            httpd.this._debug2("getCookies()");
            return this._cookieArray;
        }

        public long getDateHeader(String name) throws IllegalArgumentException {
            httpd.this._debug2("getDateHeader(" + name + ")");
            String value = httpd.this._headerValue(this._headerList, name);
            if (value == null) {
                return -1L;
            }
            try {
                return httpd.this._dateFormat.parse(value).getTime();
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to parse date header");
            }
        }

        public String getHeader(String name) {
            httpd.this._debug2("getHeader(" + name + ")");
            return httpd.this._headerValue(this._headerList, name);
        }

        public Enumeration getHeaderNames() {
            httpd.this._debug2("getHeaderNames()");
            Vector<String> v = new Vector<String>();
            Iterator it = this._headerList.iterator();
            while (it.hasNext()) {
                String h = it.next().toString();
                int i = h.indexOf(58);
                if (i < 0) continue;
                v.addElement(h.substring(0, i));
            }
            return v.elements();
        }

        public Enumeration getHeaders(String name) {
            httpd.this._debug2("getHeaders(" + name + ")");
            Vector<String> v = new Vector<String>();
            Iterator it = this._headerList.iterator();
            while (it.hasNext()) {
                String h = it.next().toString();
                int i = h.indexOf(58);
                if (i < 0 || !h.substring(0, i).equalsIgnoreCase(name)) continue;
                ++i;
                while (i < h.length() && Character.isWhitespace(h.charAt(i))) {
                    ++i;
                }
                if (i >= h.length()) continue;
                h = h.substring(i);
                v.addElement(h);
            }
            return v.elements();
        }

        public int getIntHeader(String name) {
            httpd.this._debug2("getHeader(" + name + ")");
            return Integer.parseInt(httpd.this._headerValue(this._headerList, name));
        }

        public String getMethod() {
            httpd.this._debug2("getMethod()");
            return this._mMethod;
        }

        public String getPathInfo() {
            httpd.this._debug2("getPathInfo()");
            return "";
        }

        public String getPathTranslated() {
            httpd.this._debug2("getPathTranslated()");
            return httpd.this._translatePath(this._path);
        }

        public String getQueryString() {
            httpd.this._debug2("getQueryString()");
            return this._queryString;
        }

        public String getRemoteUser() {
            String up;
            String auth = this.getHeader("Authorization");
            if (auth == null || auth.length() < 6) {
                return null;
            }
            auth = auth.substring(6);
            BASE64Decoder b64d = new BASE64Decoder();
            try {
                up = new String(b64d.decodeBuffer(auth));
            }
            catch (IOException ioe) {
                return null;
            }
            int i = up.indexOf(58);
            if (i >= 0) {
                return up.substring(0, i);
            }
            return null;
        }

        public String getRequestedSessionId() {
            httpd.this._debug2("getRequestedSessionId()");
            return this._getSessionId();
        }

        public String getRequestURI() {
            httpd.this._debug2("getRequestURI(" + this._path + ")");
            return this._path;
        }

        public StringBuffer getRequestURL() {
            httpd.this._debug2("getRequestURL()");
            return null;
        }

        public String getServletPath() {
            httpd.this._debug2("getServletPath()");
            return this._path;
        }

        private String _getSessionId() {
            String id = null;
            Cookie[] c = this.getCookies();
            String sid = httpd.this._props.getProperty("session.cookie.id");
            if (c != null) {
                int i = 0;
                while (i < c.length) {
                    if (c[i].getName().compareTo(sid) == 0) {
                        id = c[i].getValue();
                        break;
                    }
                    ++i;
                }
            }
            return id;
        }

        public HttpSession getSession() {
            Object object;
            HttpSessionImpl ret;
            httpd.this._debug2("getSession()");
            if (this._newSession != null) {
                return this._newSession;
            }
            String id = this._getSessionId();
            if (id == null) {
                return null;
            }
            if (httpd.this._sessionManagement) {
                File f = new File(httpd.this._sessionSaveDir + "/" + id + ".dat");
                if (!f.exists()) {
                    ret = null;
                } else {
                    try {
                        ReadWriteLock rwLock;
                        Hashtable hashtable = httpd.this._sessionReadWriteLockTbl;
                        synchronized (hashtable) {
                            rwLock = (ReadWriteLock)httpd.this._sessionReadWriteLockTbl.get(id);
                            if (rwLock == null) {
                                rwLock = new ReadWriteLock();
                                httpd.this._sessionReadWriteLockTbl.put(id, rwLock);
                            }
                        }
                        rwLock.readLock();
                        try {
                            FileInputStream fin = new FileInputStream(f);
                            BufferedInputStream bin = new BufferedInputStream(fin);
                            ObjectInputStream oin = new ObjectInputStream(bin);
                            Object o = oin.readObject();
                            fin.close();
                            if (o == null) {
                                ret = null;
                            } else if (o instanceof SessionData) {
                                this._newSession = ret = new HttpSessionImpl((SessionData)o, httpd.this._findServlet(this._path).getServletConfig().getServletContext());
                                this._newSessionID = ret._id;
                            } else {
                                ret = null;
                            }
                            Object var11_12 = null;
                            rwLock.readUnlock();
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            rwLock.readUnlock();
                            throw throwable;
                        }
                        {
                        }
                    }
                    catch (Throwable th) {
                        httpd.this._servletLogFile.log(null, "error reading session from file!", th);
                        ret = null;
                    }
                }
            } else {
                object = httpd.this._sessionTbl;
                synchronized (object) {
                    ret = (HttpSessionImpl)httpd.this._sessionTbl.get(id);
                }
            }
            if (ret != null) {
                object = ret;
                synchronized (object) {
                    if (!ret._valid) {
                        HttpSession httpSession = null;
                        return httpSession;
                    }
                }
            }
            return ret;
        }

        public HttpSession getSession(boolean create) {
            httpd.this._debug2("getSession(" + create + ")");
            HttpSessionImpl ret = (HttpSessionImpl)this.getSession();
            if (ret == null) {
                Object servlet;
                try {
                    servlet = httpd.this._findServlet(this._path);
                }
                catch (Throwable t) {
                    servlet = httpd.this._fileServlet;
                }
                ret = new HttpSessionImpl(servlet.getServletConfig().getServletContext());
                this._newSessionID = ret.getId();
                this._newSession = ret;
                ReadWriteLock rwLock = new ReadWriteLock();
                Hashtable hashtable = httpd.this._sessionReadWriteLockTbl;
                synchronized (hashtable) {
                    httpd.this._sessionReadWriteLockTbl.put(this._newSessionID, rwLock);
                }
                if (!httpd.this._sessionManagement) {
                    Hashtable hashtable2 = httpd.this._sessionTbl;
                    synchronized (hashtable2) {
                        httpd.this._sessionTbl.put(ret.getId(), ret);
                    }
                }
            }
            return ret;
        }

        public Principal getUserPrincipal() {
            httpd.this._debug2("getUserPrincipal()");
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            httpd.this._debug2("isRequestedSessionIdFromCookie()");
            return true;
        }

        public boolean isRequestedSessionIdFromUrl() {
            httpd.this._debug2("isRequestedSessionIdFromUrl()");
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            httpd.this._debug2("isRequestedSessionIdFromURL()");
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            httpd.this._debug2("isRequestedSessionIdValid()");
            String id = this._getSessionId();
            return id != null;
        }

        public boolean isUserInRole(String role) {
            httpd.this._debug2("isUserInRole(" + role + ")");
            return false;
        }

        public Object getAttribute(String name) {
            httpd.this._debug2("getAttribute(" + name + ")");
            return this._attrs.get(name);
        }

        public Enumeration getAttributeNames() {
            httpd.this._debug2("getAttributeNames()");
            return this._attrs.keys();
        }

        public String getCharacterEncoding() {
            httpd.this._debug2("getCharacterEncoding()");
            return null;
        }

        public int getContentLength() {
            httpd.this._debug2("getContentLength()");
            return this._contentLength;
        }

        public String getContentType() {
            httpd.this._debug2("getContentType()");
            return this._contentType;
        }

        public ServletInputStream getInputStream() {
            httpd.this._debug2("getInputStream()");
            return new InputStream();
        }

        public Locale getLocale() {
            httpd.this._debug2("getLocale()");
            return null;
        }

        public Enumeration getLocales() {
            httpd.this._debug2("getLocales()");
            return null;
        }

        public String getParameter(String name) {
            httpd.this._debug2("getParameter(" + name + ")");
            LinkedList l = (LinkedList)this._paramMap.get(name);
            if (l == null) {
                return null;
            }
            if (l.size() == 0) {
                return null;
            }
            return ((Parameter)l.get((int)0)).value;
        }

        public Map getParameterMap() {
            httpd.this._debug2("getParameterMap()");
            HashMap<String, String> map = new HashMap<String, String>();
            Set s = this._paramMap.keySet();
            Iterator it = s.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                LinkedList l = (LinkedList)this._paramMap.get(key);
                if (l == null || l.size() <= 0) continue;
                Parameter p = (Parameter)l.get(0);
                map.put(key, p.value);
            }
            return map;
        }

        public Enumeration getParameterNames() {
            httpd.this._debug2("getParameterNames()");
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < this._paramVec.size()) {
                v.addElement(((Parameter)this._paramVec.elementAt((int)i)).name);
                ++i;
            }
            return v.elements();
        }

        public String[] getParameterValues(String name) {
            httpd.this._debug2("getParameterValues(" + name + ")");
            LinkedList l = (LinkedList)this._paramMap.get(name);
            if (l == null) {
                return null;
            }
            if (l.size() == 0) {
                return null;
            }
            String[] array = new String[l.size()];
            int i = 0;
            while (i < l.size()) {
                array[i] = l.get(i).toString();
                ++i;
            }
            return array;
        }

        public String getProtocol() {
            httpd.this._debug2("getProtocol()");
            if (this.isSecure()) {
                return "https";
            }
            return "http";
        }

        public BufferedReader getReader() {
            httpd.this._debug2("getReader()");
            return null;
        }

        public String getRealPath(String path) {
            httpd.this._debug2("getRealPath(" + path + ")");
            return httpd.this._translatePath(path);
        }

        public String getRemoteAddr() {
            httpd.this._debug2("getRemoteAddr()");
            return this._client.getInetAddress().getHostAddress();
        }

        public String getRemoteHost() {
            httpd.this._debug2("getRemoteHost()");
            return this._client.getInetAddress().getHostName();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            httpd.this._debug2("getRequestDispatcher(" + path + ")");
            return null;
        }

        public String getScheme() {
            httpd.this._debug2("getScheme()");
            if (this.isSecure()) {
                return "https";
            }
            return "http";
        }

        public String getServerName() {
            httpd.this._debug2("getServerName()");
            return httpd.this._svr.getInetAddress().getHostName();
        }

        public int getServerPort() {
            httpd.this._debug2("getServerPort()");
            return httpd.this._svr.getLocalPort();
        }

        public boolean isSecure() {
            httpd.this._debug2("isSecure()");
            return httpd.this._props.getProperty("server.type").compareTo("TLS") == 0;
        }

        public void removeAttribute(String name) {
            httpd.this._debug2("removeAttribute(" + name + ")");
            this._attrs.remove(name);
        }

        public void setAttribute(String name, Object o) {
            httpd.this._debug2("setAttribute(" + name + "," + o.toString() + ")");
            this._attrs.put(name, o);
        }

        public void setCharacterEncoding(String env) {
            httpd.this._debug2("setCharacterEncoding(" + env + ")");
        }

        private class Parameter {
            String name;
            String value;

            Parameter(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }

        public class InputStream
        extends ServletInputStream {
            private int _nleft;

            public InputStream() {
                this._nleft = RequestImpl.this._contentLength;
            }

            public int read() throws IOException {
                if (RequestImpl.this._sbi == null) {
                    if (this._nleft <= 0) {
                        return -1;
                    }
                    --this._nleft;
                    int ch = RequestImpl.this._br.read();
                    return ch;
                }
                return RequestImpl.this._sbi.read();
            }
        }
    }

    private class HttpSessionImpl
    implements HttpSession {
        private boolean _isNew;
        private Hashtable _attrs;
        private Date _creationDate;
        private String _id;
        private Date _lastAccessedDate;
        private int _maxInactiveInterval;
        private boolean _valid;
        private ServletContext _servletCtx;

        private SessionData _getSessionData() {
            SessionData sd = new SessionData();
            sd.isNew = this._isNew;
            sd.attrs = this._attrs;
            sd.creationDate = this._creationDate;
            sd.id = this._id;
            sd.lastAccessedDate = this._lastAccessedDate;
            sd.maxInactiveInterval = this._maxInactiveInterval;
            sd.valid = this._valid;
            return sd;
        }

        private HttpSessionImpl(SessionData sd, ServletContext ctx) {
            this._isNew = sd.isNew;
            this._attrs = sd.attrs;
            this._creationDate = sd.creationDate;
            this._id = sd.id;
            this._lastAccessedDate = sd.lastAccessedDate;
            this._maxInactiveInterval = sd.maxInactiveInterval;
            this._valid = sd.valid;
            this._servletCtx = ctx;
        }

        private HttpSessionImpl(ServletContext ctx) {
            Object ref;
            this._servletCtx = ctx;
            this._isNew = true;
            this._attrs = new Hashtable();
            this._creationDate = new Date();
            this._lastAccessedDate = new Date();
            this._maxInactiveInterval = -1;
            this._valid = true;
            String from = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            int len = 20;
            do {
                StringBuffer key = new StringBuffer();
                int index = 0;
                while (index < len) {
                    int randIndex = (int)(Math.random() * 1000.0) % len;
                    key.append(from.charAt(randIndex));
                    ++index;
                }
                this._id = key.toString();
                if (httpd.this._sessionManagement) {
                    if (!new File(httpd.this._sessionSaveDir + "/" + this._id + ".dat").exists()) break;
                    ref = null;
                    continue;
                }
                Hashtable hashtable = httpd.this._sessionTbl;
                synchronized (hashtable) {
                    ref = httpd.this._sessionTbl.get(this._id);
                }
            } while (ref != null);
        }

        public Object getAttribute(String name) throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            return this._attrs.get(name);
        }

        public Enumeration getAttributeNames() throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            return this._attrs.keys();
        }

        public long getCreationTime() throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            return this._creationDate.getTime();
        }

        public String getId() {
            return this._id;
        }

        public long getLastAccessedTime() {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                long l = this._lastAccessedDate.getTime();
                return l;
            }
        }

        public int getMaxInactiveInterval() {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                int n = this._maxInactiveInterval;
                return n;
            }
        }

        public ServletContext getServletContext() {
            return this._servletCtx;
        }

        public HttpSessionContext getSessionContext() {
            return null;
        }

        public Object getValue(String name) throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            return this._attrs.get(name);
        }

        public String[] getValueNames() throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            String[] array = new String[this._attrs.size()];
            Enumeration keys = this._attrs.keys();
            int index = 0;
            while (keys.hasMoreElements()) {
                array[index] = keys.nextElement().toString();
                ++index;
            }
            return array;
        }

        public void invalidate() throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
                this._valid = false;
            }
        }

        public boolean isNew() {
            return this._isNew;
        }

        public void putValue(String name, Object value) throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            this._attrs.put(name, value);
        }

        public void removeAttribute(String name) throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            this._attrs.remove(name);
        }

        public void removeValue(String name) throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            this._attrs.remove(name);
        }

        public void setAttribute(String name, Object value) throws IllegalStateException {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                if (!this._valid) {
                    throw new IllegalStateException("Session is invalid");
                }
            }
            this._attrs.put(name, value);
        }

        public void setMaxInactiveInterval(int interval) {
            HttpSessionImpl httpSessionImpl = this;
            synchronized (httpSessionImpl) {
                this._maxInactiveInterval = interval;
            }
        }
    }

    private class ConfigImpl
    implements ServletConfig {
        private ContextImpl _ctx;

        ConfigImpl(ContextImpl ctx) {
            this._ctx = ctx;
        }

        public String getInitParameter(String name) {
            return this._ctx.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return this._ctx.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this._ctx;
        }

        public String getServletName() {
            return this._ctx.name();
        }
    }

    private class ContextImpl
    implements ServletContext {
        private Hashtable _attrs = new Hashtable();
        private Hashtable _initParams = new Hashtable();
        private String _servlet;

        ContextImpl(String servlet, String initParameters) {
            if (initParameters == null) {
                initParameters = "";
            }
            StringTokenizer sTok = new StringTokenizer(initParameters, "&");
            while (sTok.hasMoreTokens()) {
                String value;
                String name;
                String temp = sTok.nextToken();
                int index = temp.indexOf("=");
                if (index < 0) {
                    name = temp;
                    value = "";
                } else {
                    name = temp.substring(0, index);
                    value = index + 1 < temp.length() ? temp.substring(index + 1) : "";
                }
                this._initParams.put(name, value);
            }
            this._servlet = servlet;
        }

        String name() {
            return this._servlet;
        }

        public Object getAttribute(String name) {
            httpd.this._debug2("getAttribute(\"" + name + "\")");
            return this._attrs.get(name);
        }

        public Enumeration getAttributeNames() {
            return this._attrs.keys();
        }

        public ServletContext getContext(String uripath) {
            Servlet servlet = null;
            try {
                servlet = httpd.this._findServlet(uripath);
            }
            catch (Exception ex) {
                return null;
            }
            if (servlet == null) {
                return null;
            }
            return servlet.getServletConfig().getServletContext();
        }

        public String getInitParameter(String name) {
            httpd.this._debug2("getInitParameter(\"" + name + "\")");
            Object ip = this._initParams.get(name);
            if (ip == null) {
                return null;
            }
            httpd.this._debug2("returning=\"" + ip.toString() + "\"");
            return ip.toString();
        }

        public Enumeration getInitParameterNames() {
            return this._initParams.keys();
        }

        public int getMajorVersion() {
            return 0;
        }

        public String getMimeType(String file) {
            String s = file.toLowerCase();
            int i = s.lastIndexOf(46);
            if (i >= 0) {
                s = s.substring(i);
                return httpd.this._props.getProperty("content.type" + s);
            }
            return null;
        }

        public int getMinorVersion() {
            return 0;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            httpd.this._debug("getNameDispatcher");
            return null;
        }

        public String getRealPath(String path) {
            httpd.this._debug2("getRealPath(\"" + path + "\")");
            if (path.indexOf("..") >= 0) {
                return null;
            }
            String f = httpd.this._docRoot + path;
            File ff = new File(f);
            httpd.this._debug2("ff=" + ff.getAbsolutePath());
            if (ff.exists()) {
                return f;
            }
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            httpd.this._debug("getRequestDispatcher");
            return null;
        }

        public URL getResource(String path) {
            httpd.this._debug2("getResource");
            String file = httpd.this._translatePath(path);
            httpd.this._debug2("translated=" + file);
            if (file == null) {
                return null;
            }
            try {
                return new URL("file://" + file);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                return null;
            }
        }

        public InputStream getResourceAsStream(String path) {
            httpd.this._debug2("getResourceAsStream(\"" + path + "\")");
            String file = httpd.this._translatePath(path);
            httpd.this._debug2("translated=" + file);
            if (file == null) {
                return null;
            }
            try {
                return new FileInputStream(file);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }

        public Set getResourcePaths(String path) {
            httpd.this._debug2("getResourcePaths");
            return new TreeSet();
        }

        public String getServerInfo() {
            return httpd.VERSION;
        }

        public Servlet getServlet(String name) {
            httpd.this._debug2("getServlet");
            return null;
        }

        public String getServletContextName() {
            httpd.this._debug2("getServletContextName");
            return null;
        }

        public Enumeration getServletNames() {
            httpd.this._debug2("getServletNames");
            return null;
        }

        public Enumeration getServlets() {
            httpd.this._debug2("getServlets");
            return null;
        }

        public void log(Exception exception, String msg) {
            httpd.this._servletLogFile.log(this._servlet, exception, msg);
        }

        public void log(String msg) {
            httpd.this._servletLogFile.log(this._servlet, msg);
        }

        public void log(String message, Throwable throwable) {
            httpd.this._servletLogFile.log(this._servlet, message, throwable);
        }

        public void removeAttribute(String name) {
            this._attrs.remove(name);
        }

        public void setAttribute(String name, Object object) {
            this._attrs.put(name, object);
        }
    }

    private class FileServlet
    extends HttpServlet {
        private String _def;
        private int _maxBuffer;
        private String _root;

        private FileServlet() {
            this._def = httpd.this._props.getProperty("server.default.content.type");
            this._maxBuffer = Integer.parseInt(httpd.this._props.getProperty("server.max.buffer"));
            this._root = httpd.this._props.getProperty("server.document.root");
        }

        private String _htaccess(String path) {
            String temp = path;
            while (temp.compareTo(this._root) != 0) {
                int index = temp.lastIndexOf(47);
                if (index < 0) {
                    return null;
                }
                File f = new File(temp = temp.substring(0, index) + "/.htaccess");
                if (f.exists()) {
                    return temp;
                }
                temp = temp.substring(0, index);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
            int n;
            FileInputStream fin;
            File f;
            String contentType;
            String path = req.getRequestURI();
            if ((path = httpd.this._translatePath(path)) == null || path.toLowerCase().endsWith("/.htaccess")) {
                res.sendError(404);
                return;
            }
            int index = path.lastIndexOf(46);
            if (index >= 0) {
                String ext = path.substring(index).toLowerCase();
                contentType = httpd.this._props.getProperty("content.type" + ext);
                if (contentType == null) {
                    contentType = this._def;
                }
            } else {
                contentType = this._def;
            }
            String htaccess = this._htaccess(path);
            if (htaccess != null) {
                f = new File(htaccess);
                Properties users = new Properties();
                fin = new FileInputStream(f);
                BufferedInputStream bin = new BufferedInputStream(fin);
                users.load(bin);
                fin.close();
                String realm = users.getProperty("realm");
                String auth = req.getHeader("Authorization");
                if (auth == null) {
                    res.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
                    res.sendError(401);
                    return;
                }
                boolean ok = false;
                BASE64Decoder b64d = new BASE64Decoder();
                String up = new String(b64d.decodeBuffer(auth = auth.substring(6)));
                int i = up.indexOf(58);
                if (i >= 0 && i + 1 < up.length()) {
                    String u = up.substring(0, i);
                    String p = up.substring(i + 1);
                    String rp = users.getProperty(u);
                    if (rp != null && rp.compareTo(p) == 0 && rp.compareTo("realm") != 0) {
                        ok = true;
                    }
                }
                if (!ok) {
                    res.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
                    res.sendError(401);
                    return;
                }
            }
            f = new File(path);
            res.addDateHeader("Last-Modified", f.lastModified());
            res.setContentLength((int)f.length());
            res.setContentType(contentType);
            ServletOutputStream out = res.getOutputStream();
            httpd.this._debug("SENDING FILE: " + path);
            fin = new FileInputStream(path);
            DataInputStream din = new DataInputStream(fin);
            byte[] buffer = new byte[this._maxBuffer];
            while ((n = din.read(buffer)) > 0) {
                void auth;
                out.write(buffer, 0, (int)auth);
                out.flush();
            }
            fin.close();
        }
    }

    private class LogFile {
        private PrintWriter _out;
        private String _fileName;
        private SimpleDateFormat _dateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z");

        LogFile(String fileName) throws IOException {
            this._fileName = fileName;
            this._out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this._fileName, true))));
        }

        void log(String servlet, Exception exception, String msg) {
            LogFile logFile = this;
            synchronized (logFile) {
                this._out.println(servlet + ":" + exception.getMessage());
                this._out.println("MESSAGE: " + msg);
                this._out.println("DATE: " + this._dateFormat.format(new Date()));
                exception.printStackTrace(this._out);
                this._out.flush();
            }
        }

        void log(String servlet, String msg) {
            LogFile logFile = this;
            synchronized (logFile) {
                this._out.println(servlet + ":" + msg);
                this._out.println("DATE: " + this._dateFormat.format(new Date()));
                this._out.flush();
            }
        }

        void log(String servlet, String message, Throwable throwable) {
            LogFile logFile = this;
            synchronized (logFile) {
                this._out.println(servlet + ":" + throwable.getMessage());
                this._out.println("MESSAGE: " + message);
                this._out.println("DATE: " + this._dateFormat.format(new Date()));
                throwable.printStackTrace(this._out);
                this._out.flush();
            }
        }

        void close() throws IOException {
            LogFile logFile = this;
            synchronized (logFile) {
                this._out.flush();
                this._out.close();
            }
        }
    }

    private class AccepterThread
    extends Thread {
        private AccepterThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Socket client;
                    if (!httpd._isRunning()) {
                        return;
                    }
                    ServerSocket serverSocket = httpd.this._svr;
                    synchronized (serverSocket) {
                        client = httpd.this._svr.accept();
                    }
                    httpd.this._debug("ACCEPT: " + client.getInetAddress().getHostName());
                    try {
                        httpd.this._threadPool.postTaskForExecution(new Handler(client));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class Handler
    implements Runnable {
        Socket _client;

        public Handler(Socket client) {
            this._client = client;
        }

        public void run() {
            try {
                try {
                    httpd.this._handleClient(this._client);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this._client.close();
                    throw throwable;
                }
                this._client.close();
                {
                }
            }
            catch (SocketException se) {
                se.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
                httpd.this._servletLogFile.log("", "Handle client error", t);
            }
        }
    }

    private class ServletClassLoader
    extends ClassLoader {
        private ServletClassLoader() {
        }

        public Class findClass(String name) throws ClassNotFoundException {
            HttpServlet hs = (HttpServlet)httpd.this._servletTable.get(name);
            if (hs == null) {
                byte[] b;
                try {
                    b = this.loadClassData(name);
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException(ioe.getMessage());
                }
                return this.defineClass(name, b, 0, b.length);
            }
            Long lm = (Long)httpd.this._servletLastMod.get(name);
            URL url = this.getResource(name.replace('.', '/') + ".class");
            File f = new File(url.getFile());
            if (f.lastModified() > lm) {
                byte[] b;
                try {
                    b = this.loadClassData(name);
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException(ioe.getMessage());
                }
                return this.defineClass(name, b, 0, b.length);
            }
            return hs.getClass();
        }

        /*
         * WARNING - void declaration
         */
        private byte[] loadClassData(String name) throws IOException {
            LinkedList<Byte> list = new LinkedList<Byte>();
            InputStream in = this.getResourceAsStream(name.replace('.', '/') + ".class");
            if (in != null) {
                int ch;
                while ((ch = in.read()) != -1) {
                    void var3_4;
                    list.add(new Byte((byte)var3_4));
                }
            }
            byte[] ret = new byte[list.size()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = (Byte)list.get(i);
                ++i;
            }
            return ret;
        }
    }

    private class ServletBinding {
        private RE _re;
        private String _className;

        private ServletBinding(String expr, String className) throws Exception {
            this._re = new RE((Object)expr);
            this._className = className;
        }

        private boolean _isMatch(String uri) {
            REMatch m = this._re.getMatch((Object)uri);
            boolean ret = false;
            if (m != null && m.getStartIndex() == 0 && m.getEndIndex() == uri.length()) {
                ret = true;
            }
            return ret;
        }
    }
}

