/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.util;

public class ReadWriteLock {
    private int _readersReading = 0;
    private int _writerWriting = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readLock() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            while (this._writerWriting != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this._readersReading;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeLock() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            while (this._writerWriting != 0 || this._readersReading != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this._writerWriting;
            return;
        }
    }

    public int readUnlock() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            if (this._readersReading == 0) {
                int n = -1;
                return n;
            }
            --this._readersReading;
            if (this._readersReading == 0) {
                this.notify();
            }
        }
        return 0;
    }

    public int writeUnlock() {
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            if (this._writerWriting == 0) {
                int n = -1;
                return n;
            }
            this._writerWriting = 0;
            this.notifyAll();
        }
        return 0;
    }
}

