/*
 * Decompiled with CFR 0.152.
 */
package com.mwc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class TemplateWebPage {
    private Vector _template;
    protected Vector _content;
    private String _fileName;
    private long _lastModifyed;

    public TemplateWebPage() {
        this._template = new Vector();
        this._content = new Vector();
        this._fileName = null;
    }

    public TemplateWebPage(TemplateWebPage page) {
        TemplateWebPage templateWebPage = page;
        synchronized (templateWebPage) {
            this._template = new Vector();
            this._content = new Vector();
            int i = 0;
            while (i < page._template.size()) {
                this._template.addElement(new String(page._template.elementAt(i).toString()));
                ++i;
            }
            int i2 = 0;
            while (i2 < page._content.size()) {
                this._content.addElement(new String(page._content.elementAt(i2).toString()));
                ++i2;
            }
        }
    }

    public void loadTemplate(String fileName) throws IOException {
        this._fileName = new String(fileName);
        this._template.removeAllElements();
        this._content.removeAllElements();
        File f = new File(fileName);
        this._lastModifyed = f.lastModified();
        FileReader fin = new FileReader(fileName);
        BufferedReader bin = new BufferedReader(fin);
        String line = null;
        while ((line = bin.readLine()) != null) {
            this._template.addElement(line);
            this._content.addElement(new String(line));
        }
        fin.close();
    }

    public void expandTemplate(String name, String value) {
        StringBuffer content = null;
        int i = 0;
        while (i < this._content.size()) {
            boolean expand;
            content = new StringBuffer();
            String line = (String)this._content.elementAt(i);
            int start = 0;
            do {
                int index;
                if ((index = line.indexOf(name, start)) != -1) {
                    content.append(line.substring(start, index));
                    content.append(value);
                    start = index + name.length();
                    expand = true;
                    continue;
                }
                content.append(line.substring(start, line.length()));
                expand = false;
            } while (expand);
            this._content.setElementAt(content.toString(), i);
            ++i;
        }
    }

    public void resetToTemplate() {
        this._content = new Vector();
        int i = 0;
        while (i < this._template.size()) {
            this._content.addElement(new String(this._template.elementAt(i).toString()));
            ++i;
        }
    }

    public void reloadTemplate() throws IOException {
        if (this._fileName == null) {
            return;
        }
        TemplateWebPage templateWebPage = this;
        synchronized (templateWebPage) {
            File f = new File(this._fileName);
            long lastModifyed = f.lastModified();
            if (this._lastModifyed < lastModifyed) {
                this.loadTemplate(this._fileName);
            }
        }
    }

    public void sendTo(PrintWriter out) throws IOException {
        int i = 0;
        while (i < this._content.size()) {
            out.println((String)this._content.elementAt(i));
            ++i;
        }
        out.flush();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this._content.size()) {
            buf.append(this._content.elementAt(i).toString() + "\n");
            ++i;
        }
        return buf.toString();
    }
}

