#include <windows.h>
#include <httpext.h>
#include <stdio.h>
#include <string.h>

#define BUFFER_LENGTH 4096 

BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD fdwReason, LPVOID lpvReserved);
BOOL WINAPI GetExtensionVersion(HSE_VERSION_INFO *pVer);
BOOL WINAPI TerminateExtension(DWORD dwFlags);
DWORD WINAPI HttpExtensionProc(EXTENSION_CONTROL_BLOCK *pECB);

DWORD dwCount = 1;
const CHAR lpszMessage[] = "HelloWorld ISAPI Extension";
const TCHAR lpszHeader[] = "Content-type: text/html\r\n\r\n";   
const CHAR lpszResponse[] = 
"<HTML>\n"
"<HEAD>\n"
"<TITLE>Hello, world!</TITLE>\n"
"</HEAD>\n"
"<BODY BGCOLOR=\"WHITE\">\n"
"<H1>Hello, world!</H1>\n"
"<HR ALLCLEAR>\n"
"QUERY_STRING=%s<BR>\n"
"COUNT=%d<BR>\n"
"<HR ALLCLEAR>\n"
"</BODY>\n"
"</HTML>\n"; 

BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD fdwReason, LPVOID lpvReserved)
{
    return TRUE;
}

BOOL WINAPI GetExtensionVersion(HSE_VERSION_INFO *pVer) 
{
    pVer->dwExtensionVersion = HSE_VERSION;
    strncpy(pVer->lpszExtensionDesc, lpszMessage, sizeof(lpszMessage)-1);
    return TRUE;
}

BOOL WINAPI TerminateExtension(DWORD dwFlags)
{
    return TRUE;
}

DWORD WINAPI HttpExtensionProc(EXTENSION_CONTROL_BLOCK *pECB) 
{
    CHAR szBuffer[BUFFER_LENGTH];  
    DWORD dwBufferSize;   

    memset(szBuffer, 0, BUFFER_LENGTH);

    dwBufferSize = sizeof(lpszHeader)-1;   
    pECB->ServerSupportFunction(pECB->ConnID, 
                                HSE_REQ_SEND_RESPONSE_HEADER, 
                                NULL, 
                                &dwBufferSize, 
                                (LPDWORD)lpszHeader);   

    snprintf(szBuffer, BUFFER_LENGTH-1, lpszResponse, pECB->lpszQueryString, dwCount++);
    dwBufferSize = strlen(szBuffer);   
    pECB->WriteClient(pECB->ConnID, (PVOID)szBuffer, &dwBufferSize, 0);

    return HSE_STATUS_SUCCESS;
}