#include <stdio.h>
#include <string.h>
#include "IO.h"

/*
 * Class:     IO
 * Method:    println
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_IO_println
  (JNIEnv * env, jclass c, jstring str)
{
   const char * message;
   jboolean iscopy;
   message = (*env)->GetStringUTFChars(env, str, &iscopy);
   printf("%s\n", message);
}

/*
 * Class:     IO
 * Method:    print
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_IO_print
  (JNIEnv * env, jclass c, jstring str)
{
   printf("%s", str);
}

/*
 * Class:     IO
 * Method:    printInt
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_IO_printInt
  (JNIEnv * env, jclass c, jint i)
{
   printf("%d\n", i);
}

/*
 * Class:     IO
 * Method:    printFloat
 * Signature: (F)V
 */
JNIEXPORT void JNICALL Java_IO_printFloat
  (JNIEnv * env, jclass c, jfloat f)
{
   printf("%f\n", f);
}

/*
 * Class:     IO
 * Method:    printShort
 * Signature: (S)V
 */
JNIEXPORT void JNICALL Java_IO_printShort
  (JNIEnv * env, jclass c, jshort ch)
{
   printf("%d\n", (int)ch);
}

/*
 * Class:     IO
 * Method:    printLong
 * Signature: (J)V
 */
JNIEXPORT void JNICALL Java_IO_printLong
  (JNIEnv * env, jclass c, jlong l)
{
   printf("%ld\n", l);
}

/*
 * Class:     IO
 * Method:    printDouble
 * Signature: (D)V
 */
JNIEXPORT void JNICALL Java_IO_printDouble
  (JNIEnv * env, jclass c, jdouble d)
{
   printf("%f\n", d);
}

/*
 * Class:     IO
 * Method:    printChar
 * Signature: (C)V
 */
JNIEXPORT void JNICALL Java_IO_printChar
  (JNIEnv * env, jclass c, jchar ch)
{
   printf("%c\n", ch);
}

/*
 * Class:     IO
 * Method:    printBoolean
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_IO_printBoolean
  (JNIEnv * env, jclass c, jboolean b)
{
   if(b == 0) {
      printf("false\n");
   }
   else {
      printf("true\n");
   }
}

/*
 * Class:     IO
 * Method:    printByte
 * Signature: (B)V
 */
JNIEXPORT void JNICALL Java_IO_printByte
  (JNIEnv * env, jclass c, jbyte b)
{
   printf("%d\n", (int)b);
}

