import org.apache.bcel.generic.*;
import org.apache.bcel.classfile.*;
import org.apache.bcel.Constants;
import java.util.*;
import java.io.*;

/**
 * Simple Byte code assembly language based off of the BCEL.
 * 
 * @author Matthew W. Coan (July 1, 2002) matthewcoan@hotmail.com
 */
public class dis_asm implements InstructionConstants {
   public final static byte ACONST_NULL = (byte)0x01;

   public final static byte BASTORE = (byte)0x54;
   public final static byte BALOAD = (byte)0x33;
   public final static byte DALOAD = (byte)0x31;
   public final static byte DASTORE = (byte)0x52;
   public final static byte FASTORE = (byte)0x51;
   public final static byte FALOAD = (byte)0x30;
   public final static byte SASTORE = (byte)0x56;
   public final static byte SALOAD = (byte)0x35;
   public final static byte CASTORE = (byte)0x55;
   public final static byte CALOAD = (byte)0x34;

   public final static byte LASTORE = (byte)0x50;
   public final static byte LALOAD = (byte)0x2F;

   public final static byte AALOAD = (byte)0x32;
   public final static byte AASTORE = (byte)0x53;
   public final static byte NEWARRAY = (byte)0xBC;
   public final static byte ANEWARRAY = (byte)0xBD;
   public final static byte ARRAYLENGTH = (byte)0xBE;
   public final static byte IASTORE = (byte)0x4F;
   public final static byte IALOAD = (byte)0x2E;

   public final static byte I2L = (byte)0x85;
   public final static byte I2F = (byte)0x86;
   public final static byte I2D = (byte)0x87;
   public final static byte L2I = (byte)0x88;
   public final static byte L2F = (byte)0x89;
   public final static byte L2D = (byte)0x8A;
   public final static byte F2I = (byte)0x8B;
   public final static byte F2L = (byte)0x8C;
   public final static byte F2D = (byte)0x8D;
   public final static byte D2I = (byte)0x8E;
   public final static byte D2L = (byte)0x8F;
   public final static byte D2F = (byte)0x90;
   public final static byte I2B = (byte)0x91;
   public final static byte I2C = (byte)0x92;
   public final static byte I2S = (byte)0x93;

   public final static byte DCMPG = (byte)0x98;
   public final static byte DCMPL = (byte)0x97;
   public final static byte FCMPG = (byte)0x96;
   public final static byte FCMPL = (byte)0x95;
   public final static byte LCMP = (byte)0x94;

   public final static byte IFEQ = (byte)0x99;
   public final static byte IFNE = (byte)0x9A;
   public final static byte IFLT = (byte)0x9B;
   public final static byte IFGE = (byte)0x9C;
   public final static byte IFGT = (byte)0x9D;
   public final static byte IFLE = (byte)0x9E;
   public final static byte IFNONNULL = (byte)0xC7;
   public final static byte IFNULL = (byte)0xC6;

   public final static byte LSHL = (byte)0x79;
   public final static byte LSHR = (byte)0x7B;
   public final static byte LOR =  (byte)0x81;
   public final static byte LAND = (byte)0x7F;
   public final static byte LXOR = (byte)0x83;

   public final static byte LCONST_0 = (byte)0x09;
   public final static byte LCONST_1 = (byte)0x0A;

   public final static byte ISHL = (byte)0x78;
   public final static byte ISHR = (byte)0x7A;
   public final static byte IOR =  (byte)0x80;
   public final static byte IAND = (byte)0x7E;
   public final static byte IXOR = (byte)0x82;

   public final static byte DADD = (byte)0x63;
   public final static byte DSUB = (byte)0x67;
   public final static byte DMUL = (byte)0x6B;
   public final static byte DDIV = (byte)0x6F;
   public final static byte DREM = (byte)0x73;
   public final static byte DNEG = (byte)0x77;

   public final static byte DLOAD_3 = (byte)0x29;
   public final static byte DLOAD_2 = (byte)0x28;
   public final static byte DLOAD_1 = (byte)0x27;
   public final static byte DLOAD_0 = (byte)0x26;
   public final static byte DLOAD = (byte)0x18;

   public final static byte DSTORE_3 = (byte)0x4A;
   public final static byte DSTORE_2 = (byte)0x49;
   public final static byte DSTORE_1 = (byte)0x48;
   public final static byte DSTORE_0 = (byte)0x47;
   public final static byte DSTORE = (byte)0x39;

   public final static byte LADD = (byte)0x61;
   public final static byte LSUB = (byte)0x65;
   public final static byte LMUL = (byte)0x69;
   public final static byte LDIV = (byte)0x6D;
   public final static byte LREM = (byte)0x71;
   public final static byte LNEG = (byte)0x75;

   public final static byte LDC2_W = (byte)0x14;

   public final static byte LLOAD_3 = (byte)0x21;
   public final static byte LLOAD_2 = (byte)0x20;
   public final static byte LLOAD_1 = (byte)0x1F;
   public final static byte LLOAD_0 = (byte)0x1E;
   public final static byte LLOAD = (byte)0x16;

   public final static byte LSTORE_3 = (byte)0x42;
   public final static byte LSTORE_2 = (byte)0x41;
   public final static byte LSTORE_1 = (byte)0x40;
   public final static byte LSTORE_0 = (byte)0x3F;
   public final static byte LSTORE = (byte)0x37;

   public final static byte RETURN = -79;
   public final static byte POP = 87;
   public final static byte IPUSH = 16;
   public final static byte LDC = 18;
   public final static byte ICONST = 4;
   public final static byte ICONST_0 = 3;
   public final static byte ICONST_1 = 4;
   public final static byte ICONST_2 = 5;
   public final static byte ICONST_3 = 6;
   public final static byte ICONST_4 = 7;
   public final static byte ICONST_5 = 8;
   public final static byte ISTORE_3 = (byte)0x3E;
   public final static byte ISTORE_2 = (byte)0x3D;
   public final static byte ISTORE_1 = (byte)0x3C;
   public final static byte ISTORE_0 = (byte)0x3B;
   public final static byte ISTORE = 54;
   public final static byte ILOAD_3 = (byte)0x1D;
   public final static byte ILOAD_2 = (byte)0x1C;
   public final static byte ILOAD_1 = (byte)0x1B;
   public final static byte ILOAD_0 = (byte)0x1A;
   public final static byte ILOAD = 21;
   public final static byte ALOAD = (byte)0x19;
   public final static byte ALOAD_0 = (byte)0x2A;
   public final static byte ALOAD_1 = 43;
   public final static byte ALOAD_2 = (byte)0x2C;
   public final static byte ALOAD_3 = (byte)0x2D;
   public final static byte ASTORE = (byte)0x3A;
   public final static byte ASTORE_0 = (byte)0x4B;
   public final static byte ASTORE_1 = (byte)0x4C;
   public final static byte ASTORE_2 = (byte)0x4D;
   public final static byte ASTORE_3 = (byte)0x4E;
   public final static byte IADD = (byte)0x60;
   public final static byte ISUB = (byte)0x64;
   public final static byte IMUL = (byte)0x68;
   public final static byte IDIV = (byte)0x6C;
   public final static byte IREM = (byte)0x70;
   public final static byte INEG = (byte)0x74;

   public final static byte IF_ACMPEQ = (byte)0xA5;
   public final static byte IF_ACMPNE = (byte)0xA6;

   public final static byte IF_ICMPEQ = (byte)0x9F;
   public final static byte IF_ICMPNE = (byte)0xA0;
   public final static byte IF_ICMPLT = (byte)0xA1;
   public final static byte IF_ICMPGE = (byte)0xA2;
   public final static byte IF_ICMPGT = (byte)0xA3;
   public final static byte IF_ICMPLE = (byte)0xA4;
   public final static byte GOTO = (byte)0xA7;
   public final static byte INVOKESTATIC = -72;
   public final static byte INVOKEVIRTUAL = -74;
   public final static byte INVOKESPECIAL = -73;
   public final static byte IINC = (byte)0x84;
   public final static byte NEW = -69;
   public final static byte DUP = 89;
   public final static byte PUTFIELD = (byte)0xB5;
   public final static byte GETFIELD = (byte)0xB4;
   public final static byte GETSTATIC = (byte)0xB2;
   public final static byte PUTSTATIC = (byte)0xB3;
   public final static byte FLOAD = (byte)0x17;
   public final static byte FLOAD_0 = (byte)0x22;
   public final static byte FLOAD_1 = 35;
   public final static byte FLOAD_2 = (byte)0x24;
   public final static byte FLOAD_3 = (byte)0x25;
   public final static byte FSTORE = (byte)0x38;
   public final static byte FSTORE_0 = (byte)0x43;
   public final static byte FSTORE_1 = (byte)0x44;
   public final static byte FSTORE_2 = (byte)0x45;
   public final static byte FSTORE_3 = (byte)0x46;
   public final static byte FADD = (byte)0x62;
   public final static byte FSUB = (byte)0x66;
   public final static byte FMUL = (byte)0x6A;
   public final static byte FDIV = (byte)0x6E;
   public final static byte FREM = (byte)0x72;
   public final static byte FNEG = (byte)0x76;

   public static String toTypeName(String t) {
      if(t.equals("I")) 
         return "int";
      return t;
   }

   public static String toASM(String str) {
      String returnValue = new String();
      StringTokenizer it = new StringTokenizer(str, " ");
      if(it.hasMoreTokens()) { 
         String first = it.nextToken();
         if(it.hasMoreTokens()) {
            String second = it.nextToken();

            returnValue = first + " " + second;
         }
      }
      return returnValue;
   }

   public static int count_param(String str) {
      int count = 0;
      for(int i = 0; i < str.length(); i++) {
         if(str.charAt(i) == ';') {
            count++;
         }
      }
      return count;
   }

   public static String get_type(int type_byte) {
      String ret = "";
//System.out.println("get_type: " + type_byte);
//try { System.in.read(); } catch(Exception ex) { }
      switch(type_byte) {
      case 10:
      ret = "int";
      break;

      case 9:
      ret = "short";
      break;

      case 8:
      ret = "byte";
      break;

      case 7:
      ret = "double";
      break;

      case 6:
      ret = "float";
      break;

      case 5:
      ret = "char";
      break;

      case 4:
      ret = "boolean";
      break;

      default:
      ret = "unknown";
      }
      return ret; 
   }

   public static void main(String args[]) throws Exception {
      ClassParser parser = new ClassParser(args[0]);

      JavaClass cls = parser.parse();

      ConstantPool cp = cls.getConstantPool();

      System.out.println("CLASS_NAME: " + cls.getClassName());

      System.out.flush();

      Method array[] = cls.getMethods();
      Field array2[] = cls.getFields();

      PrintWriter out = new PrintWriter(new FileWriter(args[1]));

      out.println(".class " + cls.getClassName());
      out.println(".access public");
      out.println();

      out.println(".modifiers");
      out.println();

      out.println(".extends java.lang.Object");
      out.println(".implements");
      out.println();
      int maxStack = 0;
      String temp1 = "temp1";
      String temp2 = "temp2";
      String temp3 = "temp3";


      String name,type;

      for(int i = 0; i < array2.length; i++) {
         name = array2[i].getName();
         type = array2[i].getType().toString();
         out.println(".field " + name);
         out.println(".access public");
         out.println(".modifiers");
         out.println(".type " + type);
         out.println();
         out.flush();
      }

      for(int i = 0; i < array.length; i++) {
         temp1 = "temp1";
         temp2 = "temp2";
         temp3 = "temp3";
         //if(array[i].getName().compareTo("<init>") == 0) 
         //   continue;

         System.out.println("METHOD: " + array[i].getName());

         System.out.flush();

         Code code_obj = array[i].getCode();

         if(code_obj == null) {
            out.println(".method " + array[i].getName());
            MethodGen mg = new MethodGen(array[i], cls.getClassName(), new ConstantPoolGen(cp));
            maxStack = mg.getMaxStack();
            maxStack += count_param(array[i].getSignature());
            out.println(".maxStack " + maxStack);
            out.println(".access public");
            if(array[i].isNative()) {
               out.println(".modifiers static native");
            }
            else {
               out.println(".modifiers static");
            }
            out.println(".signature " + array[i].getSignature());
            out.println(".args args");
            out.println();

            out.println();
            out.println(".data");
            out.println(".code");
            out.println(".end");
            out.println();
            continue;
         }

         LocalVariableTable tbl = code_obj.getLocalVariableTable();

         Type[] args2 = Type.getArgumentTypes(array[i].getSignature());

         out.println(".method " + array[i].getName());
         MethodGen mg = new MethodGen(array[i], cls.getClassName(), new ConstantPoolGen(cp));
         maxStack = mg.getMaxStack();
         maxStack += count_param(array[i].getSignature());

/*
System.out.println("mg.getMaxStack() == " + mg.getMaxStack());
System.out.println("count_param() == " + count_param(array[i].getSignature()));
System.out.println("signature == " + (array[i].getSignature()));
System.out.println("CLASS_NAME=" + cls.getClassName());
System.out.println("MAX_STACK=" + maxStack);
System.out.println();
try { System.in.read(); } catch(Exception ex) { }
*/

         out.println(".maxStack " + maxStack);
         out.println(".access public");
         if(array[i].getName().equals("main")) {
            out.println(".modifiers static");
         } 
         else {
            out.println(".modifiers");
         }
         out.println(".signature " + array[i].getSignature());
         out.println(".args args");
         out.println();

         out.println();
         out.println(".data");

         if(tbl != null) {
            int ii = 0;
            int index = 1;
            for(int k = args2.length; k < tbl.getTableLength(); k++) {
               out.println("\t" + toTypeName(tbl.getLocalVariable(k).getSignature()) + " " + tbl.getLocalVariable(k).getName());
               switch(k) {
                  case 1:
                  temp1 = tbl.getLocalVariable(k).getName();
                  break;

                  case 2:
                  temp2 = tbl.getLocalVariable(k).getName();
                  break;

                  case 3:
                  temp3 = tbl.getLocalVariable(k).getName();
                  break;
               }
            }
            while((tbl.getTableLength() + ii) < maxStack) {
               out.println("\tint temp");
               ii++;
               index++;
            }
         }
         else {
            int index = 1;
            int ii = 0;
            while(ii < maxStack) {
               out.println("\tint temp" + index);
               ii++;
               index++;
            }
         }

         if(maxStack == 0) {
            out.println("\tint the_this");
         }

         out.println(".code");

         byte code[] = code_obj.getCode(); 

         System.out.println("---");

         for(int k = 0; k < code.length; k++) {
            System.out.println(code[k]);

            System.out.flush();
         }

         System.out.println("---");
         System.out.flush();

         System.out.println(code_obj.toString());
         System.out.flush();

         System.out.println("---");
         System.out.flush();

         for(int j = 0; j < code.length; j++) {
System.out.println("code=" + code[j]);
System.out.println("j=" + j);
            out.print("L" + j);
            out.print("\t");
            if(code[j] == RETURN) {
               out.println("return");
            }
            else if(code[j] == POP) {
               out.println("pop");
            }
            else if(code[j] == IPUSH) {
               out.println("ipush " + code[j+1]);
               j++;
            }
            else if(code[j] == LDC2_W) {
               int index = (code[j+1] << 8) + code[j+2];
               Constant c = cp.getConstant(index);
               out.println("ldc2_w " + cp.constantToString(c));
               j++;
               j++;
            }
            else if(code[j] == LDC) {
               Constant c = cp.getConstant((int)code[j+1]);
               out.println("ldc " + cp.constantToString(c));
               j++;
            }
            else if(code[j] == ILOAD) {
               out.println("iload " + "temp" + (int)code[j+1]/*tbl.getLocalVariable(code[j]-27+args2.length).getName()*/);
               j++;
            }
            else if(code[j] == IINC) {
               out.println("iinc temp" + (int)code[j+1] + " " + (int)code[j+2]);
               j += 2;
            }
            else if(code[j] == GOTO) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("goto L" + (j + (byte)address));
               j += 2;
            }

            else if(code[j] == DLOAD) {
               out.println("dload temp" + code[j+1]);
               j++;
            }
            else if(code[j] == DLOAD_0) {
               out.println("dload_0");
            }
            else if(code[j] == DLOAD_1) {
               out.println("dload_1");
            }
            else if(code[j] == DLOAD_2) {
               out.println("dload_2");
            }
            else if(code[j] == DLOAD_3) {
               out.println("dload_3");
            }

            else if(code[j] == DSTORE) {
               out.println("dstore temp" + code[j+1]);
               j++;
            }
            else if(code[j] == DSTORE_0) {
               out.println("dstore_0");
            }
            else if(code[j] == DSTORE_1) {
               out.println("dstore_1");
            }
            else if(code[j] == DSTORE_2) {
               out.println("dstore_2");
            }
            else if(code[j] == DSTORE_3) {
               out.println("dstore_3");
            }

            else if(code[j] == ISHL) {
               out.println("ishl");
            }
            else if(code[j] == ISHR) {
               out.println("ishr");
            }
            else if(code[j] == IAND) {
               out.println("iand");
            }
            else if(code[j] == IOR) {
               out.println("ior");
            }
            else if(code[j] == IXOR) {
               out.println("ixor");
            }

            else if(code[j] == DCMPG) {
               out.println("dcmpg");
            }
            else if(code[j] == DCMPL) {
               out.println("dcmpl");
            }
            else if(code[j] == FCMPG) {
               out.println("fcmpg");
            }
            else if(code[j] == FCMPL) {
               out.println("fcmpl");
            }
            else if(code[j] == LCMP) {
               out.println("lcmp");
            }

            else if(code[j] == ACONST_NULL) {
               out.println("aconst_null");
            }

/*
   public final static byte BASTORE = (byte)0x54;
   public final static byte BALOAD = (byte)0x33;
   public final static byte DALOAD = (byte)0x31;
   public final static byte DASTORE = (byte)0x52;
   public final static byte FASTORE = (byte)0x51;
   public final static byte FALOAD = (byte)0x30;
   public final static byte SASTORE = (byte)0x56;
   public final static byte SASLOAD = (byte)0x35;
   public final static byte CASTORE = (byte)0x55;
   public final static byte CALOAD = (byte)0x34;
*/
            else if(code[j] == LASTORE) {
               out.println("lastore");
            }
            else if(code[j] == LALOAD) {
               out.println("laload");
            }

            else if(code[j] == BASTORE) {
               out.println("bastore");
            }
            else if(code[j] == BALOAD) {
               out.println("baload");
            }

            else if(code[j] == DASTORE) {
               out.println("dastore");
            }
            else if(code[j] == DALOAD) {
               out.println("daload");
            }

            else if(code[j] == FALOAD) {
               out.println("faload");
            }
            else if(code[j] == FASTORE) {
               out.println("fastore");
            }

            else if(code[j] == SASTORE) {
               out.println("sastore");
            }
            else if(code[j] == SALOAD) {
               out.println("saload");
            }

            else if(code[j] == CALOAD) {
               out.println("caload");
            }
            else if(code[j] == CASTORE) {
               out.println("castore");
            }


/*
   public final static byte AALOAD = (byte)0x32;
   public final static byte AASTORE = (byte)0x53;
   public final static byte NEWARRAY = (byte)0xBC;
   public final static byte ANEWARRAY = (byte)0xBD;
   public final static byte ARRAYLENGTH = (byte)0xBE;
   public final static byte IASTORE = (byte)0x4F;
   public final static byte IALOAD = (byte)0x2E;
*/
            else if(code[j] == AALOAD) {
               out.println("aaload");
            }
            else if(code[j] == AASTORE) {
               out.println("aaload");
            }
            else if(code[j] == NEWARRAY) {
               out.println("newarray " + get_type(code[j+1]));
               j++;
            }
            else if(code[j] == ANEWARRAY) {
               byte c1 = code[j+1];
               byte c2 = code[j+2];
               int index = (c1 << 8) + c2;
               Constant c = cp.getConstant(index);
               String temp = cp.constantToString(c);

               out.println("anewarray " + temp);
               j += 2;
            }
            else if(code[j] == ARRAYLENGTH) {
               out.println("arraylength");
            }
            else if(code[j] == IASTORE) {
               out.println("iastore");
            }
            else if(code[j] == IALOAD) {
               out.println("iaload");
            }


            else if(code[j] == I2L) {
               out.println("i2l");
            }
            else if(code[j] == I2F) {
               out.println("i2f");
            }
            else if(code[j] == I2D) {
               out.println("i2d");
            }
            else if(code[j] == L2I) {
               out.println("i2d");
            }
            else if(code[j] == L2F) {
               out.println("l2f");
            }
            else if(code[j] == L2D) {
               out.println("l2d");
            }
            else if(code[j] == F2I) {
               out.println("f2i");
            }
            else if(code[j] == F2L) {
               out.println("f2l");
            }
            else if(code[j] == F2D) {
               out.println("f2d");
            }
            else if(code[j] == D2I) {
               out.println("d2i");
            }
            else if(code[j] == D2L) {
               out.println("d2l");
            }
            else if(code[j] == D2F) {
               out.println("d2f");
            }
            else if(code[j] == I2B) {
               out.println("i2b");
            }
            else if(code[j] == I2C) {
               out.println("i2c");
            }
            else if(code[j] == I2S) {
               out.println("i2s");
            }


            else if(code[j] == IFEQ) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("ifeq L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IFNE) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("ifne L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IFLT) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("iflt L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IFGE) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("ifge L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IFGT) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("ifgt L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IFLE) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("ifle L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IFNONNULL) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("ifnonnull L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IFNULL) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("ifnull L" + (j + (byte)address));
               j += 2;
            }

            else if(code[j] == LSHL) {
               out.println("lshl");
            }
            else if(code[j] == LSHR) {
               out.println("lshr");
            }
            else if(code[j] == LAND) {
               out.println("land");
            }
            else if(code[j] == LOR) {
               out.println("lor");
            }
            else if(code[j] == LXOR) {
               out.println("lxor");
            }



            else if(code[j] == LLOAD) {
               out.println("lload temp" + code[j+1]);
               j++;
            }
            else if(code[j] == LLOAD_0) {
               out.println("lload_0");
            }
            else if(code[j] == LLOAD_1) {
               out.println("lload_1");
            }
            else if(code[j] == LLOAD_2) {
               out.println("lload_2");
            }
            else if(code[j] == LLOAD_3) {
               out.println("lload_3");
            }

            else if(code[j] == LSTORE) {
               out.println("lstore temp" + code[j+1]);
               j++;
            }
            else if(code[j] == LSTORE_0) {
               out.println("lstore_0");
            }
            else if(code[j] == LSTORE_1) {
               out.println("lstore_1");
            }
            else if(code[j] == LSTORE_2) {
               out.println("lstore_2");
            }
            else if(code[j] == LSTORE_3) {
               out.println("lstore_3");
            }

            else if(code[j] == ILOAD_0) {
               out.println("iload temp0");
            }
            else if(code[j] == ILOAD_1) {
               out.println("iload temp1");
            }
            else if(code[j] == ILOAD_2) {
               out.println("iload temp2");
            }
            else if(code[j] == ILOAD_3) {
               out.println("iload temp3");
            }

            else if(code[j] == ASTORE_0) {
               out.println("astore temp0");
            }
            else if(code[j] == ASTORE_1) {
               out.println("astore temp1");
            }
            else if(code[j] == ASTORE_2) {
               out.println("astore temp2");
            }
            else if(code[j] == ASTORE_3) {
               out.println("astore temp3");
            }

            else if(code[j] == ISTORE_0) {
               out.println("istore temp0");
            }
            else if(code[j] == ISTORE_1) {
               out.println("istore temp1");
            }
            else if(code[j] == ISTORE_2) {
               out.println("istore temp2");
            }
            else if(code[j] == ISTORE_3) {
               out.println("istore temp3");
            }
            else if(code[j] == ISTORE) {
               out.println("istore temp" + (int)code[j+1]/*tbl.getLocalVariable(code[j]-60+args2.length).getName()*/);
               j++;
            }
            else if(code[j] == ASTORE) {
               out.println("astore temp" + (int)code[j+1]/*+ tbl.getLocalVariable((int)code[j+1]).getName()*/);
               j++;
            }
            else if(code[j] == ALOAD) {
               out.println("aload temp" + (int)code[j+1]/* tbl.getLocalVariable((int)code[j+1]).getName()*/);
               j++;
            }
            else if(code[j] == ALOAD_0) {
               out.println("aload temp0");
            }
            else if(code[j] == ALOAD_1) {
               out.println("aload temp1");
            }
            else if(code[j] == ALOAD_2) {
               out.println("aload temp2");
            }
            else if(code[j] == ALOAD_3) {
               out.println("aload temp3");
            }
            else if(code[j] == DUP) {
               out.println("dup");
            }
            else if(code[j] == PUTSTATIC) {
               byte c1 = code[j+1];
               byte c2 = code[j+2];
               int index = (c1 << 8) + c2;
               Constant c = cp.getConstant(index);
               String temp = cp.constantToString(c);
               out.println("putstatic " + temp);
               j += 2;
            }
            else if(code[j] == GETSTATIC) {
               byte c1 = code[j+1];
               byte c2 = code[j+2];
               int index = (c1 << 8) + c2;
               Constant c = cp.getConstant(index);
               String temp = cp.constantToString(c);
               out.println("getstatic " + temp);
               j += 2;
            }
            else if(code[j] == GETFIELD) {
               byte c1 = code[j+1];
               byte c2 = code[j+2];
               int index = (c1 << 8) + c2;
               Constant c = cp.getConstant(index);
               String temp = cp.constantToString(c);
               out.println("getfield " + temp);
               j += 2;
            }
            else if(code[j] == PUTFIELD) {
               byte c1 = code[j+1];
               byte c2 = code[j+2];
               int index = (c1 << 8) + c2;
               Constant c = cp.getConstant(index);
               String temp = cp.constantToString(c);
               out.println("putfield " + temp);
               j += 2;
            }
            else if(code[j] == NEW) {
               byte c1 = code[j+1];
               byte c2 = code[j+2];
               int index = ((c1 << 8) + c2);
               Constant c = cp.getConstant(index);
               String temp = cp.constantToString(c);
               out.println("new " + temp);
               j += 2;
            }

            else if(code[j] == LCONST_0) {
               out.println("lconst_0");
            }
            else if(code[j] == LCONST_1) {
               out.println("lconst_1");
            }

            else if(code[j] == ICONST_0) {
               out.println("ipush 0");
            }
            else if(code[j] == ICONST_1) {
               out.println("ipush 1");
            }
            else if(code[j] == ICONST_2) {
               out.println("ipush 2");
            }
            else if(code[j] == ICONST_3) {
               out.println("ipush 3");
            }
            else if(code[j] == ICONST_4) {
               out.println("ipush 4");
            }
            else if(code[j] == ICONST_5) {
               out.println("ipush 5");
            }
            else if(code[j] == ICONST) {
               out.println("ipush " + code[j+1]);
               j++;
            }
            else if(code[j] == IF_ACMPEQ) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_acmpeq L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IF_ACMPNE) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_acmpne L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IF_ICMPEQ) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_icmpeq L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IF_ICMPNE) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_icmpne L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IF_ICMPLT) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_icmplt L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IF_ICMPGT) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_icmpgt L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IF_ICMPLE) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_icmple L" + (j + (byte)address));
               j += 2;
            }
            else if(code[j] == IF_ICMPGE) {
               int address = (code[j+1] << 8) + code[j+2];
               out.println("if_icmpge L" + (j + (byte)address));
               j += 2;
            }

            else if(code[j] == LADD) {
               out.println("ladd");
            }
            else if(code[j] == LSUB) {
               out.println("lsub");
            }
            else if(code[j] == LMUL) {
               out.println("lmul");
            }
            else if(code[j] == LDIV) {
               out.println("ldiv");
            }
            else if(code[j] == LREM) {
               out.println("lrem");
            }
            else if(code[j] == LNEG) {
               out.println("lneg");
            }

            else if(code[j] == DADD) {
               out.println("dadd");
            }
            else if(code[j] == DSUB) {
               out.println("dsub");
            }
            else if(code[j] == DMUL) {
               out.println("dmul");
            }
            else if(code[j] == DDIV) {
               out.println("ddiv");
            }
            else if(code[j] == DREM) {
               out.println("drem");
            }
            else if(code[j] == DNEG) {
               out.println("dneg");
            }


            else if(code[j] == IADD) {
               out.println("iadd");
            }
            else if(code[j] == ISUB) {
               out.println("isub");
            }
            else if(code[j] == IMUL) {
               out.println("imul");
            }
            else if(code[j] == IDIV) {
               out.println("idiv");
            }
            else if(code[j] == IREM) {
               out.println("irem");
            }
            else if(code[j] == INEG) {
               out.println("ineg");
            }
            else if(code[j] == FNEG) {
               out.println("fneg");
            }
            else if(code[j] == FCMPG) {
               out.println("fcmpg");
            }
            else if(code[j] == FADD) {
               out.println("fadd");
            }
            else if(code[j] == FSUB) {
               out.println("fsub");
            }
            else if(code[j] == FMUL) {
               out.println("fmul");
            }
            else if(code[j] == FDIV) {
               out.println("fdiv");
            }
            else if(code[j] == FREM) {
               out.println("frem");
            }
            else if(code[j] == FLOAD) { 
               out.println("fload");
            }
            else if(code[j] == FLOAD_0) {
               out.println("fload_0");
            }
            else if(code[j] == FLOAD_1) {
               out.println("fload_1");
            }
            else if(code[j] == FLOAD_2) {
               out.println("fload_2");
            }
            else if(code[j] == FLOAD_3) {
               out.println("fload_3");
            }
            else if(code[j] == FSTORE) {
               out.println("fstore");
            }
            else if(code[j] == FSTORE_0) {
               out.println("fstore_0");
            }
            else if(code[j] == FSTORE_1) {
               out.println("fstore_1");
            }
            else if(code[j] == FSTORE_2) {
               out.println("fstore_2");
            }
            else if(code[j] == FSTORE_3) {
               out.println("fstore_3");
            }
            else if(code[j] == INVOKESTATIC) {
               int index = ((code[j+1] * 64) + code[j+2]);
System.out.println("****************");
System.out.println("index=" + index);
System.out.println("****************");
               out.println("invokestatic " + toASM(cp.constantToString(cp.getConstant(index))));
               j += 2;
            }
            else if(code[j] == INVOKEVIRTUAL) {
               int index = ((code[j+1] * 64) + code[j+2]);
               out.println("invokevirtual " + toASM(cp.constantToString(cp.getConstant(index))));
               j += 2;
            }
            else if(code[j] == INVOKESPECIAL) {
               if(tbl != null) {
                  out.println("invokespecial " + tbl.getLocalVariable(code[j+1]).getName() + ", %" + code[j+2]);
               }
               else {
                  int index = ((code[j+1] * 64) + code[j+2]);
                  out.println("invokespecial " /*+ toASM(tbl.getLocalVariable(code[j+1]).getName()) + ",  */
                              + toASM(cp.constantToString(cp.getConstant(index))));
               }
               j += 2;
            }
            else {
               out.println(code[j]);
               System.out.println("Bad instruciton...");
               System.out.println("end j=" + j);
               System.out.println(code[j]);
               System.exit(1);
            }
         }
         out.println(".end");
         out.println();
      }
      System.err.println("done dis_asm...");
      out.flush();
      out.close();
   }
}


