#include <iostream>
#include <fstream>
#include "ClassFile.h"

using namespace std;
using namespace java;

class DISASM {
   string class_name;
   ClassFile cf;

public:
   DISASM(const string & class_name) 
   : cf(class_name) {
      this->class_name = class_name;
   }

   ~DISASM() {

   }

   void run() {
      string fn = class_name + ".class";
      ifstream fin(fn.c_str(), ios::in | ios::binary);

      if(fin) {
         cf.read(fin);
         fin.close();
      }

      cf.write_asm(cout);
   }
};

int
main(int argc, char ** argv)
{
   if(argc != 2) {
      cerr << "usage: " << argv[0] << " <class>" << endl;
      exit(1);
   }

   try {
      DISASM disasm(argv[1]);
      disasm.run();
   }
   catch(...) {
      cerr << "error..." << endl;
      exit(1);
   }

   return 0;
}
