#define __WIN32__
#define _UNICODE
#define UNICODE
typedef long off64_t;
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef __WIN32__
#include <unistd.h>
#include <signal.h>
#endif
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <iostream>
#include <fstream>
#include <string>
#include <list>
#include "cgi.h"
#include "csv.h"
#include "config.h"
#include "properties_file.h"

namespace message_board {

using namespace csv_reader;
using namespace util_tools;
using namespace cgi_tools;

#ifdef __WIN32__
#define strcasecmp _stricmp
/*
#define LOCK_SH F_SETLKW
#define LOCK_EX F_SETLKW
#define LOCK_UN F_UNLCK
*/
extern "C" {
extern int _stricmp(const char * arg1, const char * arg2);
}
#endif

//
/*

*/
//
// Author : Matthew William Coan
// Date   : Sat Nov 11 08:19:41 EST 2006
//
//

// url encode a string
string urlncode(const string & str);

// handler function type
typedef void (*function_type)(CGI & form_data);

// version string
const char * VERSION_STRING = "CGI Message Board Version 3.0.0";

/*
class MessageBoardWebApp {
   CGI form_data;
public:
   void run();
   bool print_header();
   bool print_footer();
   void version_function();
   void show_topic_tree();
   void show_message_board();
   void show_message();
   void post_message();
   void show_post_message_form();
   void show_search_form();
   void message_search();
   void show_signup_form();
   void signup();
};
*/

inline
bool
print_header()
{
/********************
   bool ret;

   if(system("php5 /var/www/common/header.php") == 0) {
      ret = true;
   }
   else {
      ret = false;
   }

   return ret;
********************/

   return true;
}

inline 
bool
print_footer()
{
/****
   bool ret;

   if(system("php5 /var/www/common/footer.php") == 0) {
      ret = true;
   }
   else {
      ret = false;
   }

   return ret;
****/

   return true;
}

// version function
void
version_function(CGI & form_data)
{
   if(form_data["in_page"] == 0) {
      cout << "<HTML><HEAD><TITLE>" << VERSION_STRING  << endl
           << "</TITLE><link rel=\"stylesheet\" href=\"/~mcoan/style.css\">"
           << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" 
           << "</HEAD><BODY BGCOLOR=\"WHITE\">" << endl
           << "<FONT FACE=\"Arial\">" << endl << flush;
   }
   else {
      cout << "<FONT FACE=\"Arial\">" << endl << flush;
   }

   print_header();

   cout << "VERSION: " << VERSION_STRING << endl << flush;
   cout << "<BR>" << endl;
   cout << "BUILD DATE: " << __DATE__ << " " << __TIME__ << "<BR>" << endl << flush; 

   print_footer();

   if(form_data["in_page"] == 0) {
      cout << "</FONT>" << endl
      <<  "</BODY></HTML>" << endl << flush;
   }
   else {
      cout << "</FONT>" << endl << flush;
   }
}

// tree node class
class tree_node {
public:
   typedef list< tree_node * > node_list_type;
   enum node_type { NODE, MESSAGE_BOARD };
private:
   string _name;
   node_type _node_type;
   node_list_type _child_list;
   long _id;
public:
   tree_node() {
      _node_type = NODE;
      _id = 0;
   }

   tree_node(const string & name, 
        const node_type n, long id) { 
      _name = name;
      _node_type = n;
      _id = id;
   }

   tree_node(const tree_node & n) {
      _name = n._name;
      _node_type = n._node_type;
      _child_list = n._child_list;
      _id = n._id;
   }

   ~tree_node() { 
      for(node_list_type::iterator p = _child_list.begin();
          p != _child_list.end(); p++) {
         delete (*p);
      }

      _child_list.clear();
   }

   tree_node & operator=(const tree_node & right) {
      _name = right._name;

      _child_list = right._child_list;

      _node_type = right._node_type;

      _id = right._id;

      return *this;
   }

   void add_child(tree_node * node) {
      _child_list.push_back(node);
   }

   const char * name() { return _name.c_str(); }

   node_list_type &  child_list() { return _child_list; }

   node_type type() { return _node_type; }

   long id() { return _id; }
};

typedef list< string > string_list_type;

string
get(string_list_type & path, int index)
{
   int i = 0;
   for(string_list_type::iterator p = path.begin(); p != path.end();
       p++) {
      if(i == index)
         return (*p);

      i++;
   }

   return string();
}

// print tree listing
void
print_tree(tree_node * p_node, 
      string_list_type & path, 
      string path2, 
      string last,
      int depth = 0)
{

   if((depth - 1) >= 0) {
      if(last != get(path, depth - 1)) {
         return;
      }
   }

   string temp = urlncode(path2);

   for(int i = 0; i <= depth; i++) {
      cout << "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
   }

   if(p_node->type() == tree_node::NODE) {
      cout << "<A HREF=\"" << CGI_URL << "function_code=1&"
           << "path=" << temp
           << "\"><IMG BORDER=\"0\" SRC=\"" << FOLDER_IMG << "\"> /" 
           << p_node->name() 
           << "</A><BR>" << endl << flush;
   }
   else {
      cout << "<A HREF=\"" << CGI_URL << "function_code=2&"
           << "path=" << temp 
           << "&id=" << p_node->id() << "\"><IMG BORDER=\"0\" SRC=\"" << FILE_IMG << "\"> /" 
           << p_node->name() 
           << "</A><BR>" << endl << flush;
   }


   for(tree_node::node_list_type::iterator 
       p = p_node->child_list().begin();
       p != p_node->child_list().end(); 
       p++) {
      print_tree((*p), path, path2 
                 + string((*p)->name()) + "/",
                 string(p_node->name()), 
                 depth + 1);
   }
}

// add a node to the tree
bool
add_node(tree_node * p_parent,
    tree_node * p_node,
    const long & parent_id)
{
   bool ret = false;
   if(parent_id == p_parent->id()) {
      p_parent->add_child(p_node);
      ret = true;
   }
   else {
      for(tree_node::node_list_type::iterator 
         p = p_parent->child_list().begin();
         p != p_parent->child_list().end();
         p++) {
         if(add_node((*p), p_node, parent_id)) {
            ret = true;
            break;
         }
      }
   }
   return ret;
}

// read the tree
tree_node *
read_tree()
{
   tree_node * p_root = 0;
   tree_node * p_node;
   string name, type, parent, sid;
   long id;
   long parent_id;

   string file_name = string(DATA_DIR) + string("tree.csv");

   ifstream in(file_name.c_str());

   if(!in) {
      cout << "unable to open tree file..." << endl;
      ofstream fout(file_name.c_str(), ios::out | ios::ate);
      if(fout) {
         fout << "\"id\",\"parent_id\",\"type\",\"name\",\"path\",\"message\"" << endl << flush;
         fout << "\"1\",\"\",\"node\",\"root\",\"/root\",\"\"" << endl;
         fout << "\"2\",\"1\",\"node\",\"software\",\"/software\",\"\"" << endl;
         fout << "\"3\",\"1\",\"node\",\"my-life\",\"/my-life\",\"\"" << endl;
         fout << "\"4\",\"2\",\"message board\",\"C\",\"/root/software/C\",\"C software message board.\"" << endl;
         fout << "\"5\",\"2\",\"message board\",\"C++\",\"/root/software/C++\",\"C++ software message board.\"" << endl;
         fout << "\"6\",\"2\",\"message board\",\"Java\",\"/root/software/Java\",\"Java software message board.\"" << endl;
         fout << "\"7\",\"3\",\"message board\",\"About Me\",\"/root/my-life/About Me\",\"About me message board.\"" << endl;
         fout.flush();
         fout.close();
      }
      return 0;
   }

   csv_row_type row;
   csv_row_map_type row_map;

   if(!(in >> row))
      return 0;

   map_row(row, row_map);

   while(in >> row) {
      parent = row[row_map["parent_id"]];
      type = row[row_map["type"]];
      name = row[row_map["name"]];
      sid = row[row_map["id"]];

      if(sid.size() > 0)
         id = atol(sid.c_str());
      else
         id = 0;

      if(type == "node") {
         p_node = new tree_node(name, tree_node::NODE, id);
      }
      else if(type == "message board") {
         p_node = new tree_node(name, tree_node::MESSAGE_BOARD, id);
      }

      if(p_root == 0) {
         p_root = p_node;
      }
      else {
         if(parent.size() > 0) {
            parent_id = atol(parent.c_str());
               
            add_node(p_root, p_node, parent_id);
         }
      }
   }

   in.close();

   return p_root;
}

// show the topic tree
// use in_page...
void
show_topic_tree(CGI & form_data)
{
   cout << "<HTML><HEAD><TITLE>"
        << "Topic Tree</TITLE></HEAD>" << endl
             << "<BODY BGCOLOR=\"white\">" << endl
             << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
             << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\">" << endl;

        print_header();


   cout << "<TABLE BORDER=\"0\" ALIGN=\"left\">" << endl;
   cout << "<TR><TD>" << endl;
   cout << "<BR>"
        << "<H2>Topic Tree</H2><BR>" << endl
        << "<BR>"
        << "<BR>" << endl << flush;

   const char * path = form_data["path"];
   
   tree_node * p_root = read_tree();

   if(path == 0)
      path = "/root/";

   if(p_root == 0) {
      return;
   }

   string_list_type path_list;

   const size_t MAX = 1024;
   char buffer[MAX];

   memset(buffer, 0, MAX);

   strcpy(buffer, path);

   char * ptr = strtok(buffer, "/");

   while(ptr != NULL) {

      path_list.push_back(string(ptr));

      ptr = strtok(NULL, "/");
   }

        print_tree(p_root, path_list, "/root/", "root");

   delete p_root;

   cout << "<BR><BR>"
        << "<A HREF=\"" << CGI_URL << "function_code=6\">search</A>" 
        << endl;
   cout << " | <A HREF=\"" << CGI_URL << "function_code=8\">get account</A>" 
        << "<BR><BR><BR>" << endl << flush;
   cout << "</TD></TR></TABLE>" << endl << flush;

        print_footer();
     
   cout << "</BODY>" << endl 
        << "</HTML>" << endl << flush;
}

// read lock
int
pass_read_lock()
{
   int fd = 0;

#ifndef __WIN32__
   string filename = string(DATA_DIR) + string("passwords.lock");

   fd = open(filename.c_str(), O_RDWR);

   if(fd < 0) {
      fd = open(filename.c_str(), O_RDWR | O_CREAT);
      if(fd < 0) {
         return -1;
      }
   }

   if(flock(fd, LOCK_SH) < 0) 
      return -1;
#endif

   return fd;
}

// password file lock.
int
pass_write_lock()
{
   int fd = 0;

#ifndef __WIN32__
   string filename = string(DATA_DIR) + string("passwords.lock");

   fd = open(filename.c_str(), O_RDWR);

   if(fd < 0) {
      fd = open(filename.c_str(), O_RDWR | O_CREAT);
      if(fd < 0) {
         return -1;
      }
   }

   if(flock(fd, LOCK_SH) < 0)
      return -1;
#endif

   return fd;
}

// password file unlock.
int
pass_unlock(int fd)
{

#ifndef __WIN32__
   if(flock(fd, LOCK_UN) < 0) {
      return -1;
   }

   if(close(fd) < 0)
      return -1;
#endif

   return 0;
}

// read lock 
int
msg_read_lock(int id)
{
   const size_t MAX = 1024;
   char filename[MAX];
   int fd = 0;

#ifndef __WIN32__
   memset(filename, 0, MAX);

   sprintf(filename, (string(DATA_DIR)+"message_board%d.lock").c_str(), id);

   fd = open(filename, O_RDWR);

   if(fd < 0)
      return -1;

   if(flock(fd, LOCK_SH) < 0) {
      cout << "unable to read lock file: " << filename
           << "<BR>" << endl << flush;

      return -1;
   }
#endif

   return fd;
}

// write lock
int
msg_write_lock(int id)
{
        const size_t MAX = 1024;
   char filename[MAX];

   memset(filename, 0, MAX);

   sprintf(filename, (string(DATA_DIR)+"message_board%d.lock").c_str(), id);

   int fd = 0;

#ifndef __WIN32__
   fd = open(filename, O_RDWR);
   
   if(fd < 0)
      return -1;

   if(flock(fd, LOCK_EX) < 0) {
      cout << "unable to write lock file: " << filename 
           << "<BR>" << endl << flush;

      return -1;
   }
#endif

   return fd;
}

// unlock
int
msg_unlock(int id, int fd)
{

#ifndef __WIN32__
   if(flock(fd, LOCK_UN) < 0) {
      cout << "unable to unlock file: " << id
           << "<BR>" << endl << flush;

      return -1;
   }

   close(fd);
#endif

   return 0;
}

void print_pages(CGI & form_data, const char * path);

// the message class
class message {
public:
   long board_id;
   long id;
   string user;
   string date;
   string title;
   string text;

   message() {
   }

   message(const message & right) {
      id = right.id;
      user = right.user;
      date = right.date;
      title = right.title;
      text = right.text;
      board_id = right.board_id;
   }

   ~message() {
   }

   message & operator=(const message & right) {
      id = right.id;
      user = right.user;
      date = right.date;
      title = right.title;
      text = right.text;
      board_id = right.board_id;
      return *this;
   }
};

typedef list< message > message_list_type;

long find_max(long id);

// print a message board

void
write_default(const string & file_name) 
{
   ofstream fout(file_name.c_str(), ios::out | ios::ate);
   if(fout) {
      fout << "\"id\",\"title\",\"author\",\"message\",\"parent\",\"when\"" << endl << flush;
      fout.close();
   }
}
void
print_message_board(CGI & form_data, const char * path)
{
   cout << "<TABLE BORDER=\"1\">" << endl
        << "<TR><TD><B>User<B></TD><TD><B>Title</B></TD>"
        << "<TD><B>Date</B></TD></TR>" << endl << flush;

   const char * sid = form_data["id"];

   if(sid == 0)
      sid = "0";

   long id = atol(sid);

   const size_t MAX = 1024;
   char filename[MAX];

   memset(filename, 0, MAX);

   sprintf(filename, (string(DATA_DIR)+"message_board%d.csv").c_str(), id);
//cout << "OPEN FILE: " << filename << "<BR>" << endl << flush

   const char * skip = form_data["skip"];

   long max = find_max(id);

   long skip_count;

   if(skip == 0) {
      skip_count = max;
   }
   else {
      skip_count = atol(skip);
   }

   long index = 0;
   const int SHOW = 10;

   int fd = msg_read_lock(id);

   ifstream in(filename);

   if(!in) {
      write_default(filename);
      return;
   }

   // "id","author","message","parent","when" 
   string user, title, date, fpath, parent, msg_id;

   message msg;
   message_list_type msg_list;

   csv_row_type row;
   csv_row_map_type row_map;

   if(!(in >> row))
      return;

   map_row(row, row_map);

   while(in >> row) {
      if((skip_count - SHOW) < 0) {
         if(index < (skip_count - SHOW)) {
            index++;
            continue;
         }
      }

      if(index >= skip_count)
         break;

      parent = row[row_map["parent"]];

      msg_id = row[row_map["id"]];

      user = row[row_map["author"]];

      title = row[row_map["title"]];

      date = row[row_map["when"]];

      msg.id = atol(msg_id.c_str());
      msg.title = title;
      msg.user = user;
      msg.date = date;

      msg_list.push_back(msg);
      
      if(msg_list.size() > SHOW) {
         msg_list.pop_front();
      }

      index++;
   }

   in.close();

   msg_unlock(id, fd);

   for(message_list_type::reverse_iterator p = msg_list.rbegin();
       p != msg_list.rend(); p++) {
      cout << "<TR><TD>" << p->user << "</TD><TD>" 
           << "<A HREF=\"" << CGI_URL << "function_code=3&"
           << "id=" << id << "&msg_id=" << p->id << "\">" 
           << p->title << "</A></TD>"
           << "<TD>" << p->date << "</TD></TR>" << endl << flush;
   }

   cout << "</TABLE>" << endl << flush;

   print_pages(form_data, path);
}

long
find_max(long id)
{
   const size_t MAX = 1024;
   char buffer[MAX];

   memset(buffer, 0, MAX);

   sprintf(buffer, (string(DATA_DIR)+"message_board%d.csv").c_str(), id);

   int count = 0;

   int fd = msg_read_lock(id);

   csv_row_type row;
   csv_row_map_type row_map;

   ifstream in(buffer);

   if(!(in >> row)) 
      return 0L;

   while(in >> row) {
      count++;
   }

   in.close();

   msg_unlock(id, fd);

   return count;
}

// print page listing
void
print_pages(CGI & form_data, const char * path)
{
   long SHOW = 10;

   const char * id = form_data["id"];

   string temp_path = urlncode(string(path));

   long max = find_max(atol(id));

   if(max <= SHOW)
      return;

   cout << "<BR><BR><B>Page : </B> " << flush;

   const char * skip = form_data["skip"];

   long sk;

   long i = 1;
   long index;
   long start = max;

   typedef list< long > long_list_type;
   long_list_type the_list;

   index = start; 

   while(index > 0L) {
      the_list.push_front(index);

      if(index <= 0L)
         break;

      if((index - SHOW) < 0L) {
         index = 0L;
      }
      else {
         index -= SHOW;
      }
   }

   if(skip == 0) {
      sk = the_list.back();
   }
   else {
      sk = atol(skip);
   }

   for(long_list_type::reverse_iterator p = the_list.rbegin();
       p != the_list.rend(); p++) {
      index = (*p);

      if(p != the_list.rbegin())
         cout << " | ";

      if(index == sk) {
         cout << i << endl << flush;
      }
      else {
         cout << "<A HREF=\"" << CGI_URL << "function_code=2&"
                   << "path=" << temp_path
                 << "&id=" << id << "&skip=" << index << "\">"
                 << i
                 << "</A>" << endl << flush;
      }

      i++;
   }

   cout << "<BR><BR>" << endl << flush;

}

string
find_message(long id) {
   csv_row_type rec;

   csv_row_map_type rec_map;

   ifstream in((string(DATA_DIR)+"tree.csv").c_str());

   if(!in)
      return "";

   string ret;

   if(!(in >> rec))
      return "";

   map_row(rec, rec_map);

   while(in >> rec) {
      if(atol(rec[rec_map["id"]].c_str()) == id) {
         ret = rec[rec_map["message"]];
         break;
      }
   }

   in.close();

   return ret;
}

string 
urlncode(const string & str) 
{
   string ret;

   for(size_t i = 0; i < str.size(); i++) {
      switch(str[i]) {
         case '&':
         ret += "%26";
         break;

         case '=':
         ret += "%3D";
         break;

         case '\"':
         ret += "%22";
         break;

         case '\'':
         ret += "%27";
         break;

         case '\\':
         ret += "%5C";
         break;

         case '(':
         ret += "%28";
         break;

         case ')':
         ret += "%29";
         break;

         case '{':
         ret += "%7B";
         break;

         case '}':
         ret += "%7D";
         break;

         case '[':
         ret += "%5B";
         break;

         case ']':
         ret += "%5D";
         break;

         case '+':
         ret += "%2B";
         break;

         case ':':
         ret += "%3A";
         break;

         case ';':
         ret += "%3B";
         break;

         case '<':
         ret += "%3C";
         break;

         case '>':
         ret += "%3E";
         break;

         case ',':
         ret += "%2C";
         break;

         case '?':
         ret += "%3F";
         break;

         case '/':
         ret += "%2F";
         break;

         case '|':
         ret += "%7C";
         break;

         case '^':
         ret += "%5E";
         break;

         case '%':
         ret += "%25";
         break;

         case '$':
         ret += "%24";
         break;

         case '#':
         ret += "%23";
         break;

         case '!':
         ret += "%21";
         break;

         case '~':
         ret += "%7E";
         break;

         case '`':
         ret += "%60";
         break;

         case ' ':
         case '\r':
         case '\n':
         ret += "+";
         break;

         default:
         ret += str[i];
      }
   }

   return ret;
}

// show message board
void 
show_message_board(CGI & form_data)
{

   const char * path = form_data["path"];

   if(path == 0)
      return;

   size_t path_size = strlen(path);

   cout << "<HTML><HEAD><TITLE>" << path << "</TITLE>"
             << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" 
             << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\"></HEAD>" 
        << endl
        << "<BODY BGCLOLR=\"white\">" << endl
        << "<FONT METHOD=\"Arial\">"
        << endl << flush;

        print_header();

   cout << "<B>PATH:</B> " << path << "<BR><BR>" 
        << endl << flush;

   const char * id = form_data["id"];
   
   if(id == 0)
      id = "0";

   string message = find_message(atol(id));

   cout << "<B>MESSAGE:</B> " << message << "<BR><BR>"
        << endl << flush;

   print_message_board(form_data, path);

   string temp_path = urlncode(string(path));

   cout << "<BR><A HREF=\"" << CGI_URL << "id=" 
        << id  
        << "&function_code=5&"
        << "path=" << temp_path << "\">post message</A> | "
        << "<A HREF=\"" << CGI_URL << ""
        << "function_code=1&path=" << temp_path 
        << "\">"
        << "back to tree</A>" << endl << flush;

   print_footer();

   cout << "</FONT></BODY></HTML>" << endl << flush;
}

string
form_encode(const char * str)
{
   string ret;
   const char * p = str;

   while(*p) {
      if(*p == '\"')
         ret += "&quote";
      else if(*p == '\n')
         ret += " ";
      else if(*p == '\r')
         ret += " ";
      else 
         ret += *p;

      p++;
   }

   return ret;
}

// show post message form.
void
show_post_message_form(CGI & form_data)
{
   const char * path = form_data["path"];

   if(path == 0) 
      return;

   string temp_path = urlncode(string(path));

   const char * id = form_data["id"];

   if(id == 0)
      id = "0";

   const long SHOW = 10L;

   cout << "<HTML><HEAD><TITLE>Post Message Form</TITLE>"
             << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
             << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\"></HEAD>" << endl
        << "<BODY BGCOLOR=\"WHITE\">" << endl
        << "<FONT FACE=\"Arial\">" << endl << flush;

        print_header();
 
        cout << "<H2>Post Message Form</H2><BR>" << endl 
        << "<FORM METHOD=\"GET\" ACTION=\"" << CGI_URL2 << "\">" << endl
        << "<INPUT TYPE=\"HIDDEN\" NAME=\"path\" VALUE=\""
        << path << "\">" << endl
        << "<INPUT TYPE=\"HIDDEN\" NAME=\"page\" VALUE=\"msg\">"
        << "<INPUT TYPE=\"HIDDEN\" NAME=\"function_code\" VALUE=\"4\">"
        << endl
        << "<INPUT TYPE=\"HIDDEN\" NAME=\"id\" VALUE=\""
        << id << "\">"
        << endl << flush;

   const char * reply = form_data["reply"];
   const char * title = "";

   if(reply != 0) {
      long reply_id = atol(reply);

      title = form_data["title"];

      if(title == 0)
         title = "";

      cout << "<INPUT TYPE=\"HIDDEN\" NAME=\"reply\" VALUE=\"" 
      << reply_id
           << "\">"
           << endl 
           << "Reply To Message #: " << reply_id << "<BR>" 
      << endl << flush;
   }

   cout << "New user: <A HREF=\"" << CGI_URL << "function_code=8\">"
        << "Get an account.</A><BR>"
        << endl
        << "Title: <INPUT TYPE=\"TEXT\" NAME=\"title\" "
             << "VALUE=\"" 
        << ((reply == 0)?(""):("Re: ")) 
        << form_encode(title) << "\" SIZE=\"25\"><BR>" 
        << endl
        << "Username: <INPUT TYPE=\"TEXT\" NAME=\"username\" "
        << "SIZE=\"25\"><BR>" 
        << endl
        << "Password: <INPUT TYPE=\"PASSWORD\" NAME=\"password\" "
        << "SIZE=\"25\"><BR>"
        << endl 
        << "Message:<BR><TEXTAREA NAME=\"message\" COLS=\"40\" "
        << "ROWS=\"20\">"
        << "</TEXTAREA>"
        << "<BR>" << endl
        << "<INPUT TYPE=\"SUBMIT\" VALUE=\"Post Message\">" << endl
        << " * <INPUT TYPE=\"RESET\" VALUE=\"Clear Form\">" << endl
        << "</FORM><BR>" << endl
        << "<A HREF=\"" << CGI_URL << "id=" << id << "&function_code=2&"
        << "path=" << temp_path 
        << "\">back to message board</A> | "
        << "<A HREF=\"" << CGI_URL << ""
        << "function_code=1&path=" << temp_path << "\">"
        << "back to tree</A>" << endl << flush;

        print_footer();

        cout << "</FONT>" << endl
        << "</BODY></HTML>" << endl << flush;
}

string
get_path(long id)
{
   csv_row_type rec;

   csv_row_map_type rec_map;

   ifstream in((string(DATA_DIR)+"tree.csv").c_str());

   if(!in)
      return "";

   long temp;
   string ret;

   if(!(in >> rec)) 
      return "";

   map_row(rec, rec_map);

   while(in >> rec) {
      temp = atol(rec[rec_map["id"]].c_str());

      if(id == temp) {
                  ret = rec[rec_map["path"]];
         break;
      }
   }

   in.close();

   return ret;
}

// show a message
void
show_message(CGI & form_data)
{
   string name, title, m, date, fparent;

   const char * smsg_id = form_data["msg_id"];
   const char * sid = form_data["id"];

   if(sid == 0)
      sid = "0";

   long id = atol(sid);

   if(smsg_id == 0)
      smsg_id = "0";

   long msg_id = atol(smsg_id);

   const size_t MAX = 1024;
   char filename[MAX];

   memset(filename, 0, MAX);

   sprintf(filename, (string(DATA_DIR)+"message_board%d.csv").c_str(), id);

   int fd = msg_read_lock(id);

   csv_row_type rec;

   csv_row_map_type rec_map;

   ifstream in(filename);

   if(!in)
      return;

   if(!(in >> rec))
      return;

   map_row(rec, rec_map);

   bool found = false;
   string parent;
   long parent_id;
   message_list_type msg_list;
   message msg;
   string sid2;

   // "id","title","author","message","parent","when"
   while(in >> rec) {

      sid2 = rec[rec_map["id"]];

      if(atol(sid2.c_str()) == msg_id) {
         cout << "<B>FOUND MESSAGE ID#:</B> " 
              << msg_id << "<BR>" << endl << flush;

         name = rec[rec_map["author"]];

         title = rec[rec_map["title"]];

         m = rec[rec_map["message"]];

         date = rec[rec_map["when"]];

         fparent = rec[rec_map["parent"]];

         found = true;
      }
      else {
         parent = rec[rec_map["parent"]];

         if(parent.size() == 0)
            parent_id = 0;
         else 
            parent_id = atol(parent.c_str());

         if(msg_id == parent_id) {
            msg.id = atol(rec[rec_map["id"]].c_str());

            msg.user = rec[rec_map["author"]];

            msg.title = rec[rec_map["title"]];
         
            msg.date = rec[rec_map["when"]];

            msg_list.push_back(msg);
         }
      }
   }

   in.close();

   msg_unlock(id, fd);

   if(found) {
      string path = get_path(id);

      path = urlncode(path);

      cout << "<HTML><HEAD><TITLE>Read Message"
           << "</TITLE>"
                     << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
                     << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\"></HEAD>" << endl
           << "<BODY BGCOLOR=\"WHITE\">" << endl 
           << "<FONT FACE=\"Arial\">" << endl << flush;
                
      print_header();
 
      cout << "<H2>Read Message</H2>"
           << "<BR><HR><BR>" << endl
           << "<TABLE BORDER=\"1\">" << endl << flush;

      if(fparent.size() > 0) {
         cout << "<TR><TD COLSPAN=\"2\">"
              << "<A HREF=\"" << CGI_URL << ""
              << "function_code=3&id=" << id
              << "&msg_id=" << fparent
              << "\">" 
              << "parent message</A></TD></TR>" << endl << flush;
      }

      cout << "<TR>"
           << "<TD><B>Name:</B></TD>"
           << "<TD>" << name << "</TD>"
           << "</TR>" << endl
           << "<TR>"
           << "<TD><B>Title:</B></TD>"
           << "<TD>" << title << "</TD>"
           << "</TR>" << endl
           << "<TR>"
           << "<TD><B>Date:</B></TD>"
           << "<TD>" << date << "</TD>"
           << "</TR>" << endl
           << "<TR>"
           << "<TD COLSPAN=\"2\">" 
           << "<B>Message:</B></TD>" 
           << "</TR>" << endl
           << "<TR>"
           << "<TD COLSPAN=\"2\">" 
           << m << "</TD>" 
           << "</TR></TABLE>" << endl;

      if(msg_list.size() > 0) {
         cout << "<BR><BR><H2>Replies:</H2>" << endl
              << "<TABLE BORDER=\"1\">" << endl 
              << "<TR><TD><B>Title</B></TD>"
              << "<TD><B>Author</B></TD>"
              << "<TD><B>Date</B></TD></TR>" << endl << flush;

         for(message_list_type::iterator p = msg_list.begin();
             p != msg_list.end(); p++) {
            cout << "<TR><TD>"
                 << "<A HREF=\"" << CGI_URL << ""
                 << "function_code=3&id=" << id
                 << "&msg_id=" << p->id
                 << "\">" << p->title 
                 << "</A></TD>"
                 << "<TD>" << p->user 
                 << "</TD>"
                 << "<TD>" << p->date 
                 << "</TD></TR>"
                 << endl << flush;
         }

         cout << "</TABLE>" << endl << flush;
      }

      cout << "<BR><HR><BR>" << endl 
           << "<A HREF=\"" << CGI_URL << "id="
           << id << "&function_code=5"
           << "&title=" << urlncode(title) 
           << "&reply=" << msg_id 
           << "&path=" << path << "\">reply</A> | "
           << "<A HREF=\"" << CGI_URL << "id="
                     << id << "&function_code=2&"
                     << "path=" << path 
                     << "\">back to message board</A> | "
                     << "<A HREF=\"" << CGI_URL << ""
                     << "function_code=1&path=" << path << "\">"
                     << "back to tree</A>" << endl << flush;

      print_footer();

      cout << "</FONT>" << endl
           << "</BODY></HTML>" << endl << flush;
   }
   else {
      string path = get_path(id);

      path = urlncode(path);

      cout << "<HTML><HEAD><TITLE>Error "
           << "- Message Not Found</TITLE><link rel=\"stylesheet\" href=\"/~mcoan/style.css\">"
                     << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>"
                     << "</HEAD>" << endl 
           << "<BODY BGCOLOR=\"WHITE\">" << endl
           << "<FONT FACE=\"Arial\" COLOR=\"red\">" << endl
                     << flush;

      print_header();

      cout << "<H2>Messae Not Found</H2>" << endl
                     << id << "&function_code=2&"
                     << "path=" << path 
                     << "\">back to message board</A> | "
                     << "<A HREF=\"" << CGI_URL << ""
                     << "function_code=1&path=" << path << "\">"
                     << "back to tree</A>" << endl << flush;

      print_footer();

      cout << "</FONT>" << endl
           << "</BODY></HTML>" << endl << flush;
   }
}

// get next id
long
get_next_id()
{


#ifndef __WIN32__
   int fd = open((string(DATA_DIR)+"id.lock").c_str(), O_RDWR | O_CREAT);

   if(fd < 0)
      return 0;

   flock(fd, LOCK_EX);
#endif

   long id = 0L;

   string temp;

   ifstream in((string(DATA_DIR)+"id.dat").c_str());
  
   if(!in) {
      ofstream fout((string(DATA_DIR)+"id.dat").c_str(), ios::out | ios::ate); 
      if(fout) {
         fout << 100 << flush;
         fout.close();
      }
      in.open((string(DATA_DIR)+"id.dat").c_str(), ios::in); 
   } 

   in >> temp;

   in.close();

   if(temp.size() > 0) {
      id = atol(temp.c_str());

      ofstream out((string(DATA_DIR)+"id.dat").c_str());

      out << (id + 1) << endl << flush;

      out.close();
   }

#ifndef __WIN32__
   flock(fd, LOCK_UN);

   close(fd);
#endif

   return id;
}

// csv encode a string
string
csv_encode(const char * ptr)
{
   string ret;

   while(*ptr) {
      if(*ptr == '\"')
         ret += "\"\"";
      else if(*ptr == '<') 
         ret += "&lt;";
      else if(*ptr == '&')
         ret += "&amp;";
      else if(*ptr == '\r')
         ret += "\\r";
      else if(*ptr == '\n')
         ret += "\\n";
      else 
         ret += *ptr;

      ptr++;
   }

   return ret;
}

// end the program with an error message.
void
die(const char * message, const char * file, const int lineno)
{

   cout << "<H1>Die: " << message << " Line Number:" << lineno
        << "File: " << file << "</H1>" << endl << flush;

   exit(0);
}

// post message
void
post_message(CGI & form_data)
{
   const char * title = form_data["title"];
   string author;
   const char * username = form_data["username"];
   const char * password = form_data["password"];
   const char * message = form_data["message"];
   const char * path = form_data["path"];
   const char * parent = form_data["reply"];
   const char * when = "";
   const char * board_id = form_data["id"];
   long id = get_next_id();
   string errors;
   tm * p_tm;

   time_t the_time = time(NULL);

   p_tm = localtime(&the_time);

   const size_t TMAX = 1024;
   char time_buffer[TMAX];

   memset(time_buffer, 0, TMAX);

   strftime(time_buffer, TMAX-1, 
         //"%A %B %d, %Y %l:%M %p and %S seconds %Z", p_tm);
         "%m/%d/%Y %H:%M:%S", p_tm);

   when = time_buffer;

   if(parent == 0)
      parent = "";

   if(title == 0)
      errors += "No title.<BR>\n";
   else if(strlen(title) == 0)
      errors += "Please enter the title of the message.<BR>\n";

   if(message == 0)
      errors += "No messae.<BR>\n";
   else if(strlen(message) == 0) 
      errors += "Please enter the message text.<BR>\n";

   if(path == 0)
      errors += "No path.<BR>\n";
   else if(strlen(path) == 0)
      errors += "Path lanegth is zero.<BR>\n";

   if(board_id == 0)
      errors += "No message borad id.<BR>\n";
   else if(strlen(board_id) == 0)
      errors += "Message borad id length is zero.<BR>\n";

   string filename = string(DATA_DIR) + string("passwords.csv");

   ifstream fin(filename.c_str());

   if(!fin) {
      ofstream fout(filename.c_str(), ios::out | ios::ate);
      if(fout) { 
         fout << "\"username\",\"password\",\"email\",\"author\"" << endl << flush;
         fout.close();
      }
   }

   int pass_fd = pass_read_lock();

   csv_row_type rec, rec2;

   csv_row_map_type rec_map, rec_map2;

   if(!(fin >> rec))
      die("unable to read first record.", __FILE__, __LINE__);

   map_row(rec, rec_map);

   string pass;

   bool pass_error = true;

   while(fin >> rec) {
      if(rec[rec_map["username"]] == username) {
         pass = rec[rec_map["password"]];

         if(password == string(pass)) {
            author = rec[rec_map["author"]];

            pass_error = false;
         }
         else 
            break;
      }
   }

   fin.close();

   pass_unlock(pass_fd);

   if(pass_error) 
      errors += "Bad password username.<BR>\n";

   if(errors.size() == 0) {
      const size_t MAX = 1024;
      char filename[MAX];
      int the_id = atoi(board_id);

      memset(filename, 0, MAX);

      sprintf(filename, (string(DATA_DIR)+"message_board%d.csv").c_str(), the_id);

      int fd = msg_write_lock(the_id);

      ofstream out(filename, ios::app);

      if(out) {
         // "id","title","author","message",
         // "parent","when"
         out << "\"" << id << "\",\"" 
             << csv_encode(title) << "\",\""
             << csv_encode(author.c_str()) << "\",\"" 
             << csv_encode(message) << "\",\""
             << csv_encode(parent) << "\",\"" 
             << csv_encode(when) << "\"" << endl << flush;

         out.close();

         string temp_path = urlncode(string(path));

         cout << "<HTML><HEAD><TITLE>Post Message Form"
              << "</TITLE><link rel=\"stylesheet\" href=\"/~mcoan/style.css\">"
              << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>"
              << "</HEAD>" 
              << endl
              << "<BODY BGCOLOR=\"WHITE\">" << endl << flush;
                          
         print_header();

         cout << "<FONT FACE=\"Arial\">" << endl 
              << "<H2>Thank you, for your post.</H2>" << endl
              << "<A HREF=\"" << CGI_URL << "id=" 
              << board_id << "&function_code=2&"
              << "path=" << temp_path 
              << "\">back to message board</A> | "
              << "<A HREF=\"" << CGI_URL << ""
              << "function_code=1&path=" << temp_path << "\">"
              << "back to tree</A>" << endl << flush;

         print_footer();

         cout << "</BODY></HTML>" << endl << flush;

         msg_unlock(id, fd);

         return;
      }
      else {
         errors += "Unable to open output file.<BR>\n";
      }

      msg_unlock(id, fd);

   }

   cout << "<HTML><HEAD><TITLE>Post Message Form</TITLE>"
        << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>"
        << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\"></HEAD>"
        << endl
        << "<BODY BGCOLOR=\"WHITE\">" << endl
        << "<FONT FACE=\"Arial\" COLOR=\"red\">" << endl << flush;

   print_header();

   print_footer();

   cout << "<H2>Errors</H2><BR>" << errors << endl
        << "</BODY></HTML>" << endl << flush;
}

void
show_search_form(CGI & form_data)
{
   cout << "<HTML><HEAD><TITLE>" << endl
        << "Message Board - Search" << endl
        << "</TITLE>"
             << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
             << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\"></HEAD>" << endl
        << "<BODY BGCOLOR=\"WHITE\">" << endl
        << "<FONT FACE=\"Arial\">" << endl << flush;

   print_header();

   cout << "<BR><HR><BR><BR>"
        << "<H2>Message Board - Search</H2>" << endl
        << "<BR><HR><BR><BR>" << endl
        << "<FORM METHOD=\"GET\" "
        << "ACTION=\"" << CGI_URL2 << "\">" << endl
        << "<INPUT TYPE=\"HIDDEN\" NAME=\"function_code\" "
        << "VALUE=\"7\">" << endl
        << "Search: <INPUT TYPE=\"TEXT\" NAME=\"qs\" "
        << "SIZE=\"50\"><BR>" << endl
        << "<INPUT TYPE=SUBMIT VALUE=\"Search\"> * <INPUT TYPE=RESET><BR>"
        << endl
        << "</FORM>" << endl
        << "<BR><HR><BR><BR>" << endl
        << "<A HREF=\"" << CGI_URL << "function_code=1\">"
        << "back to tree</A>"
        << endl << flush;

   print_footer();

   cout << "</FONT></BODY></HTML>" << endl << flush;
}

void
message_search(CGI & form_data)
{
   const char * qs0 = form_data["qs"];
   string qs;
 
   if(qs0)
      qs = qs0;

   cout << "<HTML><HEAD><TITLE>" << endl
        << "Message Board - Search - Results" << endl
        << "</TITLE><link rel=\"stylesheet\" href=\"/~mcoan/style.css\">"
        << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
        << "</HEAD>" << endl
        << "<BODY BGCOLOR=\"WHITE\">" << endl << flush;

   print_header();

   cout << "<FONT FACE=\"Arial\">" << endl
        << "<BR><HR><BR><BR>"
        << "<H2>Message Board - Search - Results</H2>" << endl
        << "<BR><HR><BR><BR>" << endl
        << "<FORM METHOD=\"GET\" "
        << "ACTION=\"" << CGI_URL2 << "\">" << endl
        << "<INPUT TYPE=\"HIDDEN\" NAME=\"function_code\" "
        << "VALUE=\"7\">" << endl
        << "Search: <INPUT TYPE=\"TEXT\" NAME=\"qs\" "
        << "SIZE=\"50\" VALUE=\"" << form_encode(qs.c_str()) << "\"><BR>" << endl
        << "<INPUT TYPE=SUBMIT VALUE=\"Search\"> * <INPUT TYPE=RESET><BR>"
        << endl
        << "</FORM>" << endl
        << "<BR><HR><BR><BR>" << endl << flush;

   const char * sep = " \r\n!@#$5^&*()_-+={}[]|\\\'\";:/?><.,";
   
   char * buffer = new char [ qs.size()+1 ];

   strcpy(buffer, qs.c_str());

   char * ptr = strtok(buffer, sep);

   string_list_type qs_list;

   while(ptr != NULL) {
      qs_list.push_back(string(ptr));

      ptr = strtok(NULL, sep);
   }

   delete [] buffer;

   ifstream in((string(DATA_DIR)+"tree.csv").c_str());

   if(!in)
      return;

   csv_row_type rec, rec2;

   csv_row_map_type rec_map, rec_map2;

   if(!(in >> rec)) 
      return;

   map_row(rec, rec_map);

   string type, id, p_id;
   long idl;
   string filename, temp;
   string_list_type temp_list;
   message_list_type result_list;
   message msg;
   int count;
   bool found;

   while(in >> rec) {
      id = rec[rec_map["id"]];
      
      if(id.size() == 0)
         id = "0";

      idl = atol(id.c_str());

      type = rec[rec_map["type"]];

      if(strcasecmp(type.c_str(), "message board") != 0)
         continue;

      filename = (string(DATA_DIR)+"message_board")
            + id + string(".csv");

      int fd = msg_read_lock(idl);

      ifstream in2(filename.c_str());

      if(!in2)
         return;

      if(!(in2 >> rec2))
         return;

      map_row(rec2, rec_map2);

      //"id","title","author","message","parent","when"
      while(in2 >> rec2) {
         p_id = rec2[rec_map2["id"]];
         
         if(p_id.size() == 0)
            p_id = "0";

         msg = message();

         msg.board_id = idl;

         msg.id = atol(p_id.c_str());

         msg.title = rec2[rec_map2["title"]];

         msg.user = rec2[rec_map2["author"]];

         msg.date = rec2[rec_map2["when"]];

         temp = rec2[rec_map2["title"]]
            + string(" ")
            + rec2[rec_map2["author"]]
            + string(" ")
            + rec2[rec_map2["message"]];

         size_t buffer_size = temp.size() + 1;

         char * buffer = new char[buffer_size];

         memset(buffer, 0, buffer_size);

         strcpy(buffer, temp.c_str());

         ptr = strtok(buffer, sep);

         while(ptr != NULL) {
            temp_list.push_back(string(ptr));

            ptr = strtok(NULL, sep);
         }

         delete [] buffer;

         count = 0;

         for(string_list_type::iterator p0 
               = qs_list.begin();
            p0 != qs_list.end(); p0++) {

            found = false;

            for(string_list_type::iterator p 
                  = temp_list.begin();
               p != temp_list.end(); p++) {
               if(strcasecmp(p0->c_str(),
                        p->c_str()) == 0) {
                  found = true;

                  break;
               }
            }

            if(found) {
               count++;
            }
         }

         if(count == qs_list.size()) {
            result_list.push_front(msg);
         }

         temp_list.clear();
      }

      in2.close();

      msg_unlock(idl, fd);
   }

   in.close();

   cout << "<H2>result list size: <I>" << result_list.size() 
        << "</I></H2><BR><HR><BR><BR>" << endl << flush;

   for(message_list_type::iterator p = result_list.begin();
       p != result_list.end(); p++) {
      cout << "<B>Message ID #:</B> " << p->id << "<BR>" << endl
           << "<B>Title:</B> "
           << "<A HREF=\"" << CGI_URL << "function_code=3"
           << "&id=" << p->board_id << "&msg_id=" 
           << p->id
           << "\">" << p->title 
           << "</A><BR>" << endl 
           << "<B>Author:</B> " << p->user << "<BR>" << endl
           << "<B>Date:</B> " << p->date 
           << "<BR><BR><BR>" << endl << flush;
   }

   cout << "<BR><HR><BR><BR>" << endl
        << "<A HREF=\"" << CGI_URL << "function_code=1\">"
        << "back to tree</A>"
        << endl << flush;

   print_footer();
 
   cout << "</FONT></BODY></HTML>" << endl << flush;
}

// show the sign up form.
void
show_signup_form(CGI & form_data) 
{
   cout << "<HTML><HEAD><TITLE>" << endl
        << "Message Board - Signup" << endl
        << "</TITLE><link rel=\"stylesheet\" href=\"/~mcoan/style.css\">"
             << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>"
             << "</HEAD>" << endl
        << "<BODY BGCOLOR=\"WHITE\">" << endl 
        << "<FONT FACE=\"Arial\">" << endl << flush;

   print_header();

   cout << "<FONT FACE=\"Arial\">" << endl
        << "<BR><HR><BR><BR>"
        << "<H2>Message Board - Signup</H2>" << endl
        << "<BR><HR><BR><BR>" << endl
        << "<FORM METHOD=\"GET\" "
        << "ACTION=\"" << CGI_URL2 << "\">" << endl
        << "<INPUT TYPE=\"HIDDEN\" NAME=\"function_code\" "
        << "VALUE=\"9\">" << endl
        << "<INPUT TYPE=HIDDEN NAME=\"page\" VALUE=\"msg\"><BR>"
        << "Name: <INPUT TYPE=TEXT NAME=\"name\"><BR>"
        << endl
        << "Username: <INPUT TYPE=TEXT NAME=\"username\"><BR>" 
        << endl
        << "Password: <INPUT TYPE=PASSWORD NAME=\"password\"><BR>"
        << endl
        << "Verify password: <INPUT TYPE=PASSWORD NAME=\"password2\"><BR>"
        << endl
        << "Email address: <INPUT TYPE=TEXT NAME=\"email\"><BR>"
        << endl
        << "<BR><BR>" << endl 
        << "<INPUT TYPE=SUBMIT VALUE=\"Signup\"> * " 
        << "<INPUT TYPE=RESET VALUE=\"Clear\">" 
        << endl 
        << "</FORM><BR><HR><BR><BR>" << endl << flush;

   print_footer();

   cout << "</FONT></BODY></HTML>" 
        << endl << flush;
}

// signup
void
signup(CGI & form_data)
{
   string errors;

   string name = form_data["name"];
   string username = form_data["username"];
   string password = form_data["password"];
   string password2 = form_data["password2"];
   string email = form_data["email"];

   if(name.size() == 0)
      errors += "Please enter your name.<BR>\n";

   if(username.size() == 0)
      errors += "Please enter your user name.<BR>\n";

   if((password != password2) || password.size() <= 0) 
      errors += string("Passwords must match and be of length ")
           + string("greater then ")
           + string("zero.<BR>\n");

   if(email.size() == 0) 
      errors += "Please enter your email address.<BR>\n";

   if(errors.size() == 0) {
      int fd = pass_read_lock();

      if(fd < 0)
         die("Unable to open password lock.<BR>",
             __FILE__, __LINE__);

      // check for preexisting user.
      //

      if(pass_unlock(fd) < 0)
         die("Unable to unlock the password lock file.<BR>",
             __FILE__, __LINE__);

      fd = pass_write_lock();

      if(fd < 0)
         die("Unable to unlock the password lock file.<BR>",
                       __FILE__, __LINE__);

      // Write file hear.
      //
      ofstream out((string(DATA_DIR)+"passwords.csv").c_str(), ios::app);

                out << "\"" << username << "\",\"" 
                    << password << "\",\"" 
                    << email <<  "\",\""
                    << name << "\"" << endl << flush;

      out.close();

      if(pass_unlock(fd) < 0)
         die("Unable to unlock the password lock file.<BR>",
             __FILE__, __LINE__);

      // output result page.
      cout << "<HTML><HEAD><TITLE>Message Board - Signup - Done"
           << "</TITLE>"
           << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
           << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\"></HEAD><BR>"
           << endl
           << "<BODY BGCOLOR=\"WHITE\">"
           << "<H2>Message Board - Signup - Done</H2><BR>"
           << endl << flush;

      print_header();

      cout << "Thank you for creating your account...<BR>" << endl;

      print_footer();

      cout << "</FONT></BODY></HTML>"
           << endl
           << endl << flush;

   }
   else {
      cout << "<HTML><HEAD><TITLE>Message Board - Signup - Error"
           << "</TITLE>"
           << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
           << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\"></HEAD><BR>"
           << endl 
           << "<BODY BGCOLOR=\"WHITE\">"
           << "<H2>Message Board - Signup - Error</H2><BR>"
                     << endl << flush;

      print_header();

               
      cout << "<H2>Message Board - Signup - Error</H2><BR>"
           << "<FONT FACE=\"Arial\" COLOR=\"RED\">" 
           << errors << endl << flush;

      print_footer();
                
      cout << "</FONT></BODY></HTML>" 
           << endl
           << endl << flush;
   }
}


// on SIGINT
void
on_signal(int)
{
}

void
config_error(const string & message)
{
   cout << "Content-type: text/html\r\n\r\n" << endl;
   cout << "Service error: " << message << endl;
}

void 
load_config()
{
   ifstream fin("msg.conf");
   if(fin) {
      try {
         memset(CGI_URL, 0, MAX_STRING);
         memset(CGI_URL2, 0, MAX_STRING);
         memset(DATA_DIR, 0, MAX_STRING);
         memset(FILE_IMG, 0, MAX_STRING);
         memset(FOLDER_IMG, 0, MAX_STRING);
         properties_file props("msg.conf");
         const char* cgi_url = props["CGI_URL"];
         const char* cgi_url2 = props["CGI_URL2"];
         const char* data_dir = props["DATA_DIR"];
         const char* file_img = props["FILE_IMG"];
         const char* folder_img = props["FOLDER_IMG"];
         if(cgi_url 
            && cgi_url2
            && data_dir
            && file_img
            && folder_img) {
            if(strlen(cgi_url) < MAX_STRING)
               strcpy(CGI_URL, cgi_url);
            if(strlen(cgi_url2) < MAX_STRING)
               strcpy(CGI_URL2, cgi_url2);
            if(strlen(data_dir) < MAX_STRING)
               strcpy(DATA_DIR, data_dir);
            if(strlen(file_img) < MAX_STRING)
               strcpy(FILE_IMG, file_img);
            if(strlen(folder_img) < MAX_STRING)
               strcpy(FOLDER_IMG, folder_img);
         }
         else {
            config_error("missing configuration file values.");
         }
         fin.close(); 
      }
      catch(...) {
         config_error("bad configuration file.");
      }
   }
   else {
      config_error("missing configuration file.");
      ofstream fout("msg.conf", ios::out | ios::ate);
      if(fout) {
         fout << "CGI_URL=/scripts/msg.exe?" << endl;
         fout << "CGI_URL2=/scripts/msg.exe?" << endl;
         fout << "DATA_DIR=" << endl;
         fout << "FOLDER_IMG=/images/folder.png" << endl;
         fout << "FILE_IMG=/images/file.png" << endl << flush;
         fout.close();
      }
   }
}

}

// main entry point
int
main(int argc, char ** argv, char ** argenvp)
{
   bool in_page = false;

   using namespace message_board;

#ifndef __WIN32__
   // set signal handlers
   signal(SIGINT, on_signal);
   signal(SIGHUP, on_signal);
   signal(SIGTERM, on_signal);
   signal(SIGCHLD, on_signal);
#endif

   load_config();

   // parse form data
   CGI form_data;

   if((form_data["in_page"]) != 0) {
      in_page = true;
   }

   if(in_page == false) {
      // output content type
      cout << "Content-Type: text/html\r\n\r\n" << flush;
   }

   // make function array
   const size_t MAX = 10;
   const size_t DEFAULT_FUNCTION = 1;
   function_type function_array[] = {
      version_function,
      show_topic_tree,
      show_message_board,
      show_message,
      post_message,
      show_post_message_form,
      show_search_form,
      message_search,
      show_signup_form,
      signup
   };

   // get the function code
   const char * function_code_string = form_data["function_code"];

   int function_code;

   // turn the string into an index
   if(function_code_string) {
      function_code = atoi(function_code_string);

      if(function_code < 0 || function_code >= MAX)
         function_code = DEFAULT_FUNCTION;
   }
   else {
      function_code = DEFAULT_FUNCTION;
   }

   // lookup function in array
   function_type function = function_array[function_code];

   // call function
   function(form_data);

   // return zero
   return 0;
}


