#ifndef _PROPERTIES_FILE_H
#define _PROPERTIES_FILE_H

#include <vector>
#include <algorithm>
//#include <pair>
#include <cstring>
#include <cstdio>


namespace util_tools {

using namespace std;

//
// Matthew W. Coan (Mon Dec 23 20:40:44 EST 2002)
// mcoan@slack.net
//
// Properties that can be loaded (read/only).
//
class properties_file {
public:
   typedef pair< char *, const char * > pair_type;
   typedef pair_type * pair_ptr_type;
   typedef vector< pair_ptr_type > properties_vector_type; 

   class prop_less {
   public:
      bool operator()(const pair_ptr_type & p_left,
                      const pair_ptr_type & p_right) const {
         return strcmp(p_left->first, p_right->first) < 0;
      }
   };

   struct file_access_exception { };
private:
   const char * _file_name;
   properties_vector_type _prop_vec;
   bool _load();
public:
   properties_file(const char * file_name)
   throw(file_access_exception)
   :_file_name(file_name)
   {  
      if(!_load())
         throw file_access_exception();
   }

   ~properties_file();

   const char * operator[](const char * prop_name) const;
};

}

#endif /* _PROPERTIES_FILE_H */
