%{
#include <stdio.h>
#include <string.h>
#include "mixal.h"
#define BYTESIZE 6
#define MEMORYSIZE 4000
#define  B1 (1<<BYTESIZE)
#define  B2 B1*B1
#define  B3 B2*B1
#define  B5 B2*B3
#define  SIGN(a) (a&(MINUS))
#define  MAG(a) (a&(B5-1))
#define  MINUS ((unsigned)2*B5)
#define PLUS 0
#define  update_memory(A)  memory[location_counter]=(A); lines[lineno]=location_counter++; 
float version = 1.02;
char  *progname;
char  *source_file = NULL;
FILE *lst;
int lineno = 1;
int location_counter = 0;
unsigned word;
struct Symbol *s;
struct ref *p;
char literal[13];
char opcode[6];
unsigned  memory[MEMORYSIZE];
int  lines[MEMORYSIZE];
extern Symbol *symlist;
int list;
unsigned add_mix(), sub_mix(), div_mix(), mul_mix(), w_eval();
struct {  
    char *name;
    int f;
    int c;
  } ops[] = {
      "NOP",  0,  0, "ADD",  5,  1, "SUB",  5,  2, "MUL",  5,  3, "DIV",  5,  4,
      "NUM",  0,  5, "CHAR", 1,  5, "HLT",  2,  5, "SLA",  0,  6, "SRA",  1,  6,
      "SLAX", 2,  6, "SRAX", 3,  6, "SLC",  4,  6, "SRC",  5,  6, "MOVE", 1,  7,
      "LDA",  5,  8, "LD1",  5,  9, "LD2",  5, 10, "LD3",  5, 11, "LD4",  5, 12,
      "LD5",  5, 13, "LD6",  5, 14, "LDX",  5, 15, "LDAN", 5, 16, "LD1N", 5, 17,
      "LD2N", 5, 18, "LD3N", 5, 19, "LD4N", 5, 20, "LD5N", 5, 21, "LD6N", 5, 22,
      "LDXN", 5, 23, "STA",  5, 24, "ST1",  5, 25, "ST2",  5, 26, "ST3",  5, 27,
      "ST4",  5, 28, "ST5",  5, 29, "ST6",  5, 30, "STX",  5, 31, "STJ",  2, 32,
      "STZ",  5, 33, "JBUS", 0, 34, "IOC",  0, 35, "IN",   0, 36, "OUT",  0, 37,
      "JRED", 0, 38, "JMP",  0, 39, "JSJ",  1, 39, "JOV",  2, 39, "JNOV", 3, 39,
      "JL",   4, 39, "JE",   5, 39, "JG",   6, 39, "JGE",  7, 39, "JNE",  8, 39,
      "JLE",  9, 39, "JAN",  0, 40, "JAZ",  1, 40, "JAP",  2, 40, "JANN", 3, 40,
      "JANZ", 4, 40, "JANP", 5, 40, "J1N",  0, 41, "J1Z",  1, 41, "J1P",  2, 41,
      "J1NN", 3, 41, "J1NZ", 4, 41, "J1NP", 5, 41, "J2N",  0, 42, "J2Z",  1, 42,
      "J2P",  2, 42, "J2NN", 3, 42, "J2NZ", 4, 42, "J2NP", 5, 42, "J3N",  0, 43,
      "J3Z",  1, 43, "J3P",  2, 43, "J3NN", 3, 43, "J3NZ", 4, 43, "J3NP", 5, 43,
      "J4N",  0, 44, "J4Z",  1, 44, "J4P",  2, 44, "J4NN", 3, 44, "J4NZ", 4, 44,
      "J4NP", 5, 44, "J5N",  0, 45, "J5Z",  1, 45, "J5P",  2, 45, "J5NN", 3, 45,
      "J5NZ", 4, 45, "J5NP", 5, 45, "J6N",  0, 46, "J6Z",  1, 46, "J6P",  2, 46,
      "J6NN", 3, 46, "J6NZ", 4, 46, "J6NP", 5, 46, "JXN",  0, 47, "JXZ",  1, 47,
      "JXP",  2, 47, "JXNN", 3, 47, "JXNZ", 4, 47, "JXNP", 5, 47, "INCA", 0, 48,
      "DECA", 1, 48, "ENTA", 2, 48, "ENNA", 3, 48, "INC1", 0, 49, "DEC1", 1, 49,
      "ENT1", 2, 49, "ENN1", 3, 49, "INC2", 0, 50, "DEC2", 1, 50, "ENT2", 2, 50,
      "ENN2", 3, 50, "INC3", 0, 51, "DEC3", 1, 51, "ENT3", 2, 51, "ENN3", 3, 51,
      "INC4", 0, 52, "DEC4", 1, 52, "ENT4", 2, 52, "ENN4", 3, 52, "INC5", 0, 53,
      "DEC5", 1, 53, "ENT5", 2, 53, "ENN5", 3, 53, "INC6", 0, 54, "DEC6", 1, 54,
      "ENT6", 2, 54, "ENN6", 3, 54, "INCX", 0, 55, "DECX", 1, 55, "ENTX", 2, 55,
      "ENNX", 3, 55, "CMPA", 5, 56, "CMP1", 5, 57, "CMP2", 5, 58, "CMP3", 5, 59,
      "CMP4", 5, 60, "CMP5", 5, 61, "CMP6", 5, 62, "CMPX", 5, 63};
%}
%union {
    unsigned val;     /* WATCH OUT FOR THIS */
    struct Symbol *symp;
    char *txt;
}
%token <symp> DEFINED_SYMBOL
%token <symp> LOCAL_SYMBOL
%token <symp> FUTURE_REFERENCE
%token <symp> LOC    
%token <symp> END    
%token <val> UNDEF 
%token <val> DEF 
%token <val> NUMBER
%token <val> ASTERISK
%token <txt> TEXT
%token <txt> OPCODE
%token <txt> PSEUDO
%token <txt> ALF      
%left '-' '+'
%left '*' '/'
%left ':' SLASHES 
%nonassoc UMINUS

%type  <val>  expression 
%type  <val>  atomic_expression 
%type  <val>  a_part i_part f_part w_value
%type <symp>  literal_constant
%type <symp>  label              
%type  <txt>  op pseudo
%%
statement_list:  statement comment '\n'           { lineno++; }
      |  statement_list  statement comment '\n'  { lineno++; }
      ;

statement: label op a_part i_part f_part {
                        word = eval_op(opcode);
                        word |= SIGN($3) | MAG($3)*B3 | $4*B2 | $5*B1;  
                        update_memory(word); }
    | label pseudo w_value { if (!strcmp(opcode,"EQU"))  {
                               /* if no label wizard debug */
                               if ($1 == NULL) dumpsymtab();
                               else  $1->value = $3;
                           } else if (!strcmp(opcode,"ORIG")) {
                                 location_counter = word_s($3);
                             } else if (!strcmp(opcode,"CON")) {
                                update_memory($3);
                               } else if (!strcmp(opcode,"END")) {
                                  if ($1 != NULL) $1->type = END; 
                                  symbols();
                                  end_routine(word_s($3));
                                 }
                        }                    
     
    | label ALF   { update_memory(num($2)); }

    | ASTERISK  { ; }
    ;

label: /* none */  { $$ = NULL; }
     | LOC  { $$ = $1; 
              $1->type = DEF; 
              $1->line = lineno;
              $1->value = location_counter; }
     ;

comment:  /* nothing */
        | TEXT { ; } 
        ;

op:   OPCODE   {strcpy(opcode,$1);}
    ;

pseudo:   PSEUDO    {strcpy(opcode,$1);}
        ;

  
expression:   atomic_expression  
      |       '+'  atomic_expression %prec UMINUS  { $$ = $2; }
      |       '-'  atomic_expression %prec UMINUS  { $$ = $2^MINUS; } 
      |       expression '+' atomic_expression { $$ = add_mix($1,$3); }
      |       expression '-' atomic_expression { $$ = sub_mix($1,$3); }
      |       expression ASTERISK atomic_expression { $$ = mul_mix($1,$3); }
      |       expression '/' atomic_expression { $$ = div_mix($1,$3); } 
      |       expression SLASHES atomic_expression { $$ = mul_mix($1,B5/MAG($3)); }
      |       expression ':' atomic_expression { $$ = add_mix(mul_mix($1,8),$3); }
      ;

atomic_expression: NUMBER
    |              ASTERISK        { $$ = location_counter; }
    |              DEFINED_SYMBOL  { $$ = $1->value; }
    |              LOCAL_SYMBOL    { $$ = $1->value = find_backward($1->name); }
    ;  

a_part:                     { $$ = 0; }
      |  expression
      |  FUTURE_REFERENCE   {  $1->reflist = addref($1->reflist,location_counter,lineno); }
      |  literal_constant   { ; }
      ;    

i_part:                    { $$ = 0; }
      |  ',' expression    { $$ = $2; }
      ;    

f_part:                       { $$ = eval_f(opcode); }
      |  '('  expression ')'  { $$ = $2; }
      ;    

w_value:  expression f_part             { $$ = w_eval(0,$1,$2); }
      |   w_value ',' expression f_part { $$ = w_eval($1,$3,$4); }
      ;

literal_constant:  '=' w_value '='   { sprintf(literal,"=%d=",word_s($2));
                                      if (!(s = lookup(literal)))
                                           s = install(literal,$2,lineno);
                                      s->reflist = addref(s->reflist,location_counter,lineno);      
                                    }
                         
      ;
    
%%      
unsigned add_mix(unsigned a, unsigned b)
{ 
   unsigned s, t;
   s = SIGN(a), t = SIGN(b);
   if (s != t) {
     if (MAG(a) > MAG(b)) {
        a = MAG(a) - MAG(b);   
        t = s;
     }
     else
        a = MAG(b) - MAG(a);   
   } else 
     a = MAG(a) + MAG(b);
   if (a > B5-1) yyerror("Arithmetic result greater than 1073741823");
   return(a|t);
}

unsigned sub_mix(unsigned a, unsigned b)
{
   b ^= MINUS;
   return (add_mix (a, b));
}


unsigned mul_mix(unsigned a, unsigned b)
{
  unsigned s;
  long long w;
  s = SIGN(a) == SIGN(b)  ? PLUS : MINUS;
  if ((w = MAG(a)*MAG(b)) > B5-1) yyerror("Arithmetic result greater than 1073741823");
  return(s|MAG(w));
}
  
unsigned div_mix(unsigned a, unsigned b)
{
  unsigned s;
  s = SIGN(a);
  return(s|MAG(MAG(a)/MAG(b)));
}
   
unsigned w_eval(unsigned x, unsigned y,int f)
{
    int l, r;
    unsigned sign, mask;
    l = f/8, r = f%8;
    mask = B5 - 1;
    if (l < 0 || l > r || r > 5) yyerror("Invalid F-part");
    if ( l == 0 ) {   /* Is sign included ? */
        sign = MINUS & y;  
        l = 1;
    } else sign = MINUS & x;       /* keep previous sign */
    y <<= (4 - r + l) * BYTESIZE;  /* take correct no of bytes from right end */
    y = MAG(y);                    /* truncate to 5 bytes */
    y >>= (l - 1) * BYTESIZE;      /* position within word */
    mask <<= (4 - r + l) * BYTESIZE; /* do same for mask */
    mask = MAG(mask);                /* truncate to 5 bytes */
    mask >>= (l - 1) * BYTESIZE;  
    x &= ~mask;    /* mask off where y is to be inserted */
    x = MAG(x);                     /* discard sign */
    x |= y;        /* insert y */
    x |= sign;     /* insert sign */
    return x;
}
word_s(unsigned w)  /* convert mix word into a signed integer */
{
    if (w & MINUS)  w = -MAG(w);         
    return w;
}

yyerror(s)  /* called for yacc syntax error */
  char *s;
{
    warning(s, (char *) 0);
}
warning(s, t)
  char *s, *t;
{
    fprintf(stderr, "%s: %s", progname, s);
    if (t)
      fprintf(stderr, " %s", t);
    fprintf(stderr, " near line %d\n", lineno);
}
main(int argc, char *argv[])
{
    extern FILE *yyin, *yyout, *lst;
    int i;
    
    progname = argv[0];
    lst = fopen("mixal.lst","w"); 
    for (i=0; i<MEMORYSIZE; i++) lines[i] = -1;
    while (argc > 1 && argv[1][0] == '-') {
       switch (argv[1][1]) {
       case 'l':  /* produce a listing */
           list = 1;
           break;
       case 'V':  /* show version */
           printf("%s: version %4.2f\n", progname, version);
           exit(0);
       default:
           fprintf(stderr,"%s: unknown arg %s\n", progname, argv[1]);
           exit(1);
       }
       argc--, argv++;
    }
    if (argc > 1) {
      source_file = argv[1];
      if ((yyin = fopen(source_file, "r")) == NULL) {
        fprintf(stderr,"Can't open %s\n", argv[1]);
        exit(1);
       }
    }
    yyparse();
}
dumpsymtab()
{
    Symbol *s;
    ref *p;
  
    fprintf(stderr,"\nSymbol     Value  Line\n");
    s = symlist;
    while (s) { /* don't dump local symbol backward and forward refs */
      if (strlen(s->name) != 2 ||  s->name[0] < '0' || s->name[0] > '9' ||
           (s->name[1] != 'B' && s->name[1] != 'F'))
        fprintf(stderr,"%-10s  %4d %4d\n",s->name,word_s(s->value),s->line);
      s = s->next;
    }
}

symbols()
/* dump literals and fix forward refs and undefined symbols */
{
    Symbol *s;
    ref *p;
  
    s = symlist;
    while (s) {
        if (s->name[0] == '=') {
          memory[location_counter] = w_eval(0,s->value,5);
          s->value = location_counter++;
        }
        if (s->type == UNDEF && (strlen(s->name) != 2 ||
                                 s->name[1] != 'F'||
                                 s->name[0] < '0' ||
                                 s->name[0] > '9')) {
          fprintf(stderr,"Warning: '%-10s CON  0' inserted at %d:\n",
                            s->name,location_counter);
          memory[location_counter] = 0;
          s->value = location_counter++;
          s->type = DEF;
        }
        s = s->next;
    }
    s = symlist;
    while (s) {
       /* Now that the literal pool has been dumped we can
          evaluate the location of the END statement */          
        if (s->type == END)   s->value = location_counter; 
       /* Now we can handle any forward references */
        p = s->reflist;
        while (p) {
            memory[p->address] &= (B3 - 1);
            memory[p->address] |= s->value<<(BYTESIZE*3);
            p = p->next;
        }
        if (strlen(s->name) == 2 && s->name[1] == 'F' &&
                    s->name[0] >= '0' && s->name[0] <= '9') {
             find_forward(s);
             s->type = DEF;
        }
        s = s->next;
    }
}
end_routine(int start)
{
  long address, loc, sign, value;
  int i, j, flag, l; 
  int A, I, F, C, S;
  char field[7][11];
  char title[6];
  FILE *obj;
 
  if (source_file) {
    for (i=0; i<5 && source_file[i]; i++) 
      title[i] = toupper(source_file[i]);
    title[i] = '\0';
  }
  else
       strcpy(title,"MIXAL");
  if (list) {
    obj = fopen("mixal.obj","w");
    dumpsymtab();
    for (l=1;l <= lineno;l++) 
      if ((i = lines[l]) != -1) {
        S = (memory[i] & MINUS) ? '-' : '+';
        A = (memory[i] & (B5 - 1))>>3*BYTESIZE;
        I = (memory[i] & (B3 - 1))>>2*BYTESIZE;
        F = (memory[i] & (B2 - 1))>>BYTESIZE;
        C = (memory[i] & (B1 - 1));
        fprintf(obj,"%4d: %c %4d %2d %2d %2d   %3d\n",i,S,A,I,F,C,l);
      } else fprintf (obj,"%23s %3d\n"," ",l);
  }
  /* The loading routine */
  printf(" O O6 Z O6    I C O4 0 EH A  F F CF 0  E   EU 0 IH G BB   EJ  CA. Z EU   EH E BA\n");
  printf("   EU 2A-H S BB  C U 1AEH 2AEN V  E  CLU  ABG Z EH E BB J B. A  9               \n");
  flag = i = 0;
  for (address=0; address<MEMORYSIZE;address++) 
    if (memory[address]) {
      sign = memory[address] & MINUS ? -1 : 1;
      value = MAG(memory[address]);
      if (!flag) flag=1, loc=address;
      if (address != loc+i || i >= 7) {
        printf("%-5s%1d%04d",title,i,loc);
        for (j=0;j<i;j++) printf("%10s",field[j]);
        printf("\n");
        loc = address;
        i = 0;
      } 
      sprintf(field[i],"%010d",value);
      if (sign < 0) field[i][9] = "~JKLMNOPQR"[field[i][9]-'0'];
       i++;
    }
  printf("%-5s%1d%04d",title,i,loc);
  for (j=0;j<i;j++) printf("%10s",field[j]);
  printf("\n");
  printf("TRANS0%04d\n",start);
}
num(char *text) 
{
    int i, n;
    char *p;  
    char alf[] =
        " ABCDEFGHInJKLMNOPQRepSTUVWXYZ0123456789.,()+-*/=$<>@;:'abcdfghi";
    n = 0;
    for (i=0;i<5;i++) 
      if (!text[i])
          n = n*B1;
      else if (p = strchr(alf,text[i]))
          n = n*B1 + (p - alf);
          else yyerror("bad character in ALF constant");
      return n;
}

eval_op(c)
char *c;
{
  int i;
  for (i=0;i<144;i++)
    if (!strcmp(c,ops[i].name)) return ops[i].c;
  yyerror("invalid opcode.");    
}

eval_f(c)
char *c;
{
  int i;
  for (i=0;i<144;i++)
    if (!strcmp(c,ops[i].name)) return ops[i].f;
  return(5);                     
}

find_backward(char *name)
{
    char here[3] = "0H";
    int location;  
    int line;

    s = symlist;
    here[0] = name[0];
    line = 0;       
    while(s) {
      if (!strcmp(s->name, here) && lineno > s->line &&
             s->line > line) {
        location = s->value;
        line = s->line;
      }
      s = s->next;
    }
    if (line == 0) yyerror("missing backward 'here'");
    return location;
}  

find_forward(Symbol *f)
{
    Symbol *s;
    ref *p;
    char here[3] = "0H";
    int location;  
    int line;

    s = symlist;
    here[0] = f->name[0];
    p = f->reflist; 
    while(p) {
      line = B5;               
      s = symlist;
      while(s) {
        if (!strcmp(s->name, here) && p->line < s->line  &&
               s->line < line) {
          location = s->value;
          line = s->line;
        }
        s = s->next;
      }
      f->value = location;
      if (line == B5) yyerror("missing 'forward here'");
      memory[p->address] &= (B3 - 1);
      memory[p->address] |= location<<(BYTESIZE*3);
      p = p->next;
    }
}  
