#define SIGN(word)(word&MINUS)
#define MAG(word)(word&FIVEBYTES)
#define ADDRESS(word)(word&TWOBYTES<<3*BYTESIZE)>>3*BYTESIZE
#define INDEX(word)(word&ONEBYTE<<2*BYTESIZE)>>2*BYTESIZE
#define FIELD(word)(word&ONEBYTE<<BYTESIZE)>>BYTESIZE
#define CODE(word)(word&ONEBYTE)
#define MEMSIZE 4000
#define BYTESIZE 6
#define BYTESPERWORD 5
#define ONEBYTE 077
#define TWOBYTES 07777
#define FIVEBYTES 07777777777
#define PLUS 0
#define MINUS (1<<(WORDSIZE+1))
#define WORDSIZE BYTESIZE*BYTESPERWORD
#define LDA 8
#define LDAN 16
#define STA 24
#define IOC 35
#define IN 36
#define OUT 37
#define JA 40
#define INCA 48
#define CMPA 56
#define ON 1
#define OFF 0
#define LESS -1
#define EQUAL 0
#define GREATER 1 \
 \
 \

#define areg reg[0]
#define i1reg reg[1]
#define i2reg reg[2]
#define i3reg reg[3]
#define i4reg reg[4]
#define i5reg reg[5]
#define i6reg reg[6]
#define xreg reg[7]
#define jreg reg[8]
#define zero reg[9]
#define signa sign[0]
#define sign1 sign[1]
#define sign2 sign[2]
#define sign3 sign[3]
#define sign4 sign[4]
#define sign5 sign[5]
#define sign6 sign[6]
#define signx sign[7]
#define signj sign[8]
#define signz sign[9] \

#define T 1
#define F 0 \

#define TAPE7 7
#define DISK8 8
#define DISK15 15
#define READER 16
#define PUNCH 17
#define PRINTER 18
#define MAXUNITS 19 \
 \

#define sch(p)(sign[p]?'-':'+')
/*2:*/
#line 13 "mixsim.w"

/*9:*/
#line 289 "mixsim.w"

#include <stdio.h>
#include <fcntl.h>
#include <strings.h>
#include <signal.h>
/*:9*/
#line 14 "mixsim.w"

/*4:*/
#line 74 "mixsim.w"

float version= 1.01;
char*progname;
long cell[MEMSIZE];
long reg[10]= {0,0,0,0,0,0,0,0,0,0};
long sign[10]= {0,0,0,0,0,0,0,0,0,0};
/*:4*//*5:*/
#line 85 "mixsim.w"

typedef void(*PFV)();
typedef int BOOLEAN;

void nop(),add(),sub(),mul(),div(),spec(),shift(),move(),
load(),loadn(),store(),jbus(),ioc(),in(),out(),jred(),
jump(),regjump(),addrop(),compare();

struct operation{PFV fn;
int time;
BOOLEAN iflag;
};

struct operation optable[64]= {
{nop,1,F},
{add,2,F},
{sub,2,F},
{mul,10,F},
{div,12,F},
{spec,1,F},
{shift,2,F},
{move,1,F},
{load,2,F},
{load,2,T},
{load,2,T},
{load,2,T},
{load,2,T},
{load,2,T},
{load,2,T},
{load,2,F},
{loadn,2,T},
{loadn,2,F},
{loadn,2,F},
{loadn,2,F},
{loadn,2,F},
{loadn,2,F},
{loadn,2,F},
{loadn,2,T},
{store,2,F},
{store,2,F},
{store,2,F},
{store,2,F},
{store,2,F},
{store,2,F},
{store,2,F},
{store,2,F},
{store,2,F},
{store,2,F},
{jbus,1,F},
{ioc,1,F},
{in,1,F},
{out,1,F},
{jred,1,F},
{jump,1,F},
{regjump,1,F},
{regjump,1,F},
{regjump,1,F},
{regjump,1,F},
{regjump,1,F},
{regjump,1,F},
{regjump,1,F},
{regjump,1,F},
{addrop,1,F},
{addrop,1,T},
{addrop,1,T},
{addrop,1,T},
{addrop,1,T},
{addrop,1,T},
{addrop,1,T},
{addrop,1,F},
{compare,2,T},
{compare,2,T},
{compare,2,T},
{compare,2,T},
{compare,2,T},
{compare,2,T},
{compare,2,T},
{compare,2,T}};

/*:5*//*6:*/
#line 179 "mixsim.w"

void tape(),disk(),reader(),punch(),printer();


struct io_device{PFV device;
int io_time;
int position;
int seek_pos;
int tape_end;
int seek_time;
int address;
int io_op;
int clock;
int complete;
int fd;
};

struct io_device*unitp,unit[MAXUNITS]= {
{tape,50,0,0,0,50,0,0,-1,1,0},
{tape,50,0,0,0,50,0,0,-1,1,0},
{tape,50,0,0,0,50,0,0,-1,1,0},
{tape,50,0,0,0,50,0,0,-1,1,0},
{tape,50,0,0,0,50,0,0,-1,1,0},
{tape,50,0,0,0,50,0,0,-1,1,0},
{tape,50,0,0,0,50,0,0,-1,1,0},
{tape,50,0,0,0,50,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{disk,250,0,0,0,1,0,0,-1,1,0},
{reader,10000,0,0,0,0,0,0,-1,1,0},
{punch,20000,0,0,0,0,0,0,-1,1,0},
{printer,7500,0,0,0,10000,0,0,-1,1,0}};


/*:6*//*7:*/
#line 219 "mixsim.w"

int loc;
int mem;
int op;
int fld;
long inst;
int compi= EQUAL;
int ovtog= OFF;
int uclock;
int time= 0;
long rA,rX;
int rI1,rI2;
void inc(),dec(),sizechk(),ovcheck(),jmp(),jsj(),jumps(),
addrerror(),indexerror(),operror(),memerror(),fielderror(),sizeerror(),
dump();
PFV interrupt= dump;
/*:7*/
#line 15 "mixsim.w"

/*10:*/
#line 296 "mixsim.w"

void memory()
{
if(mem<0||mem>=MEMSIZE)memerror();
rA= MAG(cell[mem]);
rX= SIGN(cell[mem]);
}
/*:10*//*11:*/
#line 306 "mixsim.w"

void fcheck()
{
rI1= rA= fld/8;
rI2= rX= fld%8;
if(rA>rX||rX>5)fielderror();
}
/*:11*//*12:*/
#line 314 "mixsim.w"

void sizechk()
{
if(optable[op].iflag){
if(abs(rA)>TWOBYTES)sizeerror();
}else ovcheck();
}

/*:12*//*13:*/
#line 323 "mixsim.w"

void ovcheck()
{
if(rA&FIVEBYTES+1)ovtog= ON;
rA&= FIVEBYTES;
}
/*:13*//*14:*/
#line 332 "mixsim.w"

void getav()
{
if(rI1){
rX= PLUS;
rA<<= (BYTESIZE*(rI1-1));
rA&= FIVEBYTES;
rA>>= (BYTESIZE*(rI1-1));
}
rA>>= (BYTESIZE*(BYTESPERWORD-rI2));
}
/*:14*//*15:*/
#line 345 "mixsim.w"

void getv()
{
fcheck();
memory();
getav();
}
/*:15*//*16:*/
#line 354 "mixsim.w"

void nop()
{

if(fld==63)uclock= -1;
}
/*:16*//*17:*/
#line 361 "mixsim.w"

void add()
{
getv();
rI1= 0;
inc();
}
/*:17*//*18:*/
#line 369 "mixsim.w"

void sub()
{
getv();
rI1= 0;
dec();
}
/*:18*//*19:*/
#line 377 "mixsim.w"

void mul()
{
long long work;

getv();
if(rX==signa)
rX= PLUS;
else
rX= MINUS;
signa= signx= rX;
work= rA*(long long int)areg;
xreg= work&FIVEBYTES;
work>>= WORDSIZE;
areg= work&FIVEBYTES;
}

/*:19*//*20:*/
#line 395 "mixsim.w"

void div()
{
long long work;

signx= signa;
getv();
if(rX==signa)
rX= PLUS;
else
rX= MINUS;
signa= rX;
if(areg>rA)ovtog= ON;
work= areg;
work<<= WORDSIZE;
work|= xreg;
areg= (work/rA)&FIVEBYTES;
xreg= work%rA;
}

/*:20*//*21:*/
#line 416 "mixsim.w"

void loadn()
{
getv();
rI1= op-LDAN;
rX= rX?PLUS:MINUS;
reg[rI1]= rA&FIVEBYTES;
sign[rI1]= rX;
sizechk();
}
void load()
{
getv();
rI1= op-LDA;
reg[rI1]= rA&FIVEBYTES;
sign[rI1]= rX;
sizechk();
}

/*:21*//*22:*/
#line 436 "mixsim.w"

void store()
{
long work;

fcheck();
memory();
if(!rI1){
rI1= 1;
rX= sign[op-STA];
}
rA<<= (BYTESIZE*rI2);
rA&= FIVEBYTES;
rA>>= (BYTESIZE*rI2);
work= rA;
rA= cell[mem];
rA&= FIVEBYTES;
rA>>= (BYTESIZE*(BYTESPERWORD-(rI1-1)));
rA<<= (BYTESIZE*(BYTESPERWORD-(rI1-1)));
work|= rA;
rA= reg[op-STA];
rA<<= (BYTESIZE*(BYTESPERWORD-rI2+(rI1-1)));
rA&= FIVEBYTES;
rA>>= (BYTESIZE*(rI1-1));
work|= rA;
work|= rX;
cell[mem]= work;
}
/*:22*//*23:*/
#line 465 "mixsim.w"

void jump()
{
if(fld>9)fielderror();
rA= compi;
jumps(fld);
}
void jumps(int fld)
{
switch(fld)
{
case 0:
jmp();
break;
case 1:
jsj();
break;
case 2:
rX= ovtog;
ovtog= OFF;
if(rX)jmp();
break;
case 3:
rX= ovtog;
ovtog= OFF;
if(!rX)jmp();
break;
case 4:
if(rA<0)jmp();
break;
case 5:
if(rA==0)jmp();
break;
case 6:
if(rA>0)jmp();
break;
case 7:
if(rA>=0)jmp();
break;
case 8:
if(rA!=0)jmp();
break;
case 9:
if(rA<=0)jmp();
break;
}
}

void jmp()
{
jreg= loc;
jsj();
}
void jsj()
{
memory();
loc= mem;
}

/*:23*//*24:*/
#line 525 "mixsim.w"

void regjump()
{
rA= reg[op-JA];
rA= sign[op-JA]?-rA:rA;
if(fld>5)fielderror();
jumps(fld+4);
}

/*:24*//*25:*/
#line 535 "mixsim.w"

void addrop()
{
if(fld>3)fielderror();
if(!mem)rX= SIGN(inst);
else rX= mem<0?MINUS:PLUS;
rA= mem>0?mem:-mem;
rI1= op-INCA;
switch(fld){
case 0:
inc();
break;
case 1:
dec();
break;
case 2:
reg[rI1]= rA&FIVEBYTES;
sign[rI1]= rX;
sizechk();
break;
case 3:
reg[rI1]= rA&FIVEBYTES;
sign[rI1]= rX?PLUS:MINUS;
sizechk();
break;
}
}
void dec()
{
rX= rX?PLUS:MINUS;
inc();
}
void inc()
{
if(rX!=sign[rI1]){
rA-= reg[rI1];
if(rA>0)
sign[rI1]= rX;
else
rA= -rA;
}
else rA+= reg[rI1];
reg[rI1]= rA&FIVEBYTES;
sizechk();
}

/*:25*//*26:*/
#line 582 "mixsim.w"

void compare()
{
long v;

getv();
v= rX?-rA:rA;
rA= reg[op-CMPA];
rX= sign[op-CMPA];
getav();
rX= rX?-rA:rA;
if(rX==v)compi= EQUAL;
else compi= rX>v?GREATER:LESS;
}

/*:26*//*27:*/
#line 598 "mixsim.w"

void shift()
{
unsigned long long work,work1;
if(mem<0)addrerror();
if(fld>5)fielderror();
rA= areg;
work= areg;
work<<= WORDSIZE;
work|= xreg;

switch(fld){
case 0:
if(mem>BYTESPERWORD)mem= BYTESPERWORD;
rA<<= mem*BYTESIZE;
areg= rA&FIVEBYTES;
break;
case 1:
if(mem>BYTESPERWORD)mem= BYTESPERWORD;
rA>>= mem*BYTESIZE;
areg= rA;
break;
case 2:
if(mem>(2*BYTESPERWORD))mem= (2*BYTESPERWORD);
work<<= mem*BYTESIZE;
rX= work&FIVEBYTES;
work>>= WORDSIZE;
rA= work&FIVEBYTES;
areg= rA;
xreg= rX;
break;
case 3:
if(mem>(2*BYTESPERWORD))mem= (2*BYTESPERWORD);
work>>= mem*BYTESIZE;
rX= work&FIVEBYTES;
work>>= WORDSIZE;
rA= work&FIVEBYTES;
areg= rA;
xreg= rX;
break;
case 4:
mem%= (2*BYTESPERWORD);
work1= work;
work<<= mem*BYTESIZE;
work1>>= (((2*BYTESPERWORD)-mem)*BYTESIZE);
work|= work1;
rX= work&FIVEBYTES;
work>>= WORDSIZE;
rA= work&FIVEBYTES;
areg= rA;
xreg= rX;
break;
case 5:
mem%= (2*BYTESPERWORD);
work1= work;
work>>= mem*BYTESIZE;
work1<<= (((2*BYTESPERWORD)-mem)*BYTESIZE);
work|= work1;
rX= work&FIVEBYTES;
work>>= WORDSIZE;
rA= work&FIVEBYTES;
areg= rA;
xreg= rX;
break;
}
}
/*:27*//*28:*/
#line 665 "mixsim.w"

void move(){
while(fld){
memory();
rX|= rA;
rI1= i1reg;
rA= sign1;
if(rA){
if(rI1)memerror();
sign1= 0;
}
if(rI1>MEMSIZE)memerror();
cell[rI1]= rX;
uclock+= 2;
rI1++;
i1reg= rI1;
mem++;
fld--;
}
}

/*:28*//*29:*/
#line 687 "mixsim.w"

void jbus(){
if(unitp->clock>uclock){
if(loc-1==mem){
do_outstanding_io(unitp->clock);
uclock= unitp->clock;
}
jmp();
}
}

/*:29*//*30:*/
#line 699 "mixsim.w"

void ioc(){
int I;
if(fld==PUNCH||fld==READER)return;
if(unitp->clock>uclock){
do_outstanding_io(unitp->clock);
uclock= unitp->clock;
do_io();
}
if(unitp->clock>uclock){
do_outstanding_io(unitp->clock);
uclock= unitp->clock;
do_io();
}
unitp->io_op= op;
unitp->address= mem;
if(fld<=TAPE7)
if(mem)unitp->clock= uclock+abs(mem)*unitp->seek_time;
else unitp->clock= uclock+unitp->position*unitp->seek_time;
if(DISK8<=fld&&fld<=DISK15){
unitp->clock= uclock+abs(xreg-unitp->position)*unitp->seek_time;
unitp->seek_pos= xreg;
}
if(fld==PRINTER){
unitp->clock= uclock+unitp->seek_time;
}
}

/*:30*//*31:*/
#line 728 "mixsim.w"

void in()
{
if(unitp->clock>uclock){
do_outstanding_io(unitp->clock);
uclock= unitp->clock;
do_io();
}
if(unitp->clock>uclock){
do_outstanding_io(unitp->clock);
uclock= unitp->clock;
do_io();
}
unitp->io_op= op;
unitp->address= mem;
unitp->clock= uclock+unitp->io_time/2;
unitp->complete= F;
if(fld>=DISK8&&fld<=DISK15){
unitp->clock+= abs(xreg-unitp->position)*unitp->seek_time;
unitp->seek_pos= xreg;
}
}

/*:31*//*32:*/
#line 752 "mixsim.w"

void jred(){
if(unitp->clock<=uclock)
jmp();
}

/*:32*//*33:*/
#line 759 "mixsim.w"

void spec(){
long long n,m;
char work[11];
int i,next,device,t;
int table[10]= {30,31,32,33,34,35,36,37,38,39};

if(fld>2)fielderror();
switch(fld){
case 0:
n= 0;
m= 1;
for(i= 0;i<BYTESPERWORD;i++){
n+= (xreg>>BYTESIZE*i)%64%10*m;
m*= 10;
}
for(i= 0;i<BYTESPERWORD;i++){
n+= (areg>>BYTESIZE*i)%64%10*m;
m*= 10;
}
areg= n&FIVEBYTES;
if(areg!=n)ovtog= ON;
uclock+= 9;
break;
case 1:
sprintf(work,"%010d",areg);
areg= xreg= 0;
for(i= 0;i<BYTESPERWORD;i++){
areg|= table[work[i]-'0']<<((BYTESPERWORD-(i+1))*BYTESIZE);
xreg|= table[work[i+BYTESPERWORD]-'0']<<((BYTESPERWORD-(i+1))*BYTESIZE);
}
uclock+= 9;
break;
case 2:
do_outstanding_io(FIVEBYTES);
dump();
exit(-1);
}
}

/*:33*//*34:*/
#line 800 "mixsim.w"


void out()
{
if(unitp->clock>uclock){
do_outstanding_io(unitp->clock);
uclock= unitp->clock;
do_io();
}
if(unitp->clock>uclock){
do_outstanding_io(unitp->clock);
uclock= unitp->clock;
do_io();
}
unitp->io_op= op;
unitp->address= mem;
unitp->clock= uclock+unitp->io_time/2;
unitp->complete= F;
if(fld>=DISK8&&fld<=DISK15){
unitp->clock+= abs(xreg-unitp->position)*unitp->seek_time;
unitp->seek_pos= xreg;
}
}

/*:34*//*35:*/
#line 825 "mixsim.w"

do_io()
{
if(!unitp->complete){
(*unitp->device)();
unitp->complete= T;
unitp->clock= uclock+unitp->io_time/2;
}
else unitp->clock= -1;
}

do_outstanding_io(int time)
{
int i,next,save_fld;

save_fld= fld;
next= 0;
while(next!=time){
next= time;
for(i= 0;i<MAXUNITS;i++)
if(unit[i].clock>0&&unit[i].clock<next){
next= unit[i].clock;
fld= i;
}
if(next!=time){
unitp= &unit[fld];
uclock= unitp->clock;
do_io();
}
}
fld= save_fld;
unitp= &unit[fld];
}

/*:35*//*36:*/
#line 860 "mixsim.w"

void reader()
{
char buffer[82];
char table[]= " ABCDEFGHI~JKLMNOPQR~~STUVWXYZ0123456789.,()+-*/=";
int i,j,l;
char*p;

fgets(buffer,82,stdin);
l= strlen(buffer);
for(i= 0;i<16;i++){
cell[unit[READER].address]= 0;
for(j= 0;j<BYTESPERWORD;j++)
if(i*BYTESPERWORD+j<l&&(p= strchr(table,buffer[i*BYTESPERWORD+j])))
cell[unit[READER].address]|= (p-table)<<(BYTESIZE*(BYTESPERWORD-(j+1)));
unit[READER].address++;
}
}
/*:36*//*37:*/
#line 879 "mixsim.w"

void printer()
{
char table[]= " ABCDEFGHI~JKLMNOPQR~~STUVWXYZ0123456789.,()+-*/=$<>@;:'~~~~~~~~";
int i,j;

switch(unitp->io_op){
case IOC:
printf("\f");
break;
case OUT:
for(i= 0;i<24;i++)
for(j= BYTESPERWORD-1;j>=0;j--)
putchar(table[(cell[unit[PRINTER].address+i]&ONEBYTE<<BYTESIZE*j)>>BYTESIZE*j]);
putchar('\n');
break;
}
}
/*:37*//*38:*/
#line 898 "mixsim.w"

void punch()
{
char table[]= " ABCDEFGHI~JKLMNOPQR~~STUVWXYZ0123456789.,()+-*/=$<>@;:'~~~~~~~~";
int i,j;

for(i= 0;i<15;i++)
for(j= BYTESPERWORD-1;j>=0;j--)
putc(table[(cell[unit[PUNCH].address+i]&ONEBYTE<<BYTESIZE*j)>>BYTESIZE*j],stderr);
putc('\n',stderr);
}
/*:38*//*39:*/
#line 910 "mixsim.w"

void tape()
{
char path[7];

sprintf(path,"tape%d",fld);
if(!unitp->fd){
unitp->position= unitp->tape_end= 0;
if(unitp->io_op==OUT){
if((unitp->fd= open(path,O_RDWR|O_CREAT|O_TRUNC,0777))<0)
fprintf(stderr,"Write open failed for %s\n",path);
}else{
if(!unitp->fd&&(unitp->fd= open(path,O_RDWR))<0)
fprintf(stderr,"Read open failed for %s\n",path);
}
}

switch(unitp->io_op){
case OUT:
if(write(unitp->fd,&cell[unitp->address],400)<0)
fprintf(stderr,"Write failed for %s\n",path);
unitp->position++;
unitp->tape_end= unitp->position;
break;
case IN:
if(read(unitp->fd,&cell[unitp->address],400)<=0)
fprintf(stderr,"Read failed for %s\n",path);
unitp->position++;
break;
case IOC:
if(unitp->address==0){
close(unitp->fd);
unitp->fd= NULL;
unitp->position= 0;
}else{
if(unitp->position+unitp->address<0){
close(unitp->fd);
unitp->position= 0;
}else{
if(lseek(unitp->fd,unitp->address*400,SEEK_CUR)<0)
fprintf(stderr,"IOC %d on tape %d failed\n",unitp->address,fld);
unitp->position+= unitp->address;
}
}
}
}
/*:39*//*40:*/
#line 961 "mixsim.w"

void disk()
{
char path[8];
int i,offset;

sprintf(path,"disk%d",fld);
if(!unitp->fd){
if((unitp->fd= open(path,O_RDWR|O_CREAT,0777))<0)
fprintf(stderr,"Open failed for %s\n",path);
}
switch(unitp->io_op){
case IOC:
unitp->position= unitp->seek_pos;
break;
case OUT:
if(lseek(unitp->fd,unitp->seek_pos*400,SEEK_SET)<0)
fprintf(stderr,"Seek failed for %s\n",path);
else unitp->position= unitp->seek_pos;
if(write(unitp->fd,&cell[unitp->address],400)<0)
fprintf(stderr,"Write failed for %s\n",path);
else unitp->position++;
break;
case IN:
if(lseek(unitp->fd,unitp->seek_pos*400,SEEK_SET)<0)
fprintf(stderr,"Seek failed for %s\n",path);
else unitp->position= unitp->seek_pos;
if(read(unitp->fd,&cell[unitp->address],400)<=0)
fprintf(stderr,"Read failed for %s\n",path);
else unitp->position++;
break;
}
}


/*:40*//*41:*/
#line 997 "mixsim.w"

void indexerror()
{
fprintf(stderr,"Invalid index register: %d\n",rI2);
dump();
}
void addrerror()
{
fprintf(stderr,"Invalid address: %d\n",mem);
dump();
}
void operror()
{
fprintf(stderr,"Invalid opcode: %d\n",op);
dump();
}
void memerror()
{
fprintf(stderr,"Invalid memory location: %d\n",mem);
dump();
}
void fielderror()
{
fprintf(stderr,"Invalid field: %d\n",fld);
dump();
}
void sizeerror()
{
fprintf(stderr,"Invalid size: %d\n",rA);
dump();
}


/*:41*//*42:*/
#line 1032 "mixsim.w"

dump_status()
{
char t[4],c[8];
if(ovtog)strcpy(t,"ON");
else strcpy(t,"OFF");
if(!compi)strcpy(c,"EQUAL");
else if(compi>0)strcpy(c,"GREATER");
else strcpy(c,"LESS");
fprintf(stderr,"Registers A/X    %c0%010o %c0%010o\n",sch(0),reg[0],sch(7),reg[7]);
fprintf(stderr,"                 %c %10d %c %10d\n\n",sch(0),reg[0],sch(7),reg[7]);
fprintf(stderr,"Index Registers  %c0%04o  %c0%04o  %c0%04o  %c0%04o  %c0%04o  %c0%04o \n",
sch(1),reg[1],sch(2),reg[2],sch(3),reg[3],sch(4),reg[4],sch(5),reg[5],sch(6),reg[6]);
fprintf(stderr,"                 %c %4d  %c %4d  %c %4d  %c %4d  %c %4d  %c %4d \n\n",
sch(1),reg[1],sch(2),reg[2],sch(3),reg[3],sch(4),reg[4],sch(5),reg[5],sch(6),reg[6]);
fprintf(stderr,"Jump Register    %c0%04o     Overflow toggle:      %s\n",sch(8),reg[8],t);
fprintf(stderr,"                 %c %4d     Comparison Indicator: %s\n\n",sch(8),reg[8],c);
fprintf(stderr,"Clock = %d u. Location = %04d, M %d, I %d, F %d, C %d, inst = %c %010o \n\n",
uclock,loc,mem,INDEX(inst),fld,op,SIGN(inst)?'-':'+',MAG(inst));
}

void dump_memory()
{
char buff[2][132];
int a,i,j,k,flag;
k= 0;
flag= 0;
a= 0;
for(i= 0;i<MEMSIZE;i+= 8){
k= ++k%2;
sprintf(buff[k],"%04d ",i);
for(j= 0;j<8;j++){
sprintf(buff[k]+5+j*15,"%c%04d %02d %02d %02d ",SIGN(cell[i+j])?'-':'+',
ADDRESS(cell[i+j]),INDEX(cell[i+j]),FIELD(cell[i+j]),CODE(cell[i+j]));
}
if(strcmp(buff[0]+5,buff[1]+5)){
if(flag){
if(a-i+8)fprintf(stderr,"    Lines %04d to %04d are the same.\n",a,i-16);
fprintf(stderr,"%s\n",buff[(k+1)%2]);
}
flag= 0;
fprintf(stderr,"%s\n",buff[k]);
}
else{
if(!flag)a= i;
flag= 1;
}
}
if(flag){
if(a-i+8)fprintf(stderr,"    Lines %04d to %04d are the same.\n",a,i-16);
fprintf(stderr,"%s\n",buff[k%2]);
}
}

void dump()
{
dump_status();
dump_memory();
exit(-1);
}

/*:42*/
#line 16 "mixsim.w"

/*8:*/
#line 239 "mixsim.w"

main(int argc,char*argv[])
{
int i,t;
progname= argv[0];

if(signal(SIGINT,SIG_IGN)!=SIG_IGN)signal(SIGINT,interrupt);
while(argc>1&&argv[1][0]=='-'){
switch(argv[1][1]){
case'V':
printf("%s: version %4.2f\n",progname,version);
exit(0);
default:
fprintf(stderr,"%s: unknown arg %s\n",progname,argv[1]);
exit(1);
}
argc--,argv++;
}

go();
loc= 0;
while(T){
uclock+= time;
for(fld= 0;fld<MAXUNITS;fld++){
unitp= &unit[fld];
if(unitp->clock>0&&unitp->clock<=uclock){

do_io();
}
}
inst= cell[loc];
loc++;
if(loc>=MEMSIZE)addrerror();
mem= ADDRESS(inst);
if(SIGN(inst))mem= -mem;
rI2= INDEX(inst);
if(rI2){
if(rI2>6)indexerror();
mem+= sign[rI2]?-reg[rI2]:reg[rI2];
if(abs(mem)>TWOBYTES)addrerror();
}
fld= FIELD(inst);
op= CODE(inst);
if(op>=64)operror(op);
time= optable[op].time;
unitp= &unit[fld];
(*optable[op].fn)();
}
}
/*:8*/
#line 17 "mixsim.w"


/*:2*//*43:*/
#line 1094 "mixsim.w"

go()
{
unit[READER].address= 0;
unitp= &unit[READER];
uclock+= unitp->io_time;
reader();
}/*:43*/
