%{
#include "y.tab.h"
#include "mixal.h"
#include <string.h>
extern FILE *lst;
char label[11] = " ";
char *ptr;
%}

symbol [A-Z0-9]*[A-Z][A-Z0-9]*
opcod1 NOP|ADD|SUB|MUL|DIV|NUM|CHAR|HLT|SLA|SRA|SLAX|SRAX|SLC
opcod2 {opcod1}|SRC|MOVE|LDA|LD1|LD2|LD3|LD4|LD5|LD6|LDX|LDAN
opcod3 {opcod2}|LD1N|LD2N|LD3N|LD4N|LD5N|LD6N|LDXN|STA|ST1|ST2|ST3
opcod4 {opcod3}|ST4|ST5|ST6|STX|STJ|STZ|JBUS|IOC|IN|OUT|JRED
opcod5 {opcod4}|JMP|JSJ|JOV|JNOV|JL|JE|JG|JGE|JNE|JLE|JAN
opcod6 {opcod5}|JAZ|JAP|JANN|JANZ|JANP|J1N|J1Z|J1P|J1NN|J1NZ|J1NP
opcod7 {opcod6}|J2N|J2Z|J2P|J2NN|J2NZ|J2NP|J3N|J3Z|J3P|J3NN|J3NZ
opcod8 {opcod7}|J3NP|J4N|J4Z|J4P|J4NN|J4NZ|J4NP|J5N|J5Z|J5P|J5NN
opcod9 {opcod8}|J5NZ|J5NP|J6N|J6Z|J6P|J6NN|J6NZ|J6NP|JXN|JXZ|JXP
opcoda {opcod9}|JXNN|JXNZ|JXNP|INCA|DECA|ENTA|ENNA|INC1|DEC1|ENT1|ENN1
opcodb {opcoda}|INC2|DEC2|ENT2|ENN2|INC3|DEC3|ENT3|ENN3|INC4|DEC4|ENT4
opcodc {opcodb}|ENN4|INC5|DEC5|ENT5|ENN5|INC6|DEC6|ENT6|ENN6|INCX|DECX
opcode {opcodc}|ENTX|ENNX|CMPA|CMP1|CMP2|CMP3|CMP4|CMP5|CMP6|CMPX
pseudo EQU|ORIG|CON|END
number [0-9]+
asterisk \*
slashes \/\/
%s  COMMENT
%s  OP
%s  ADDRESS
%array
%%
^{symbol} { if (strlen(yytext) > 10) {
              yyerror("Symbol greater than 10 characters");
              yytext[10] = '\0';
          }
          if (yylval.symp = lookup(yytext)) {
            if (yylval.symp->type != UNDEF)
              if ( strlen(yytext) != 2 || (yytext[0] < '0' ||
                     yytext[0] > '9') || yytext[1] != 'H' ) 
                       yyerror("Duplicate symbol");
              else yylval.symp = install(yytext,0,0);
          } else {
              yylval.symp = install(yytext,0,0);
              yylval.symp->type = UNDEF;
          }  
          strcpy(label,yytext);
          return LOC; }

^\*       { BEGIN COMMENT; fprintf(lst,"*"); return ASTERISK;}

<COMMENT>[^\n]* { yylval.txt = yytext; fprintf(lst,"%s",yytext);
                      return TEXT;}

<COMMENT>\n { BEGIN 0; fprintf(lst,"\n"); return yytext[0];}

<INITIAL>[ \t]+   { fprintf(lst,"%-10s ",label); strcpy(label," ");
                    BEGIN OP; }

<OP>{opcode} { yylval.txt = yytext; fprintf(lst,"%-4s ",yytext);
               return OPCODE; }

<OP>{pseudo} { yylval.txt = yytext; fprintf(lst,"%-4s ",yytext);
               return PSEUDO; }

<OP>ALF[ ]*[\n]      {
                       yylval.txt = "    ";
                       fprintf(lst,"ALF  %s",yylval.txt);
                       unput('\n');
                       BEGIN COMMENT;
                       return ALF; }
<OP>ALF[ ][ ].     |
<OP>ALF[ ][ ]..    |
<OP>ALF[ ][ ]...   |
<OP>ALF[ ][ ]....  |
<OP>ALF[ ][ ].....   {  /* .{1,5} doesn't seem to work */
                       yylval.txt = strcat(&yytext[5],"     ");
                       yylval.txt[5] = '\0';
                       fprintf(lst,"ALF  %s",yylval.txt);
                       BEGIN COMMENT;
                       return ALF; }
<OP>ALF[ ][^ ]     |
<OP>ALF[ ][^ ].    |
<OP>ALF[ ][^ ]..   |
<OP>ALF[ ][^ ]...  |
<OP>ALF[ ][^ ]....   {
                       yylval.txt = strcat(&yytext[4],"     ");
                       yylval.txt[5] = '\0';
                       fprintf(lst,"ALF  %s",yylval.txt);
                       BEGIN COMMENT;
                       return ALF; }

<OP>[ \t]+ {BEGIN ADDRESS; } 

<OP>[^ \t\n]+ { yyerror("Invalid op code"); }

<ADDRESS>{symbol} {
            if (strlen(yytext) > 10) {
              yyerror("Symbol greater than 10 characters");
              yytext[10] = '\0';
            }
            fprintf(lst,"%s",yytext);
            if (!(yylval.symp = lookup(yytext))) {
              yylval.symp = install(yytext,0,0);
              yylval.symp->type = UNDEF;
              if ( yytext[0] >= '0' && yytext[0] <= '9' &&
                    yytext[1] == 'B' && yytext[2] == '\0' ) {
                yylval.symp->type = DEF;
                return LOCAL_SYMBOL;
              }
              else
                return FUTURE_REFERENCE; 
            }
            else if ( yytext[0] >= '0' && yytext[0] <= '9' &&
                       yytext[1] == 'B' && yytext[2] == '\0' )
                    return LOCAL_SYMBOL;
                 else
										if (yylval.symp->type == UNDEF) return FUTURE_REFERENCE;
                    else return DEFINED_SYMBOL; }

<ADDRESS>{number}   { if (strlen(yytext) > 10) {
              yyerror("Number greater than 10 digits");
              yytext[10] = '\0';
            }
            fprintf(lst,"%s",yytext);
            yylval.val = atoi(yytext);
            if (yylval.val > 1073741823) yyerror("Number greater than 1073741823");
            return NUMBER; }

<ADDRESS>{asterisk} { fprintf(lst,"*"); return ASTERISK; }

<ADDRESS>{slashes}  { fprintf(lst,"//"); return SLASHES; }

<ADDRESS>[^ \t\n] {fprintf(lst,"%c",*yytext); return yytext[0];}

<ADDRESS>[ \t]* {fprintf(lst,"%s",yytext); BEGIN COMMENT;}

<ADDRESS>[\n] {BEGIN 0; fprintf(lst,"\n"); return yytext[0];}

[ \t\n]       { BEGIN 0; fprintf(lst,"%c",yytext[0]); return yytext[0]; }
%%
