#ifndef _STDIO_2015abc_H
#define _STDIO_2015abc_H

#include <sys/types.h>

extern "C" {

#define EOF (-1)

typedef struct __sFILE {
   unsigned char buffer[232];
} FILE;
 
#ifdef MINGW
extern FILE * stdin;
extern FILE * stdout;
extern FILE * stderr;
#else
extern FILE * stdin;
extern FILE * stdout;
extern FILE * stderr;
#endif

/*
#ifdef MINGW
#define stdin   _stdin
#define stdout  _stdout
#define stderr  _stderr
#endif
*/

extern int fileno(FILE *stream);

extern size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);

extern size_t fwrite(const void *ptr, size_t size, size_t nmemb,
                     FILE *stream);

extern int getc(FILE * file);

extern FILE * fopen(const char * filename, const char * flags);

extern void clearerr(FILE * f);

extern int ferror(FILE * f);

extern int feof(FILE * f);

extern int fprintf(FILE * f, const char * fmt, ...);

extern char * fgets(char * buffer, size_t size, FILE * f);

extern int fscanf(FILE * f, const char * fmt, ...);

extern void fflush(FILE * f);

extern void fclose(FILE * f);

extern int ungetc(int ch, FILE * f);

extern int fpeek(FILE * f);

extern int printf(const char * fmt, ...);

extern int scanf(const char * fmt, ...);

extern int sscanf(const char * fmt, ...);

extern int getchar();

extern int fgetc(FILE * f);

extern int putc(FILE * f, int c);

extern int puts(const char * message);

extern int sprintf(char * buffer, const char * fmt, ...);

extern int perror(const char * message);

}

#endif /* END _STDIO_H */
