<?php

define("THE_DIR", "/home/music/public_html/");

function list_dir($fp, $the_dir) {
   if(is_dir($the_dir)) {
      $d = scandir($the_dir);
      foreach($d as $it) {
         if(strcmp($it, ".") != 0 && strcmp($it, "..") != 0) {
            list_dir($fp, $the_dir.'/'.$it);
         }
      }
   }
   else {
      if(strstr($the_dir, ".mp4") != null || strstr($the_dir, ".mp3") != null) {
         $the_dir = substr($the_dir, strlen(THE_DIR)+1);
         fprintf($fp, "%s\n", $the_dir);
         printf( "%s\n", $the_dir);
      }
   }
}

$fp = fopen("filelist.txt", "w");
if($fp != null) {
   list_dir($fp, THE_DIR);
   fflush($fp);
   fclose($fp);
}
else {
   print("Unable to open file: filelist.txt\n");
   exit(1);
}

function _mysqli_query($link, $sql) {
   #print("$sql\n");
   return mysqli_query($link, $sql);
}

unlink("/home/music/music.db");

$id = dba_open("/home/music/music.db", "n", "flatfile");

if (!$id) {
    echo "dba_open failed\n";
    exit;
}

$fp = fopen("filelist.txt", "r");

$link = mysqli_connect("localhost", "mcoan", "abc123")
or die(mysqli_error($link));

mysqli_select_db($link, "music")
or die(mysqli_error($link));

$word_map = array();
$song_map = array();

$word_id = 0;
$song_id = 0;

if($fp != null) {
   _mysqli_query($link,
   "DELETE FROM w_s")
   or die(mysqli_error($link));

   _mysqli_query($link,
   "DELETE FROM word")
   or die(mysqli_error($link));

   _mysqli_query($link,
   "DELETE FROM song")
   or die(mysqli_error($link));

   $token = " ,.\r\n\t<>;:|[]{}()-+*_/\\&^%\$#@!~`\'\"";

   while(($line = fgets($fp)) != null) {
      $keyword_array = array();

      $song = trim($line);

      $str = strtok($song, $token);

      while($str != null) {
         print("KEY=$str\n");

         $keyword_array[count($keyword_array)] = strtolower($str);

         $str = strtok($token);
      }

      //$keyword_array = array_unique($keyword_array);

      for($i = 0; $i < count($keyword_array); $i++) {
         if(!isset($keyword_array[$i])) 
            continue;

         $word = strtolower($keyword_array[$i]);

         print("WORD=" . $word . "\n");

         if(!isset($word_map[$word]))
            $word_map[$word] = false;

         if($word_map[$word] == false) {
            $word_map[$word] = true;

            _mysqli_query($link,
            "INSERT INTO word (value) VALUES ('".mysqli_real_escape_string($link, $word)."')") 
            or die(mysqli_error($link));

            $word_id = mysqli_insert_id($link);   
         }
         else {
            $result = mysqli_query($link,
            "SELECT id FROM word WHERE value = '" . mysqli_real_escape_string($link, $word) . "'")
            or die(mysqli_error($link));

            $res = mysqli_fetch_assoc($result);

            if($res == null) {
               continue;
            }

            $word_id = intval($res["id"]);

            mysqli_free_result($result); 
         }

         if(!isset($song_map[$song]))
            $song_map[$song] = false;

         if($song_map[$song] == false) {
            $song_map[$song] = true;

            _mysqli_query($link,
            "INSERT INTO song (title) VALUES ('".mysqli_real_escape_string($link, $song)."')")
            or die(mysqli_error($link));

            $song_id = mysqli_insert_id($link);

            _mysqli_query($link,
            "INSERT INTO w_s (word_id,song_id) VALUES ($word_id,$song_id)")
            or die(mysqli_error($link));
         }
         else {
            $result = _mysqli_query($link,
            "SELECT id FROM song WHERE title = '" . mysqli_real_escape_string($link, $song) . "'")
            or die(mysqli_error($link));

            while(($res = mysqli_fetch_assoc($result)) != null) {
               if($res == null) {
                  continue;
               }

               $song_id = intval($res["id"]);

               _mysqli_query($link,
               "INSERT INTO w_s (word_id,song_id) VALUES ($word_id,$song_id)")
               or die(mysqli_error($link));
            }

            mysqli_free_result($result);
         }
      }
   }

   fclose($fp);

   mysqli_close($link);
}

dba_sync($id);

dba_close($id);
?>
