<?php

// -----------------------------------------
// PHP SCRIPT TO SEARCH MP3 DIRECTORY...
//
// Date: Sun May  7 13:15:13 EDT 2017
// Author: Matthew W. Coan (mcoan@slack.net)
// -----------------------------------------

include("auth_code.php");

?>
<HTML>
<HEAD>
<TITLE>
MISIC SEARCH...
</TITLE>
<?php
include("css.php");
?>
<STYLE>
.the_link {
        font-family: <?= $font_name ?>;
        background-color: white;
        color: black;
        margin-top: 0px;
        margin-right: 0px;
        margin-bottom: 0px;
        margin-left: 0px;
        font-style: normal;
        font-weight: 200;
        font-size: 16px;
        font-variant: small-caps;
}
</STYLE>
<SCRIPT LANGUAGE="JavaScript">
function timeFormat(n) {
   var s = n+"";
   var i = s.indexOf(".");
   if(i != -1) {
      if((i+3) s.length()) {
         n = parseInt(n) + s.substring(i, i+3);
      }
      else {
         n = parseInt(n) + s.substring(i);
      }
   }
   return n;
}
</SCRIPT>
</HEAD>
<BODY BGCOLOR="WHITE">
<TABLE BORDER="0" BGCOLOR="white">
<TR>
<TD>
<H1>Music search from Matt...</H1>
</TD>
</TR>
<TR>
<TD>
<TABLE BORDER="0" BGCOLOR="white" WIDTH="100%" HEIGHT="100px">
<TR>
<TD>
<FORM METHOD="GET" ACTION="search.php">
<?php
if(isset($_GET["qs"])) {
?>
<FONT CLASS="search">Search:</FONT> <INPUT CLASS="input" TYPE="TEXT" SIZE="40" NAME="qs" VALUE="<?= $_GET["qs"] ?>">
<?php
}
else {
?>
<FONT CLASS="search">Search:</FONT> <INPUT CLASS="input" TYPE="TEXT" SIZE="40" NAME="qs" VALUE="">
<?php
}
?>
<INPUT CLASS="button" TYPE="SUBMIT" VALUE="Search">
</FORM>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR>
<TD>
<DIV CLASS="song_list">
<?php

function has_words($text, $word_array) {
   $array = array();
   $sep = ",;:\r\n\t -()[].+";
   $tok = strtok($text, $sep);
   while($tok != null) { 
      $array[count($array)] = $tok;
      $tok = strtok($sep);
   }
   $count = 0;
   for($i = 0; $i < count($word_array); $i++) {
      $ret = false;
      for($j = 0; $j < count($array); $j++) {
         if(strcmp(soundex($word_array[$i]), soundex($array[$j])) == 0) {
            $ret = true;
            break;
         } 
      }
      if($ret) {
         $count++;
      }
   }
   if($count == count($word_array)) {
      $ret = true;
   }
   else {
      $ret = false;
   }
   return $ret;
}

function query($link, $sql) {
   return mysqli_query($link, $sql);
}

function to_string($keyword_array, $word, $index) {
   $ret = "";
   for($i = 0; $i < count($keyword_array); $i++) {
      if($i == $index) {
         $ret .= $word . " ";
      }
      else {
         $ret .= $keyword_array[$i] . " ";
      }
   }
   return urlencode($ret);
}


if(isset($_GET["qs"])) {
   $qs = $_GET["qs"];

   $script = "";

   $link = mysqli_connect(DATABASE_HOSTNAME, DATABASE_USERNAME, DATABASE_PASSWORD)
   or die(mysqli_error($link));

   mysqli_select_db($link, DATABASE_NAME)
   or die(mysqli_error($link));

   $token = " .\r\n\t<>;:|[]{}()-+*_/\\&^%\$#@!~`\'\"";

   $keyword_array = array();

   $str = strtok($qs, $token);

   while($str != null) {
      if(strcmp(strtolower($str), "the") == 0) {
         $str = strtok($token);
         continue;
      }

      $keyword_array[count($keyword_array)] = strtolower($str);

      $str = strtok($token);
   }

   $flag = false;

   for($i = 0; $i < count($keyword_array); $i++) {
      $result = query($link, "SELECT value FROM word WHERE lower(value) = '" 
                . mysqli_real_escape_string($link, $keyword_array[$i])
                . "'");
      if(mysqli_num_rows($result) == 0) {
         print("&nbsp;&nbsp;&nbsp;&nbsp;<b>" . $keyword_array[$i] . "</b> - ");
         $result = query($link, "SELECT value FROM word WHERE SOUNDEX(lower(value)) = SOUNDEX('" 
                   . mysqli_real_escape_string($link, $keyword_array[$i])
                   . "')");
         while(($res = mysqli_fetch_assoc($result)) != null) {
            $word = $res["value"];
            print("<a href=\"/~music/search.php?qs=" .to_string($keyword_array, $word, $i). "\"><i>" . $word . "</i></a> ");
         }
         print("<br>\n");
         $flag = true;
      }
   }
   if($flag) {
      print("<br>\n");
   }

   $flag = false;

   print("<table border=\"0\" bgcolor=\"lightgray\">\n");
   print("<tr><td>&nbsp;</td><td><b>TITLE</b></td><td><b>LENGTH</b></td></tr>\n");

   $line = "";

   $index = 0;

   $sql0 = "";
   if(count($keyword_array) > 0) {
      for($i = 0; $i < count($keyword_array); $i++) {
         if(strlen($sql0) != 0)
            $sql0 .= " OR ";
         $sql0 .= "lower(value) = '" . mysqli_real_escape_string($link, $keyword_array[$i]) . "'";
      }
      $sql0 = " ( " . $sql0 . " ) ";
      $sql = "SELECT title,count(title) as the_count "
             . " FROM word,w_s,song "
             . " WHERE word.id = word_id AND song_id = song.id AND " . $sql0
             . " GROUP BY title "
             . " ORDER BY the_count DESC,title ASC";
      $result = query($link, $sql)
      or die(mysqli_error($link));
      $one = false;

      while(($res = mysqli_fetch_assoc($result)) != null) {
         $line = $res["title"];

         $cnt = 0;
  
         for($i = 0; $i < count($keyword_array); $i++) {
            if(strstr(strtolower($line), strtolower($keyword_array[$i])) != null) {
               $cnt++;
            }
         }

         if($cnt >= count($keyword_array)) {
            $one = true;
            break;
         }
      }

      mysqli_data_seek($result, 0);

      if($one) {
         $flag = true;
      }
      else {
         $flag = false;
      }
   }

   if(count($keyword_array) > 0)
   while(($res = mysqli_fetch_assoc($result)) != null) {
      $line = $res["title"];

      if($flag) {
         $cnt = 0;

         for($j = 0; $j < count($keyword_array); $j++) {
            if(strstr(strtolower($line), strtolower($keyword_array[$j])) != null) {
               $cnt++;
            }
         }

         if($cnt != count($keyword_array)) {
            continue;
         }
      }

      $value = str_replace("+", "%20", str_replace("%2F", "/", urlencode($line)));

      $script .= "song_array[song_array.length] = \"" . $value . "\";\n";

      print("<TR><TD><div id=\"block" . $index . "\">&nbsp;</div></TD>"
            . "<TD STYLE=\"song_list\"><U><A HREF=\"javascript:return true;\" onClick=\"playSong(".$index.")\">"
            . htmlentities($line) ."</A></U></td><td></td></tr>\n");

      $index++;
   }

   print("<tr><td>&nbsp;</td><td>\n");
   print("<br><audio id=\"myAudio\" controls></audio>\n");
   print("</td></tr>\n");
   print("</table>\n");

   mysqli_close($link);
}

?>
<SCRIPT LANGUAGE="JavaScript">

var song_index = 0;
var song_array = new Array();

function playSong(index) {
   song_index = index;
   myAudio.src = song_array[index];
   myAudio.play();
   for(var i = 0; i < song_array.length; i++) {
      eval("block" + i + ".innerHTML = '&nbsp;';");
   }
   eval("block" + index + ".innerHTML = '<div class=\"block\"></div>';");
   return true;
}

function stop() {
   myAudio.pause(); 
}

function play() {
   if(song_index >= song_array.length)
      song_index = 0;
   playSong(song_index);
}

function next() {
   song_index++;
   if(song_index >= song_array.length)
      song_index = 0;
   playSong(song_index);
}

function prev() {
   song_index--;
   if(song_index < 0) 
      song_index = 0;
   playSong(song_index);
}

function rand() {
   song_index = parseInt(Math.random() * 1000) % song_array.length;
   playSong(song_index);
}

<?php
   if(isset($script)) {
      print($script);
   }
?>

myAudio.onended = function() {
   if(song_index < (song_array.length-1)) {
      song_index++;
      playSong(song_index);
   }
};

if(song_array.length != 0) {
   block0.innerHTML = "<div class=\"block\"></div>";
   myAudio.src = song_array[0];
}

</SCRIPT>
<BR>
<DIV CLASS="menu">
<TABLE BORDER="0">
<TR>
<TD>
<A HREF="javascript:return true;" onClick="play()">Play...</A>
</TD>
<TD>
<A HREF="javascript:return true;" onClick="stop()">Stop...</A>
</TD>
<TD>
<A HREF="javascript:return true;" onClick="next()">Next...</A>
</TD>
<TD>
<A HREF="javascript:return true;" onClick="prev()">Previous...</A>
</TD>
<TD>
<A HREF="javascript:return true;" onClick="rand()">Random...</A>
</TD>
<TD>
<A TARGET="top" HREF="movies.php">Movies...</A>
</TD>
</TR>
</TABLE>
</DIV>
<BR>
</TD>
</TR>
<TR>
<TD>
<TABLE BORDER="0" BGCOLOR="white" WIDTH="100%" HEIGHT="100px">
<TR>
<TD>
<FORM METHOD="GET" ACTION="search.php">
<FONT CLASS="search">Search:</FONT> 
<?php
if(isset($_GET["qs"])) {
?>
<INPUT CLASS="input" TYPE="TEXT" SIZE="40" NAME="qs" VALUE="<?= htmlentities($_GET["qs"]) ?>">
<?php
}
else {
?>
<INPUT CLASS="input" TYPE="TEXT" SIZE="40" NAME="qs" VALUE="">
<?php
}
?>
<INPUT CLASS="button" TYPE="SUBMIT" VALUE="Search">
</FORM>
</TD>
</TR>
</TABLE>
<BR>
<BR>
<A CLASS="the_link" HREF="/~music/index.php">follow this link go back to the main page...</A>
<BR>
<BR>
</TD>
</TR>
</TABLE>
</BODY>
</HTML>
