/* 
 * (C) 2006 Copywrite. All rights reserved.
 *
 * A java program that shows a window.
 *
 * Author : Matthew William Coan
 * Date   : 1:31 PM 8/22/2006
 *
 **/
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class AppCloser extends WindowAdapter {
   
   public void windowClosing(WindowEvent e) {
      synchronized(Prog.mutex) {
         Prog.flag = true;
         Prog.mutex.notify();
      }
   }
}

public class Prog {
   public static Object mutex = new Object();
   public static boolean flag = false;

   public static void main(String args[]) 
   throws Exception {
      JFrame frame = new JFrame("Prog");
      frame.addWindowListener(new AppCloser());
      frame.setSize(100,100);
      frame.getContentPane().setLayout(new GridLayout(1,1));
      frame.getContentPane().add(new JLabel("Hello, World!", JLabel.CENTER));
      frame.setVisible(true);

      // wait for AppCloser to be called
      while(true) {
         synchronized(mutex) {
            mutex.wait();

            if(flag)
               break;
         }
      }

      System.exit(0);
   }
}