import java.io.*;
import java.net.*;

public class ObjectClient implements Runnable {
   private String className = "Object";
   private String host = "localhost";
   private int port = 2012;

   public ObjectClient(String host, int port, String className) {
      this.host = host;

      this.port = port;

      this.className = className;
   }

   public void run() {
      try {
         Socket sock = new Socket(host, port);

         Class theClass = Class.forName(className);

         ObjectOutputStream out = new ObjectOutputStream(sock.getOutputStream());

         BufferedInputStream fin = new BufferedInputStream(new FileInputStream(className + ".class"));

         int size = (int)(new File(className + ".class").length());

         byte[] classBytes = new byte [size];

         fin.read(classBytes, 0, size);

         fin.close();

         out.writeObject(new ObjectRequest(className, classBytes, "HelloAgent"));

         out.flush();

         ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(sock.getInputStream()));

         Object response = in.readObject();

         System.out.println(response);

         out.close();

         in.close();

         sock.close();
      }
      catch(Exception e) {
         e.printStackTrace(System.err);
      }
   }

   public static void main(String args[]) 
   throws Exception {
      ObjectClient client = new ObjectClient(args[0], Integer.parseInt(args[1]), args[2]);

      client.run();
   }
}

