import java.io.*;

public class ObjectRequest implements Serializable {
   private String name;
   private byte[] data;
   private String task;

   public ObjectRequest(String name,  
                        byte[] data,
                        String task) {
      super();

      this.name = name;

      this.data = data;

      this.task = task;
   }

   public String getName() { 
      return name; 
   }

   public byte[] getData() { 
      return data; 
   }

   public Task getTask() {
      Task task = null;

      try {
         ServerClassLoader cl = new ServerClassLoader(name, data);

         Class c = cl.findClass(name);

         task = (Task)c.newInstance();
      } 
      catch(Exception e) {
         e.printStackTrace(System.err);
      }

      return task;
   }
}
