import java.io.*;
import java.util.*;

public class PipelineThreadModel implements ThreadModel {
   private ThreadPool array[] = null;
   private int size;

   public PipelineThreadModel() {
      try {
         Properties props = new Properties();
         props.load(new FileInputStream("objsvr.properties"));
         size = Integer.parseInt(props.getProperty("pipeline.size"));
      }
      catch(Exception e) {
         size = 4;
      }
      array = new ThreadPool[size];
      for(int i = 0; i < size; i++) 
         array[i] = ThreadPoolFactory.createThreadPool(); 
   }

   public String getName() {
      return "Pipeline";
   }

   public void runTask(Runnable task) {
      array[0].postTaskForExecution(new PipelineTask(array, task));
   }
}
