///////////////////////////////////////////////////////
//
// (C) 2006 Copywrite. All rights reserved.
//
// Simple TCP echo client localhost port 1976.
//
// Author : Matthew W. Coan
// Date   : Thu Jul 27 11:08:19 EDT 2006
//
//////////////////////////////////////////////////////
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <pthread.h>

using namespace std;

string user_name;

void *
read_thread(void * arg)
{
   const size_t BUF_SZ = 1024;
   char buf[BUF_SZ];

   int sock = (*((int*)(arg)));

   while(true) {
      memset(buf, 0, BUF_SZ);

      if(recv(sock, buf, BUF_SZ - 1, 0) < 0)
         break;

      fprintf(stdout, "%s", buf);
      fflush(stdout);
   }
	 
   close(sock);

   return NULL;
}

//
// Echo lines of text back and forth between 
// the client and the server.  
//
void
Echo(int sock)
{
   const size_t BUF_SZ = 1024;
   char buf[BUF_SZ];

   fprintf(stdout, "What is your name?\n");
   fflush(stdout);

   memset(buf, 0, BUF_SZ);
   fgets(buf, BUF_SZ -1, stdin);

   int i = strlen(buf) -1;
   while(i >= 0) {
      if(isspace(buf[i])) 
      {
         buf[i] = '\0';
      }
      else
      {
         break;
      }

      i--;
   }

   user_name = string(buf);

   string temp;

   fprintf(stdout, "You are now in the chat room...\n"
		   "Type exit to quit...\n");
   fflush(stdout);

   // Forever:
   while(true) {
      // Get a line of text from the user.
      memset(buf, 0, BUF_SZ);
      fgets(buf, BUF_SZ - 1, stdin);
     
      // Send the text to the server.
      temp = user_name + string(": ") + string(buf);
      if(send(sock, temp.c_str(), temp.size(), 0) != temp.size())
         break;

      // if exit typed break out of the loop
      if(strstr(buf, "exit") == buf)
	      break;
   }

   close(sock);
}

int sock;     // Socket descriptor.

void
on_SIGINT(int arg)
{
    string temp = user_name + string(": ") + string("exit\n");

    send(sock, temp.c_str(), temp.size(), 0);

    close(sock);

    fprintf(stdout, "done...\n");
    fflush(stdout);

    exit(0);
}

char * host;
int port;

void
usage()
{
   fprintf(stdout, "Poll server client...\n");
   fprintf(stdout, "(C) 2006 Copywrite. All rights reserved.\n");
   fprintf(stdout, "Matthew W. Coan\n");
   fprintf(stdout, "Version: 1.0.0\n\n");
   fprintf(stdout, 
   "usage: client [-h | -help] [-host <HOST>] [-port <PORT>]\n");
   exit(0);
}

// 
// Main entry point.
//
int
main(int argc, char ** argv)
{
   sockaddr_in svr; // Server address info.
   int n;
   pthread_t th_id;
   char str[INET6_ADDRSTRLEN];

   host = "localhost";
   port = 1976;

   for(int i = 0; i < argc; i++)
   {
      if(strcmp(argv[i], "-h") == 0
         || strcmp(argv[i], "-help") == 0)
      {
         usage();
      }
      else if(strcmp(argv[i], "-host") == 0)
      {
         if((i + 1) >= argc)
            usage();

	 host = argv[i + 1];
      }
      else if(strcmp(argv[i], "-port") == 0)
      {
         if((i + 1) >= argc)
            usage();

	 port = atoi(argv[i + 1]);
      }
   }

   if(port < 0)
      port = 1976;

   // handle interupt signal Control-C
   signal(SIGINT, on_SIGINT);

   // Create the socket.
   sock = socket(AF_INET, SOCK_STREAM, 0);

   // Check for an error.
   assert(sock >= 0);

   // Write zero's into the address info.
   memset(reinterpret_cast< char* >(&svr), 0, sizeof(svr));

   fprintf(stdout, "host==%s\n", host);
   fflush(stdout);

   hostent * ph = gethostbyname(host);
   if(ph != NULL) {
      host = (char*)inet_ntop(AF_INET,
		ph->h_addr, 
		str, 
		sizeof(str));
   }

   fprintf(stdout, "host==%s\n", host);
   fflush(stdout);

   memset(&svr, 0, sizeof(svr));
   svr.sin_family = AF_INET;
   svr.sin_port = htons(port);
   svr.sin_addr.s_addr = inet_addr(host);

   // Connect to the server.
   n = connect(sock, reinterpret_cast< const sockaddr* >(&svr), sizeof(svr));

   // Check for an error.
   assert(n >= 0);

   fprintf(stdout, "Chat client...\n");
   fprintf(stdout, "(C) 2006 Copywrite. All rights reserved.\n");
   fprintf(stdout, "Matthew W. Coan\n");
   fprintf(stdout, "Version: 1.0.0\n");
   fflush(stdout);

   fprintf(stdout, "Connected...\n");
   fflush(stdout);

   // Echo strings back and forth.
   pthread_create(&th_id, NULL, read_thread, ((void*)(&sock)));

   Echo(sock);

   close(sock);

   fprintf(stdout, "done...\n");
   fflush(stdout);

   return 0;
}
