#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>

int
main(int argc, char ** argv)
{
	char * ptr, ** pptr;
	char str[INET6_ADDRSTRLEN];
	hostent * hptr;

	while(--argc > 0) {
		ptr = *++argv;
		if((hptr = gethostbyname(ptr)) == NULL) 
		{
			fprintf(stderr, "error...\n");
			exit(1);
		}

		printf("offical hostname: %s\n", hptr->h_name);

		for(pptr = hptr->h_aliases; *pptr != NULL; pptr++)
			printf("\talias: %s\n", *pptr);

		switch(hptr->h_addrtype) {
			case AF_INET:
				pptr = hptr->h_addr_list;
				for(; *pptr != NULL; pptr++)
					printf("\taddress: %s\n",
					inet_ntop(hptr->h_addrtype,
					*pptr, str, sizeof(str)));
				break;

			default:
				fprintf(stderr, "unknown address type\n");
				exit(1);

		}
	}

	exit(0);
}
