// ////////////////////////////////////////////////////
//
// (C) 2006 Copywrite. All rights reserved.
//
// Poll driven server.
//
// Author : Matthew W. Coan
// Date   : Thu Jul 27 11:06:56 EDT 2006
//
// ////////////////////////////////////////////////////

#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <assert.h>
#include <errno.h>
#include <stdarg.h>
#include <string.h>
#include <list>
#include <map>
#include <string>
#include <algorithm>
#include "sync_queue.h"
#include "user.h"

using namespace std;

#define CHATSVR_PORT 1976

//
// Echo lines of text back and forth between
// the client and the server.
//
int ReadLine(int fd, char * ptr0, size_t len);
int WriteN(int fd, const char * ptr0, size_t n);

typedef map< int, user > user_map_type;

char * host;
int port;
int nthreads;

// Print an error message and exit
void 
Error(const char * fmt, ...) 
{
   va_list ap;

   va_start(ap, fmt);
   vfprintf(stdout, fmt, ap);
   va_end(ap);

   fflush(stdout);

   exit(1);
}

// Read a line of text into a buffer from a socket
int
ReadLine(int fd, char * ptr0, size_t len)
{
   int n, rc;
   char c, * ptr;

   ptr = ptr0;
   for(n = 1; n < len; n++) {
      if((rc = recv(fd, &c, 1, 0)) == 1) {
         *ptr++ = c;

         if(c == '\n')
            break;
      }
      else if(rc == 0) {
         break;
      }
      else {
fprintf(stderr, "*****************recv socket error\n");
         return -1;
      }
   }

   *ptr = 0;
   return n;
}

// Write N bytes of data from a pointer to a socket
int
WriteN(int fd, const char * ptr0, size_t n) 
{
   size_t nleft;
   int nwritten;
   const char * ptr;
   
   ptr = ptr0;
   nleft = n;
   int ret = 0;
   while(nleft > 0) {
      if((nwritten = send(fd, ptr, nleft, 0)) < 0) {
fprintf(stderr, "*****************send socket error\n");
         return -1;
      }
fprintf(stdout, "nwritten == %d\n", nwritten);
fflush(stdout);

      if(nwritten == 0)
         break;

      nleft -= nwritten;
      ptr += nwritten;
      ret += nwritten;
   }

   return ret;
}

// Create a socket
int
Socket(int af, int type, int proto)
{
   int s = socket(af, type, proto); 

   if(s < 0)
      Error("Unable to create socket!\n");

   return s;
}

// Bind a socket to an address
void
Bind(int s, sockaddr * p, int len)
{
   int res = bind(s, p, len);

   if(res < 0)
      Error("Error after bind!\n");
}

// Declare a socket a listening socket
void 
Listen(int s, int backlog)
{
   int res = listen(s, backlog);
   
   // Check for an error.
   if(res < 0)
      Error("Error after listen!\n");
}

// Call the select system call to wait for IO
int 
Select(int n, 
       fd_set * rset, 
       fd_set * writefds, 
       fd_set * exceptfds,             
       timeval * timeout)
{
   int nready = select(n+1, rset, writefds, exceptfds, timeout);

   if(nready < 0) {
      if(errno == EINTR)
         return -1;
      else
         Error("select error, errno = %d\n", errno);
   }

   return nready;
}

// Accept a new connection
int
Accept(int s, sockaddr * p, socklen_t * addrLen)
{
   int ret = accept(s, p, addrLen);

   return ret;
}

#define MAX_POOL 16

struct poll_array 
{
   pollfd * fdarray;
   int nfd;
   user_map_type user_map;
};

typedef list< poll_array > poll_list_type;

poll_list_type * poll_list;

pollfd * addClient(pollfd * fds, int clientSock, int & n)
{
fprintf(stdout, "addClient(%d)\n", clientSock);
fflush(stdout);
   n++;

   pollfd * ret = new pollfd[n];

   memset(ret, 0, sizeof(pollfd) * n);

   ret[n-1].fd = clientSock;
   ret[n-1].events |= POLLIN;
   ret[n-1].events |= POLLPRI;
   ret[n-1].events |= POLLERR;
   ret[n-1].events |= POLLNVAL;

   if(fds != NULL) 
   {
      for(int i = 0; i < n - 1; i++) 
      {
         ret[i].fd = fds[i].fd;
         ret[i].events = fds[i].events;
         ret[i].revents = fds[i].revents;
      }

      delete [] fds;
   }

   fprintf(stdout, "n connections == %d\n", n);
   fflush(stdout);

   return ret;
}

void
remove_fd(int i, pollfd * & fdarray, int & nfd)
{
fprintf(stdout, "remove_fd(%d)\n", i);
fflush(stdout);
   pollfd * array = new pollfd[nfd - 1];
   int temp = 0;
   int fd = fdarray[i].fd;

   for(int j = 0; (j + temp) < nfd; j++) {
      if(i == j && temp == 0)  
      { 
         temp++;

	 j--;
      }
      else 
      {
         array[j] = fdarray[j + temp];
      }
   }

   delete [] fdarray;

   fdarray = array;

   nfd--;
}

bool exit_flag;

pthread_mutex_t * mutex;
pthread_cond_t * cond;
pthread_mutex_t exit_mutex;
pthread_mutex_t accept_mutex;

pthread_t * thID;
pthread_t accept_thID;
pthread_t accept_thID2;
pthread_t dist_thID;
pthread_t dist_thID1;
pthread_t dist_thID2;

bool
is_exit(char * buf)
{
   const int size = 1024;
   char buffer[size];

   memset(buffer, 0, size);

   strcpy(buffer, buf);

   char * p = strchr(buffer, ' ');

   if(p == NULL)
      return false;

   p++;

   char * end = p + (strlen(p) - 1);

   while(end >= p) 
   {
      if(isspace(*end))
      {
         *end = '\0';
      }
      else 
      {
         break;
      }

      end--;
   }

   return (strcasecmp(p, "exit") == 0);
}

typedef list< string > string_list_type;
bool * shutdown_thread;

void *
poll_thread(void * arg)
{
   int n, i, j, k, index;
   const int size = 1024;
   char buffer[size];
   string_list_type temp_list;

   index = ((int)(arg));

   fprintf(stdout, "Poll thread start...\n");
   fflush(stdout);

   bool flag = true;

   while(flag) 
   {
      pthread_mutex_lock(&exit_mutex);

      if(exit_flag)
      {
fprintf(stdout, "EXIT_FLAG\n");
fflush(stdout);
         pthread_mutex_unlock(&exit_mutex);

	 break;
      }

      pthread_mutex_unlock(&exit_mutex);

      pthread_yield();
      pthread_mutex_lock(&mutex[index]);

      while(poll_list[index].size() == 0 && !shutdown_thread[index]) 
      {
         pthread_cond_wait(&cond[index], &mutex[index]);
      }

      if(shutdown_thread[index])
      {
          pthread_mutex_unlock(&mutex[index]);

	  break;
      }

      for(poll_list_type::iterator ptr = poll_list[index].begin(); 
          ptr != poll_list[index].end(); ptr++) 
      {
         if(poll(ptr->fdarray, ptr->nfd, 0) >= 0) 
         {
		 /*
fprintf(stdout, "WAKE UP\n");
fprintf(stdout, "nfd = %d\n", ptr->nfd);
fflush(stdout);
*/

            for(i = 0; i < ptr->nfd; i++)  
            {
		    /*
fprintf(stdout, "EVENTS(%d)\n", fdarray[i].revents);
fflush(stdout);
*/
	       //pthread_mutex_lock(&user_mutex);

	       user & the_u = ptr->user_map[ptr->fdarray[i].fd];

	       if(ptr->fdarray[i].revents & POLLNVAL)
	       {
fprintf(stdout, "POLLENVAL\n");
fflush(stdout);
	       }

	       if(ptr->fdarray[i].revents & POLLERR)
	       {
fprintf(stdout, "POLLEERR\n");
fflush(stdout);
                  ptr->user_map.erase(
                        ptr->user_map.find(ptr->fdarray[i].fd));

                  remove_fd(i, ptr->fdarray, ptr->nfd);

                  fprintf(stdout, "BACK FROM REMOVE_FD\n");
                  fflush(stdout);

                  if(ptr->nfd == 0)
                  {
                     fprintf(stdout, "nfd == 0\n");
                     fflush(stdout);

                     poll_list[index].erase(ptr);

                     fprintf(stdout, "done erase...\n");
                     fflush(stdout);
                  }

		  i--;

                  continue;;
	       }

	       if(ptr->fdarray[i].revents & POLLOUT)
	       {
fprintf(stdout, "POLLOUT\n");
fflush(stdout);
                  if(the_u.msg_list.size() == 0)
		  {			  
                     continue;
		  }

                  string line = the_u.msg_list.front();

		  int n = WriteN(ptr->fdarray[i].fd, 
                                 line.c_str() + the_u.n, 
				 line.size() - the_u.n);

fprintf(stdout, "WRITE N = %d\n", n);
fprintf(stdout, "LINE SIZE = %d\n", line.size());
fflush(stdout);

		  the_u.n += n;

		  if(the_u.n == line.size())
		  {
fprintf(stdout, "the_u.n == line.size()\n");
fflush(stdout);
                     the_u.msg_list.pop_front();

		     the_u.n = 0;

		     if(the_u.msg_list.size() == 0) 
		     {
		        ptr->fdarray[i].events = 0;

		        ptr->fdarray[i].events |= POLLIN;
		        ptr->fdarray[i].events |= POLLPRI;
		        ptr->fdarray[i].events |= POLLERR;
		        ptr->fdarray[i].events |= POLLNVAL;
		     }
		  }
fprintf(stdout, "DID LINE.SIZE\n", n);
fflush(stdout);

	       }

               if(ptr->fdarray[i].revents & POLLIN
                  || ptr->fdarray[i].revents & POLLPRI) 
	       {
		       /*
fprintf(stdout, "READ LINE\n");
fflush(stdout);
*/
		  memset(buffer, 0, size);

                  if((n = ReadLine(ptr->fdarray[i].fd, 
		                   buffer, size-1)) >= 0) {
				 
			  /*
fprintf(stdout, "READ(%s)\n", buffer);
fflush(stdout);
*/
		     the_u.input += string(buffer);
		     
		     if(the_u.input.size() > 0) 
		     {
		        if(the_u.input[the_u.input.size()-1] != '\n') 
			{
                           continue;
			}
		     }
		     else
		     {
                        continue;
		     }

		     if(is_exit(buffer)) 
		     {
			ptr->user_map.erase(
                             ptr->user_map.find(ptr->fdarray[i].fd));

                        remove_fd(i, ptr->fdarray, ptr->nfd);

                        fprintf(stdout, "BACK FROM REMOVE_FD\n");
                        fflush(stdout);

                        if(ptr->nfd == 0)
		        {
			    fprintf(stdout, "nfd == 0\n");
			    fflush(stdout);

		            poll_list[index].erase(ptr);

			    fprintf(stdout, "done erase...\n");
			    fflush(stdout);

                            ptr = poll_list[index].begin();

			    fprintf(stdout, "done ptr...\n");
			    fflush(stdout);
			}

			i--;

			continue;
		     }

		     temp_list.push_back(the_u.input);

		     the_u.input = "";
                  }

		  if(ptr != poll_list[index].end()) 
		  {
		     if(i < ptr->nfd)
                     {
                        ptr->fdarray[i].revents = 0; 

			user & u = ptr->user_map[ptr->fdarray[i].fd];

			if(u.msg_list.size() > 0) 
			{
                           ptr->fdarray[i].events = 0; 
                           ptr->fdarray[i].events |= POLLIN; 
                           ptr->fdarray[i].events |= POLLOUT; 
                           ptr->fdarray[i].events |= POLLPRI; 
                           ptr->fdarray[i].events |= POLLERR; 
                           ptr->fdarray[i].events |= POLLNVAL; 
			}
			else 
			{
                           ptr->fdarray[i].events = 0; 
                           ptr->fdarray[i].events |= POLLERR; 
                           ptr->fdarray[i].events |= POLLPRI; 
                           ptr->fdarray[i].events |= POLLERR; 
                           ptr->fdarray[i].events |= POLLNVAL; 
			}
	             }
		  }
	       }

	       if(ptr != poll_list[index].end()) 
	       {
	          if(i < ptr->nfd)
	          {
	             if(ptr->fdarray[i].revents & POLLHUP)
	             {
fprintf(stdout, "HANGUP\n");
fflush(stdout);
                        flag = false;
	             }
	          }
	       }
            } // end for 
         } // if 
      } // end for

      pthread_mutex_unlock(&mutex[index]);

      if(temp_list.size() > 0) 
      {
 fprintf(stdout, "temp_list.size() == %d\n", temp_list.size());
 fflush(stdout);
         for(j = 0; j < nthreads; j++)
         {

 fprintf(stdout, "lock next j == %d\n", j);
 fflush(stdout);

             pthread_yield();
             pthread_mutex_lock(&mutex[j]);

 fprintf(stdout, "did lock\n\n");
 fflush(stdout);

             for(poll_list_type::iterator p = 
                 poll_list[j].begin();
                 p != poll_list[j].end(); p++)
             {
fprintf(stdout, "p->nfd == %d\n", p->nfd);
fflush(stdout);
                for(k = 0; k < p->nfd; k++)
                {
                   user & u = p->user_map[p->fdarray[k].fd];

	           for(string_list_type::iterator ps = temp_list.begin();
                       ps != temp_list.end(); ps++) 
	           {
                      u.msg_list.push_back(*ps);
	           }

                   p->fdarray[k].events = 0;
                   p->fdarray[k].events |= POLLIN;
                   p->fdarray[k].events |= POLLPRI;
                   p->fdarray[k].events |= POLLOUT;
                   p->fdarray[k].events |= POLLERR;
                   p->fdarray[k].events |= POLLNVAL;
                }
             } // end for

 fprintf(stdout, "unlock next j == %d\n", j);
 fflush(stdout);
             pthread_mutex_unlock(&mutex[j]);
 fprintf(stdout, "unlock done\n");
 fflush(stdout);

          } // end for
      } // end if

      temp_list.clear();
   } // end while

fprintf(stdout, "RETURN NULL FROM POLL THREAD\n");
fflush(stdout);

   return NULL;
}

int server_fd;
sockaddr_in svr, cli;    // Server and client socket addresss info.
int svrSock; // Server and client socket descriptors.
socklen_t addrLen;
int cliSock;
bool set_up_flag;
pthread_mutex_t set_up_mutex;

sync_queue * p_the_queue;

void
on_SIGHUP(int arg)
{
   int i;

   pthread_mutex_lock(&exit_mutex);

   exit_flag = true;

   pthread_mutex_unlock(&exit_mutex);

   p_the_queue->shutdown();

   void * ret_addr = 0;

   pthread_join(accept_thID, &ret_addr);

   pthread_join(accept_thID2, &ret_addr);

   pthread_join(dist_thID, &ret_addr);

   pthread_join(dist_thID1, &ret_addr);

   pthread_join(dist_thID2, &ret_addr);

   for(i = 0; i < nthreads; i++) 
   {
      pthread_mutex_lock(&mutex[i]);

      shutdown_thread[i] = true;

      pthread_cond_broadcast(&cond[i]);

      pthread_mutex_unlock(&mutex[i]);

      pthread_join(thID[i], &ret_addr);
   }

   pthread_mutex_destroy(&exit_mutex);

   pthread_mutex_destroy(&set_up_mutex);

   for(int i = 0; i < nthreads; i++) 
   {
      pthread_mutex_destroy(&mutex[i]);

      for(poll_list_type::iterator p = poll_list[i].begin();
          p != poll_list[i].end(); p++)
      {
         for(int i = 0; i < p->nfd; i++) 
         {
            close(p->fdarray[i].fd);
         }

         delete [] (p->fdarray);

         p->fdarray = NULL;

         p->nfd = 0;
      }

      poll_list[i].clear();
   }

   close(server_fd);

   delete [] shutdown_thread;

   delete [] cond;

   delete [] mutex;

   delete [] thID;

   delete [] poll_list;

   delete p_the_queue;

   exit(0);
}

void *
accept_thread(void * arg)
{
   hostent * pRemoteHost;
   int on = 1;
   char str[INET6_ADDRSTRLEN];

   pRemoteHost = gethostbyname(host);

   if(pRemoteHost != NULL) 
   {
 fprintf(stdout, "host==%s\n", host);
 fflush(stdout);

      host = (char*)inet_ntop(pRemoteHost->h_addrtype,
	pRemoteHost->h_addr,
	str,
	sizeof(str));

 fprintf(stdout, "host==%s\n", host);
 fflush(stdout);
   }

   // Create the server socket.
   pthread_mutex_lock(&set_up_mutex);

   if(!set_up_flag) 
   {
      set_up_flag = true;

      svrSock = Socket(AF_INET, SOCK_STREAM, 0);

      server_fd = svrSock;

      fprintf(stdout, "HOST=%s\n", host);
      fflush(stdout);

      // Set all the server sockets address into to zero.
      memset(reinterpret_cast< char* >(&svr), 0, sizeof(svr));

      svr.sin_family = AF_INET;                 // Set the protocol family to
      svr.sin_port = htons(port);               // Set tbe port number the
                                                // for connections on.
      svr.sin_addr.s_addr = inet_addr(host);    // Accept connections for all
                                                // this machine.

      setsockopt(svrSock, SOL_SOCKET,
                 SO_REUSEADDR, (const char *)&on,
                 sizeof(on));

      // Bind the server socket to the specified address.
      Bind(svrSock, (sockaddr *)&svr, sizeof(svr));

      // Let the socket API know that this is a listening socket
      // with a backlog specified socket API constant SOMAXCONN.
      Listen(svrSock, SOMAXCONN);
   }

   pthread_mutex_unlock(&set_up_mutex);

   fd_set read_set;
   timeval tv;
   int n;

   while(true)
   {
      pthread_mutex_lock(&exit_mutex);

      if(exit_flag) {
         pthread_mutex_unlock(&exit_mutex);
         
         break;
      }

      pthread_mutex_unlock(&exit_mutex);

      FD_ZERO(&read_set);
      FD_SET(svrSock, &read_set);

      tv.tv_sec = 1;
      tv.tv_usec = 0;

      fprintf(stdout, "SELECT FOR ACCEPT NEXT\n");
      fflush(stdout);

      pthread_mutex_lock(&accept_mutex);

      n = select(svrSock + 1, &read_set, NULL, NULL, &tv);

      fprintf(stdout, "DONE SELECT n == %d\n", n);
      fflush(stdout);

      if(n < 0) 
      {
         break;
      }

      if(FD_ISSET(svrSock, &read_set)) 
      {
         addrLen = sizeof(cli);
         memset(&cli, 0, addrLen);

         fprintf(stdout, "ACCEPT-NEXT\n");
         fflush(stdout);

         cliSock = Accept(svrSock, (sockaddr *)&cli, &addrLen);

	 if(cliSock < 0)
            continue;

         fprintf(stdout, "ACCEPT-DONE\n");
         fflush(stdout);

         fcntl(cliSock, FNDELAY);

         fprintf(stdout, "ACCEPT-ADDRESS=%s\n", inet_ntoa(cli.sin_addr));
         fflush(stdout);

         pRemoteHost = gethostbyaddr((const char*)&cli.sin_addr,
                                  addrLen,
                                  AF_INET);
         if(pRemoteHost != NULL) {
            fprintf(stdout, "accept, address=%s\n", pRemoteHost->h_name);
            fflush(stdout);
         }

         pthread_mutex_unlock(&accept_mutex);

         p_the_queue->put(cliSock);
      }
      else
         pthread_mutex_unlock(&accept_mutex);
   }

   fprintf(stdout, "DONE ACCEPT THREAD\n");
   fflush(stdout);

   return NULL;
}

void
usage()
{		   
   fprintf(stdout, "Poll server...\n");
   fprintf(stdout, "(C) 2006 Copywrite. All rights reserved.\n");
   fprintf(stdout, "Matthew W. Coan\n");
   fprintf(stdout, "Version: 1.0.0\n\n");
   fprintf(stdout, 
           "poll_server [-h | -help] "
	   "[-host <host>] [-port <port>] [-nthreads <N>]\n");
   fflush(stdout);
   exit(0);
}

void * dist_thread(void * arg);

// /////////////////
// Main entry point.
// /////////////////
int
main(int argc, char ** argv)
{
   int i;

   host = "localhost";
   port = 1976;
   nthreads = 3;

   for(i = 0; i < argc; i++) 
   {
      if(strcmp(argv[i], "-h") == 0
         || strcmp(argv[i], "-help") == 0)
      {
         usage();
      }
      else if(strcmp(argv[i], "-host") == 0) 
      {
         if((i+1) >= argc)
            usage();

	 host = argv[i+1];
      }
      else if(strcmp(argv[i], "-port") == 0)
      {	   
         if((i+1) >= argc)
            usage();

	 port = atoi(argv[i+1]);
      }
      else if(strcmp(argv[i], "-nthreads") == 0)
      {
         if((i+1) >= argc)
            usage();

	 nthreads = atoi(argv[i+1]);
      }
   }

   set_up_flag = false;

   pthread_mutex_init(&set_up_mutex, NULL);

   shutdown_thread = new bool[nthreads];

   for(i = 0; i < nthreads; i++)
   {
      shutdown_thread[i] = false;
   }

   p_the_queue = new sync_queue();

   exit_flag = false;

   signal(SIGHUP, on_SIGHUP);

   fprintf(stdout, "Poll server...\n");
   fprintf(stdout, "(C) 2006 Copywrite. All rights reserved.\n");
   fprintf(stdout, "Matthew W. Coan\n");
   fprintf(stdout, "Version: 1.0.0\n");
   fflush(stdout);

   fprintf(stdout, "Start pool threads next...\n");
   fflush(stdout);

   if(nthreads <= 0)
      nthreads = 3;

   if(port < 0)
     port = 1976;

   cond = new pthread_cond_t[nthreads];

   mutex = new pthread_mutex_t[nthreads];

   thID = new pthread_t[nthreads];

   poll_list = new poll_list_type[nthreads];

   for(i = 0; i < nthreads; i++)
   {
      pthread_cond_init(&cond[i], NULL);

      pthread_mutex_init(&mutex[i], NULL);
   }

   pthread_mutex_init(&exit_mutex, NULL);

   pthread_mutex_init(&accept_mutex, NULL);

   pthread_create(&accept_thID, NULL, accept_thread, NULL);

   pthread_create(&accept_thID2, NULL, accept_thread, NULL);

   pthread_create(&dist_thID, NULL, dist_thread, NULL);

   pthread_create(&dist_thID1, NULL, dist_thread, NULL);

   pthread_create(&dist_thID2, NULL, dist_thread, NULL);

   for(i = 0; i < nthreads; i++) 
   {
       pthread_create(&thID[i], NULL, poll_thread, ((void*)(i)));
   }

   fprintf(stdout, "Poll threads running...\n");
   fflush(stdout);

   while(true)
   {
      usleep(1000);
   }

   return 0;
}

void *
dist_thread(void * arg)
{
   int i;
   int cliSock;

   int temp, min_val = INT_MAX, index = -1;
   
   // Forever:
   while(true) {
      cliSock = p_the_queue->get();

      if(cliSock < 0) 
      {
         break;
      }

      bool found = false;
 
      for(i = 0; i < nthreads; i++) 
      {
         pthread_mutex_lock(&mutex[i]);

	 temp = 0;

         for(poll_list_type::iterator p = poll_list[i].begin(); 
             p != poll_list[i].end(); p++)
         {
            temp += p->nfd;
         }

	 if(temp < min_val) 
	 {
            min_val = temp;

	    index = i;
	 }

         pthread_mutex_unlock(&mutex[i]);
      }

      if(index != -1) 
      {
         pthread_mutex_lock(&mutex[index]);

         for(poll_list_type::iterator p = poll_list[index].begin(); 
             p != poll_list[index].end(); p++)
         {
            if(p->nfd < MAX_POOL) 
	    {
               found = true;

               p->fdarray = addClient(p->fdarray, cliSock, p->nfd);
	    
	       p->user_map[cliSock] = user();
	       
	       break;
	    }
         }

         if(!found)
         {
            poll_array pa;

	    pa.fdarray = NULL;

	    pa.nfd = 0;

	    pa.fdarray = addClient(pa.fdarray, cliSock, pa.nfd);

	    pa.user_map[cliSock] = user();

	    poll_list[index].push_back(pa);

	    pthread_cond_signal(&cond[index]);
         }

         pthread_mutex_unlock(&mutex[index]);
      }
      else 
      {
         poll_array pa;

         pa.fdarray = NULL;

         pa.nfd = 0;

         pa.fdarray = addClient(pa.fdarray, cliSock, pa.nfd);

         pthread_mutex_lock(&mutex[0]);

         poll_list[0].push_back(pa);

	 pthread_cond_signal(&cond[0]);

         pthread_mutex_unlock(&mutex[0]);

	 pa.user_map[cliSock] = user();
      }
   }

   fprintf(stdout, "DONE dist_thread\n");
   fflush(stdout);

   return NULL;
}

