#ifndef _SYNC_QUEUE_H
#define _SYNC_QUEUE_H

#include <pthread.h>
#include <list>

using namespace std;

// /////////////////////////////////////////
//
// (C) 2006 Copywrite. All rights reserved.
//
// pthread sync queue
//
// Author: Matthew W. Coan
// Date: Tue Aug  8 15:44:13 EDT 2006
//
// /////////////////////////////////////////
class sync_queue {
public:
   typedef list< int > fd_list_type;

private:
   pthread_mutex_t _mutex;
   pthread_cond_t _cond;
   fd_list_type _list;
   bool _shutdown;

public:
   // constructor
   sync_queue()
   {
      pthread_mutex_init(&_mutex, NULL);

      pthread_cond_init(&_cond, NULL);

      _shutdown = false;
   }

   // deconstructor
   ~sync_queue()
   {
      pthread_cond_destroy(&_cond);

      pthread_mutex_destroy(&_mutex);

      for(fd_list_type::iterator p = _list.begin();
          p != _list.end(); p++)
      {
         close(*p);
      }

      _list.erase(_list.begin(), _list.end());
   }

   // put a file descriptor in the queue.
   void put(int fd)
   {
      pthread_mutex_lock(&_mutex);

      _list.push_back(fd);

      pthread_cond_signal(&_cond);

      pthread_mutex_unlock(&_mutex);
   }

   void shutdown() 
   {
      pthread_mutex_lock(&_mutex);

      _shutdown = true;

      pthread_cond_broadcast(&_cond);

      pthread_mutex_unlock(&_mutex);
   }

   // get a file descriptor from the queue.
   int get()
   {
      pthread_mutex_lock(&_mutex);

      while(_list.size() == 0)
      {
         pthread_cond_wait(&_cond, &_mutex);

	 if(_shutdown)
	 {
	     pthread_mutex_unlock(&_mutex);

             return -1;
         }
      }

      int fd = _list.front();

      _list.pop_front();

      pthread_mutex_unlock(&_mutex);

      return fd;
   }
};

#endif /* _SYNC_QUEUE_H */
