/* 

CHANGE THE ZIP FILE PASSWORD...

USE: java, zip and unzip linux programs...

Author: Matthew William Coan
Date: Tue Jun 30 14:14:04 EDT 2009

*/

#include <iostream>
#include <cstdlib>
#include <sys/types.h>
#include <signal.h>

using namespace std;

void
on_error(const char * msg, const char * file, const int line)
{
   cerr << "error: " << msg << endl
        << "file: " << file << endl
        << "line: " << line << endl << endl;

   exit(1);
}

#define error(msg) on_error(msg,__FILE__,__LINE__)

void
on_signal(int arg)
{
}

int
main(int argc, 
     char ** argv,
     char ** envp)
{
 
   signal(SIGCHLD, on_signal);
   signal(SIGINT, on_signal);
   signal(SIGTERM, on_signal);
   signal(SIGHUP, on_signal);

   if(system("unzip ./zip_file.zip") != 0) {
      error("unable to unzip the key_file.zip file...");
   }

   if(system("./zero ./zip_file.zip") != 0) {
      error("unable to zero the zip_file.zip file...");
   }

   if(system("rm -f ./zip_file.zip") != 0) {
      error("unable to remove zip_file.zip file...");
   }

   if(system("zip -e -r ./zip_file.zip ./SecretKey.ser") != 0) {
      error("unable to create zip file...");
   }

   if(system("./zero ./SecretKey.ser") != 0) {
      error("unable to zero ./SecretKey.ser file...");
   }

   if(system("rm -f ./SecretKey.ser") != 0) {
      error("unable to remove the ./SecretKey.ser file...");
   }

   if(system("sync") != 0) {
      error("unable to sync...");
   }

   return 0;
}
