/* 

ENCRYPTED TEXT EDITOR...

THIS USES: java, zip and unzip programs...

Author: Matthew William Coan
Date: Tue Jun 30 00:07:31 EDT 2009

*/

#include <iostream>
#include <cstdlib>
#include <sys/types.h>
#include <signal.h>

using namespace std;

int
on_error(const char * msg, 
         const char * file, 
         const int line)
{
   cerr << "error: " << msg << endl
        << "file: " << file << endl
        << "line: " << line << endl << endl;

   exit(1);
}

#define error(msg) on_error(msg,__FILE__,__LINE__)

void
on_signal(int arg)
{
}

int
main(int argc, 
     char ** argv,
     char ** envp)
{
 
   signal(SIGCHLD, on_signal);
   signal(SIGINT, on_signal);
   signal(SIGTERM, on_signal);
   signal(SIGHUP, on_signal);

   if(system("cp ./zip_file.zip ./backup/") != 0) {
      error("unable to backup key zip file...");
   }

   if(system("cp ./cypher_text.txt ./backup/") != 0) {
      error("unable to backup the cypher_text.txt");
   }

   if(system("unzip zip_file.zip") != 0) {
      error("unable to unzip the key zip file...");
   }

   if(system("java -classpath \"./:./cryptix32.jar\" SecretWriting ./SecretKey.ser -d ./cypher_text.txt ./plain_text.txt") != 0) {
      error("unable to decrypt...");
   }

   if(system("chmod a-rwx ./plain_text.txt") != 0) {
      error("unable to chmod the plain_text.txt file...");
   }

   if(system("chmod u+rw ./plain_text.txt") != 0) {
      error("unable to chmod the plain_text.txt file...");
   }

   if(system("chmod a-rwx ./SecretKey.ser") != 0) {
      error("unable to chmod the plain_text.txt text file...");
   }

   if(system("chmod u+rw ./SecretKey.ser") != 0) {
      error("unable to chmod the secret key file...");
   }

   if(system("vi +\"`cat ./plain_text.txt | wc -l`\" ./plain_text.txt") != 0) {
      error("unable to edit the plain_text file...");
   }

   if(system("./zero ./cypher_text.txt") != 0) {
      error("unable to zero the cypher text file...");
   }

   if(system("rm -f ./cypher_text.txt") != 0) {
      error("unable to remove the cypher_text.txt file...");
   }

   if(system("java -classpath \"./:./cryptix32.jar\" SecretWriting ./SecretKey.ser -e ./plain_text.txt ./cypher_text.txt") != 0) {
      error("unable to encrypt the plain_text.txt file...");
   }

   if(system("./zero ./plain_text.txt") != 0) {
      error("unable to decrypt the plain_text.txt file...");
   }

   if(system("rm -f ./plain_text.txt") != 0) {
      error("unable to decrypt the cypher text...");
   }

   if(system("chmod a-rwx ./cypher_text.txt") != 0) {
      error("unable to chmod the cypher_text.txt file...");
   }

   if(system("chmod u+rw ./cypher_text.txt") != 0) {
      error("unable to chmod the cypher_text.txt file...");
   }

   if(system("./zero ./SecretKey.ser") != 0) {
      error("unable to zero the SecretKey.ser file...");
   }

   if(system("rm -f ./SecretKey.ser") != 0) {
      error("unable to remove the SecretKey.ser file...");
   }

   if(system("sync") != 0) {
      error("unable to sync...");
   }

   return 0;
}
